require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1742: Symptom - Add]", :regression => true do

  before(:all) do
    @ENTRY_FORM = [
        "* required field",
        "*",
        "Required: Date: M M / D D / Y Y Y Y:",
        "Date:",
        "This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "* Symptom Name:",
        "Auto-complete input",
        "Duration",
        "Hours:",
        "Minutes:",
        "Intensity (1=Mild, 10=Severe):",
        "1",
        "10",
        "Slider on",
        "5",
        "Trigger:",
        "250 character maximum",
        "250 characters left",
        "Treatment:",
        "250 character maximum",
        "250 characters left",
        "Response to Treatment:",
        "250 character maximum",
        "250 characters left",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel"
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("symptoms", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05","patient05, zztest")

    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
    waitForPageToFinishLoading
    @driver.find_element(:id, "MyMedical").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @my_medical.clickSymptom()
    !5.times{ break if (getPrimaryHeader() == Symptom::HEADER); sleep 1 }
    expect(getPrimaryHeader()).to eq(Symptom::HEADER)

    #expect(getCount()).to eq(0)
  end

  # after(:all) do
  #   quitDriver()
  # end

  describe "AC JRNL-1733|TC-3126: Symptoms List" do

    it "Add Button" do
      expect(@common.isAddButtonVisible()).to eq(true)
    end

  end

  describe "AC JRNL-1733|TC-3126: When Selecting Add" do

    it "Header" do
      waitForPageToFinishLoading
      @common.clickAddButton
      !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
      expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)
    end

    describe "Detailed Fields" do

      it "Screen Content", :broken => true do
        @form = @symptom.stripSelectTextFromScreen(
            @symptom.getScreenContent().split("\n"),
            ['hours', 'minutes']
        )

        @ENTRY_FORM.each_with_index do | expectedScreenRow, i |\
          expect(@form[i]).to eq(expectedScreenRow)
        end
      end

      it "Symptom Name" do
        expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("")
        expect(@symptom.isFieldRequired(:css, Symptom::DESCRIPTION)).to eq(true)
        expect(@symptom.isThisElementDisabled(:css, Symptom::DESCRIPTION)).to eq(false)
      end

      it "Date" do
        expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("")
        expect(@symptom.isFieldRequired(:css, Symptom::SYMPTOM_DATE)).to eq(true)
      end

      it "Time" do
        expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to be <= (formatTimeAMPM(Time.now))
        expect(@symptom.isFieldRequired(:css, Symptom::SYMPTOM_TIME)).to eq(true)
      end

      it "Trigger" do
        expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("")
        expect(@symptom.isFieldRequired(:css, Symptom::TRIGGER)).to eq(false)
      end

      it "Treatment" do
        expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("")
        expect(@symptom.isFieldRequired(:css, Symptom::TREATMENT)).to eq(false)
      end

      it "Response" do
        expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("")
        expect(@symptom.isFieldRequired(:css, Symptom::RESPONSE)).to eq(false)
      end

      it "Notes" do
        expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("")
        expect(@symptom.isFieldRequired(:css, Symptom::NOTES)).to eq(false)
      end

      it "Screen Content", :broken => true do
        @form = @symptom.stripSelectTextFromScreen(
            @symptom.getScreenContent().split("\n"),
            ['hours', 'minutes']
        )

        @ENTRY_FORM.each_with_index do | expectedScreenRow, i |
          expect(@form[i]).to eq(expectedScreenRow)
        end
      end

      it "Error Messages", :broken => true do
        expectedValidationSummaryHeader = "The following errors were found:"

        @symptom.clickSaveButton()

        !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(true)

        @symptom.setInput(Symptom::SYMPTOM_DATE, "11/01")

        @symptom.clickSaveButton()

        !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)

        @symptom.setInput(Symptom::SYMPTOM_TIME, "09")

        @symptom.clickSaveButton()

        !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(true)

        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
          @symptom.setInput(Symptom::SYMPTOM_DATE, futureDate)
          @symptom.clickSaveButton()

          !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(true)
          expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(true)
        end

        @symptom.setInput(Symptom::SYMPTOM_DATE, today)
        time = formatTimeAMPM(Time.now + 2*60*60)
        @symptom.setInput(Symptom::SYMPTOM_TIME, time)

        @symptom.clickSaveButton()

        !5.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(false)
      end

    end

    describe "Standard Save and Cancel Options" do

      it "Cancel" do
        expect(@symptom.isCancelButtonVisible()).to eq(true)

        @symptom.clickCancelButton()
        !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)
        expect(getCount()).to eq(0)
      end

      describe "Save" do

        it "Min", :broken => true do
          @common.clickAddButton
          !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)

          @symptom.setInput(Symptom::DESCRIPTION, "Headache")

          @driver.find_element(:css, "input[id='date']").clear
          waitForPageToFinishLoading
          @driver.find_element(:css, "input[id='date']").send_keys "11/01/1990"
          waitForPageToFinishLoading
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("11/01/1990")

          @driver.find_element(:css, "input[id='time']").clear
          waitForPageToFinishLoading
          @driver.find_element(:css, "input[id='time']").send_keys "11:05 AM"
          waitForPageToFinishLoading

          @symptom.setSelectBoxValue(Symptom::DURATION_HOURS, "2")

          @symptom.setSelectBoxValue(Symptom::DURATION_MINUTES, "20")

          @symptom.clickSaveButton()
          !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)
          waitForPageToFinishLoading
          expect(getCount()).to eq(0)
        end

        it "Max", :broken => true do
          @common.clickAddButton
          waitForPageToFinishLoading
          @symptom.setInput(Symptom::DESCRIPTION, "PainPainPainPainPainPainPainPainPainPainPainPainP")
          @symptom.setInput(Symptom::SYMPTOM_DATE, "11/02/2014")

          @driver.find_element(:css, "input[id='time']").clear
          waitForPageToFinishLoading
          @driver.find_element(:css, "input[id='time']").send_keys "09:01 AM"
          waitForPageToFinishLoading
          moveArrowInputRangeToRight("intensity", 5)

          @symptom.setSelectBoxValue(Symptom::DURATION_HOURS, "10")
          @symptom.setSelectBoxValue(Symptom::DURATION_MINUTES, "20")
          @symptom.setInput(Symptom::TRIGGER, "TriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTrig")
          @symptom.setInput(Symptom::TREATMENT, "TREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATM")
          @symptom.setInput(Symptom::RESPONSE, "ReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonRea")
          @symptom.setInput(Symptom::NOTES, "NotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNote")
          waitForPageToFinishLoading
          @symptom.clickSaveButton()
          !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)
        end


        it "Verify Min Data", :broken => true do
          @symptomFilter.setInput(Symptom_Filter::FROM_DATE, "01/01/1990")
          @symptomFilter.setInput(Symptom_Filter::TO_DATE, "11/10/2014")

          @symptomFilter.clickFilterBtn()
          !5.times{ break if (@symptomFilter.getFocusedElementText().include?("Event Title")); sleep 1 }
          @symptom.clickApplyButton()
          waitForPageToFinishLoading
          expect(getCount()).to eq(2)

          waitForPageToFinishLoading
          #clickNthRow(2)
          @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[3]/list-table/div/div/ul/li[2]/span[1]").click
          waitForPageToFinishLoading

          !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq("Edit Symptom Diary Entry")

          expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("Headache")
          expect(@symptom.isThisElementDisabled(:css, Symptom::DESCRIPTION)).to eq(false)
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("11/01/1990")
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to eq("11:05 AM")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_HOURS)).to eq("2")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_MINUTES)).to eq("20")
          expect(getInputRangeValue("intensity")).to eq("5")
          expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("")
        end

        it "Verify Max Data", :broken => true do
          @symptom.clickCancelButton()
          !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          @symptomFilter.setInput(Symptom_Filter::FROM_DATE, "01/01/1990")
          @symptomFilter.setInput(Symptom_Filter::TO_DATE, "11/10/2014")

          @symptomFilter.clickFilterBtn()
          !5.times{ break if (@symptomFilter.getFocusedElementText().include?("Event Title")); sleep 1 }
          @symptom.clickApplyButton()
          waitForPageToFinishLoading
          expect(getCount()).to eq(2)

          #clickNthRow(1)
          waitForPageToFinishLoading
          @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[3]/list-table/div/div/ul/li[1]/span[1]").click
          waitForPageToFinishLoading

          !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
          expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("PainPainPainPainPainPainPainPainPainPainPainPainP")
          expect(@symptom.isThisElementDisabled(:css, Symptom::DESCRIPTION)).to eq(false)
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("11/02/2014")
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to eq("09:01 AM")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_HOURS)).to eq("10")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_MINUTES)).to eq("20")
          expect(getInputRangeValue("intensity")).to eq("10")
          expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("TriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTrig")
          expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("TREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATM")
          expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("ReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonRea")
          expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("NotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNote")
        end

      end

    end

    describe "AC JRNL-1730|TC-3247: Navigation Without Saving" do

      context "Clicking Back Button" do

        it "No changes", :broken => true do
          @symptom.clickBackButton()
          !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }

          expect(getCount()).to eq(2)
        end

        it "Changes", :broken => true do
          @common.clickAddButton()
          !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)

          @symptom.setInput(Symptom::NOTES, "XYZ")

          @symptom.clickBackButton()
          !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickReturnButton()
          !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)

          @symptom.clickBackButton()
          !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickContinueButton()
          !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          expect(getCount()).to eq(2)
        end

      end

    #   context "Clicking Menu Item" do
    #
    #     it "No changes", :broken => true do
    #       @common.clickAddButton()
    #       !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
    #       expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)
    #
    #       @mymedical.clickSymptom()
    #       !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
    #
    #       expect(getCount()).to eq(2)
    #     end
    #
    #     it "Changes", :broken => true do
    #       @common.clickAddButton()
    #       !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
    #       expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)
    #
    #       @symptom.setInput(Symptom::NOTES, "XYZ")
    #
    #       @mymedical.clickSymptom()
    #       !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    #       expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    #       expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
    #       expect(@modal.getConfirmButtonText()).to eq("Continue")
    #       expect(@modal.getCancelButtonText()).to eq("Return")
    #
    #       @modal.clickReturnButton()
    #       !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
    #       expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)
    #
    #       @mymedical.clickSymptom()
    #       !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    #       expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    #       expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
    #       expect(@modal.getConfirmButtonText()).to eq("Continue")
    #       expect(@modal.getCancelButtonText()).to eq("Return")
    #
    #       @modal.clickContinueButton()
    #       !5.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
    #       expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)
    #
    #       expect(getCount()).to eq(2)
    #     end
       end
     end
  end










































#@driver.find_element(:css, "select[name='Meal Type']").send_keys "Breakfast"









############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1742: Symptom - Add]", :regression => true do

  before(:all) do
    @ENTRY_FORM = [
        "* required field",
        "* Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Time:",
        "hh:mm AM/PM",
        "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
        "* Symptom Name:",
        "Auto-complete input",
        "Duration",
        "Hours:",
        "Minutes:",
        "Intensity (1=Mild, 10=Severe):",
        "1",
        "10",
        "Slider on",
        "5",
        "Trigger:",
        "250 character maximum",
        "250 characters left",
        "Treatment:",
        "250 character maximum",
        "250 characters left",
        "Response to Treatment:",
        "250 character maximum",
        "250 characters left",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel"
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("symptoms", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest")

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }

    @navMenu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickSymptom()
    !45.times{ break if (getPrimaryHeader() == Symptom::HEADER); sleep 1 }
    expect(getPrimaryHeader()).to eq(Symptom::HEADER)

    expect(getCount()).to eq(0)
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1733|TC-3126: Symptoms List" do

    it "Add Button" do
      expect(@common.isAddButtonVisible()).to eq(true)
    end

  end

  describe "AC JRNL-1733|TC-3126: When Selecting Add" do

    it "Header" do
      @common.clickAddButton()
      !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
      expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)
    end

    describe "Detailed Fields" do

      it "Screen Content", :broken => true do
        @form = @symptom.stripSelectTextFromScreen(
            @symptom.getScreenContent().split("\n"),
            ['hours', 'minutes']
        )

        @ENTRY_FORM.each_with_index do | expectedScreenRow, i |\
          expect(@form[i]).to eq(expectedScreenRow)
        end
      end

      it "Symptom Name" do
        expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("")
        expect(@symptom.isFieldRequired(:css, Symptom::DESCRIPTION)).to eq(true)
        expect(@symptom.isThisElementDisabled(:css, Symptom::DESCRIPTION)).to eq(false)
      end

      it "Date" do
        expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq(getDateNthDaysAgo(0, "%m/%d/%Y"))
        expect(@symptom.isFieldRequired(:css, Symptom::SYMPTOM_DATE)).to eq(true)
      end

      it "Time" do
        expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to be <= (formatTimeAMPM(Time.now))
        expect(@symptom.isFieldRequired(:css, Symptom::SYMPTOM_TIME)).to eq(true)
      end

      it "Trigger" do
        expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("")
        expect(@symptom.isFieldRequired(:css, Symptom::TRIGGER)).to eq(false)
      end

      it "Treatment" do
        expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("")
        expect(@symptom.isFieldRequired(:css, Symptom::TREATMENT)).to eq(false)
      end

      it "Response" do
        expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("")
        expect(@symptom.isFieldRequired(:css, Symptom::RESPONSE)).to eq(false)
      end

      it "Notes" do
        expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("")
        expect(@symptom.isFieldRequired(:css, Symptom::NOTES)).to eq(false)
      end

      it "Screen Content", :broken => true do
        @form = @symptom.stripSelectTextFromScreen(
            @symptom.getScreenContent().split("\n"),
            ['hours', 'minutes']
        )

        @ENTRY_FORM.each_with_index do | expectedScreenRow, i |
          expect(@form[i]).to eq(expectedScreenRow)
        end
      end

      it "Error Messages", :broken => true do
        expectedValidationSummaryHeader = "The following errors were found:"

        @symptom.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(true)

        @symptom.setInput(Symptom::SYMPTOM_DATE, "11/01")

        @symptom.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)

        @symptom.setInput(Symptom::SYMPTOM_TIME, "09")

        @symptom.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Date must be formatted MM/DD/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time must be formatted hh:mm (AM/PM).")).to eq(true)

        today = getDateNthDaysFromNow(0, "%m/%d/%Y")

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
          @symptom.setInput(Symptom::SYMPTOM_DATE, futureDate)
          @symptom.clickSaveButton()

          !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
          expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
          expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(true)
          expect(@error.isErrorMessageDisplayed("form", "Date must be between 01/01/1900 and " + today + ".")).to eq(true)
        end

        @symptom.setInput(Symptom::SYMPTOM_DATE, today)
        time = formatTimeAMPM(Time.now + 2*60*60)
        @symptom.setInput(Symptom::SYMPTOM_TIME, time)

        @symptom.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("form", "Symptom Name field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("form", "Time cannot be a future time.")).to eq(true)
      end

    end

    describe "Standard Save and Cancel Options" do

      it "Cancel" do
        expect(@symptom.isCancelButtonVisible()).to eq(true)

        @symptom.clickCancelButton()
        !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
        expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

        expect(getCount()).to eq(0)
      end

      describe "Save" do

        it "Min", :broken => true do
          @common.clickAddButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)

          @symptom.setInput(Symptom::DESCRIPTION, "Headache")

          @date_picker.click(:css, Symptom::SYMPTOM_DATE_BUTTON)
          !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
          @date_picker.setDateFromGUI(11, 01, 1990)
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("11/01/1990")

          @time_picker.clickTimePickerButton()
          !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
          expect(@time_picker.areMinutesIn5MinIntervals()).to eq(false)
          @time_picker.setTimeFromGUI(11, 5, "AM")
          !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }
          timeStr = "11:05 AM"
          expect(@time_picker.getTime()).to eq(timeStr)

          @symptom.setSelectBoxValue(Symptom::DURATION_HOURS, "2")

          @symptom.setSelectBoxValue(Symptom::DURATION_MINUTES, "20")

          @symptom.clickSaveButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          expect(getCount()).to eq(0)
        end

        it "Max", :broken => true do
          @common.clickAddButton()
          @symptom.setInput(Symptom::DESCRIPTION, "PainPainPainPainPainPainPainPainPainPainPainPainP")
          @symptom.setInput(Symptom::SYMPTOM_DATE, "11/02/2014")

          @time_picker.clickTimePickerButton()
          !45.times{ break if (@driver.find_element(:id, "set-button").displayed?); sleep 1 }
          expect(@time_picker.areMinutesIn5MinIntervals()).to eq(false)
          @time_picker.setTimeFromGUI(9, "01", "AM")
          !45.times{ break if (is_element_present(:id, "set-button") == false); sleep 1 }
          timeStr = "09:01 AM"
          expect(@time_picker.getTime()).to eq(timeStr)
          moveArrowInputRangeToRight("intensity", 5)

          @symptom.setSelectBoxValue(Symptom::DURATION_HOURS, "10")
          @symptom.setSelectBoxValue(Symptom::DURATION_MINUTES, "20")
          @symptom.setInput(Symptom::TRIGGER, "TriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTrig")
          @symptom.setInput(Symptom::TREATMENT, "TREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATM")
          @symptom.setInput(Symptom::RESPONSE, "ReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonRea")
          @symptom.setInput(Symptom::NOTES, "NotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNote")

          @symptom.clickSaveButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          expect(getCount()).to eq(1)
        end


        it "Verify Min Data", :broken => true do
          @symptomFilter.setInput(Symptom_Filter::FROM_DATE, "01/01/1990")
          @symptomFilter.setInput(Symptom_Filter::TO_DATE, "11/10/2014")

          @symptomFilter.clickFilterBtn()
          !10.times{ break if (@symptomFilter.getFocusedElementText().include?("Event Title")); sleep 1 }
          expect(getCount()).to eq(2)

          clickNthRow(2)
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)

          expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("Headache")
          expect(@symptom.isThisElementDisabled(:css, Symptom::DESCRIPTION)).to eq(true)
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("11/01/1990")
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to eq("11:05 AM")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_HOURS)).to eq("2")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_MINUTES)).to eq("20")
          expect(getInputRangeValue("intensity")).to eq("5")
          expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("")
          expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("")
        end

        it "Verify Max Data", :broken => true do
          @symptom.clickCancelButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          @symptomFilter.setInput(Symptom_Filter::FROM_DATE, "01/01/1990")
          @symptomFilter.setInput(Symptom_Filter::TO_DATE, "11/10/2014")

          @symptomFilter.clickFilterBtn()
          !10.times{ break if (@symptomFilter.getFocusedElementText().include?("Event Title")); sleep 1 }
          expect(getCount()).to eq(2)

          clickNthRow(1)
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::EDIT_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::EDIT_HEADER)
          expect(@symptom.getTextFromInput(:css, Symptom::DESCRIPTION)).to eq("PainPainPainPainPainPainPainPainPainPainPainPainP")
          expect(@symptom.isThisElementDisabled(:css, Symptom::DESCRIPTION)).to eq(true)
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_DATE)).to eq("11/02/2014")
          expect(@symptom.getTextFromInput(:css, Symptom::SYMPTOM_TIME)).to eq("09:01 AM")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_HOURS)).to eq("10")
          expect(@symptom.getSelectBoxText(Symptom::DURATION_MINUTES)).to eq("20")
          expect(getInputRangeValue("intensity")).to eq("10")
          expect(@symptom.getTextFromInput(:css, Symptom::TRIGGER)).to eq("TriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTriggerTrig")
          expect(@symptom.getTextFromInput(:css, Symptom::TREATMENT)).to eq("TREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATMENTTREATM")
          expect(@symptom.getTextFromInput(:css, Symptom::RESPONSE)).to eq("ReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonReasonRea")
          expect(@symptom.getTextFromInput(:css, Symptom::NOTES)).to eq("NotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNotesNote")
        end

      end

    end

    describe "AC JRNL-1730|TC-3247: Navigation Without Saving" do

      context "Clicking Back Button" do

        it "No changes", :broken => true do
          @symptom.clickBackButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }

          expect(getCount()).to eq(2)
        end

        it "Changes", :broken => true do
          @common.clickAddButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)

          @symptom.setInput(Symptom::NOTES, "XYZ")

          @symptom.clickBackButton()
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickReturnButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)

          @symptom.clickBackButton()
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickContinueButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          expect(getCount()).to eq(2)
        end

      end

      context "Clicking Menu Item" do

        it "No changes", :broken => true do
          @common.clickAddButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)

          @mymedical.clickSymptom()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }

          expect(getCount()).to eq(2)
        end

        it "Changes", :broken => true do
          @common.clickAddButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)

          @symptom.setInput(Symptom::NOTES, "XYZ")

          @mymedical.clickSymptom()
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickReturnButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::ADD_HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::ADD_HEADER)

          @mymedical.clickSymptom()
          !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
          expect(@modal.getConfirmationHeading()).to eq("Confirmation")
          expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
          expect(@modal.getConfirmButtonText()).to eq("Continue")
          expect(@modal.getCancelButtonText()).to eq("Return")

          @modal.clickContinueButton()
          !45.times{ break if (@symptom.getPrimaryHeader() == Symptom::HEADER); sleep 1 }
          expect(@symptom.getPrimaryHeader()).to eq(Symptom::HEADER)

          expect(getCount()).to eq(2)
        end

      end

    end

  end

end
=end




