require_relative '../../../globalized'
include Globalized
require 'rspec'
require 'date'
require 'time'

todayMonthDayYear= Date.today.strftime('%m/%d/%Y')

describe "Story #JRNL-2288: [MyMedical_JRNL-2288_spec.rb]", :regression => true do



  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
    removeCollection("symptoms", "medicalhistorydb")
    removeCollection('medications', 'medicalhistorydb')
    removeCollection('allergies', 'medicalhistorydb')
    removeCollection("diagnosis", "medicalhistorydb")
    removeCollection("surgeries", "medicalhistorydb")
    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
  end

  # after(:all) do
  #   quitDriver()
  # end

  context "JRNL-2288-My Medical Sub Categories text fields are not saving complete text" do

    it "Verify MyMedical/Symptom Diary is saving complete text" do
      @main.clickNavMenu
      #@navMenu.clickMyMedical
      waitForPageToFinishLoading
      @driver.find_element(:id, "MyMedical").click
      waitForPageToFinishLoading
      @myMedical.clickSymptom()
      @myMedical.clickAddEntryButton
      @symptom.enterDate(todayMonthDayYear)
      @driver.find_element(:css, "button[ng-model='ngModel']").click
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='set-btn']").click
      waitForPageToFinishLoading
      @symptom.enterSymptomName('Itchy Eye')
      @symptom.clickSaveButtonJump
      @symptom.clickApplyButton()
      #expect(getTextForRowColumn(1,1)).to eq('Itchy Eye')
    end

    it "Verify MyMedical/Medications is saving complete text" do
        @myMedical.clickMedications
        waitForPageToFinishLoading
        @my_medical.clickMedications()
        waitForPageToFinishLoading
        @common.clickAddButton
        @medications.enterMedicationName('Tylenol')
        @medications.setSelectBoxFrequency('Once a Day')
        @medications.setStartDate(todayMonthDayYear)
        @medications.setEndDate(todayMonthDayYear)
        @medications.clickSaveButtonJump
        clickReviewYourInfoSaveButton
        expect(getTextForRowColumn(1,1)).to eq("Tylenol\nOnce a Day")
    end

    it "Verify MyMedical/Allergies is saving complete text" do
      @my_medical.clickAllergies()
      waitForPageToFinishLoading
      @common.clickAddButton
      waitForPageToFinishLoading
      @driver.find_element(:css, "textarea[name='allergy']").send_keys "Allscale pollen extract 100 MG/ML Injectable Solut"
      waitForPageToFinishLoading
      @allergies.enterDate(todayMonthDayYear)
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[ng-click='confirmSave()']").click
      waitForPageToFinishLoading
      clickReviewYourInfoSaveButton
      @allergies.clickApplyButton()
      expect(getTextForRowColumn(1,1)).to eq('Allscale pollen extract 100 MG/ML Injectable Solut')
    end

    it "Verify MyMedical/Diagnoses is saving complete text" do
      @my_medical.clickDiagnoses()
      waitForPageToFinishLoading
      @common.clickAddButton
      @diagnoses.enterDate(todayMonthDayYear)
      @diagnoses.setDiagnosis('Cancer')
      @diagnoses.setCurrentChecked
      @diagnoses.clickSaveButtonJump
      waitForPageToFinishLoading
      @diagnoses.clickApplyButton()
      expect(getTextForRowColumn(1,1)).to eq('Cancer')
    end

    it "Verify MyMedical/Surgeries is saving complete text" do
      @my_medical.clickSurgeries()
      waitForPageToFinishLoading
      @surgeries.clickAddEntryButton
      @surgeries.setNameOfSurgery('Biopsy')
      @surgeries.setDateOfSurgeryProcedure(todayMonthDayYear)
      @surgeries.clickSaveButtonJump
      waitForPageToFinishLoading
      expect(getTextForRowColumn(1,1)).to eq('Biopsy')
    end
  end
end

















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized
require 'rspec'
require 'date'
require 'time'

todayMonthDayYear= Date.today.strftime('%m/%d/%Y')

describe "Story #JRNL-2288: [MyMedical_JRNL-2288_spec.rb]", :regression => true do



  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
    removeCollection("symptoms", "medicalhistorydb")
    removeCollection('medications', 'medicalhistorydb')
    removeCollection('allergies', 'medicalhistorydb')
    removeCollection("diagnosis", "medicalhistorydb")
    removeCollection("surgeries", "medicalhistorydb")
    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
  end

  after(:all) do
    quitDriver()
  end

  context "JRNL-2288-My Medical Sub Categories text fields are not saving complete text" do

    it "Verify MyMedical/Symptom Diary is saving complete text" do
      @main.clickNavMenu
      @navMenu.clickMyMedical
      @myMedical.clickSymptom
      @myMedical.clickAddEntryButton
      @symptom.enterDate(todayMonthDayYear)
      @symptom.enterSymptomName('Itchy Eye')
      @symptom.clickSaveButtonJump
      expect(getTextForRowColumn(1,1)).to eq('Itchy Eye')
    end

    it "Verify MyMedical/Medications is saving complete text" do
      @myMedical.clickMedications
      @common.clickAddButton
      @medications.enterMedicationName('Tylenol')
      @medications.setSelectBoxFrequency('Once a Day')
      @medications.setStartDate(todayMonthDayYear)
      @medications.setEndDate(todayMonthDayYear)
      @medications.clickSaveButtonJump
      clickReviewYourInfoSaveButton
      expect(getTextForRowColumn(1,1)).to eq("Tylenol\nOnce a Day")
    end

    it "Verify MyMedical/Allergies is saving complete text" do
      @myMedical.clickAllergies
      @common.clickAddButton
      @allergies.enterAllergy('Pollen')
      @allergies.enterDate(todayMonthDayYear)
      @allergies.clickSaveButton
      clickReviewYourInfoSaveButton
      expect(getTextForRowColumn(1,1)).to eq('Pollen')
    end

    it "Verify MyMedical/Diagnoses is saving complete text" do
      @myMedical.clickAddDiagnosis
      @common.clickAddButton
      @diagnoses.enterDate(todayMonthDayYear)
      @diagnoses.setDiagnosis('Cancer')
      @diagnoses.setCurrentChecked
      @diagnoses.clickSaveButtonJump
      expect(getTextForRowColumn(1,1)).to eq('Cancer')
    end

    it "Verify MyMedical/Surgeries is saving complete text" do
      @myMedical.clickSurgeries
      @surgeries.clickAddEntryButton
      @surgeries.setNameOfSurgery('Biopsy')
      @surgeries.setDateOfSurgeryProcedure(todayMonthDayYear)
      @surgeries.clickSaveButtonJump
      expect(getTextForRowColumn(1,1)).to eq('Biopsy')
    end
  end
end
=end