require_relative '../../../globalized'

include Globalized

describe "[Story #JRNL-1961: Surgeries: List view - Filters and Table]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("surgeries", "medicalhistorydb", "surgeries")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")
  end

  after(:all) do
    quitDriver()
  end

  context "AC #JRNL-1913|TC #JRNL-1849: 1. Sub Feature Selection" do

    context "When a user opens the Left Panel navigation and selects My Medical feature, the system displays a navigation option for the Surgeries" do

      it "Location & Label" do
        menuLocation = -1
        menu = getElements(:css, "div.secondary-content li")

        menu.each_with_index do | menuItem, i |
          if menuItem.text() == "Surgeries"
            menuLocation = i + 1
            break
          end
        end

        expect(@nav_menu.getNthSubFeatureName(menuLocation)).to eq("Surgeries")
        expect(@nav_menu.getNthSubFeatureName(menuLocation - 1)).to eq("Diagnoses")
      end

    end

  end

  context "AC #JRNL-1912|TC #JRNL-1850: 2. Sub Feature Default View (Table List only)" do

    it "When a user selects Surgeries from the My Medical feature, given that the user has surgery records, the system displays the Surgeries table list view in the Detail screen (header = Surgeries)" do
      @mymedical.clickSurgeries()
      !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Surgeries")
    end

    it "Records are sorted in reverse chronological order by Surgery Date, and then by Surgery name; null values are shown as empty table cells unless otherwise noted", :broken => true do
      !5.times{ break if (@surgeries_list.getTextForRowColumn(1, 1) != nil); sleep 1 }
      verifySurgeriesList(@surgeries_list.getList(), getAllSurgeriesInDBSorted())
      expect(@surgeries_list.getCount()).to eq(12)
    end

    it "2.1. Surgery Name 2.2 Surgery Date (mm/dd/yyyy format) 2.3 Source (not shown on phone)", :broken => true do
      expect(@surgeries_list.getTableHeaders()).to eq(["Surgery Name", "Surgery Date", "Source"])
    end

    it "2.4 If no records exist for the user, display the following message in place of the table view: Use the Add button above to create a new record." do
      removeCollection("surgeries", "medicalhistorydb")
      refreshBrowser()
      noRecordsMessage = "Use the Add button above to create a new record."
      !5.times{ break if (@surgeries_list.getNoResultsFoundMessage() == noRecordsMessage ); sleep 1 }
      expect(@surgeries_list.getNoResultsFoundMessage()).to match(noRecordsMessage)
    end

  end


  #######################
  ### Local Functions ###
  #######################

  def getAllSurgeriesInDBSorted
    def sortKeys(x,y)
      returnval = -(x["surgeryDate"] <=> y["surgeryDate"])
      if returnval == 0
        return x["name"].upcase <=> y["name"].upcase
      else
        return returnval
      end
    end
    return retreiveAllDocumentsInCollection("surgeries", "medicalhistorydb").sort { |x, y| sortKeys(x,y) }
  end


  def verifySurgeriesList(screenList, dbList)
    dbList.each_with_index do |dbrow, i|
      screenRow = screenList[i].text.split("\n")
      expect(screenRow[1].strip.upcase).to eq(dbrow['name'].upcase)
      expect(screenRow[3].strip).to eq(dbrow['surgeryDate'].strftime('%m/%d/%Y'))
      expect(screenRow[5].strip).to eq(dbrow['source'])
    end
  end


end