require_relative '../../../globalized'

include Globalized

describe "[Story #JRNL-1960: Surgeries Edit/Delete/Nav]", :broken => true, :regression => true  do

  before(:all) do
    @ENTRY_FORM = [ \
        "* required field",
        "* Name of Surgery:",
        # JRNL-1196 changed 'Name of Surgery' to a type-ahead input
        "Auto-complete input",
        # "100 character maximum",
        "* Date of Surgery/Procedure:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Is this date estimated?",
        "Yes",
        "No",
        "Reason for Surgery:",
        "150 character maximum",
        "Provider:",
        "First Name:",
        "50 character maximum",
        "Last Name:",
        "50 character maximum",
        "Clinic/Organization:",
        "50 character maximum",
        "Facility/Hospital:",
        "100 character maximum",
        "Source: Self",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Delete Cancel",
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("surgeries", "medicalhistorydb", "surgeries")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:id, "MyMedical").click
    waitForPageToFinishLoading
    @nav_menu.clickMyMedical()
    !5.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickSurgeries()
    !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Surgeries")

    expect(getCount()).to eq(12)
  end

  after(:all) do
    quitDriver()
  end

  context "AC #JRNL-1925|TC #JRNL-1888: Edit an Entry" do

      context "When the user selects a Surgery entry from the table view" do

          it "The system displays the Surgery record in the Detail screen in Edit mode: (header: Edit Surgery)" do
            clickNthRow(1)
            !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")
            !5.times{ break if (getFocusedElementText().include?("Edit Surgery")); sleep 1 }
            expect(getFocusedElementText()).to eq("Edit Surgery")
          end

          it "All values previously saved are visible. If no value was previously saved for a field, the display defaults to null (or select for drop lists); no guidance text (light gray placeholder text) is shown unless and all fields are optional unless otherwise indicated." do
            expect(@surgeries.getNameOfSurgery()).to eq("A Surgery")
            expect(@surgeries.isFieldRequired(:css, Surgeries::SURGERY)).to be true
            expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/01/2014")
            expect(@surgeries.isFieldRequired(:css, Surgeries::SURGERY_DATE)).to be true
            expect(@surgeries.isEstimatedYes()).to be false
            expect(@surgeries.isFieldRequired(:css, Surgeries::YES_RADIO)).to be false
            expect(@surgeries.isEstimatedNo()).to be false
            expect(@surgeries.isFieldRequired(:css, Surgeries::NO_RADIO)).to be false
            expect(@surgeries.getReasonForSurgery()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::REASON)).to be false
            expect(@surgeries.getFirstName()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::FIRST_NAME)).to be false
            expect(@surgeries.getLastName()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::LAST_NAME)).to be false
            expect(@surgeries.getClinicOrganization()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::CLINIC_ORGANIZATION)).to be false
            expect(@surgeries.getFacilityHospital()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::FACILITY_HOSPITAL)).to be false
            expect(@surgeries.getSource()).to eq("Source: Self")
            expect(@surgeries.getNote()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::NOTE)).to be false
            expect(@surgeries.getCountDownDisplayForNote()).to eq("250 characters left")
          end

          it "All data elements available in Add Entry mode are visible." do
            expect(@surgeries.isDeleteButtonVisible()).to be true
            expect(@surgeries.isCancelButtonVisible()).to be true
            expect(@surgeries.isSaveButtonVisible()).to be true

            form = @surgeries.getScreenContent().split("\n")
            @ENTRY_FORM.each_with_index do | expectedScreenRow, i |
              expect(form[i]).to eq(expectedScreenRow)
            end
            expect(form.length).to eq(@ENTRY_FORM.length())

            @surgeries.setNameOfSurgery("")
            @surgeries.setDateOfSurgeryProcedure("")
            @surgeries.clickSaveButton()

            checkingInlineError("Name of Surgery field is required.", 0)
            checkingInlineError("Date of Surgery/Procedure field is required.", 1)

            @surgeries.setNameOfSurgery("x")
            @surgeries.setDateOfSurgeryProcedure("01/01")
            @surgeries.clickSaveButton()

            checkingInlineError("Date of Surgery/Procedure must be formatted MM/DD/YYYY.", 0)
          end

      end

  end

  context "AC #JRNL-1924|TC #JRNL-1904: Standard Edit functions are available (Save, Cancel, Delete)" do

      it "Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        @surgeries.setNameOfSurgery("Abc")
        @surgeries.clickDateOfSurgeryCalendarBtn()
        !5.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(3, 7, 1991)

        @surgeries.clickCancelButton()
        !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Surgeries")
        !5.times{ break if (getFocusedElementText().include?("Surgeries")); sleep 1 }
        expect(getFocusedElementText()).to eq("Surgeries")
      end

      it "Cancel -  When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        expect(getCount()).to eq(12)

        clickNthRow(1)
        !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Surgery")

        expect(@surgeries.getNameOfSurgery()).to eq("A Surgery")
        expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/01/2014")
        expect(@surgeries.isEstimatedYes()).to be false
        expect(@surgeries.isEstimatedNo()).to be false
        expect(@surgeries.getReasonForSurgery()).to eq("")
        expect(@surgeries.getFirstName()).to eq("")
        expect(@surgeries.getLastName()).to eq("")
        expect(@surgeries.getClinicOrganization()).to eq("")
        expect(@surgeries.getFacilityHospital()).to eq("")
        expect(@surgeries.getSource()).to eq("Source: Self")
        expect(@surgeries.getNote()).to eq("")
        expect(@surgeries.getCountDownDisplayForNote()).to eq("250 characters left")
      end

      it "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view." do
        @surgeries.setNameOfSurgery("Abc")
        @surgeries.setDateOfSurgeryProcedure("10/16/2014")

        @surgeries.clickSaveButton()
        !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Surgeries")
        !5.times{ break if (getFocusedElementText().include?("Surgeries")); sleep 1 }
        expect(getFocusedElementText()).to eq("Surgeries")

        expect(getCount()).to eq(12)

        expect(getTextForRow(1).include?("Abc")).to be true
      end

      it "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view." do
        clickNthRow(1)
        !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Surgery")

        expect(@surgeries.getNameOfSurgery()).to eq("Abc")
        expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/16/2014")
        expect(@surgeries.isEstimatedYes()).to be false
        expect(@surgeries.isEstimatedNo()).to be false
        expect(@surgeries.getReasonForSurgery()).to eq("")
        expect(@surgeries.getFirstName()).to eq("")
        expect(@surgeries.getLastName()).to eq("")
        expect(@surgeries.getClinicOrganization()).to eq("")
        expect(@surgeries.getFacilityHospital()).to eq("")
        expect(@surgeries.getSource()).to eq("Source: Self")
        expect(@surgeries.getNote()).to eq("")
        expect(@surgeries.getCountDownDisplayForNote()).to eq("250 characters left")

        @surgeries.setNameOfSurgery("ZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgery")
        @surgeries.setDateOfSurgeryProcedure("10/10/2010")
        @surgeries.setEstimatedYes()
        @surgeries.setReasonForSurgery("I was catching too many z's. I was catching too many z's. I was catching too many z's. I was catching too many z's. I was catching too many z's. I was catching too many z's.")
        @surgeries.setFirstName("ScottScottScottScottScottScottScottScottScottScottScott")
        @surgeries.setLastName("SimpsonSimpsonSimpsonSimpsonSimpsonSimpsonSimpsonSimpson")
        @surgeries.setClinicOrganization("The Organization The Organization The Organization The Organization")
        @surgeries.setFacilityHospital("UnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknown")
        @surgeries.setNote("ZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzz")

        @surgeries.clickSaveButton()
        !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Surgeries")
        !5.times{ break if (getFocusedElementText().include?("Surgeries")); sleep 1 }
        expect(getFocusedElementText()).to eq("Surgeries")

        expect(getCount()).to eq(12)

        expect(getTextForRow(12).include?("ZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgery")).to be true

        clickNthRow(12)
        !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Surgery")

        expect(@surgeries.getNameOfSurgery()).to eq("ZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgery")
        expect(@surgeries.getNameOfSurgery().length()).to eq(100)
        expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/10/2010")
        expect(@surgeries.isEstimatedYes()).to be true
        expect(@surgeries.isEstimatedNo()).to be false
        expect(@surgeries.getReasonForSurgery()).to eq("I was catching too many z's. I was catching too many z's. I was catching too many z's. I was catching too many z's. I was catching too many z's. I was")
        expect(@surgeries.getReasonForSurgery().length()).to eq(150)
        expect(@surgeries.getFirstName()).to eq("ScottScottScottScottScottScottScottScottScottScott")
        expect(@surgeries.getFirstName().length()).to eq(50)
        expect(@surgeries.getLastName()).to eq("SimpsonSimpsonSimpsonSimpsonSimpsonSimpsonSimpsonS")
        expect(@surgeries.getLastName().length()).to eq(50)
        expect(@surgeries.getClinicOrganization()).to eq("The Organization The Organization The Organization")
        expect(@surgeries.getClinicOrganization().length()).to eq(50)
        expect(@surgeries.getFacilityHospital()).to eq("UnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUn")
        expect(@surgeries.getFacilityHospital().length()).to eq(100)
        expect(@surgeries.getSource()).to eq("Source: Self")
        expect(@surgeries.getNote()).to eq("ZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZ")
        expect(@surgeries.getNote().length()).to eq(250)
        expect(@surgeries.getCountDownDisplayForNote()).to eq("0 characters left")
      end

      context "Delete" do

          it "When a user selects Delete, the system prompts the user to confirm the Delete by displaying a modal" do
            @surgeries.clickDeleteButton()
            !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Yes")
            expect(@modal.getCancelButtonText()).to eq("No")
          end

          it "Clicking No closes the modal and returns the user to the Detail entry, edit mode, with focus on the delete button." do
            @modal.clickNoButton()
            !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")
            !5.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
            expect(getFocusedElementText()).to eq("Delete")

            @surgeries.clickCancelButton()
            !5.times{ break if (@mymedical.getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(@mymedical.getPrimaryHeader()).to eq("Surgeries")

            expect(getCount()).to eq(12)
          end

          it "Clicking Yes, closes the modal, and moves the user to the Detail view with the table shown and the deleted item is removed from the table list." do
            clickNthRow(12)
            !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            @surgeries.clickDeleteButton()
            !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Yes")
            expect(@modal.getCancelButtonText()).to eq("No")

            @modal.clickYesButton()
            !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")
            !5.times{ break if (getFocusedElementText().include?("Surgeries")); sleep 1 }
            expect(getFocusedElementText()).to eq("Surgeries")

            expect(getCount()).to eq(11)
          end

      end

  end

  context "AC #JRNL-1923|TC #JRNL-1869: Navigation" do

      it "On all form factors when the user views the Add or Edit Detail screen (secondary detail page), a < is shown (alt text: Return to Surgeries table view); when clicked the user is returned to the Detail Screen for the group where the filter and table list view is presented." do
        clickNthRow(1)
        !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Surgery")

        expect(@surgeries.isBackButtonVisible()).to be true
        # JRNL-1580 changes back button text of entry page to 'Return to Previous Screen'
        # expect(@surgeries.getBackButtonAltText()).to eq("Return to Surgeries table view")
        expect(@surgeries.getBackButtonAltText()).to eq("Return to Previous Screen")
      end


      context "If a user selects the < symbol and there are unsaved changes on the screen, the system will prompt the user to save their changes via a modal:" do
          it "No changes" do
            @surgeries.clickBackButton()
            @mymedical.clickSurgeries()
            !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")
          end

          it "With changes" do
            clickNthRow(1)
            !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            @surgeries.setNameOfSurgery("sdfsdfsd")

            @surgeries.clickBackButton()

            !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Continue")
            expect(@modal.getCancelButtonText()).to eq("Return")

            @modal.clickReturnButton()
            !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            @surgeries.clickBackButton()

            !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Continue")
            expect(@modal.getCancelButtonText()).to eq("Return")

            @modal.clickContinueButton()
            !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")

            clickNthRow(1)
            !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            expect(@surgeries.getNameOfSurgery()).to eq("a surgery")
          end

      end


      context "If the user tries to Navigate away from a detail record where a field has been updated without Saving, the user is prompted to confirm that they want to leave the record without saving via a modal." do

          it "No changes" do
            @mymedical.clickSurgeries()
            !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")
          end

          it "With changes" do
            clickNthRow(1)
            !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            @surgeries.setNameOfSurgery("ASDFGHJKL")
            @mymedical.clickSurgeries()

            !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Continue")
            expect(@modal.getCancelButtonText()).to eq("Return")

            @modal.clickReturnButton()
            !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            @mymedical.clickSurgeries()
            !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Continue")
            expect(@modal.getCancelButtonText()).to eq("Return")

            @modal.clickContinueButton()
            !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")

            clickNthRow(1)
            !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            expect(@surgeries.getNameOfSurgery()).to eq("a surgery")
            @surgeries.clickCancelButton()
            !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")
          end

      end

  end

  #######################
  ### Local Functions ###
  #######################

  def checkingInlineError(errMsg, seqNum)

    #Verify that the error message section header is displayed
    if seqNum == 0 then
      !5.times{ break if (@error.getValidationSummaryHeader("form") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq("The following errors were found:")
    end
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("form", errMsg)).to be true

  end

end


















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'

include Globalized

describe "[Story #JRNL-1960: Surgeries Edit/Delete/Nav]", :broken => true, :regression => true  do

  before(:all) do
    @ENTRY_FORM = [ \
        "* required field",
        "* Name of Surgery:",
        # JRNL-1196 changed 'Name of Surgery' to a type-ahead input
        "Auto-complete input",
        # "100 character maximum",
        "* Date of Surgery/Procedure:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Is this date estimated?",
        "Yes",
        "No",
        "Reason for Surgery:",
        "150 character maximum",
        "Provider:",
        "First Name:",
        "50 character maximum",
        "Last Name:",
        "50 character maximum",
        "Clinic/Organization:",
        "50 character maximum",
        "Facility/Hospital:",
        "100 character maximum",
        "Source: Self",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Delete Cancel",
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("surgeries", "medicalhistorydb", "surgeries")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:id, "MyMedical").click
    waitForPageToFinishLoading
    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickSurgeries()
    !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Surgeries")

    expect(getCount()).to eq(12)
  end

  after(:all) do
    quitDriver()
  end

  context "AC #JRNL-1925|TC #JRNL-1888: Edit an Entry" do

      context "When the user selects a Surgery entry from the table view" do

          it "The system displays the Surgery record in the Detail screen in Edit mode: (header: Edit Surgery)" do
            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")
            !10.times{ break if (getFocusedElementText().include?("Edit Surgery")); sleep 1 }
            expect(getFocusedElementText()).to eq("Edit Surgery")
          end

          it "All values previously saved are visible. If no value was previously saved for a field, the display defaults to null (or select for drop lists); no guidance text (light gray placeholder text) is shown unless and all fields are optional unless otherwise indicated." do
            expect(@surgeries.getNameOfSurgery()).to eq("A Surgery")
            expect(@surgeries.isFieldRequired(:css, Surgeries::SURGERY)).to be true
            expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/01/2014")
            expect(@surgeries.isFieldRequired(:css, Surgeries::SURGERY_DATE)).to be true
            expect(@surgeries.isEstimatedYes()).to be false
            expect(@surgeries.isFieldRequired(:css, Surgeries::YES_RADIO)).to be false
            expect(@surgeries.isEstimatedNo()).to be false
            expect(@surgeries.isFieldRequired(:css, Surgeries::NO_RADIO)).to be false
            expect(@surgeries.getReasonForSurgery()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::REASON)).to be false
            expect(@surgeries.getFirstName()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::FIRST_NAME)).to be false
            expect(@surgeries.getLastName()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::LAST_NAME)).to be false
            expect(@surgeries.getClinicOrganization()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::CLINIC_ORGANIZATION)).to be false
            expect(@surgeries.getFacilityHospital()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::FACILITY_HOSPITAL)).to be false
            expect(@surgeries.getSource()).to eq("Source: Self")
            expect(@surgeries.getNote()).to eq("")
            expect(@surgeries.isFieldRequired(:css, Surgeries::NOTE)).to be false
            expect(@surgeries.getCountDownDisplayForNote()).to eq("250 characters left")
          end

          it "All data elements available in Add Entry mode are visible." do
            expect(@surgeries.isDeleteButtonVisible()).to be true
            expect(@surgeries.isCancelButtonVisible()).to be true
            expect(@surgeries.isSaveButtonVisible()).to be true

            form = @surgeries.getScreenContent().split("\n")
            @ENTRY_FORM.each_with_index do | expectedScreenRow, i |
              expect(form[i]).to eq(expectedScreenRow)
            end
            expect(form.length).to eq(@ENTRY_FORM.length())

            @surgeries.setNameOfSurgery("")
            @surgeries.setDateOfSurgeryProcedure("")
            @surgeries.clickSaveButton()

            checkingInlineError("Name of Surgery field is required.", 0)
            checkingInlineError("Date of Surgery/Procedure field is required.", 1)

            @surgeries.setNameOfSurgery("x")
            @surgeries.setDateOfSurgeryProcedure("01/01")
            @surgeries.clickSaveButton()

            checkingInlineError("Date of Surgery/Procedure must be formatted MM/DD/YYYY.", 0)
          end

      end

  end

  context "AC #JRNL-1924|TC #JRNL-1904: Standard Edit functions are available (Save, Cancel, Delete)" do

      it "Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        @surgeries.setNameOfSurgery("Abc")
        @surgeries.clickDateOfSurgeryCalendarBtn()
        !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(3, 7, 1991)

        @surgeries.clickCancelButton()
        !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Surgeries")
        !10.times{ break if (getFocusedElementText().include?("Surgeries")); sleep 1 }
        expect(getFocusedElementText()).to eq("Surgeries")
      end

      it "Cancel -  When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        expect(getCount()).to eq(12)

        clickNthRow(1)
        !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Surgery")

        expect(@surgeries.getNameOfSurgery()).to eq("A Surgery")
        expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/01/2014")
        expect(@surgeries.isEstimatedYes()).to be false
        expect(@surgeries.isEstimatedNo()).to be false
        expect(@surgeries.getReasonForSurgery()).to eq("")
        expect(@surgeries.getFirstName()).to eq("")
        expect(@surgeries.getLastName()).to eq("")
        expect(@surgeries.getClinicOrganization()).to eq("")
        expect(@surgeries.getFacilityHospital()).to eq("")
        expect(@surgeries.getSource()).to eq("Source: Self")
        expect(@surgeries.getNote()).to eq("")
        expect(@surgeries.getCountDownDisplayForNote()).to eq("250 characters left")
      end

      it "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view." do
        @surgeries.setNameOfSurgery("Abc")
        @surgeries.setDateOfSurgeryProcedure("10/16/2014")

        @surgeries.clickSaveButton()
        !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Surgeries")
        !10.times{ break if (getFocusedElementText().include?("Surgeries")); sleep 1 }
        expect(getFocusedElementText()).to eq("Surgeries")

        expect(getCount()).to eq(12)

        expect(getTextForRow(1).include?("Abc")).to be true
      end

      it "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view." do
        clickNthRow(1)
        !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Surgery")

        expect(@surgeries.getNameOfSurgery()).to eq("Abc")
        expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/16/2014")
        expect(@surgeries.isEstimatedYes()).to be false
        expect(@surgeries.isEstimatedNo()).to be false
        expect(@surgeries.getReasonForSurgery()).to eq("")
        expect(@surgeries.getFirstName()).to eq("")
        expect(@surgeries.getLastName()).to eq("")
        expect(@surgeries.getClinicOrganization()).to eq("")
        expect(@surgeries.getFacilityHospital()).to eq("")
        expect(@surgeries.getSource()).to eq("Source: Self")
        expect(@surgeries.getNote()).to eq("")
        expect(@surgeries.getCountDownDisplayForNote()).to eq("250 characters left")

        @surgeries.setNameOfSurgery("ZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgery")
        @surgeries.setDateOfSurgeryProcedure("10/10/2010")
        @surgeries.setEstimatedYes()
        @surgeries.setReasonForSurgery("I was catching too many z's. I was catching too many z's. I was catching too many z's. I was catching too many z's. I was catching too many z's. I was catching too many z's.")
        @surgeries.setFirstName("ScottScottScottScottScottScottScottScottScottScottScott")
        @surgeries.setLastName("SimpsonSimpsonSimpsonSimpsonSimpsonSimpsonSimpsonSimpson")
        @surgeries.setClinicOrganization("The Organization The Organization The Organization The Organization")
        @surgeries.setFacilityHospital("UnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknown")
        @surgeries.setNote("ZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzz")

        @surgeries.clickSaveButton()
        !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Surgeries")
        !10.times{ break if (getFocusedElementText().include?("Surgeries")); sleep 1 }
        expect(getFocusedElementText()).to eq("Surgeries")

        expect(getCount()).to eq(12)

        expect(getTextForRow(12).include?("ZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgery")).to be true

        clickNthRow(12)
        !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Surgery")

        expect(@surgeries.getNameOfSurgery()).to eq("ZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgeryZZZSurgery")
        expect(@surgeries.getNameOfSurgery().length()).to eq(100)
        expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/10/2010")
        expect(@surgeries.isEstimatedYes()).to be true
        expect(@surgeries.isEstimatedNo()).to be false
        expect(@surgeries.getReasonForSurgery()).to eq("I was catching too many z's. I was catching too many z's. I was catching too many z's. I was catching too many z's. I was catching too many z's. I was")
        expect(@surgeries.getReasonForSurgery().length()).to eq(150)
        expect(@surgeries.getFirstName()).to eq("ScottScottScottScottScottScottScottScottScottScott")
        expect(@surgeries.getFirstName().length()).to eq(50)
        expect(@surgeries.getLastName()).to eq("SimpsonSimpsonSimpsonSimpsonSimpsonSimpsonSimpsonS")
        expect(@surgeries.getLastName().length()).to eq(50)
        expect(@surgeries.getClinicOrganization()).to eq("The Organization The Organization The Organization")
        expect(@surgeries.getClinicOrganization().length()).to eq(50)
        expect(@surgeries.getFacilityHospital()).to eq("UnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUnknownUn")
        expect(@surgeries.getFacilityHospital().length()).to eq(100)
        expect(@surgeries.getSource()).to eq("Source: Self")
        expect(@surgeries.getNote()).to eq("ZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZzzZ")
        expect(@surgeries.getNote().length()).to eq(250)
        expect(@surgeries.getCountDownDisplayForNote()).to eq("0 characters left")
      end

      context "Delete" do

          it "When a user selects Delete, the system prompts the user to confirm the Delete by displaying a modal" do
            @surgeries.clickDeleteButton()
            !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Yes")
            expect(@modal.getCancelButtonText()).to eq("No")
          end

          it "Clicking No closes the modal and returns the user to the Detail entry, edit mode, with focus on the delete button." do
            @modal.clickNoButton()
            !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")
            !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
            expect(getFocusedElementText()).to eq("Delete")

            @surgeries.clickCancelButton()
            !45.times{ break if (@mymedical.getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(@mymedical.getPrimaryHeader()).to eq("Surgeries")

            expect(getCount()).to eq(12)
          end

          it "Clicking Yes, closes the modal, and moves the user to the Detail view with the table shown and the deleted item is removed from the table list." do
            clickNthRow(12)
            !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            @surgeries.clickDeleteButton()
            !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Yes")
            expect(@modal.getCancelButtonText()).to eq("No")

            @modal.clickYesButton()
            !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")
            !10.times{ break if (getFocusedElementText().include?("Surgeries")); sleep 1 }
            expect(getFocusedElementText()).to eq("Surgeries")

            expect(getCount()).to eq(11)
          end

      end

  end

  context "AC #JRNL-1923|TC #JRNL-1869: Navigation" do

      it "On all form factors when the user views the Add or Edit Detail screen (secondary detail page), a < is shown (alt text: Return to Surgeries table view); when clicked the user is returned to the Detail Screen for the group where the filter and table list view is presented." do
        clickNthRow(1)
        !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Surgery")

        expect(@surgeries.isBackButtonVisible()).to be true
        # JRNL-1580 changes back button text of entry page to 'Return to Previous Screen'
        # expect(@surgeries.getBackButtonAltText()).to eq("Return to Surgeries table view")
        expect(@surgeries.getBackButtonAltText()).to eq("Return to Previous Screen")
      end


      context "If a user selects the < symbol and there are unsaved changes on the screen, the system will prompt the user to save their changes via a modal:" do
          it "No changes" do
            @surgeries.clickBackButton()
            @mymedical.clickSurgeries()
            !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")
          end

          it "With changes" do
            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            @surgeries.setNameOfSurgery("sdfsdfsd")

            @surgeries.clickBackButton()

            !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Continue")
            expect(@modal.getCancelButtonText()).to eq("Return")

            @modal.clickReturnButton()
            !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            @surgeries.clickBackButton()

            !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Continue")
            expect(@modal.getCancelButtonText()).to eq("Return")

            @modal.clickContinueButton()
            !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")

            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            expect(@surgeries.getNameOfSurgery()).to eq("a surgery")
          end

      end


      context "If the user tries to Navigate away from a detail record where a field has been updated without Saving, the user is prompted to confirm that they want to leave the record without saving via a modal." do

          it "No changes" do
            @mymedical.clickSurgeries()
            !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")
          end

          it "With changes" do
            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            @surgeries.setNameOfSurgery("ASDFGHJKL")
            @mymedical.clickSurgeries()

            !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Continue")
            expect(@modal.getCancelButtonText()).to eq("Return")

            @modal.clickReturnButton()
            !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            @mymedical.clickSurgeries()
            !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Continue")
            expect(@modal.getCancelButtonText()).to eq("Return")

            @modal.clickContinueButton()
            !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")

            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Edit Surgery")

            expect(@surgeries.getNameOfSurgery()).to eq("a surgery")
            @surgeries.clickCancelButton()
            !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getPrimaryHeader()).to eq("Surgeries")
          end

      end

  end

  #######################
  ### Local Functions ###
  #######################

  def checkingInlineError(errMsg, seqNum)

    #Verify that the error message section header is displayed
    if seqNum == 0 then
      !45.times{ break if (@error.getValidationSummaryHeader("form") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq("The following errors were found:")
    end
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("form", errMsg)).to be true

  end

end
=end