require_relative '../../../globalized'

include Globalized

describe "[Story #JRNL-1960: Surgeries Add]", :regression => true do

  before(:all) do
    @ENTRY_FORM = [ \
        "* required field",
        "* Name of Surgery:",
        # JRNL-1196 changed 'Name of Surgery' to a type-ahead input
        "Auto-complete input",
        # "100 character maximum",
        "*",
        "Required: Date of Surgery/Procedure: M M / D D / Y Y Y Y:",
        "Date of Surgery/Procedure:",
        "This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.",
        "Is this date estimated?",
        "Yes",
        "No",
        "Reason for Surgery:",
        "150 character maximum",
        "Provider:",
        "First Name:",
        "50 character maximum",
        "Last Name:",
        "50 character maximum",
        "Clinic/Organization:",
        "50 character maximum",
        "Facility/Hospital:",
        "100 character maximum",
        "Source: Self",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel",
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("surgeries", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:id, "MyMedical").click
    waitForPageToFinishLoading
    @nav_menu.clickMyMedical()
    !5.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickSurgeries()
    !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Surgeries")
  end

  # after(:all) do
  #   quitDriver()
  # end

  context "AC #JRNL-1926|TC #JRNL-1905: Add New Entry" do

      it "When the user views the Surgeries Table list, an Add button (+ icon, alt text Add), is available in the upper right corner of the Detail screen." do
        expect(@common.isAddButtonVisible()).to eq(true)
      end

      it "When a user selects Add, the Add Surgery screen is shown, header:  Add Surgery" do
        #@common.clickAddButton()
        waitForPageToFinishLoading
        @medications.clickAddEntryButton()
        waitForPageToFinishLoading
        !5.times{ break if (getPrimaryHeader() == "Add Surgery"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Add Surgery")
      end

      context "Detailed Surgery fields include the following:" do

          it "Unless otherwise indicated, all values default to null (or select for drop lists), no guidance text (light gray placeholder text) is shown, and all fields are optional.", :broken => true do
            expect(@surgeries.getNameOfSurgery()).to eq("")
            expect(@surgeries.getDateOfSurgeryProcedure()).to eq("")
            expect(@surgeries.isEstimatedYes()).to eq(false)
            #expect(@surgeries.isEstimatedNo()).to eq(false)
            expect(@surgeries.getReasonForSurgery()).to eq("")
            expect(@surgeries.getFirstName()).to eq("")
            expect(@surgeries.getLastName()).to eq("")
            expect(@surgeries.getClinicOrganization()).to eq("")
            expect(@surgeries.getFacilityHospital()).to eq("")
            expect(@surgeries.getSource()).to eq("Source: Self")
            expect(@surgeries.getNote()).to eq("")
            expect(@surgeries.getCountDownDisplayForNote()).to eq("250 characters left")

            form = @surgeries.getScreenContent().split("\n")
            @ENTRY_FORM.each_with_index do | expectedScreenRow, i |
              expect(form[i]).to eq(expectedScreenRow)
            end
            expect(form.length()).to eq(@ENTRY_FORM.length())
          end

          it "Name of Surgery (required, alphanumeric, text box, 100 characters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::SURGERY)).to eq(true)

            @surgeries.clickSaveButton()

            checkingInlineError("Name of Surgery field is required.", 0)

            @surgeries.setNameOfSurgery("!@$%^&*()_+:?><,.;-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,.;-~`")
            expect(@surgeries.getNameOfSurgery()).to eq ("!@$%^&*()_+:?><,.;-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,")
            expect(@surgeries.getNameOfSurgery().length).to eq(100)
          end

          it "Date of Surgery/Procedure (required, date, date picker, MM/DD/YYYY format, show light gray text as format mask and read format in VO)", :broken => true do
            expect(@surgeries.isFieldRequired(:css, Surgeries::SURGERY_DATE)).to eq(true)

            @surgeries.setDateOfSurgeryProcedure("09/19/3000")
            @surgeries.clickSaveButton()

            checkingInlineError("Date of Surgery/Procedure must be formatted MM/DD/YYYY.", 0)

            #@surgeries.clickDateOfSurgeryCalendarBtn()
            !5.times{ break if (@date_picker.getSetButtonText() == "SET"); sleep 1 }
            #@date_picker.setDateFromGUI(10, 14, 2014)
            waitForPageToFinishLoading
            @driver.find_element(:id, "date").clear
            waitForPageToFinishLoading
            @driver.find_element(:id, "date").send_keys "10/14/2014"
            waitForPageToFinishLoading
            expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/14/2014")
          end

          it "Is this date estimated? (single select, radio button, values: Yes, No)", :broken => true do
            expect(@surgeries.isFieldRequired(:css, Surgeries::YES_RADIO)).to eq(false)
            expect(@surgeries.isFieldRequired(:css, Surgeries::NO_RADIO)).to eq(false)

            @surgeries.setEstimatedYes()
            expect(@surgeries.isEstimatedYes()).to eq(true)
            expect(@surgeries.isEstimatedNo()).to eq(false)

            @surgeries.setEstimatedNo()
            expect(@surgeries.isEstimatedYes()).to eq(false)
            expect(@surgeries.isEstimatedNo()).to eq(true)
          end

          it "Reason for Surgery (alphanumeric, text box, 150 characters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::REASON)).to eq(false)

            @surgeries.setReasonForSurgery("!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ")
            expect(@surgeries.getReasonForSurgery()).to eq("!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFG")
            expect(@surgeries.getReasonForSurgery().length()).to eq(150)
          end

          it "First Name (alphanumeric, text box, 50 characters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::FIRST_NAME)).to eq(false)

            @surgeries.setFirstName("1234567890!?><$@AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz")
            expect(@surgeries.getFirstName()).to eq("1234567890!?><$@AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQq")
            expect(@surgeries.getFirstName().length()).to eq(50)
          end

          it "Last Name (alphanumeric, textbox, 50 charcters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::LAST_NAME)).to eq(false)

            @surgeries.setLastName("SsTtUuVvWwXxYyZz1234567890!?><$@AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRr")
            expect(@surgeries.getLastName()).to eq("SsTtUuVvWwXxYyZz1234567890!?><$@AaBbCcDdEeFfGgHhIi")
            expect(@surgeries.getLastName().length()).to eq(50)
          end

          it "Clinic/Organization(alphanumeric, text box, 50 characters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::CLINIC_ORGANIZATION)).to eq(false)

            @surgeries.setClinicOrganization("CcDdEeFfGgHhIi1234567890!?><$@AaBbOoPpQqRrSsTtUuVvWwXxYyZzJjKkLlMmNn")
            expect(@surgeries.getClinicOrganization()).to eq("CcDdEeFfGgHhIi1234567890!?><$@AaBbOoPpQqRrSsTtUuVv")
            expect(@surgeries.getClinicOrganization().length()).to eq(50)
          end

          it "Facility/Hospital (alphanumeric, text box, 100 characters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::FACILITY_HOSPITAL)).to eq(false)

            @surgeries.setFacilityHospital("jhgfdaszxmncbvABCDEFGHIJKJLMNOPQ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkRSTUVWXYZ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ")
            expect(@surgeries.getFacilityHospital()).to eq("jhgfdaszxmncbvABCDEFGHIJKJLMNOPQ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkRSTUVWXYZ!@$%^&*()_+:?><")
            expect(@surgeries.getFacilityHospital().length()).to eq(100)
          end

          it "Source:  Self (static text)" do
            expect(@surgeries.getSource()).to eq("Source: Self")
          end

          it "Note: (alphanumeric, textbox, 250 characters, display character countdown)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::NOTE)).to eq(false)

            text150 = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890="
            @surgeries.setNote(text150)
            expect(@surgeries.getNote()).to eq(text150)
            expect(@surgeries.getNote().length()).to eq(150)
            expect(@surgeries.getCountDownDisplayForNote()).to eq("100 characters left")

            @surgeries.setNote(text150 + text150)
            expect(@surgeries.getNote()).to eq((text150 + text150)[0..-51])
            expect(@surgeries.getNote().length()).to eq(250)
            expect(@surgeries.getCountDownDisplayForNote()).to eq("0 characters left")
          end

      end

      it "Standard Save and Cancel options are available." do
        expect(@surgeries.isDeleteButtonVisible()).to eq(false)
        expect(@surgeries.isCancelButtonVisible()).to eq(true)
        expect(@surgeries.isSaveButtonVisible()).to eq(true)
      end

      context "AC #JRNL-1924|TC #JRNL-1904: Save, Cancel, Delete Functionality" do

          it "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view.", :broken => true do
            @surgeries.clickSaveButton()
            !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getFocusedElementText()).to match("Surgeries")
            expect(getCount()).to eq(1)

            clickNthRow(1)
            !5.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getFocusedElementText()).to match("Edit Surgery")

            expect(@surgeries.getNameOfSurgery()).to eq ("!@$%^&*()_+:?><,.;-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,")
            expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/14/2014")
            expect(@surgeries.isEstimatedYes()).to eq(false)
            expect(@surgeries.isEstimatedNo()).to eq(true)
            expect(@surgeries.getReasonForSurgery()).to eq("!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFG")
            expect(@surgeries.getFirstName()).to eq("1234567890!?><$@AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQq")
            expect(@surgeries.getLastName()).to eq("SsTtUuVvWwXxYyZz1234567890!?><$@AaBbCcDdEeFfGgHhIi")
            expect(@surgeries.getClinicOrganization()).to eq("CcDdEeFfGgHhIi1234567890!?><$@AaBbOoPpQqRrSsTtUuVv")
            expect(@surgeries.getFacilityHospital()).to eq("jhgfdaszxmncbvABCDEFGHIJKJLMNOPQ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkRSTUVWXYZ!@$%^&*()_+:?><")
            expect(@surgeries.getNote()).to eq("123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890=123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789A")
            expect(@surgeries.getCountDownDisplayForNote()).to eq("0 characters left")

            @surgeries.clickCancelButton()
            !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
          end

          it "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view.", :broken => true do
            @common.clickAddButton()
            !5.times{ break if (getPrimaryHeader() == "Add Surgery"); sleep 1 }

            @surgeries.setNameOfSurgery("A")
            @surgeries.setDateOfSurgeryProcedure("03/07/1991")
            @surgeries.clickSaveButton()
            !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getFocusedElementText()).to match("Surgeries")

            expect(getCount()).to eq(2)

            clickNthRow(2)

            expect(@surgeries.getNameOfSurgery()).to eq ("A")
            expect(@surgeries.getDateOfSurgeryProcedure()).to eq("03/07/1991")
            expect(@surgeries.isEstimatedYes()).to eq(false)
            expect(@surgeries.isEstimatedNo()).to eq(false)
            expect(@surgeries.getReasonForSurgery()).to eq("")
            expect(@surgeries.getFirstName()).to eq("")
            expect(@surgeries.getLastName()).to eq("")
            expect(@surgeries.getClinicOrganization()).to eq("")
            expect(@surgeries.getFacilityHospital()).to eq("")
            expect(@surgeries.getNote()).to eq("")
            expect(@surgeries.getCountDownDisplayForNote()).to eq("250 characters left")

            @surgeries.clickCancelButton()
            !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
          end

          it "Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header.", :broken => true do
            @common.clickAddButton()
            !5.times{ break if (getPrimaryHeader() == "Add Surgery"); sleep 1 }

            @surgeries.setReasonForSurgery("AAAA")
            @surgeries.clickCancelButton()
            !5.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getFocusedElementText()).to match("Surgeries")
            expect(getCount()).to eq(2)
          end

      end

  end

  #######################
  ### Local Functions ###
  #######################

  def checkingInlineError(errMsg, seqNum)

    #Verify that the error message section header is displayed
    if seqNum == 0 then
      !5.times{ break if (@error.getValidationSummaryHeader("form") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq("The following errors were found:")
    end
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("form", errMsg)).to eq(true)

  end

end


























































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'

include Globalized

describe "[Story #JRNL-1960: Surgeries Add]", :regression => true do

  before(:all) do
    @ENTRY_FORM = [ \
        "* required field",
        "* Name of Surgery:",
        # JRNL-1196 changed 'Name of Surgery' to a type-ahead input
        "Auto-complete input",
        # "100 character maximum",
        "* Date of Surgery/Procedure:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Is this date estimated?",
        "Yes",
        "No",
        "Reason for Surgery:",
        "150 character maximum",
        "Provider:",
        "First Name:",
        "50 character maximum",
        "Last Name:",
        "50 character maximum",
        "Clinic/Organization:",
        "50 character maximum",
        "Facility/Hospital:",
        "100 character maximum",
        "Source: Self",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel",
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("surgeries", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickSurgeries()
    !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Surgeries")
  end

  after(:all) do
    quitDriver()
  end

  context "AC #JRNL-1926|TC #JRNL-1905: Add New Entry" do

      it "When the user views the Surgeries Table list, an Add button (+ icon, alt text Add), is available in the upper right corner of the Detail screen." do
        expect(@common.isAddButtonVisible()).to eq(true)
      end

      it "When a user selects Add, the Add Surgery screen is shown, header:  Add Surgery" do
        @common.clickAddButton()
        !45.times{ break if (getPrimaryHeader() == "Add Surgery"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Add Surgery")
      end

      context "Detailed Surgery fields include the following:" do

          it "Unless otherwise indicated, all values default to null (or select for drop lists), no guidance text (light gray placeholder text) is shown, and all fields are optional.", :broken => true do
            expect(@surgeries.getNameOfSurgery()).to eq("")
            expect(@surgeries.getDateOfSurgeryProcedure()).to eq("")
            expect(@surgeries.isEstimatedYes()).to eq(false)
            expect(@surgeries.isEstimatedNo()).to eq(false)
            expect(@surgeries.getReasonForSurgery()).to eq("")
            expect(@surgeries.getFirstName()).to eq("")
            expect(@surgeries.getLastName()).to eq("")
            expect(@surgeries.getClinicOrganization()).to eq("")
            expect(@surgeries.getFacilityHospital()).to eq("")
            expect(@surgeries.getSource()).to eq("Source: Self")
            expect(@surgeries.getNote()).to eq("")
            expect(@surgeries.getCountDownDisplayForNote()).to eq("250 characters left")

            form = @surgeries.getScreenContent().split("\n")
            @ENTRY_FORM.each_with_index do | expectedScreenRow, i |
              expect(form[i]).to eq(expectedScreenRow)
            end
            expect(form.length()).to eq(@ENTRY_FORM.length())
          end

          it "Name of Surgery (required, alphanumeric, text box, 100 characters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::SURGERY)).to eq(true)

            @surgeries.clickSaveButton()

            checkingInlineError("Name of Surgery field is required.", 0)

            @surgeries.setNameOfSurgery("!@$%^&*()_+:?><,.;-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,.;-~`")
            expect(@surgeries.getNameOfSurgery()).to eq ("!@$%^&*()_+:?><,.;-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,")
            expect(@surgeries.getNameOfSurgery().length).to eq(100)
          end

          it "Date of Surgery/Procedure (required, date, date picker, MM/DD/YYYY format, show light gray text as format mask and read format in VO)", :broken => true do
            expect(@surgeries.isFieldRequired(:css, Surgeries::SURGERY_DATE)).to eq(true)

            @surgeries.setDateOfSurgeryProcedure("09/19/3000")
            @surgeries.clickSaveButton()

            checkingInlineError("Date of Surgery/Procedure must be formatted MM/DD/YYYY.", 0)

            @surgeries.clickDateOfSurgeryCalendarBtn()
            !45.times{ break if (@date_picker.getSetButtonText() == "SET"); sleep 1 }
            @date_picker.setDateFromGUI(10, 14, 2014)
            expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/14/2014")
          end

          it "Is this date estimated? (single select, radio button, values: Yes, No)", :broken => true do
            expect(@surgeries.isFieldRequired(:css, Surgeries::YES_RADIO)).to eq(false)
            expect(@surgeries.isFieldRequired(:css, Surgeries::NO_RADIO)).to eq(false)

            @surgeries.setEstimatedYes()
            expect(@surgeries.isEstimatedYes()).to eq(true)
            expect(@surgeries.isEstimatedNo()).to eq(false)

            @surgeries.setEstimatedNo()
            expect(@surgeries.isEstimatedYes()).to eq(false)
            expect(@surgeries.isEstimatedNo()).to eq(true)
          end

          it "Reason for Surgery (alphanumeric, text box, 150 characters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::REASON)).to eq(false)

            @surgeries.setReasonForSurgery("!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ")
            expect(@surgeries.getReasonForSurgery()).to eq("!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFG")
            expect(@surgeries.getReasonForSurgery().length()).to eq(150)
          end

          it "First Name (alphanumeric, text box, 50 characters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::FIRST_NAME)).to eq(false)

            @surgeries.setFirstName("1234567890!?><$@AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz")
            expect(@surgeries.getFirstName()).to eq("1234567890!?><$@AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQq")
            expect(@surgeries.getFirstName().length()).to eq(50)
          end

          it "Last Name (alphanumeric, textbox, 50 charcters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::LAST_NAME)).to eq(false)

            @surgeries.setLastName("SsTtUuVvWwXxYyZz1234567890!?><$@AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRr")
            expect(@surgeries.getLastName()).to eq("SsTtUuVvWwXxYyZz1234567890!?><$@AaBbCcDdEeFfGgHhIi")
            expect(@surgeries.getLastName().length()).to eq(50)
          end

          it "Clinic/Organization(alphanumeric, text box, 50 characters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::CLINIC_ORGANIZATION)).to eq(false)

            @surgeries.setClinicOrganization("CcDdEeFfGgHhIi1234567890!?><$@AaBbOoPpQqRrSsTtUuVvWwXxYyZzJjKkLlMmNn")
            expect(@surgeries.getClinicOrganization()).to eq("CcDdEeFfGgHhIi1234567890!?><$@AaBbOoPpQqRrSsTtUuVv")
            expect(@surgeries.getClinicOrganization().length()).to eq(50)
          end

          it "Facility/Hospital (alphanumeric, text box, 100 characters)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::FACILITY_HOSPITAL)).to eq(false)

            @surgeries.setFacilityHospital("jhgfdaszxmncbvABCDEFGHIJKJLMNOPQ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkRSTUVWXYZ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ")
            expect(@surgeries.getFacilityHospital()).to eq("jhgfdaszxmncbvABCDEFGHIJKJLMNOPQ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkRSTUVWXYZ!@$%^&*()_+:?><")
            expect(@surgeries.getFacilityHospital().length()).to eq(100)
          end

          it "Source:  Self (static text)" do
            expect(@surgeries.getSource()).to eq("Source: Self")
          end

          it "Note: (alphanumeric, textbox, 250 characters, display character countdown)" do
            expect(@surgeries.isFieldRequired(:css, Surgeries::NOTE)).to eq(false)

            text150 = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890="
            @surgeries.setNote(text150)
            expect(@surgeries.getNote()).to eq(text150)
            expect(@surgeries.getNote().length()).to eq(150)
            expect(@surgeries.getCountDownDisplayForNote()).to eq("100 characters left")

            @surgeries.setNote(text150 + text150)
            expect(@surgeries.getNote()).to eq((text150 + text150)[0..-51])
            expect(@surgeries.getNote().length()).to eq(250)
            expect(@surgeries.getCountDownDisplayForNote()).to eq("0 characters left")
          end

      end

      it "Standard Save and Cancel options are available." do
        expect(@surgeries.isDeleteButtonVisible()).to eq(false)
        expect(@surgeries.isCancelButtonVisible()).to eq(true)
        expect(@surgeries.isSaveButtonVisible()).to eq(true)
      end

      context "AC #JRNL-1924|TC #JRNL-1904: Save, Cancel, Delete Functionality" do

          it "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view.", :broken => true do
            @surgeries.clickSaveButton()
            !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getFocusedElementText()).to match("Surgeries")
            expect(getCount()).to eq(1)

            clickNthRow(1)
            !45.times{ break if (getPrimaryHeader() == "Edit Surgery"); sleep 1 }
            expect(getFocusedElementText()).to match("Edit Surgery")

            expect(@surgeries.getNameOfSurgery()).to eq ("!@$%^&*()_+:?><,.;-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,")
            expect(@surgeries.getDateOfSurgeryProcedure()).to eq("10/14/2014")
            expect(@surgeries.isEstimatedYes()).to eq(false)
            expect(@surgeries.isEstimatedNo()).to eq(true)
            expect(@surgeries.getReasonForSurgery()).to eq("!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkjhgfdaszxmncbvABCDEFG")
            expect(@surgeries.getFirstName()).to eq("1234567890!?><$@AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQq")
            expect(@surgeries.getLastName()).to eq("SsTtUuVvWwXxYyZz1234567890!?><$@AaBbCcDdEeFfGgHhIi")
            expect(@surgeries.getClinicOrganization()).to eq("CcDdEeFfGgHhIi1234567890!?><$@AaBbOoPpQqRrSsTtUuVv")
            expect(@surgeries.getFacilityHospital()).to eq("jhgfdaszxmncbvABCDEFGHIJKJLMNOPQ!@$%^&*()_+:?><,.;=-~`1234567890qwertyuioplkRSTUVWXYZ!@$%^&*()_+:?><")
            expect(@surgeries.getNote()).to eq("123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890=123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789A")
            expect(@surgeries.getCountDownDisplayForNote()).to eq("0 characters left")

            @surgeries.clickCancelButton()
            !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
          end

          it "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view.", :broken => true do
            @common.clickAddButton()
            !45.times{ break if (getPrimaryHeader() == "Add Surgery"); sleep 1 }

            @surgeries.setNameOfSurgery("A")
            @surgeries.setDateOfSurgeryProcedure("03/07/1991")
            @surgeries.clickSaveButton()
            !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getFocusedElementText()).to match("Surgeries")

            expect(getCount()).to eq(2)

            clickNthRow(2)

            expect(@surgeries.getNameOfSurgery()).to eq ("A")
            expect(@surgeries.getDateOfSurgeryProcedure()).to eq("03/07/1991")
            expect(@surgeries.isEstimatedYes()).to eq(false)
            expect(@surgeries.isEstimatedNo()).to eq(false)
            expect(@surgeries.getReasonForSurgery()).to eq("")
            expect(@surgeries.getFirstName()).to eq("")
            expect(@surgeries.getLastName()).to eq("")
            expect(@surgeries.getClinicOrganization()).to eq("")
            expect(@surgeries.getFacilityHospital()).to eq("")
            expect(@surgeries.getNote()).to eq("")
            expect(@surgeries.getCountDownDisplayForNote()).to eq("250 characters left")

            @surgeries.clickCancelButton()
            !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
          end

          it "Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header.", :broken => true do
            @common.clickAddButton()
            !45.times{ break if (getPrimaryHeader() == "Add Surgery"); sleep 1 }

            @surgeries.setReasonForSurgery("AAAA")
            @surgeries.clickCancelButton()
            !45.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
            expect(getFocusedElementText()).to match("Surgeries")
            expect(getCount()).to eq(2)
          end

      end

  end

  #######################
  ### Local Functions ###
  #######################

  def checkingInlineError(errMsg, seqNum)

    #Verify that the error message section header is displayed
    if seqNum == 0 then
      !45.times{ break if (@error.getValidationSummaryHeader("form") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq("The following errors were found:")
    end
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed("form", errMsg)).to eq(true)
  end
end
=end