require_relative '../../../globalized'

include Globalized

describe "[Story #JRNL-2472: Pregnancy History - List view]", :broken => true, :regression => true  do

  before(:all) do

    initializeConfigurations(BASE_URL)
    removeCollection("pregnancies", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.female96", "female96, zztest")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")

    @expectedValidationSummaryHeader = "The following errors were found:"

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1934|TC #JRNL-1759: Navigation option for Pregnancy History in Detail Screen" do
    it ".When a user opens the Left Panel navigation and selects My Medical, the system displays a navigation option for the Pregnancy History in the Detail Screen." do
      expect(@nav_menu.getNthSubFeatureName(8)).to eq("Pregnancy History")
    end
  end

  context "#AC JRNL-1932|TC #JRNL-1759: Pregnancy History show in Detail screen" do
    it "When Pregnancy History is selected, the list of entries is shown in the Detail screen, header 'Pregnancy History'" do
      @mymedical.clickPregnancyHistory
      !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Pregnancy History")
    end

    it ".	If no records are found when a filter is applied the following message is shown in the screen area in place of the table view. (Text is centered on the page)" do
      !45.times{ break if (@list.getNoResultsFoundMessage == "Use the Add button above to create a new record."); sleep 1 }
      expect(@list.getNoResultsFoundMessage).to eq("Use the Add button above to create a new record.")
    end

    it ".Pregnancy History entries are displayed in a table format, sorted in ascending order by pregnancy number; null values are shown as empty table cells unless otherwise noted:" do
      addPregnancyHistory()
      expect(@list.getTableHeaders).to eq(["Number", "Outcome", "Outcome Date"])
      expect(@list.getTextForRowColumn(1, 1)).to eq("1")
      expect(@list.getTextForRowColumn(2, 1)).to eq("2")
      expect(@list.getTextForRowColumn(3, 1)).to eq("3")
      expect(@list.getTextForRowColumn(4, 1)).to eq("4")
      expect(@list.getTextForRowColumn(5, 1)).to eq("5")
      expect(@list.getTextForRowColumn(6, 1)).to eq("6")
      expect(@list.getTextForRowColumn(7, 1)).to eq("7")
      expect(@list.getTextForRowColumn(8, 1)).to eq("8")

      expect(@list.getTextForRowColumn(1, 2)).to eq("Vaginal Delivery")
      expect(@list.getTextForRowColumn(2, 2)).to eq("C-section")
      expect(@list.getTextForRowColumn(3, 2)).to eq("Still Birth")
      expect(@list.getTextForRowColumn(4, 2)).to eq("Miscarriage")
      expect(@list.getTextForRowColumn(5, 2)).to eq("Elective Abortion")
      expect(@list.getTextForRowColumn(6, 2)).to eq("Therapeutic Abortion")
      expect(@list.getTextForRowColumn(7, 2)).to eq("Ectopic")
      expect(@list.getTextForRowColumn(8, 2)).to eq("Other")

      twoYearAgo = getDateNthYearsAgo(2, "%m/%d/%Y")
      fourYearAgo = getDateNthYearsAgo(4, "%m/%d/%Y")
      sixYearAgo = getDateNthYearsAgo(6, "%m/%d/%Y")
      eightYearAgo = getDateNthYearsAgo(8, "%m/%d/%Y")

      expect(@list.getTextForRowColumn(1, 3)).to eq("")
      expect(@list.getTextForRowColumn(2, 3)).to eq(twoYearAgo)
      expect(@list.getTextForRowColumn(3, 3)).to eq("")
      expect(@list.getTextForRowColumn(4, 3)).to eq(fourYearAgo)
      expect(@list.getTextForRowColumn(5, 3)).to eq("")
      expect(@list.getTextForRowColumn(6, 3)).to eq(sixYearAgo)
      expect(@list.getTextForRowColumn(7, 3)).to eq("")
      expect(@list.getTextForRowColumn(8, 3)).to eq(eightYearAgo)
    end

    it ". Phone view display" do
      resizeWindowToPhone()

      expect(@list.getTableHeaders).to eq(["Number", "Outcome"])
      expect(@list.getTextForRowColumn(1, 1)).to eq("1")
      expect(@list.getTextForRowColumn(2, 1)).to eq("2")
      expect(@list.getTextForRowColumn(3, 1)).to eq("3")
      expect(@list.getTextForRowColumn(4, 1)).to eq("4")
      expect(@list.getTextForRowColumn(5, 1)).to eq("5")
      expect(@list.getTextForRowColumn(6, 1)).to eq("6")
      expect(@list.getTextForRowColumn(7, 1)).to eq("7")
      expect(@list.getTextForRowColumn(8, 1)).to eq("8")

      expect(@list.getTextForRowColumn(1, 2)).to eq("Vaginal Delivery")
      expect(@list.getTextForRowColumn(2, 2)).to eq("C-section")
      expect(@list.getTextForRowColumn(3, 2)).to eq("Still Birth")
      expect(@list.getTextForRowColumn(4, 2)).to eq("Miscarriage")
      expect(@list.getTextForRowColumn(5, 2)).to eq("Elective Abortion")
      expect(@list.getTextForRowColumn(6, 2)).to eq("Therapeutic Abortion")
      expect(@list.getTextForRowColumn(7, 2)).to eq("Ectopic")
      expect(@list.getTextForRowColumn(8, 2)).to eq("Other")

      resizeWindowToDefault()
    end
  end

  context "#AC JRNL-1932|TC #JRNL-1759: Phone user views Filter and Table List View Detailed screen" do
    it ".Navigation:  a < is shown (alt text: Return to My Medical options) " do
      expect(isElementPresentAndVisible(:css, Pregnancy_History_List::BACK_BUTTON)).to eq(false)
      resizeWindowToPhone()
      expect(isElementPresentAndVisible(:css, Pregnancy_History_List::BACK_BUTTON)).to eq(true)

      click(:css, Pregnancy_History_List::BACK_BUTTON)
      !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
      expect(getSecondaryHeader()).to eq("My Medical")

    end

  end


  def addPregnancyHistory
    outcomeList = [
        "Vaginal Delivery",
        "C-section",
        "Still Birth",
        "Miscarriage",
        "Elective Abortion",
        "Therapeutic Abortion",
        "Ectopic",
        "Other"
    ]

    for i in 0..(outcomeList.length - 1)
      count = @list.getCount
      @common.clickAddButton
      !45.times { break if (getPrimaryHeader() == "Add Pregnancy History Entry"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Pregnancy History Entry")

      @history.setPregnancyNumber(i + 1)
      @history.selectOutcome(outcomeList[i])
      if ((i + 1 ) % 2 == 0)
        outcomeDate = getDateNthYearsAgo(i + 1, "%m/%d/%Y")
        @history.setOutcomeDate(outcomeDate)
      end

      @history.clickSaveButton
      !45.times { break if (@list.getCount > count); sleep 1 }
    end
  end
end
