#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2473: Pregnancy History Detail - Edit Delete]", :broken => true, :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("pregnancies", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.female96", "female96, zztest")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")

    @expectedValidationSummaryHeader = "The following errors were found:"

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickPregnancyHistory
    !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Pregnancy History")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1930|TC#JRNL-1679:  Edit Entry for Pregnancy History Detail" do
    it ".Still Birth" do
      pregNum = "1"
      pregStartedDate = "02/2001"
      lastMenstrualDate = "01/03/2001"
      outcomeDate = "05/30/2001"
      outcomeType = "Still Birth"
      hospitalName = "Fair Oaks Inova Hospital"
      note = "No comment"
      addNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")

      lastMenstrualDate = ""
      outcomeDate = "06/30/2001"
      outcomeType = "Still Birth"
      hospitalName = "Fair Oaks Inova Hospital - Edited"
      note = ""
      editNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")

    end

    it ".Miscarriage"  do
      pregNum = "2"
      pregStartedDate = "08/2003"
      lastMenstrualDate = "07/26/2003"
      outcomeDate = "12/22/2003"
      outcomeType = "Miscarriage"
      hospitalName = "Fair Oaks Inova Hospital"
      note = "No comment"
      addNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")

      pregStartedDate = ""
      lastMenstrualDate = ""
      outcomeDate = ""
      outcomeType = "Miscarriage"
      hospitalName = "Fair Oaks Inova Hospital - edited"
      note = ""
      editNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")

    end

    it ".Elective Abortion" do
      pregNum = "3"
      pregStartedDate = "05/2004"
      lastMenstrualDate = "04/22/2004"
      outcomeDate = "05/23/2004"
      outcomeType = "Elective Abortion"
      hospitalName = "Fair Fax hospital"
      note = ""
      addNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")

      pregStartedDate = "06/2004"
      lastMenstrualDate = "04/22/2004"
      outcomeDate = "05/23/2004"
      outcomeType = "Elective Abortion"
      hospitalName = "Fair Fax hospital edited"
      note = "N/A"
      editNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")
    end

    it ".Therapeutic Abortion" do
      pregNum = "4"
      pregStartedDate = "07/2006"
      lastMenstrualDate = "06/02/2006"
      outcomeDate = "09/18/2006"
      outcomeType = "Therapeutic Abortion"
      hospitalName = "Reston Hospital"
      note = "N/A"
      addNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")

      pregStartedDate = "07/2006"
      lastMenstrualDate = "06/02/2006"
      outcomeDate = ""
      outcomeType = "Ectopic"
      hospitalName = "Reston Hospital"
      note = "N/A"
      editNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")

    end

    it ". Ectopic" do
      pregNum = "5"
      pregStartedDate = "12/2008"
      lastMenstrualDate = "11/04/2008"
      outcomeDate = "01/11/2009"
      outcomeType = "Ectopic"
      hospitalName = "Reston Hospital"
      note = "N/A"
      addNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")

      pregStartedDate = "12/2008"
      lastMenstrualDate = "11/04/2008"
      outcomeDate = ""
      outcomeType = "Elective Abortion"
      hospitalName = "Reston Hospital"
      note = ""
      editNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, "")

    end

    it ".Vaginal Delivery " do
      pregNum = "6"
      pregStartedDate = "02/2009"
      lastMenstrualDate = "01/23/2009"
      outcomeDate = "12/01/2009"
      outcomeType = "Vaginal Delivery"
      hospitalName = "Reston Hospital"
      note = "N/A"

      name = "John Do"
      sex = "Male"
      pounds = "7"
      ounces = "11"
      length = "14"
      infant1 = [name, sex, pounds, ounces, length]

      name = "Helen Do"
      sex = "Female"
      pounds = "6"
      ounces = "2"
      length = "15"
      infant2 = [name, sex, pounds, ounces, length]

      infantDetail = [infant1, infant2]
      addLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)
      verifyLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)

      pregStartedDate = ""
      lastMenstrualDate = ""
      outcomeDate = ""
      outcomeType = "Vaginal Delivery"
      hospitalName = "Reston Hospital - edited"
      note = ""

      name = "John Do - edited"
      sex = "Male"
      pounds = "9"
      ounces = "1"
      length = "14.2"
      infant1 = [name, sex, pounds, ounces, length]

      name = "Helen Do"
      sex = "Female"
      pounds = "6"
      ounces = "2"
      length = "15"
      infant2 = [name, sex, pounds, ounces, length]

      infantDetail = [infant1, infant2]
      editLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)
      verifyLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)

    end

    it ". C-section "  do
      pregNum = "7"
      pregStartedDate = "03/2011"
      lastMenstrualDate = "02/21/2011"
      outcomeDate = "12/22/2011"
      outcomeType = "C-section"
      hospitalName = "DC Hospital"
      note = ""

      name = "James Do"
      sex = "Male"
      pounds = "8"
      ounces = "7"
      length = "15"
      infant1 = [name, sex, pounds, ounces, length]

      infantDetail = [infant1]
      addLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)
      verifyLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)

      pregStartedDate = ""
      lastMenstrualDate = "02/21/2011"
      outcomeDate = "12/22/2011"
      outcomeType = "C-section"
      hospitalName = ""
      note = ""

      name = "James Do"
      sex = "Male"
      pounds = "7"
      ounces = "7"
      length = "15"
      infant1 = [name, sex, pounds, ounces, length]

      infantDetail = [infant1]
      editLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)
      verifyLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)

    end

    it ". Other "  do
      pregNum = "8"
      pregStartedDate = "06/2012"
      lastMenstrualDate = "05/23/2012"
      outcomeDate = "08/22/2012"
      outcomeType = "Other"
      hospitalName = "Fair Oaks Inova Hospital"
      note = "No comment"
      other = "Other text !&%*(@!!!"
      addNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, other)
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, other)

      pregStartedDate = "06/2012"
      lastMenstrualDate = ""
      outcomeDate = ""
      outcomeType = "Other"
      hospitalName = "Fair Oaks Inova Hospital"
      note = ""
      other = "Other text !&%*(@!!!"
      editNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, other)
      verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, other)

    end

    it ". Vaginal Delivery with twin" do
      pregNum = "9"
      pregStartedDate = "03/2013"
      lastMenstrualDate = "02/11/2013"
      outcomeDate = "01/02/2014"
      outcomeType = "Vaginal Delivery"
      hospitalName = "Reston Hospital"
      note = "N/A"

      name = "Lauren Do"
      sex = "Female"
      pounds = "6"
      ounces = "2"
      length = "11"
      infant1 = [name, sex, pounds, ounces, length]

      name = "Jessica Do"
      sex = "Female"
      pounds = "5"
      ounces = "11"
      length = "13"
      infant2 = [name, sex, pounds, ounces, length]

      infantDetail = [infant1, infant2]
      addLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)
      verifyLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)

      pregStartedDate = ""
      lastMenstrualDate = ""
      outcomeDate = ""
      outcomeType = "Vaginal Delivery"
      hospitalName = "Reston Hospital - edited"
      note = ""

      name = "Lauren Do - edited"
      sex = "Female"
      pounds = "6"
      ounces = "2"
      length = "11"
      infant1 = [name, sex, pounds, ounces, length]

      name = "Jessica Do edited"
      sex = "Female"
      pounds = "5"
      ounces = "11"
      length = "13"

      infant2 = [name, sex, pounds, ounces, length]

      infantDetail = [infant1, infant2]
      editLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)
      verifyLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)
    end


    it ". Standard Edit functions are available (Save, Cancel, Delete)" do
      @list.clickNthRow(1)

      !45.times{ break if (getPrimaryHeader() == "Edit Pregnancy History Entry"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Pregnancy History Entry")

      expect(@history.isSaveButtonVisible).to eq(true)
      expect(@history.isCancelButtonVisible).to eq(true)
      expect(@history.isDeleteButtonVisible).to eq(true)

      @history.clickCancelButton
      !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Pregnancy History")
    end

  end

  context "#AC JRNL-1928|TC#JRNL-1679: Navigation for Pregnancy History Detai" do
    it ".On all form factors when the user views the Add or Edit Detail screen (secondary detail page), a < is shown (alt text: Return to Pregnancy History table view; when clicked the user is returned to the Detail Screen for the group where the filter and table list view is presented." do
      @list.clickNthRow(2)

      !45.times{ break if (getPrimaryHeader() == "Edit Pregnancy History Entry"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Pregnancy History Entry")

      expect(@history.isBackButtonVisible).to eq(true)
      expect(@history.getBackButtonAltText).to eq("Return to Previous Screen")

      @history.clickBackButton
      !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Pregnancy History")

    end

    it ". If a user selects the < symbol and there are unsaved changes on the screen, the system will prompt the user to save their changes via a modal:" do
      @list.clickNthRow(2)

      !45.times{ break if (getPrimaryHeader() == "Edit Pregnancy History Entry"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Pregnancy History Entry")

      @history.setNote("Note field edited.")
      @history.clickBackButton()

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      @modal.clickReturnButton()
      !45.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }
      expect(@history.getNote).to eq("Note field edited.")

      @history.clickBackButton

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      @modal.clickContinueButton
      !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Pregnancy History")

    end

    it ".If the user tries to Navigate away from a detail record where a field has been updated without Saving, the user is prompted to confirm that they want to leave the record without saving via a modal:" do
      @list.clickNthRow(2)

      !45.times{ break if (getPrimaryHeader() == "Edit Pregnancy History Entry"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Pregnancy History Entry")

      @history.setNote("Note field edited.")
      @mymedical.clickHospitalizations

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      @modal.clickReturnButton()
      !45.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }
      expect(@history.getNote).to eq("Note field edited.")

      @mymedical.clickFamilyHistory

      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      @modal.clickContinueButton
      !45.times{ break if (getPrimaryHeader() == "Family History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Family History")

      @mymedical.clickPregnancyHistory
      !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Pregnancy History")
    end


  end

  context "#AC JRNL-1929|TC#JRNL-1679: Save, Cancel Delete Functionality for Pregnancy History Detail" do
    it ".Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view." do
      @list.clickNthRow(1)

      !45.times{ break if (getPrimaryHeader() == "Edit Pregnancy History Entry"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Pregnancy History Entry")

      @history.selectOutcome("Other")
      @history.clickSaveButton

      !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Pregnancy History")

      index = @list.findIndexWithGivenPregnancyNumber("1")
      expect(@list.getTextForRowColumn(index, 1)).to eq("1")
      expect(@list.getTextForRowColumn(index, 2)).to eq("Other")

    end

    it ".Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
      index = @list.findIndexWithGivenPregnancyNumber("1")
      @list.clickNthRow(index)

      !45.times{ break if (getPrimaryHeader() == "Edit Pregnancy History Entry"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Pregnancy History Entry")
      @history.clickCancelButton
      expect(getFocusedElementText).to eq("Pregnancy History")

      expect(@list.getTextForRowColumn(index, 1)).to eq("1")
      expect(@list.getTextForRowColumn(index, 2)).to eq("Other")
    end

    it " Delete - When a user selects Delete, the system prompts the user to confirm the Delete by displaying a modal:" do
      pregnancyCount = @list.getCount

      puts "Total Pregnancy History Count : " + pregnancyCount.to_s

      for i in 0..( pregnancyCount -1)
        @list.clickNthRow(pregnancyCount - i)
        !45.times{ break if (getPrimaryHeader() == "Edit Pregnancy History Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Pregnancy History Entry")

        @history.clickDeleteButton

        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        @modal.clickNoButton()

        !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Pregnancy History Entry")

        @history.clickDeleteButton

        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        @modal.clickYesButton

        !45.times{ break if (@list.getCount == pregnancyCount - (i + 1) ); sleep 1 }
        expect(@list.getCount).to eq(pregnancyCount - (i + 1))

      end

      expect(@list.getNoResultsFoundMessage).to eq("Use the Add button above to create a new record.")

    end

    it ".All deletes are soft deletes, meaning they are removed from the user’s screen but remain in the database for audit purposes." do
      expect(verifyDocumentsDeleted("pregnancies", "medicalhistorydb", "EDIPI", "0000000181", "deletedFlag")).to eq(true)
    end

  end

  def editLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)
    count = @list.getCount
    index = @list.findIndexWithGivenPregnancyNumber(pregNum)
    @list.clickNthRow(index)

    !45.times{ break if (getPrimaryHeader() == "Edit Pregnancy History Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Pregnancy History Entry")

    expect(@history.getPregnancyNumber()).to eq(pregNum)
    enterLivePregnancyDataEntry(hospitalName, infantDetail, lastMenstrualDate, note, outcomeDate, outcomeType, pregNum, pregStartedDate)

    @history.clickSaveButton
    !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Pregnancy History")

  end


  def verifyLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)
    puts "         .When the user selects a Pregnancy History entry from the table view, the system displays the Pregnancy History record in the Detail screen in Edit mode: "
    index = @list.findIndexWithGivenPregnancyNumber(pregNum)
    @list.clickNthRow(index)

    !45.times{ break if (getPrimaryHeader() == "Edit Pregnancy History Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Pregnancy History Entry")

    puts "         .All data elements available in Add Entry mode are visible.  && . Note: All values previously saved are visible. "

    expect(@history.getPregnancyNumber()).to eq(pregNum)
    expect(@history.getPregnancyStartedDate).to eq(pregStartedDate)
    expect(@history.getLastMenstrualDate).to eq(lastMenstrualDate)
    expect(@history.getOutcomeDate).to eq(outcomeDate)
    expect(@history.getOutcome).to eq(outcomeType)
    expect(@history.getHospitalName).to eq(hospitalName)
    expect(@history.getNote).to eq(note)

    name1 = infantDetail[0][0]
    sex1 = infantDetail[0][1]
    pounds1 = infantDetail[0][2]
    ounces1 = infantDetail[0][3]
    length1 = infantDetail[0][4]

    expect(@history.getName_1).to eq(name1)

    if(sex1 == "Male")
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_FEMALE_1)).to eq(false)
    elsif (sex1 == "Female")
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_MALE_1)).to eq(false)
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_FEMALE_1)).to eq(true)
    end

    expect(@history.getPounds_1).to eq(pounds1)
    expect(@history.getOunces_1).to eq(ounces1)
    expect(@history.getLength_1).to eq(length1)

    name2 = ""
    sex2 = ""
    pounds2 = ""
    ounces2 = ""
    length2 = ""

    if(infantDetail.length == 2)
      name2 = infantDetail[1][0]
      sex2 = infantDetail[1][1]
      pounds2 = infantDetail[1][2]
      ounces2 = infantDetail[1][3]
      length2 = infantDetail[1][4]
    end

    if(infantDetail.length == 2)
      expect(@history.getName_2).to eq(name2)

      if(sex2 == "Male")
        expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_MALE_2)).to eq(true)
        expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_FEMALE_2)).to eq(false)
      elsif (sex2 == "Female")
        expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_MALE_2)).to eq(false)
        expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_FEMALE_2)).to eq(true)
      end

      expect(@history.getPounds_2).to eq(pounds2)
      expect(@history.getOunces_2).to eq(ounces2)
      expect(@history.getLength_2).to eq(length2)

      @history.clickDeleteNthInfantButton(1)
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2) == false); sleep 1 }
      expect(@history.getName_1).to eq(name2)

      if(sex2 == "Male")
        expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_MALE_1)).to eq(true)
        expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_FEMALE_1)).to eq(false)
      elsif (sex2 == "Female")
        expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_MALE_1)).to eq(false)
        expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_FEMALE_1)).to eq(true)
      end

      expect(@history.getPounds_1).to eq(pounds2)
      expect(@history.getOunces_1).to eq(ounces2)
      expect(@history.getLength_1).to eq(length2)

    end

    @history.clickSaveButton
    !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Pregnancy History")

  end


  def addLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, infantDetail)

    count = @list.getCount
    @common.clickAddButton
    !45.times{ break if (getPrimaryHeader() == "Add Pregnancy History Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Add Pregnancy History Entry")

    enterLivePregnancyDataEntry(hospitalName, infantDetail, lastMenstrualDate, note, outcomeDate, outcomeType, pregNum, pregStartedDate)

    @history.clickSaveButton
    !45.times{ break if (@list.getCount == count + 1); sleep 1 }

  end

  def editNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, other)
    count = @list.getCount
    index = @list.findIndexWithGivenPregnancyNumber(pregNum)
    @list.clickNthRow(index)

    !45.times{ break if (getPrimaryHeader() == "Edit Pregnancy History Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Pregnancy History Entry")

    expect(@history.getPregnancyNumber()).to eq(pregNum)
    enterNonLivePregnancyDataEntry(hospitalName, lastMenstrualDate, note, other, outcomeDate, outcomeType, pregNum, pregStartedDate)

    @history.clickSaveButton
    !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Pregnancy History")

  end

  def addNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, other)

    count = @list.getCount
    @common.clickAddButton
    !45.times{ break if (getPrimaryHeader() == "Add Pregnancy History Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Add Pregnancy History Entry")

    enterNonLivePregnancyDataEntry(hospitalName, lastMenstrualDate, note, other, outcomeDate, outcomeType, pregNum, pregStartedDate)

    @history.clickSaveButton
    !45.times{ break if (@list.getCount == count + 1); sleep 1 }

  end

  def verifyNonLivePregnancyHistory(pregNum, pregStartedDate, lastMenstrualDate, outcomeDate, outcomeType, hospitalName, note, other)
    puts "         .When the user selects a Pregnancy History entry from the table view, the system displays the Pregnancy History record in the Detail screen in Edit mode: "

    index = @list.findIndexWithGivenPregnancyNumber(pregNum)
    @list.clickNthRow(index)

    !45.times{ break if (getPrimaryHeader() == "Edit Pregnancy History Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Pregnancy History Entry")

    puts "          .All data elements available in Add Entry mode are visible.  && . Note: All values previously saved are visible. "

    expect(@history.getPregnancyNumber()).to eq(pregNum)
    expect(@history.getPregnancyStartedDate).to eq(pregStartedDate)
    expect(@history.getLastMenstrualDate).to eq(lastMenstrualDate)
    expect(@history.getOutcomeDate).to eq(outcomeDate)
    expect(@history.getOutcome).to eq(outcomeType)
    expect(@history.getHospitalName).to eq(hospitalName)
    expect(@history.getNote).to eq(note)

    if(outcomeType == "Other")
      expect(@history.getOther).to eq(other)
    end

    @history.clickCancelButton
    !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Pregnancy History")
  end

  def enterLivePregnancyDataEntry(hospitalName, infantDetail, lastMenstrualDate, note, outcomeDate, outcomeType, pregNum, pregStartedDate)
    @history.setPregnancyNumber(pregNum)
    @history.setPregnancyStartedDate(pregStartedDate)
    @history.setLastMenstrualDate(lastMenstrualDate)
    @history.setOutcomeDate(outcomeDate)
    @history.selectOutcome(outcomeType)
    @history.setHospitalName(hospitalName)
    @history.setNote(note)

    name1 = infantDetail[0][0]
    sex1 = infantDetail[0][1]
    pounds1 = infantDetail[0][2]
    ounces1 = infantDetail[0][3]
    length1 = infantDetail[0][4]

    @history.setName_1(name1)
    @history.setSex_1(sex1)
    @history.setPounds_1(pounds1)
    @history.setOunces_1(ounces1)
    @history.setLength_1(length1)

    name2 = ""
    sex2 = ""
    pounds2 = ""
    ounces2 = ""
    length2 = ""

    if (infantDetail.length == 2)
      click(:css, Pregnancy_History::ADD_TWIN_BUTTON)
      !45.times { break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2)); sleep 1 }

      name2 = infantDetail[1][0]
      sex2 = infantDetail[1][1]
      pounds2 = infantDetail[1][2]
      ounces2 = infantDetail[1][3]
      length2 = infantDetail[1][4]

      @history.setName_2(name2)
      @history.setSex_2(sex2)
      @history.setPounds_2(pounds2)
      @history.setOunces_2(ounces2)
      @history.setLength_2(length2)

    end
  end

  def enterNonLivePregnancyDataEntry(hospitalName, lastMenstrualDate, note, other, outcomeDate, outcomeType, pregNum, pregStartedDate)
    @history.setPregnancyNumber(pregNum)
    @history.setPregnancyStartedDate(pregStartedDate)
    @history.setLastMenstrualDate(lastMenstrualDate)
    @history.setOutcomeDate(outcomeDate)
    @history.selectOutcome(outcomeType)
    @history.setHospitalName(hospitalName)
    @history.setNote(note)

    if (outcomeType == "Other")
      @history.setOther(other)
    end
  end

end
