#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2473: Pregnancy History Detail - Add]", :broken => true, :regression => true  do

  before(:all) do
    @ENTRY_FORM = [ \
        "* required field",
        "* Pregnancy Number:",
        "Date Pregnancy Started:",
        "MM/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Last Menstrual Period Prior to Pregnancy:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Outcome Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Outcome:",
        "Select",
        "Vaginal Delivery",
        "C-section",
        "Still Birth",
        "Miscarriage",
        "Elective Abortion",
        "Therapeutic Abortion",
        "Ectopic",
        "Other",
        "Hospital Name:",
        "50 character maximum",
        "Infant Details:",
        "Name (first and last):",
        "75 character maximum",
        "Sex:",
        "Male",
        "Female",
        "Weight:",
        "Pounds:",
        "Between 1 and 14",
        "Ounces:",
        "Between 0 and 15",
        "Length (inches):",
        "Add Twin",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel",       
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("pregnancies", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.female96", "female96, zztest")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")

    @expectedValidationSummaryHeader = "The following errors were found:"

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    waitForPageToFinishLoading
    @driver.find_element(:id, "MyMedical").click
    waitForPageToFinishLoading
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickPregnancyHistory
    !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Pregnancy History")
  end

  # after(:all) do
  #   quitDriver()
  # end

  context "#AC JRNL-1931|TC#JRNL-1679: Add New Entry for Pregnancy History Detail" do
    it ".When the user views the Pregnancy History Table list, an Add button (+ icon, alt text Add), is available in the upper right corner of the Detail screen." do
      expect(@common.isAddButtonVisible()).to be true
    end

    it ".When a user selects Add, the Add Pregnancy History detail screen is shown, header: Add Pregnancy History Entry" do
        @driver.find_element(:css, "button[ng-click='getDetails()']").click
        waitForPageToFinishLoading
        !45.times{ break if (getPrimaryHeader() == "Add Pregnancy History Entry"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Pregnancy History Entry")
    end

    it "Unless otherwise indicated, all values default to null (or select for drop lists), no guidance text (light gray placeholder text) is shown, and all fields are optional." do
      @history.selectOutcome("Vaginal Delivery")
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)); sleep 1 }

      form = @history.getScreenContent().split("\n")

      @ENTRY_FORM.each_with_index do | expectedScreenRow, i |
        expect(form[i]).to eq(expectedScreenRow)
      end
      expect(form.length()).to eq(@ENTRY_FORM.length())

    end

    it ".Pregnancy Number (required, numeric, text box, constrain values accepted to integers between 1 and 10)" do
      expect(isFieldRequired(:css, Pregnancy_History::PREGNANCY_NUMBER)).to eq(true)

      @history.setPregnancyNumber(1)
      expect(@history.getPregnancyNumber()).to eq("1")
      @history.setPregnancyNumber(10)
      expect(@history.getPregnancyNumber).to eq("10")

      @history.setPregnancyNumber(0)
      expect(@history.getPregnancyNumber).to eq("0")
      @history.setPregnancyNumber(02)
      expect(@history.getPregnancyNumber).to eq("2")

      @history.setPregnancyNumber(12)
      expect(@history.getPregnancyNumber).to eq("12")

      @history.selectOutcome("Vaginal Delivery")

      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Pregnancy Number is outside the expected range. Please enter a value between 1 and 10.")).to eq(true)

      @history.setPregnancyNumber(1)

    end

    it ".Date Pregnancy Started (date, date picker showing month/year) MM/YYYY formatting constraint, show guidance text indicating formatting; cannot be future date)" do
        expect(@history.getPlaceHolderByCSS(:css, Pregnancy_History::PREGNANCY_DATE_STARTED)).to eq("MM/YYYY")
      thirtyTwoDaysLater = getDateNthDaysFromNow(32, "%m/%Y")

      @history.setPregnancyStartedDate(thirtyTwoDaysLater)
      @history.clickSaveButton
      todayMonthYear = getDateNthDaysFromNow(0, "%m/%Y")
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
     # expect(@error.isErrorMessageDisplayed("form", "Date Pregnancy Started must be between 01/1900 and " + todayMonthYear + ".")).to eq(true)
    end

    it ".Last Menstrual Period Prior to Pregnancy (date, date picker, format MM/DD/YYYY, show guidance text formatting, cannot be future date)" do
      expect(@history.getPlaceHolderByCSS(:css, Pregnancy_History::LAST_MENSTRUAL_DATE)).to eq("MM/DD/YYYY")
      oneDayLater = getDateNthDaysFromNow(1, "%m/%d/%Y")

      @history.setLastMenstrualDate(oneDayLater)
      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)

      if Time.new.year.to_s != oneDayLater[-4..-1]
        expect(@error.isErrorMessageDisplayed("form", "Last Menstrual Period Prior to Pregnancy must be formatted MM/DD/YYYY.")).to eq(true)
      else
        expect(@error.isErrorMessageDisplayed("form", "Last Menstrual Period Prior to Pregnancy must be between 01/01/1900 and " + @today + ".")).to eq(true)
      end
    end

    it ".Outcome date (MM/DD/YYYY, cannot be future date)" do
      expect(@history.getPlaceHolderByCSS(:css, Pregnancy_History::OUTCOME_DATE)).to eq("MM/DD/YYYY")
      oneDayLater = getDateNthDaysFromNow(1, "%m/%d/%Y")

      @history.setOutcomeDate(oneDayLater)
      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)

      if Time.new.year.to_s != oneDayLater[-4..-1]
        expect(@error.isErrorMessageDisplayed("form", "Outcome Date must be formatted MM/DD/YYYY.")).to eq(true)
      else
        expect(@error.isErrorMessageDisplayed("form", "Outcome Date must be between 01/01/1900 and " + @today + ".")).to eq(true)
      end
    end

    it ".Outcome (required, single select, drop list" do
      expect(isFieldRequired(:css, Pregnancy_History::OUTCOME)).to eq(true)
      expect(areAllTheseValuesAvailableInDropDown(Pregnancy_History::OUTCOME, "Select;Vaginal Delivery;C-section;Still Birth;Miscarriage;Elective Abortion;Therapeutic Abortion;Ectopic;Other")).to eq(true)

      @history.selectOutcome("Other")
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OTHER))
      other_text_50 = "12345678901234567890123456789012345678901234567890"
      other_text_60 = other_text_50 + "ABCDEFGHIJ"
      @history.setOther(other_text_60)
      expect(@history.getOther()).to eq(other_text_50)

      @history.selectOutcome("")
      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Outcome field is required.")).to eq(true)

    end

    it ".Hospital name (alphanumeric, text box, text, 50 characters)" do
      other_text_50 = "12345678901234567890123456789012345678901234567890"
      other_text_60 = other_text_50 + "ABCDEFGHIJ"
      @history.setHospitalName(other_text_60)
      expect(@history.getHospitalName).to eq(other_text_50)

    end

    it ".If outcome is Vaginal Delivery or C-section, then show additional fields: " do
      @history.selectOutcome("C-section")
    end

    it ".Infant Details (label, static text shown above the following fields)" do
      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_1)).to eq(true)

      expect(@history.getFirstInfantDetailLabel).to eq("Infant Details:")

      @history.selectOutcome("Other");
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1) == false); sleep 1 }
      @history.selectOutcome("Vaginal Delivery")
      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_1)).to eq(true)

      expect(@history.getFirstInfantDetailLabel).to eq("Infant Details:")

    end

    it ".Name (first and last) (text - single field 75 characters)" do
      name_75 = "123456789012345678901234567890123456789012345678901234567890123456789012345"
      @history.setName_1(name_75 + "ABCDEFG")
      expect(@history.getName_1()).to eq(name_75)
    end

    it ".Sex (single select, radio buttons, values: male, female)" do
      @history.setSex_1("Male")
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_FEMALE_1)).to eq(false)

      @history.setSex_1("Female")
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_MALE_1)).to eq(false)
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_FEMALE_1)).to eq(true)
    end

    it ".Weight - 	Pounds (numeric, text box, constrain to integers between 1 and 14; light gray guidance text showing 'Between 1 and 14'; read for VO with label)" do
      expect(@history.getPlaceHolderByCSS(:css, Pregnancy_History::POUND_1)).to eq("Between 1 and 14")
      @history.setPounds_1("01")
      expect(@history.getPounds_1).to eq("01")

      @history.setPounds_1(14)
      expect(@history.getPounds_1).to eq("14")

      @history.setPounds_1(15)

      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Pounds is outside the expected range. Please enter a value between 1 and 14.")).to eq(true)

    end

    it ".Weight - Ounces (numeric, text box, constrain to integers between 0 and 15k light gray guidance text showing 'Between 0 and 15'; read for VO with label)" do
      expect(@history.getPlaceHolderByCSS(:css, Pregnancy_History::OUNCES_1)).to eq("Between 0 and 15")
      @history.setOunces_1(0)
      expect(@history.getOunces_1()).to eq("0")

      @history.setOunces_1(15)
      expect(@history.getOunces_1).to eq("15")

      @history.setOunces_1(16)
      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Ounces is outside the expected range. Please enter a value between 0 and 15.")).to eq(true)

    end

    it ".Length (inches) (numeric, text box, constrain to numeric values of format ##.#)" do
      @history.setLength_1(11.1)
      expect(@history.getLength_1).to eq("11.1")

      @history.setLength_1(123.1)
      expect(@history.getLength_1).to eq("12.1")

    end

    it ".Add Twin button" do
      click(:css, Pregnancy_History::ADD_TWIN_BUTTON)
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2)); sleep 1 }

    end

    it ".When the user selects the Add Twin button, the a new label 'Second Infant Details' is shown (focus is placed on this label), and the new infant section is separated from the previous section by a horizontal rule;" do
      expect(@history.getSecondInfantDetailLabel).to eq("Second Infant Details:")
      expect(getFocusedElementText).to eq("Second Infant Details:")

      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_2)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_2)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_2)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_2)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::LENGTH_2)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_2)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::ADD_TWIN_BUTTON)).to eq(false)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_1)).to eq(true)

      expect(@history.getFirstInfantDetailLabel).to eq("Infant Details:")

      click(:css, Pregnancy_History::DELETE_TWIN_BUTTON_1)
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2) == false); sleep 1 }

      expect(isElementPresentAndVisible(:css, Pregnancy_History::ADD_TWIN_BUTTON)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_1)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_1)).to eq(false)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_2)).to eq(false)

    end

    it ".Only one additional live birth (i.e. twin birth) per pregnancy entry is supported. 	The Add Twin button is removed after one twin entry field set is added.  " do
      click(:css, Pregnancy_History::ADD_TWIN_BUTTON)
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2)); sleep 1 }

      expect(isElementPresentAndVisible(:css, Pregnancy_History::ADD_TWIN_BUTTON)).to eq(false)

      click(:css, Pregnancy_History::DELETE_TWIN_BUTTON_2)
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2) == false); sleep 1 }

      expect(isElementPresentAndVisible(:css, Pregnancy_History::ADD_TWIN_BUTTON)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_1)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_1)).to eq(false)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_2)).to eq(false)

    end

    it ".Note (alphanumeric, text box, 250 characters, show character countdown)" do
      expect(@history.getCharacterCounter).to eq("250 characters left")

      text_10 = "1234567890"
      @history.setNote(text_10)
      expect(@history.getNote()).to eq(text_10)
      expect(@history.getCharacterCounter).to eq("240 characters left")

      text_250 = "ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG8901234567890"

      puts "text size " + text_250.length.to_s
      @history.setNote(text_250)
      expect(@history.getNote()).to eq(text_250)
      expect(@history.getCharacterCounter).to eq("0 characters left")

      text_255 = text_250 + "*&@#!"
      @history.setNote(text_255)
      expect(@history.getNote()).to eq(text_250)
      expect(@history.getCharacterCounter).to eq("0 characters left")

    end

    it ".Standard Save and Cancel options are available" do
      expect(@history.isSaveButtonVisible).to eq(true)
      expect(@history.isCancelButtonVisible).to eq(true)

      @history.clickCancelButton
      !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Pregnancy History")
    end

  end

 end















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2473: Pregnancy History Detail - Add]", :broken => true, :regression => true  do

  before(:all) do
    @ENTRY_FORM = [ \
        "* required field",
        "* Pregnancy Number:",
        "Date Pregnancy Started:",
        "MM/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Last Menstrual Period Prior to Pregnancy:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Outcome Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* Outcome:",
        "Select",
        "Vaginal Delivery",
        "C-section",
        "Still Birth",
        "Miscarriage",
        "Elective Abortion",
        "Therapeutic Abortion",
        "Ectopic",
        "Other",
        "Hospital Name:",
        "50 character maximum",
        "Infant Details:",
        "Name (first and last):",
        "75 character maximum",
        "Sex:",
        "Male",
        "Female",
        "Weight:",
        "Pounds:",
        "Between 1 and 14",
        "Ounces:",
        "Between 0 and 15",
        "Length (inches):",
        "Add Twin",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel",
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("pregnancies", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.female96", "female96, zztest")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")

    @expectedValidationSummaryHeader = "The following errors were found:"

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickPregnancyHistory
    !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Pregnancy History")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1931|TC#JRNL-1679: Add New Entry for Pregnancy History Detail" do
    it ".When the user views the Pregnancy History Table list, an Add button (+ icon, alt text Add), is available in the upper right corner of the Detail screen." do
      expect(@common.isAddButtonVisible()).to be true
    end

    it ".When a user selects Add, the Add Pregnancy History detail screen is shown, header: Add Pregnancy History Entry" do
      @common.clickAddButton
      !45.times{ break if (getPrimaryHeader() == "Add Pregnancy History Entry"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Pregnancy History Entry")
    end

    it "Unless otherwise indicated, all values default to null (or select for drop lists), no guidance text (light gray placeholder text) is shown, and all fields are optional." do
      @history.selectOutcome("Vaginal Delivery")
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)); sleep 1 }

      form = @history.getScreenContent().split("\n")

      @ENTRY_FORM.each_with_index do | expectedScreenRow, i |
        expect(form[i]).to eq(expectedScreenRow)
      end
      expect(form.length()).to eq(@ENTRY_FORM.length())

    end

    it ".Pregnancy Number (required, numeric, text box, constrain values accepted to integers between 1 and 10)" do
      expect(isFieldRequired(:css, Pregnancy_History::PREGNANCY_NUMBER)).to eq(true)

      @history.setPregnancyNumber(1)
      expect(@history.getPregnancyNumber()).to eq("1")
      @history.setPregnancyNumber(10)
      expect(@history.getPregnancyNumber).to eq("10")

      @history.setPregnancyNumber(0)
      expect(@history.getPregnancyNumber).to eq("0")
      @history.setPregnancyNumber(02)
      expect(@history.getPregnancyNumber).to eq("2")

      @history.setPregnancyNumber(12)
      expect(@history.getPregnancyNumber).to eq("12")

      @history.selectOutcome("Vaginal Delivery")

      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Pregnancy Number is outside the expected range. Please enter a value between 1 and 10.")).to eq(true)

      @history.setPregnancyNumber(1)

    end

    it ".Date Pregnancy Started (date, date picker showing month/year) MM/YYYY formatting constraint, show guidance text indicating formatting; cannot be future date)" do
        expect(@history.getPlaceHolderByCSS(:css, Pregnancy_History::PREGNANCY_DATE_STARTED)).to eq("MM/YYYY")
      thirtyTwoDaysLater = getDateNthDaysFromNow(32, "%m/%Y")

      @history.setPregnancyStartedDate(thirtyTwoDaysLater)
      @history.clickSaveButton
      todayMonthYear = getDateNthDaysFromNow(0, "%m/%Y")
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
     # expect(@error.isErrorMessageDisplayed("form", "Date Pregnancy Started must be between 01/1900 and " + todayMonthYear + ".")).to eq(true)
    end

    it ".Last Menstrual Period Prior to Pregnancy (date, date picker, format MM/DD/YYYY, show guidance text formatting, cannot be future date)" do
      expect(@history.getPlaceHolderByCSS(:css, Pregnancy_History::LAST_MENSTRUAL_DATE)).to eq("MM/DD/YYYY")
      oneDayLater = getDateNthDaysFromNow(1, "%m/%d/%Y")

      @history.setLastMenstrualDate(oneDayLater)
      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)

      if Time.new.year.to_s != oneDayLater[-4..-1]
        expect(@error.isErrorMessageDisplayed("form", "Last Menstrual Period Prior to Pregnancy must be formatted MM/DD/YYYY.")).to eq(true)
      else
        expect(@error.isErrorMessageDisplayed("form", "Last Menstrual Period Prior to Pregnancy must be between 01/01/1900 and " + @today + ".")).to eq(true)
      end
    end

    it ".Outcome date (MM/DD/YYYY, cannot be future date)" do
      expect(@history.getPlaceHolderByCSS(:css, Pregnancy_History::OUTCOME_DATE)).to eq("MM/DD/YYYY")
      oneDayLater = getDateNthDaysFromNow(1, "%m/%d/%Y")

      @history.setOutcomeDate(oneDayLater)
      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)

      if Time.new.year.to_s != oneDayLater[-4..-1]
        expect(@error.isErrorMessageDisplayed("form", "Outcome Date must be formatted MM/DD/YYYY.")).to eq(true)
      else
        expect(@error.isErrorMessageDisplayed("form", "Outcome Date must be between 01/01/1900 and " + @today + ".")).to eq(true)
      end
    end

    it ".Outcome (required, single select, drop list" do
      expect(isFieldRequired(:css, Pregnancy_History::OUTCOME)).to eq(true)
      expect(areAllTheseValuesAvailableInDropDown(Pregnancy_History::OUTCOME, "Select;Vaginal Delivery;C-section;Still Birth;Miscarriage;Elective Abortion;Therapeutic Abortion;Ectopic;Other")).to eq(true)

      @history.selectOutcome("Other")
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OTHER))
      other_text_50 = "12345678901234567890123456789012345678901234567890"
      other_text_60 = other_text_50 + "ABCDEFGHIJ"
      @history.setOther(other_text_60)
      expect(@history.getOther()).to eq(other_text_50)

      @history.selectOutcome("")
      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Outcome field is required.")).to eq(true)

    end

    it ".Hospital name (alphanumeric, text box, text, 50 characters)" do
      other_text_50 = "12345678901234567890123456789012345678901234567890"
      other_text_60 = other_text_50 + "ABCDEFGHIJ"
      @history.setHospitalName(other_text_60)
      expect(@history.getHospitalName).to eq(other_text_50)

    end

    it ".If outcome is Vaginal Delivery or C-section, then show additional fields: " do
      @history.selectOutcome("C-section")
    end

    it ".Infant Details (label, static text shown above the following fields)" do
      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_1)).to eq(true)

      expect(@history.getFirstInfantDetailLabel).to eq("Infant Details:")

      @history.selectOutcome("Other");
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1) == false); sleep 1 }
      @history.selectOutcome("Vaginal Delivery")
      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_1)).to eq(true)

      expect(@history.getFirstInfantDetailLabel).to eq("Infant Details:")

    end

    it ".Name (first and last) (text - single field 75 characters)" do
      name_75 = "123456789012345678901234567890123456789012345678901234567890123456789012345"
      @history.setName_1(name_75 + "ABCDEFG")
      expect(@history.getName_1()).to eq(name_75)
    end

    it ".Sex (single select, radio buttons, values: male, female)" do
      @history.setSex_1("Male")
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_FEMALE_1)).to eq(false)

      @history.setSex_1("Female")
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_MALE_1)).to eq(false)
      expect(@history.isGenderRadioButtonSelected(Pregnancy_History::SEX_FEMALE_1)).to eq(true)
    end

    it ".Weight - 	Pounds (numeric, text box, constrain to integers between 1 and 14; light gray guidance text showing 'Between 1 and 14'; read for VO with label)" do
      expect(@history.getPlaceHolderByCSS(:css, Pregnancy_History::POUND_1)).to eq("Between 1 and 14")
      @history.setPounds_1("01")
      expect(@history.getPounds_1).to eq("01")

      @history.setPounds_1(14)
      expect(@history.getPounds_1).to eq("14")

      @history.setPounds_1(15)

      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Pounds is outside the expected range. Please enter a value between 1 and 14.")).to eq(true)

    end

    it ".Weight - Ounces (numeric, text box, constrain to integers between 0 and 15k light gray guidance text showing 'Between 0 and 15'; read for VO with label)" do
      expect(@history.getPlaceHolderByCSS(:css, Pregnancy_History::OUNCES_1)).to eq("Between 0 and 15")
      @history.setOunces_1(0)
      expect(@history.getOunces_1()).to eq("0")

      @history.setOunces_1(15)
      expect(@history.getOunces_1).to eq("15")

      @history.setOunces_1(16)
      @history.clickSaveButton
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Ounces is outside the expected range. Please enter a value between 0 and 15.")).to eq(true)

    end

    it ".Length (inches) (numeric, text box, constrain to numeric values of format ##.#)" do
      @history.setLength_1(11.1)
      expect(@history.getLength_1).to eq("11.1")

      @history.setLength_1(123.1)
      expect(@history.getLength_1).to eq("12.1")

    end

    it ".Add Twin button" do
      click(:css, Pregnancy_History::ADD_TWIN_BUTTON)
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2)); sleep 1 }

    end

    it ".When the user selects the Add Twin button, the a new label 'Second Infant Details' is shown (focus is placed on this label), and the new infant section is separated from the previous section by a horizontal rule;" do
      expect(@history.getSecondInfantDetailLabel).to eq("Second Infant Details:")
      expect(getFocusedElementText).to eq("Second Infant Details:")

      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_2)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_2)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_2)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_2)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::LENGTH_2)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_2)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::ADD_TWIN_BUTTON)).to eq(false)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_1)).to eq(true)

      expect(@history.getFirstInfantDetailLabel).to eq("Infant Details:")

      click(:css, Pregnancy_History::DELETE_TWIN_BUTTON_1)
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2) == false); sleep 1 }

      expect(isElementPresentAndVisible(:css, Pregnancy_History::ADD_TWIN_BUTTON)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_1)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_1)).to eq(false)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_2)).to eq(false)

    end

    it ".Only one additional live birth (i.e. twin birth) per pregnancy entry is supported. 	The Add Twin button is removed after one twin entry field set is added.  " do
      click(:css, Pregnancy_History::ADD_TWIN_BUTTON)
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2)); sleep 1 }

      expect(isElementPresentAndVisible(:css, Pregnancy_History::ADD_TWIN_BUTTON)).to eq(false)

      click(:css, Pregnancy_History::DELETE_TWIN_BUTTON_2)
      !45.times{ break if (isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_2) == false); sleep 1 }

      expect(isElementPresentAndVisible(:css, Pregnancy_History::ADD_TWIN_BUTTON)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::INFANT_NAME_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_FEMALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::SEX_MALE_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::POUND_1)).to eq(true)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::OUNCES_1)).to eq(true)

      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_1)).to eq(false)
      expect(isElementPresentAndVisible(:css, Pregnancy_History::DELETE_TWIN_BUTTON_2)).to eq(false)

    end

    it ".Note (alphanumeric, text box, 250 characters, show character countdown)" do
      expect(@history.getCharacterCounter).to eq("250 characters left")

      text_10 = "1234567890"
      @history.setNote(text_10)
      expect(@history.getNote()).to eq(text_10)
      expect(@history.getCharacterCounter).to eq("240 characters left")

      text_250 = "ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG890ABCDEFG8901234567890"

      puts "text size " + text_250.length.to_s
      @history.setNote(text_250)
      expect(@history.getNote()).to eq(text_250)
      expect(@history.getCharacterCounter).to eq("0 characters left")

      text_255 = text_250 + "*&@#!"
      @history.setNote(text_255)
      expect(@history.getNote()).to eq(text_250)
      expect(@history.getCharacterCounter).to eq("0 characters left")

    end

    it ".Standard Save and Cancel options are available" do
      expect(@history.isSaveButtonVisible).to eq(true)
      expect(@history.isCancelButtonVisible).to eq(true)

      @history.clickCancelButton
      !45.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Pregnancy History")
    end

  end

 end
=end