require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1749: Hide Pregnancy History for Male Users]", :broken => true, :regression => true do

  before(:all) do

    initializeConfigurations(BASE_URL)

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.male96", "male96, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    waitForPageToFinishLoading
    @driver.find_element(:id, "MyMedical").click
    waitForPageToFinishLoading
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1729|TC JRNL-1678: Hide Pregnancy for Male Users" do
    it ".When a male users views the app, the Pregnancy History sub-feature is not visible under the My Medical feature" do
      expect(isElementPresentAndVisible(:css, "button.pregnancy-history")).to eq(false)
    end
  end

end















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1749: Hide Pregnancy History for Male Users]", :broken => true, :regression => true do

  before(:all) do

    initializeConfigurations(BASE_URL)

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.male96", "male96, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1729|TC JRNL-1678: Hide Pregnancy for Male Users" do
    it ".When a male users views the app, the Pregnancy History sub-feature is not visible under the My Medical feature" do
      expect(isElementPresentAndVisible(:css, "button.pregnancy-history")).to eq(false)
    end
  end

end
=end