# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "[Story JRNL-1744: Plan Your Appointment - Notification Accordion]", :acceptance => true do

  before(:all) do
    initializeConfigurations(BASE_URL)

    removeCollection("plan", "previsitagendadb")
    removeCollection("reminders", "remindersdb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @tomorrow = getDateNthDaysFromNow(1,  "%m/%d/%Y")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @expectedValidationSummaryHeader = "The following errors were found:"

    setEmailAccount()

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    expect(@mymedical.isPlanYourAppointmentVisible).to eq(true)
    @mymedical.clickPlanYourAppointment
    !45.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Plan Your Appointment")

    @common.clickAddButton
    !45.times{ break if (getPrimaryHeader() == "Add Appointment Plan"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Add Appointment Plan")
    !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)); sleep 1 }
    expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq(true)
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1612|TC JRNL-1547: Set Notifications (Accordion Label)" do
    it "1.2 Set Notifications - Label" do
      !45.times{ break if (@appmt.getAccordionLabelByHeading("Set Notifications") == "Set Notifications"); sleep 1 }
      expect(@appmt.getAccordionLabelByHeading("Set Notifications")).to eq("Set Notifications")
    end

    it "1.3. Instruction text", :broken => true do
      @appmt.selectAppointmentStatus("Desired")
      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      expect(@appmt.getNotificationInstructionText).to eq("Notifications are available for future scheduled appointments only.")

      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.selectAppointmentStatus("Scheduled")
      @appmt.setAppointmentDate(@tomorrow)
      @appmt.setAppointmentTime("09:30 AM")

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      expect(@appmt.getNotificationInstructionText).to eq("Use this section to send yourself a notice to complete/update your appointment planning for a scheduled appointment.")

      yesterday = getDateNthDaysFromNow(-1, "%m/%d/%Y")
      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.setAppointmentDate(yesterday)
      @appmt.setAppointmentTime("10:30 AM")

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)
      #todo: defect
      #expect(@appmt.getNotificationInstructionText).to eq("Notifications are available for future scheduled appointments only.")

      eightDaysLater = getDateNthDaysFromNow(8, "%m/%d/%Y")
      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.setAppointmentDate(eightDaysLater)

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      statusArr = ["Desired", "Canceled", "Completed"]

      for i in 0..(statusArr.length - 1)
        @appmt.clickAccordionByHeading("Appointment Information")
        @appmt.selectAppointmentStatus(statusArr[i])

        @appmt.clickAccordionByHeading("Set Notifications")
        expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)
        expect(@appmt.getNotificationInstructionText).to eq("Notifications are available for future scheduled appointments only.")
      end

    end

    it "1.4 Notification label with bell icon", :broken => true do
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::BELL_ICON)).to eq(true)
    end

    it "1.5 Status (single choice, on/off radio buttons)", :broken => true do
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO))

      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)

      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.selectAppointmentStatus("Scheduled")
      @appmt.setAppointmentTime("11:30 AM")

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      @appmt.selectRadioButton("On", Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)
      !45.times{ break if (isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX) == false); sleep 1 }
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(false)

      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)

      ENTRY_FORM = [\
                  "Expand",
                  "Appointment Information",
                  "Expand",
                  "Items to Discuss",
                  "Collapse",
                  "Set Notifications",
                  "Use this section to send yourself a notice to complete/update your appointment planning for a scheduled appointment.",
                  "Notification:",
                  "On",
                  "Off",
                  "* Remind Me to Create My Plan:",
                  "On the date 1 day before",
                  "* Notification Delivery:",
                  "In-App",
                  "Email",
                  "testAccount@agilex.com",
                  "You may update your Preferred Email address in the Notification feature by selecting the notification settings icon",
                  "You may update your Preferred Email address in the Notification feature by selecting the icon.",
                  "Expand",
                  "After Appointment Notes"
                 ]

      form = @appmt.getScreenContent().split("\n")

      ENTRY_FORM.each_with_index do | expectedScreenRow, i |
        expect(form[i]).to eq(expectedScreenRow)
      end
      expect(form.length).to eq(ENTRY_FORM.length)
    end

    it "1.6.	Remind Me to Create My Plan (multi select, checkbox, values: On the date, 1 day before)", :broken => true do
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(true)
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(true)

      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX).attribute("type")).to eq("checkbox")
      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX).attribute("type")).to eq("checkbox")
      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX).attribute("value")).to eq("On the date")
      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX).attribute("value")).to eq("1 day before")
    end

    it "1.7 Notification Delivery(multi select check boxes: Email, In App)", :broken => true do
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(true)
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)

      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).attribute("type")).to eq("checkbox")
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).attribute("type")).to eq("checkbox")
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).attribute("value")).to eq("Email")
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).attribute("value")).to eq("In-App")
    end

    it "1.8 Email (text with user email)", :broken => true do
      expect(@appmt.getEmailText).to eq("testAccount@agilex.com")
    end

  end

  context "AC JRNL-1525|TC JRNL-1547: Notification fields are enabled/disabled based on the following business rules" do

    it "2.1 Given status =  scheduled, and appointment date is greater than today + 2 days", :broken => true do
      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.selectAppointmentStatus("Desired")  #  this will turn off notification option
      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      expect(@appmt.isRadioButtonSelected("Off", Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      twoDaysLater = getDateNthDaysFromNow(2, "%m/%d/%Y")
      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.selectAppointmentStatus("Scheduled")
      @appmt.setClinic("Reston Clinic")
      @appmt.setAppointmentDate(twoDaysLater)
      @appmt.setAppointmentTime("04:30 PM")

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      expect(@appmt.getNotificationInstructionText).to eq("Use this section to send yourself a notice to complete/update your appointment planning for a scheduled appointment.")
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(false)

      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)

      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(false)

      @appmt.selectRadioButton("On", Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)

      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(true)

      click(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)
      click(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)
      click(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)
      click(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)

      @appmt.clickSaveBtn
      !45.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
      expect(@appmt.isSaveButtonDisabled).to eq(true)

      @common.clickBackButton
      !45.times { break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")

      @appmt_list.clickNthEntry(1)
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Plan")

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      @appmt.isRadioButtonSelected("On", Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)

      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(false)
    end

    it "2.2 Given status = scheduled, but the appointment date greater than today + 1 days,", :broken => true do
      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.setAppointmentDate(@tomorrow)

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)
      expect(@appmt.getNotificationInstructionText).to eq("Use this section to send yourself a notice to complete/update your appointment planning for a scheduled appointment.")
      @appmt.isRadioButtonSelected("On", Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)

      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX).selected?).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(true)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(false)

      click(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)

      @appmt.clickSaveBtn
      !45.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
      expect(@appmt.isSaveButtonDisabled).to eq(true)

      @common.clickBackButton
      !45.times { break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")

      @common.clickAddButton
      !45.times{ break if (getPrimaryHeader() == "Add Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Appointment Plan")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq(true)

      @appmt.selectAppointmentStatus("Scheduled")
      @appmt.setClinic("Herndon Clinic")
      @appmt.setAppointmentDate(@tomorrow)
      @appmt.setAppointmentTime("04:30 PM")

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      expect(@appmt.getNotificationInstructionText).to eq("Use this section to send yourself a notice to complete/update your appointment planning for a scheduled appointment.")

      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)

      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(false)

      @appmt.selectRadioButton("On", Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)

      click(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)
      click(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)

      @appmt.clickSaveBtn
      !45.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
      expect(@appmt.isSaveButtonDisabled).to eq(true)

      @common.clickBackButton
      !45.times { break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")

      tableHeaderArr = ["Clinic/Organization", "Provider", "Date/Time", "Status"]
      !45.times{ break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      index = @appmt_list.findIndexWithGivenClinic("Herndon Clinic")

      @appmt_list.clickNthEntry(index)
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Plan")

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      @appmt.isRadioButtonSelected("On", Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)

      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(true)

      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(true)

      #Notification option is set to Off, In-App option is unchecked. All notification fields nullified and disabled
      @appmt.selectRadioButton("Off", Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)
      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX).selected?).to eq(false)

      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)


    end

    it "Given status is not “scheduled”", :broken => true do
      statusArr = ["Desired", "Canceled", "Completed"]

      for i in 0..2
        @appmt.clickAccordionByHeading("Appointment Information")
        @appmt.selectAppointmentStatus(statusArr[i])
        @appmt.clickSaveBtn

        !45.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
        expect(@appmt.isSaveButtonDisabled).to eq(true)

        @appmt.clickAccordionByHeading("Set Notifications")
        !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
        expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)
        @appmt.isRadioButtonSelected("Off", Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)

        expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)
        expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(true)
        expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(true)
        expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(true)
        expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(true)

        expect(@appmt.getNotificationInstructionText).to eq("Notifications are available for future scheduled appointments only.")
      end
    end

    it "2.4 Notification cannot be provided for the Appintment Date you entered", :broken => true do
      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.selectAppointmentStatus("Scheduled")
      @appmt.setClinic("Reston Clinic")
      @appmt.setAppointmentDate(@today)

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)
      expect(@appmt.getNotificationInstructionText).to eq("Use this section to send yourself a notice to complete/update your appointment planning for a scheduled appointment.")

      @appmt.selectRadioButton("On", Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)

      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)).to eq(false)

      click(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_EMAIL_CHECKBOX)
      click(:css, Plan_Your_Appointment::NOTIFICATION_DELIVERY_IN_APP_CHECKBOX)

      @appmt.clickSaveBtn
      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      #todo:  defect
      expect(@error.isErrorMessageDisplayed("form", "Notifications cannot be provided for the Appointment Date you entered. Turn the Notification off to save this appointment plan.")).to eq(true)
    end

    it "2.5 Every time the Appointment Date field is changed, the Notify me checkbox options are enabled/disabled based on the business rules.", :broken => true do
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(true)

      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.setAppointmentDate(@tomorrow)

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(true)

      @appmt.clickAccordionByHeading("Appointment Information")
      fourDaysLater = getDateNthDaysFromNow(4,  "%m/%d/%Y")
      @appmt.setAppointmentDate(fourDaysLater)

      @appmt.clickAccordionByHeading("Set Notifications")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::NOTIFICATION__STATUS_RADIO)).to eq(true)

      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ON_THE_DATE_CHECKBOX)).to eq(false)
      expect(isThisElementDisabled(:css, Plan_Your_Appointment::REMIND_ME_ONE_DAY_BEFORE_CHECKBOX)).to eq(false)
    end

  end

  def setEmailAccount
    @main.clickNavMenu()
    !45.times { break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickNotifications()
    !45.times { break if (@notifications.getTitle() == "Notifications"); sleep 1 }
    expect(@notifications.getTitle()).to eq("Notifications")

    @notifications.clickTheGearIcon()
    @notifications.setEmailAddressFromNotificationSettingScreen("testAccount@agilex.com")
    @modal.clickSaveButton()
    !45.times { break if (@notifications.isSettingPopupDisappeared == true); sleep 1 }
    expect(@notifications.isSettingPopupDisappeared()).to eq(true)
    !45.times { break if (@notifications.getTitle() == "Notifications"); sleep 1 }
    expect(@notifications.getTitle()).to eq("Notifications")
  end

end
