require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1952: Plan Your Appointment - Notifications]", :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("notifications", "notificationsdb", "planAppointmentNotification")

    oneDayAgo = (Time.now - 1.days)
    @FORMATTED_DATE = oneDayAgo.strftime("%m/%d/%Y %I:%M %p")

    updateDocument("notifications", "notificationsdb", "546e30d00364f600b81959da", "createDate", oneDayAgo)
    updateDocument("notifications", "notificationsdb", "546e30d00364f600b81959da", "effectiveDisplayDate", oneDayAgo)

    initializeAllObjects

    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @login_page.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @login_page.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

  end

  after(:all) do
    quitDriver()
  end

  it "#AC JRNL-1608|TC JRNL-1574: Reminder shown in Notification feature", :broken => true do
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickNotifications
    !45.times{ break if (getSecondaryHeader == "Notifications"); sleep 1 }
    expect(getSecondaryHeader).to eq("Notifications")

    @nav_menu.clickAllNotifications

    !45.times{ break if (getPrimaryHeader == "All Notifications"); sleep 1 }
    expect(getPrimaryHeader).to eq("All Notifications")

    !45.times{ break if (getCount > 0); sleep 1 }

    expect(getTextForRowColumn(1, 2)).to eq("You have an appointment with John Do, South Riding Clinic on 11/21/2014 at 09:00 AM. Please update your Appointment Plan as well as medication and allergy information prior to the appointment.")
    expect(getTextForRowColumn(1, 3)).to eq("My VA Health - My Medical")
    expect(getTextForRowColumn(1, 4)).to eq(@FORMATTED_DATE + " America/New_York")

    clickNthRow(1)

    !45.times{ break if (@notification.getPrimaryHeader == "View Notification" ); sleep 1 }
    expect(@notification.getPrimaryHeader).to eq("View Notification")

    !45.times{ break if (@notification.getSourceInDetail== "My VA Health - My Medical" ); sleep 1 }

    expect(@notification.getSourceInDetail).to eq("My VA Health - My Medical")
    expect(@notification.getDateAndTimeInDetail).to eq(@FORMATTED_DATE)
    expect(@notification.getTextInDetail).to eq("You have an appointment with John Do, South Riding Clinic on 11/21/2014 at 09:00 AM. Please update your Appointment Plan as well as medication and allergy information prior to the appointment.")

  end


end

 
