#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2459: Plan Your Appointment - Navigation, List, Filter][Story #JRNL-1785: Print Blank Form]",  :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("plan", "previsitagendadb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @tomorrow = getDateNthDaysFromNow(1,  "%m/%d/%Y")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @expectedValidationSummaryHeader = "The following errors were found:"

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1728|TC JRNL-1656:  Sub Feature Selection for Plan Your Appointment" do
     it "Sub Feature Selection: When a user opens the Left Panel navigation and selects the My Medical feature, the system displays a navigation option labeled 'Plan Your Appointment'" do
       @nav_menu.clickMyMedical()
       !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
       expect(getSecondaryHeader()).to eq("My Medical")

       expect(@mymedical.isPlanYourAppointmentVisible).to eq(true)
     end

      it "1.1 Sub Feature Label: Plan Your appointment   1.2 List Loation: First option" do
        expect(@mymedical.getNthMyMedicalFeatureName(1)).to eq("Plan Your Appointment")

        @mymedical.clickPlanYourAppointment
        !45.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Plan Your Appointment")
      end
  end

  context "#AC JRNL-1605|TC JRNL-1545: Print Blank Form Button" do
    it "1. Print Black Form button" do
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment_List::PRINT_BLANK_FORM_BUTTON)); sleep 1 }

      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment_List::BLANK_PDF_ICON)).to eq(true)
      expect(getTextForElement(:css, Plan_Your_Appointment_List::PRINT_BLANK_FORM_BUTTON)).to eq("Print Blank Form")
      expect(getElement(:css, Plan_Your_Appointment_List::PRINT_BLANK_FORM_BUTTON).attribute("title")).to eq("Print Blank Form")
    end

    it "2. When the user selects the Print Paper Form button, the system opens the paper form in a PDF view", :broken => true do
      click(:css, Plan_Your_Appointment_List::PRINT_BLANK_FORM_BUTTON)
      switchWindowToWindowHandleLast()

      !45.times{ break if (getPageTitle() == "Plan Your Appointment - Blank Form - appointment-plan-blank-form.pdf"); sleep 1 }
      expect(getPageTitle).to eq("Plan Your Appointment - Blank Form - appointment-plan-blank-form.pdf")
      expect(@appmt_list.verifyEmbeddedPDF()).to eq(true)

      closeBrowser()
      switchWindowToWindowHandleFirst()
    end
  end

  context "#AC JRNL-1727|TC JRNL-1656: Sub Feature Default View (Filter and Table List) for Plan Your Appointment" do

    it "Filter Control/2.1.1 Filter defaults to an expanded view. Filter button alt text reads 'Collapse filter options' when expanded" do
      expect(@date_filter.isFilterAccordionExpanded).to eq(true)
      expect(@date_filter.getFilterAccordionTitle).to eq("Collapse filter options")
    end

    it "Users can collapse the filter list by clicking on the Collapse filter icon. When collapsed, the filter icon alt text reads 'Expand filter options.'", :broken => true do
      @date_filter.clickFilterAccordion
      !45.times{ break if (@date_filter.isFilterAccordionExpanded == false); sleep 1 }
      expect(@date_filter.isFilterAccordionExpanded).to eq(false)
      expect(@date_filter.getFilterAccordionTitle).to eq("Expand filter options")
      @date_filter.clickFilterAccordion
      !45.times{ break if (@date_filter.isFilterAccordionExpanded == true); sleep 1 }
      expect(@date_filter.isFilterAccordionExpanded).to eq(true)

    end

    it "Filter Option  2.2.1 Appointment Date Range (Default to today minus 6 months - today plus 6 months)", :broken => true do
      expect(@date_filter.getDateRangeLabel).to eq("Appointment Date Range:")

      expect(@date_filter.getStartDateLabel).to eq("* Start Date:")
      expect(@date_filter.isStartDateRequiredField).to eq(true)
      expect(@date_filter.getStartDatePlaceHolder).to eq("MM/DD/YYYY")

      sixMonthsFromToday = getDateNthMonthsFromNow(6, "%m/%d/%Y")
      sixMonthsBackFromToday = getDateNthMonthsFromNow(-6, "%m/%d/%Y")

      #default date range equivalent to 6 months forward and back from today
      expect(@date_filter.getStartDate).to eq(sixMonthsBackFromToday)
      expect(@date_filter.getEndDate).to eq(sixMonthsFromToday)
    end

    it "* required field", :broken => true do
      expect(@date_filter.getEndDateLabel).to eq("* End Date:")
      expect(@date_filter.isEndDateRequiredField).to eq(true)
      expect(@date_filter.getEndDatePlaceHolder).to eq("MM/DD/YYYY")

      expect(@date_filter.getRequiredFieldIndicator).to eq("* required field")

    end

    it "To Date cannot be before Start Date" do

      @date_filter.setDateRangeAndFilter(@tomorrow, @today)
      @date_filter.clickFilterBtn

      !45.times{ break if (@error.getValidationSummaryHeader("filterForm") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("filterForm")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("filterForm", "Start Date must occur before End Date.")).to eq(true)

    end

    it "Selected dates cannot be before January 1, 1900; text and date picker controls are constrained accordingly" do
      @date_filter.setFromDate("09/01/1899")
      expect(@date_filter.getStartDate).to eq("09/01/199")

    end

    it "Status (single select, pick list, values: Select, Desired, Scheduled, Canceled, Completed)" do
      expect(getTextForElement(:css, Plan_Your_Appointment_List::STATUS_LABEL)).to eq("Status:")
      expect(areAllTheseValuesAvailableInDropDown(Plan_Your_Appointment_List::STATUS, "Select;Desired;Scheduled;Canceled;Completed")).to eq(true)
    end

    it "Filter Button (alt text - filter)  3.5 No results found message", :broken => true do
      expect(@date_filter.getFilterButtonLabel).to eq("Filter")
      @date_filter.setDateRangeAndFilter("11/02/1991", "12/02/1992")
      !45.times{ break if (getFocusedElementText == "No results were found with the current filters. Use the Add button above to create a new record.\nIt is a good idea to prepare for your healthcare visit ahead of time. To do that, think about what you want to talk about, questions you have, and any other issues you want to bring up. It’s also helpful to review your medication and allergies with your provider.\nAt your visit, don’t be afraid to ask questions or let the provider know if you don’t fully understand something they said. It’s OK to ask them to repeat what they said or to write it down for you. Use this app to write notes on what you were told and look at it later as a reminder."); sleep 1 }
      expect(getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.\nIt is a good idea to prepare for your healthcare visit ahead of time. To do that, think about what you want to talk about, questions you have, and any other issues you want to bring up. It’s also helpful to review your medication and allergies with your provider.\nAt your visit, don’t be afraid to ask questions or let the provider know if you don’t fully understand something they said. It’s OK to ask them to repeat what they said or to write it down for you. Use this app to write notes on what you were told and look at it later as a reminder.")

    end

  end

  context "#AC JRNL-1726: Filter Action and Results Display for Plan Your Appointment" do

    it "When a user selects the filter button, the system updates the table view to show records that match the filter options entered", :broken => true do

      refreshBrowser()
      !45.times{ break if (getPrimaryHeader == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader).to eq("Plan Your Appointment")

      status = "Scheduled"
      date = getDateNthDaysFromNow(7, "%m/%d/%Y")
      time = "12:30 PM"
      firstName = "John"
      lastName = "Do"
      clinic = "Herndon Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Scheduled"
      date = getDateNthDaysFromNow(-250, "%m/%d/%Y")
      time = "02:30 PM"
      firstName = ""
      lastName = ""
      clinic = "Two Hundred Fifty Days Ago Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Scheduled"
      date = getDateNthDaysFromNow(250, "%m/%d/%Y")
      time = "12:30 PM"
      firstName = ""
      lastName = ""
      clinic = "Two Hundred Fifty Days From today Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Desired"
      date = ""
      time = ""
      firstName = ""
      lastName = ""
      clinic = "Reston Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Scheduled"
      date = getDateNthDaysFromNow(29,"%m/%d/%Y")
      time = "03:00 PM"
      firstName = ""
      lastName = "Cross"
      clinic = "Arlington Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Scheduled"
      date = getDateNthDaysFromNow(29,"%m/%d/%Y")
      time = "04:00 PM"
      firstName = ""
      lastName = "Park"
      clinic = "Arlington Clinic 2"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Canceled"
      date = getDateNthDaysFromNow(4, "%m/%d/%Y")
      time = "10:30 AM"
      firstName = ""
      lastName = ""
      clinic = "Fair Oaks Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Canceled"
      date = ""
      time = ""
      firstName = "Susan"
      lastName = ""
      clinic = "Fair Oaks Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Completed"
      date = getDateNthDaysFromNow(-6, "%m/%d/%Y")
      time = "04:30 PM"
      firstName = ""
      lastName = ""
      clinic = "Inova Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Desired"
      date = getDateNthDaysFromNow(10, "%m/%d/%Y")
      time = ""
      firstName = ""
      lastName = ""
      clinic = "DC Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Completed"
      date = getDateNthDaysFromNow(-20, "%m/%d/%Y")
      time = "08:30 AM"
      firstName = "John"
      lastName = "Henkel"
      clinic = "South Riding Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Canceled"
      date = getDateNthDaysFromNow(-24, "%m/%d/%Y")
      time = "11:00 AM"
      firstName = ""
      lastName = ""
      clinic = "Zaita clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Canceled"
      date = ""
      time = ""
      firstName = ""
      lastName = ""
      clinic = "Chantilly Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Desired"
      date = ""
      time = ""
      firstName = ""
      lastName = ""
      clinic = "Centreville Clinic"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Completed"
      date = getDateNthMonthsFromNow(-5, "%m/%d/%Y")
      time = "04:30 PM"
      firstName = ""
      lastName = ""
      clinic = "Inova Clinic 2"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Completed"
      date = getDateNthMonthsFromNow(-20, "%m/%d/%Y")
      time = "08:30 AM"
      firstName = "John"
      lastName = "Henkel"
      clinic = "South Riding Clinic 2"
      addAppointment(status, date, time, clinic, firstName, lastName )

      status = "Canceled"
      date = getDateNthMonthsFromNow(-24, "%m/%d/%Y")
      time = "11:00 AM"
      firstName = ""
      lastName = ""
      clinic = "Zaita clinic 2"
      addAppointment(status, date, time, clinic, firstName, lastName )

      expect(@appmt_list.getCount).to eq(13)

      expect(@appmt_list.getTextForRowColumn(1, 1)).to eq("Arlington Clinic 2")
      expect(@appmt_list.getTextForRowColumn(1, 2)).to eq("Park")
      expect(@appmt_list.getTextForRowColumn(1, 3)).to eq(getDateNthDaysFromNow(29,"%m/%d/%Y") + " 04:00 PM")
      expect(@appmt_list.getTextForRowColumn(1, 4)).to eq("Scheduled")

      expect(@appmt_list.getTextForRowColumn(2, 1)).to eq("Arlington Clinic")
      expect(@appmt_list.getTextForRowColumn(2, 2)).to eq("Cross")
      expect(@appmt_list.getTextForRowColumn(2, 3)).to eq(getDateNthDaysFromNow(29,"%m/%d/%Y") + " 03:00 PM")
      expect(@appmt_list.getTextForRowColumn(2, 4)).to eq("Scheduled")

      expect(@appmt_list.getTextForRowColumn(3, 1)).to eq("DC Clinic")
      expect(@appmt_list.getTextForRowColumn(3, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(3, 3)).to eq(getDateNthDaysFromNow(10, "%m/%d/%Y"))
      expect(@appmt_list.getTextForRowColumn(3, 4)).to eq("Desired")

      expect(@appmt_list.getTextForRowColumn(4, 1)).to eq("Herndon Clinic")
      expect(@appmt_list.getTextForRowColumn(4, 2)).to eq("John Do")
      expect(@appmt_list.getTextForRowColumn(4, 3)).to eq(getDateNthDaysFromNow(7, "%m/%d/%Y") + " 12:30 PM")
      expect(@appmt_list.getTextForRowColumn(4, 4)).to eq("Scheduled")

      expect(@appmt_list.getTextForRowColumn(5, 1)).to eq("Fair Oaks Clinic")
      expect(@appmt_list.getTextForRowColumn(5, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(5, 3)).to eq(getDateNthDaysFromNow(4, "%m/%d/%Y") + " 10:30 AM")
      expect(@appmt_list.getTextForRowColumn(5, 4)).to eq("Canceled")

      expect(@appmt_list.getTextForRowColumn(6, 1)).to eq("Inova Clinic")
      expect(@appmt_list.getTextForRowColumn(6, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(6, 3)).to eq(getDateNthDaysFromNow(-6, "%m/%d/%Y") + " 04:30 PM")
      expect(@appmt_list.getTextForRowColumn(6, 4)).to eq("Completed")

      expect(@appmt_list.getTextForRowColumn(7, 1)).to eq("South Riding Clinic")
      expect(@appmt_list.getTextForRowColumn(7, 2)).to eq("John Henkel")
      expect(@appmt_list.getTextForRowColumn(7, 3)).to eq(getDateNthDaysFromNow(-20, "%m/%d/%Y") + " 08:30 AM")
      expect(@appmt_list.getTextForRowColumn(7, 4)).to eq("Completed")

      expect(@appmt_list.getTextForRowColumn(8, 1)).to eq("Zaita clinic")
      expect(@appmt_list.getTextForRowColumn(8, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(8, 3)).to eq(getDateNthDaysFromNow(-24, "%m/%d/%Y") + " 11:00 AM")
      expect(@appmt_list.getTextForRowColumn(8, 4)).to eq("Canceled")

      expect(@appmt_list.getTextForRowColumn(9, 1)).to eq("Inova Clinic 2")
      expect(@appmt_list.getTextForRowColumn(9, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(9, 3)).to eq(getDateNthMonthsFromNow(-5, "%m/%d/%Y") + " 04:30 PM")
      expect(@appmt_list.getTextForRowColumn(9, 4)).to eq("Completed")

      expect(@appmt_list.getTextForRowColumn(10, 1)).to eq("Reston Clinic")
      expect(@appmt_list.getTextForRowColumn(10, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(10, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(10, 4)).to eq("Desired")

      expect(@appmt_list.getTextForRowColumn(11, 1)).to eq("Fair Oaks Clinic")
      expect(@appmt_list.getTextForRowColumn(11, 2)).to eq("Susan")
      expect(@appmt_list.getTextForRowColumn(11, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(11, 4)).to eq("Canceled")

      expect(@appmt_list.getTextForRowColumn(12, 1)).to eq("Chantilly Clinic")
      expect(@appmt_list.getTextForRowColumn(12, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(12, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(12, 4)).to eq("Canceled")

      expect(@appmt_list.getTextForRowColumn(13, 1)).to eq("Centreville Clinic")
      expect(@appmt_list.getTextForRowColumn(13, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(13, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(13, 4)).to eq("Desired")

      fromDate =  getDateNthDaysFromNow(-250, "%m/%d/%Y")
      toDate = getDateNthDaysFromNow(-240, "%m/%d/%Y")

      @date_filter.setDateRangeAndFilter(fromDate, toDate)

      tableHeaderArr = ["Clinic/Organization", "Provider", "Date/Time", "Status"]
      !45.times { break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      expect(@appmt_list.getTextForRowColumn(1, 1)).to eq("Two Hundred Fifty Days Ago Clinic")
      expect(@appmt_list.getTextForRowColumn(1, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(1, 3)).to eq(getDateNthDaysFromNow(-250, "%m/%d/%Y") + " 02:30 PM")
      expect(@appmt_list.getTextForRowColumn(1, 4)).to eq("Scheduled")

      fromDate =  getDateNthDaysFromNow(230, "%m/%d/%Y")
      toDate = getDateNthDaysFromNow(260, "%m/%d/%Y")

      @date_filter.setDateRangeAndFilter(fromDate, toDate)

      tableHeaderArr = ["Clinic/Organization", "Provider", "Date/Time", "Status"]
      !45.times { break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      expect(@appmt_list.getTextForRowColumn(1, 1)).to eq("Two Hundred Fifty Days From today Clinic")
      expect(@appmt_list.getTextForRowColumn(1, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(1, 3)).to eq(getDateNthDaysFromNow(250, "%m/%d/%Y") + " 12:30 PM")
      expect(@appmt_list.getTextForRowColumn(1, 4)).to eq("Scheduled")

    end

    it "After the filter button is selected, the focus moves to the returned results, first row, or the No results found message.", :broken => true do

      fromDate =  getDateNthDaysFromNow(-60, "%m/%d/%Y")
      toDate = getDateNthDaysFromNow(90, "%m/%d/%Y")

      @date_filter.setDateRangeAndFilter(fromDate, toDate)

      tableHeaderArr = ["Clinic/Organization", "Provider", "Date/Time", "Status"]
      !45.times { break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      expect(@appmt_list.getNoResultsFoundMessage).to eq("Please update your other My Medical information especially medications and allergies prior to your visit.")
      expect(getFocusedElementText).to include("Clinic/Organization \nArlington Clinic 2\n  Provider \nPark\n  Date/Time")

    end

    it "Appointment agenda entries are displayed in a table format, sorted reverse chronological order by appointment date and time if valued (regardless of status);   Null values are shown as empty table cells; 3.4.1.2 Records that don't have date/time are displayed sorted by create date below records with date/time values.", :broken => true do
      expect(@appmt_list.getCount).to eq(12)

      expect(@appmt_list.getTextForRowColumn(1, 1)).to eq("Arlington Clinic 2")
      expect(@appmt_list.getTextForRowColumn(1, 2)).to eq("Park")
      expect(@appmt_list.getTextForRowColumn(1, 3)).to eq(getDateNthDaysFromNow(29,"%m/%d/%Y") + " 04:00 PM")
      expect(@appmt_list.getTextForRowColumn(1, 4)).to eq("Scheduled")

      expect(@appmt_list.getTextForRowColumn(2, 1)).to eq("Arlington Clinic")
      expect(@appmt_list.getTextForRowColumn(2, 2)).to eq("Cross")
      expect(@appmt_list.getTextForRowColumn(2, 3)).to eq(getDateNthDaysFromNow(29,"%m/%d/%Y") + " 03:00 PM")
      expect(@appmt_list.getTextForRowColumn(2, 4)).to eq("Scheduled")

      expect(@appmt_list.getTextForRowColumn(3, 1)).to eq("DC Clinic")
      expect(@appmt_list.getTextForRowColumn(3, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(3, 3)).to eq(getDateNthDaysFromNow(10, "%m/%d/%Y"))
      expect(@appmt_list.getTextForRowColumn(3, 4)).to eq("Desired")

      expect(@appmt_list.getTextForRowColumn(4, 1)).to eq("Herndon Clinic")
      expect(@appmt_list.getTextForRowColumn(4, 2)).to eq("John Do")
      expect(@appmt_list.getTextForRowColumn(4, 3)).to eq(getDateNthDaysFromNow(7, "%m/%d/%Y") + " 12:30 PM")
      expect(@appmt_list.getTextForRowColumn(4, 4)).to eq("Scheduled")

      expect(@appmt_list.getTextForRowColumn(5, 1)).to eq("Fair Oaks Clinic")
      expect(@appmt_list.getTextForRowColumn(5, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(5, 3)).to eq(getDateNthDaysFromNow(4, "%m/%d/%Y") + " 10:30 AM")
      expect(@appmt_list.getTextForRowColumn(5, 4)).to eq("Canceled")

      expect(@appmt_list.getTextForRowColumn(6, 1)).to eq("Inova Clinic")
      expect(@appmt_list.getTextForRowColumn(6, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(6, 3)).to eq(getDateNthDaysFromNow(-6, "%m/%d/%Y") + " 04:30 PM")
      expect(@appmt_list.getTextForRowColumn(6, 4)).to eq("Completed")

      expect(@appmt_list.getTextForRowColumn(7, 1)).to eq("South Riding Clinic")
      expect(@appmt_list.getTextForRowColumn(7, 2)).to eq("John Henkel")
      expect(@appmt_list.getTextForRowColumn(7, 3)).to eq(getDateNthDaysFromNow(-20, "%m/%d/%Y") + " 08:30 AM")
      expect(@appmt_list.getTextForRowColumn(7, 4)).to eq("Completed")

      expect(@appmt_list.getTextForRowColumn(8, 1)).to eq("Zaita clinic")
      expect(@appmt_list.getTextForRowColumn(8, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(8, 3)).to eq(getDateNthDaysFromNow(-24, "%m/%d/%Y") + " 11:00 AM")
      expect(@appmt_list.getTextForRowColumn(8, 4)).to eq("Canceled")

      #3.4.1.2 Records that don't have date/time are displayed sorted by create date below records with date/time values.
      expect(@appmt_list.getTextForRowColumn(9, 1)).to eq("Reston Clinic")
      expect(@appmt_list.getTextForRowColumn(9, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(9, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(9, 4)).to eq("Desired")

      expect(@appmt_list.getTextForRowColumn(10, 1)).to eq("Fair Oaks Clinic")
      expect(@appmt_list.getTextForRowColumn(10, 2)).to eq("Susan")
      expect(@appmt_list.getTextForRowColumn(10, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(10, 4)).to eq("Canceled")

      expect(@appmt_list.getTextForRowColumn(11, 1)).to eq("Chantilly Clinic")
      expect(@appmt_list.getTextForRowColumn(11, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(11, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(11, 4)).to eq("Canceled")

      expect(@appmt_list.getTextForRowColumn(12, 1)).to eq("Centreville Clinic")
      expect(@appmt_list.getTextForRowColumn(12, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(12, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(12, 4)).to eq("Desired")

      resizeWindowToPhone()

      phoneTableHeaderArr = ["Clinic/Organization", "Status"]
      !45.times { break if (@appmt_list.getTableHeaders == phoneTableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(phoneTableHeaderArr)

      resizeWindowToDefault()

      tableHeaderArr = ["Clinic/Organization", "Provider", "Date/Time", "Status"]
      !45.times { break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      @appmt_list.selectStatus("Scheduled")
      @date_filter.clickFilterBtn

      !45.times { break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      expect(@appmt_list.getCount).to eq(3)

      expect(@appmt_list.getTextForRowColumn(1, 1)).to eq("Arlington Clinic 2")
      expect(@appmt_list.getTextForRowColumn(1, 2)).to eq("Park")
      expect(@appmt_list.getTextForRowColumn(1, 3)).to eq(getDateNthDaysFromNow(29,"%m/%d/%Y") + " 04:00 PM")
      expect(@appmt_list.getTextForRowColumn(1, 4)).to eq("Scheduled")

      expect(@appmt_list.getTextForRowColumn(2, 1)).to eq("Arlington Clinic")
      expect(@appmt_list.getTextForRowColumn(2, 2)).to eq("Cross")
      expect(@appmt_list.getTextForRowColumn(2, 3)).to eq(getDateNthDaysFromNow(29,"%m/%d/%Y") + " 03:00 PM")
      expect(@appmt_list.getTextForRowColumn(2, 4)).to eq("Scheduled")

      expect(@appmt_list.getTextForRowColumn(3, 1)).to eq("Herndon Clinic")
      expect(@appmt_list.getTextForRowColumn(3, 2)).to eq("John Do")
      expect(@appmt_list.getTextForRowColumn(3, 3)).to eq(getDateNthDaysFromNow(7, "%m/%d/%Y") + " 12:30 PM")
      expect(@appmt_list.getTextForRowColumn(3, 4)).to eq("Scheduled")

      @appmt_list.selectStatus("Desired")
      @date_filter.clickFilterBtn

      !45.times { break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      expect(@appmt_list.getCount).to eq(3)

      expect(@appmt_list.getTextForRowColumn(1, 1)).to eq("DC Clinic")
      expect(@appmt_list.getTextForRowColumn(1, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(1, 3)).to eq(getDateNthDaysFromNow(10, "%m/%d/%Y"))
      expect(@appmt_list.getTextForRowColumn(1, 4)).to eq("Desired")

      expect(@appmt_list.getTextForRowColumn(2, 1)).to eq("Reston Clinic")
      expect(@appmt_list.getTextForRowColumn(2, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(2, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(2, 4)).to eq("Desired")

      expect(@appmt_list.getTextForRowColumn(3, 1)).to eq("Centreville Clinic")
      expect(@appmt_list.getTextForRowColumn(3, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(3, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(3, 4)).to eq("Desired")

      @appmt_list.selectStatus("Canceled")
      @date_filter.clickFilterBtn

      !45.times { break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      expect(@appmt_list.getCount).to eq(4)

      expect(@appmt_list.getTextForRowColumn(1, 1)).to eq("Fair Oaks Clinic")
      expect(@appmt_list.getTextForRowColumn(1, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(1, 3)).to eq(getDateNthDaysFromNow(4, "%m/%d/%Y") + " 10:30 AM")
      expect(@appmt_list.getTextForRowColumn(1, 4)).to eq("Canceled")

      expect(@appmt_list.getTextForRowColumn(2, 1)).to eq("Zaita clinic")
      expect(@appmt_list.getTextForRowColumn(2, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(2, 3)).to eq(getDateNthDaysFromNow(-24, "%m/%d/%Y") + " 11:00 AM")
      expect(@appmt_list.getTextForRowColumn(2, 4)).to eq("Canceled")

      expect(@appmt_list.getTextForRowColumn(3, 1)).to eq("Fair Oaks Clinic")
      expect(@appmt_list.getTextForRowColumn(3, 2)).to eq("Susan")
      expect(@appmt_list.getTextForRowColumn(3, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(3, 4)).to eq("Canceled")

      expect(@appmt_list.getTextForRowColumn(4, 1)).to eq("Chantilly Clinic")
      expect(@appmt_list.getTextForRowColumn(4, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(4, 3)).to eq("")
      expect(@appmt_list.getTextForRowColumn(4, 4)).to eq("Canceled")

      @appmt_list.selectStatus("Completed")
      @date_filter.clickFilterBtn

      !45.times { break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      expect(@appmt_list.getCount).to eq(2)

      expect(@appmt_list.getTextForRowColumn(1, 1)).to eq("Inova Clinic")
      expect(@appmt_list.getTextForRowColumn(1, 2)).to eq("")
      expect(@appmt_list.getTextForRowColumn(1, 3)).to eq(getDateNthDaysFromNow(-6, "%m/%d/%Y") + " 04:30 PM")
      expect(@appmt_list.getTextForRowColumn(1, 4)).to eq("Completed")

      expect(@appmt_list.getTextForRowColumn(2, 1)).to eq("South Riding Clinic")
      expect(@appmt_list.getTextForRowColumn(2, 2)).to eq("John Henkel")
      expect(@appmt_list.getTextForRowColumn(2, 3)).to eq(getDateNthDaysFromNow(-20, "%m/%d/%Y") + " 08:30 AM")
      expect(@appmt_list.getTextForRowColumn(2, 4)).to eq("Completed")

    end

  end

  context "#AC JRNL-1508|TC JRNL-1656: Plan your appointment - Navigation" do
    it "On phone from factors, a < is shown", :broken => true do
      resizeWindowToPhone
      expect(@common.getBackButtonAltText).to eq("Return to My Medical options")
      @common.clickBackButton
      !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
      expect(@nav_menu.isMyMedicalButtonVisible).to eq("My Medical")
      resizeWindowToDefault
    end
  end


  def addAppointment(status, date, time, clinic, firstName, lastName )
    @common.clickAddButton

    !45.times { break if (getPrimaryHeader() == "Add Appointment Plan"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Add Appointment Plan")

    @appmt.selectAppointmentStatus(status)
    @appmt.setAppointmentDate(date)
    @appmt.setAppointmentTime(time)
    @appmt.setClinic(clinic)
    @appmt.setFirstName(firstName)
    @appmt.setLastName(lastName)

    @appmt.clickSaveBtn
    !45.times { break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
    expect(@appmt.isSaveButtonDisabled).to eq(true)

    @common.clickBackButton()

    !45.times { break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Plan Your Appointment")

    tableHeaderArr = ["Clinic/Organization", "Provider", "Date/Time", "Status"]
    !45.times { break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
    expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)
  end


end

