#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2457: Plan Your Appointment - Edit, Delete]", :regression => true  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("plan", "previsitagendadb")

    @tomorrow = getDateNthDaysFromNow(1,  "%m/%d/%Y")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @expectedValidationSummaryHeader = "The following errors were found:"

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickPlanYourAppointment()
    waitForPageToFinishLoading()
  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1722|TC JRNL-1576: Edit an Entry for Plan Your Appointment" do

    it "2.1.	When the user selects the Plan Your Appointment entry from the table view, the system displays the Plan Your Appointment record in the Detail screen in Edit mode:", :broken => true do
      @common.clickAddButton
      !45.times{ break if (getPrimaryHeader() == "Add Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Appointment Plan")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq(true)

      @appmt.selectAppointmentStatus("Desired")
      @appmt.setClinic("South Riding Clinic")

      @appmt.clickSaveBtn
      !45.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
      expect(@appmt.isSaveButtonDisabled).to eq(true)

      @common.clickBackButton
      !45.times{ break if (@appmt_list.getCount == 1); sleep 1 }
      expect(@appmt_list.getCount).to eq(1)

      tableHeaderArr = ["Clinic/Organization", "Provider", "Date/Time", "Status"]
      !45.times{ break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      @appmt_list.clickNthRow(1)
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Plan")
    end

    it "2.1.1.	All data elements available in Add Entry mode are visible.", :broken => true do
      !45.times{ break if (@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::APPOINTMENT_STATUS_SELECT) == true); sleep 1 }

      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::APPOINTMENT_INFORMATION_HEADING)).to eq(false)

      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::APPOINTMENT_STATUS_SELECT)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::APPOINTMENT_DATE_INPUT)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::APPOINTMENT_TIME_INPUT)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::PROVIDER_FIRST_NAME)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::PROVIDER_LAST_NAME)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::CLINIC_NAME)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::APPOINTMENT_REASON)).to eq(true)

      @appmt.clickAccordionByHeading("Items to Discuss")

      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::TALK_ABOUT_TEXTAREA)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::SYMPTOMS_RADIO)).to eq(true)
      @appmt.selectRadioButton("true", Plan_Your_Appointment::SYMPTOMS_RADIO)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::SYMPTOMS_TEXTAREA)).to eq(true)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::MEDICATIONS_QUESTION_TEXTAREA)).to eq(true)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::DIAGNOSIS_QUESTION_TEXTAREA)).to eq(true)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::TESTS_QUESTION_TEXTAREA)).to eq(true)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::TREATMENT_QUESTION_TEXTAREA)).to eq(true)

      expect(@appmt.isNthOtherConcernsTextAreaVisible(1)).to eq(true)

      for i in 2..10
        click(:css, Plan_Your_Appointment::ADD_ITEM_BUTTON)
        expect(@appmt.isNthOtherConcernsTextAreaVisible(i)).to eq(true)
      end

      @appmt.clickAccordionByHeading("After Appointment Notes")

      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::GENERAL_NOTES_TEXTAREA)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::DIAGNOSIS_NOTES_TEXTAREA)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::TEST_NOTES_TEXTAREA)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::DIAGNOSIS_NOTES_TEXTAREA)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::ACTIONS_NOTES_TEXTAREA)).to eq(true)
      expect(@appmt.isElementPresentAndVisible(:css, Plan_Your_Appointment::NEXT_FOLLOWUP_NOTES_TEXTAREA)).to eq(true)

      @appmt.clickSaveBtn
      !45.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
      expect(@appmt.isSaveButtonDisabled).to eq(true)

      @common.clickBackButton
      !45.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")
    end

    it "2.1.2.	All values previously saved are visible. If no value was previously saved for a field, the display defaults to null (or select for drop lists); no guidance text (light gray placeholder text) is shown unless and all fields are optional unless otherwise indicated.", :broken => true do
      @common.clickAddButton
      !45.times{ break if (getPrimaryHeader() == "Add Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Appointment Plan")

      @appmt.selectAppointmentStatus("Scheduled")

      fourtyDays = getDateNthDaysFromNow(40,  "%m/%d/%Y")
      @appmt.setAppointmentDate(fourtyDays)
      @appmt.setAppointmentTime("10:30 AM")

      @appmt.setFirstName("Cindy")
      @appmt.setLastName("Lee")
      @appmt.setClinic("Fair Oaks clinic")
      @appmt.setReason("Migrane, Sinus infection")

      @appmt.clickAccordionByHeading("Items to Discuss")
      @appmt.setTalkAbout("Discuss Migrane, Sinus issue")
      @appmt.selectRadioButton("true", Plan_Your_Appointment::SYMPTOMS_RADIO)
      @appmt.setSymptomsNote("Severe headache, blurry eyes")
      @appmt.selectRadioButton("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)
      @appmt.setMedicationsQuestionNote("Vitamin E, Omega-3")
      @appmt.selectRadioButton("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)
      @appmt.setDiagnosisNote("Strep, Sinus infection?")
      @appmt.selectRadioButton("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)
      @appmt.setTestsNote("Blood test results")
      @appmt.selectRadioButton("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)
      @appmt.setTreatmentPlanNote("Medications, Food")
      @appmt.setNthConcernNote(1, "Other Concern 1")

      for i in 2..10
        click(:css, Plan_Your_Appointment::ADD_ITEM_BUTTON)
        @appmt.setNthConcernNote(i, "Other Concern " + i.to_s)
      end

      @appmt.clickAccordionByHeading("After Appointment Notes")
      @appmt.setGeneralNote("General notes entered")
      @appmt.setAfterAppointmentDiagnosisNote("After Appointment Notes Diagnosis")
      @appmt.setAfterAppointmentTestNote("After Appointment Test results entered")
      @appmt.setDirectionsGiveNote("After Appointment Directions given")
      @appmt.setActionsNote("After Appointment Actions note")
      @appmt.setFollwUpNote("When is next follow-up?")

      @appmt.clickSaveBtn
      !45.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
      expect(@appmt.isSaveButtonDisabled).to eq(true)

      @common.clickBackButton
      !45.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")

      tableHeaderArr = ["Clinic/Organization", "Provider", "Date/Time", "Status"]
      !45.times{ break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      @appmt_list.clickNthEntry(1)
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Plan")

      expect(@appmt.getAppointmentStatus()).to eq("Scheduled")

      expect(@appmt.getAppointmentDate).to eq(fourtyDays)
      expect(@appmt.getAppointmentTime).to eq("10:30 AM")

      expect(@appmt.getFirstName()).to eq("Cindy")
      expect(@appmt.getLastName).to eq("Lee")
      expect(@appmt.getClinic).to eq("Fair Oaks clinic")
      expect(@appmt.getReason).to eq("Migrane, Sinus infection")

      @appmt.clickAccordionByHeading("Items to Discuss")
      expect(@appmt.getTalkAbout).to eq("Discuss Migrane, Sinus issue")

      expect(@appmt.getSymptomsNote).to eq("Severe headache, blurry eyes")
      expect(@appmt.getMedicationsQuestionNote).to eq("Vitamin E, Omega-3")
      expect(@appmt.getDiagnosisQuestionNote).to eq("Strep, Sinus infection?")

      expect(@appmt.getTestsQuestionNote).to eq("Blood test results")

      expect(@appmt.getTreatmentPlanNote).to eq("Medications, Food")

      for i in 1..10
        expect(@appmt.getNthConcernNote(i)).to eq("Other Concern " + i.to_s)
      end

      @appmt.clickAccordionByHeading("After Appointment Notes")

      expect(@appmt.getGeneralNote).to eq("General notes entered")
      expect(@appmt.getAfterAppointmentDiagnosisNote).to eq("After Appointment Notes Diagnosis")
      expect(@appmt.getTestNote).to eq("After Appointment Test results entered")
      expect(@appmt.getDirectionsNote).to eq("After Appointment Directions given")
      expect(@appmt.getActionsNote).to eq("After Appointment Actions note")
      expect(@appmt.getFolloupNote).to eq("When is next follow-up?")

      #set to null except for the required fields
      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.selectAppointmentStatus("Scheduled")

      fourtyDays = getDateNthDaysFromNow(40,  "%m/%d/%Y")
      @appmt.setAppointmentDate(fourtyDays)
      @appmt.setAppointmentTime("10:30 AM")

      @appmt.setFirstName("")
      @appmt.setLastName("")
      @appmt.setClinic("Fair Oaks clinic")
      @appmt.setReason("")

      @appmt.clickAccordionByHeading("Items to Discuss")
      @appmt.setTalkAbout("")
      @appmt.selectRadioButton("false", Plan_Your_Appointment::SYMPTOMS_RADIO)
      @appmt.selectRadioButton("false", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)
      @appmt.selectRadioButton("false", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)
      @appmt.selectRadioButton("false", Plan_Your_Appointment::TESTS_QUESTION_RADIO)
      @appmt.selectRadioButton("false", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)

      for i in 1..10
        @appmt.setNthConcernNote(i, "")
      end

      @appmt.clickAccordionByHeading("After Appointment Notes")
      @appmt.setGeneralNote("")
      @appmt.setAfterAppointmentDiagnosisNote("")
      @appmt.setAfterAppointmentTestNote("")
      @appmt.setDirectionsGiveNote("")
      @appmt.setActionsNote("")
      @appmt.setFollwUpNote("")

      @appmt.clickSaveBtn
      !45.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
      expect(@appmt.isSaveButtonDisabled).to eq(true)

      @common.clickBackButton
      !45.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")

      tableHeaderArr = ["Clinic/Organization", "Provider", "Date/Time", "Status"]
      !45.times{ break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      @appmt_list.clickNthRow(1)
      #Verify null value saved
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Plan")

      expect(@appmt.getAppointmentStatus()).to eq("Scheduled")

      expect(@appmt.getAppointmentDate).to eq(fourtyDays)
      expect(@appmt.getAppointmentTime).to eq("10:30 AM")

      expect(@appmt.getFirstName()).to eq("")
      expect(@appmt.getLastName).to eq("")
      expect(@appmt.getClinic).to eq("Fair Oaks clinic")
      expect(@appmt.getReason).to eq("")

      @appmt.clickAccordionByHeading("Items to Discuss")
      expect(@appmt.getTalkAbout).to eq("")

      @appmt.selectRadioButton("true", Plan_Your_Appointment::SYMPTOMS_RADIO)
      expect(@appmt.getSymptomsNote).to eq("")
      @appmt.selectRadioButton("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)
      expect(@appmt.getMedicationsQuestionNote).to eq("")
      @appmt.selectRadioButton("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)
      expect(@appmt.getDiagnosisQuestionNote).to eq("")
      @appmt.selectRadioButton("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)
      expect(@appmt.getTestsQuestionNote).to eq("")
      @appmt.selectRadioButton("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)
      expect(@appmt.getTreatmentPlanNote).to eq("")

      for i in 1..10
        expect(@appmt.getNthConcernNote(i)).to eq("")
      end

      @appmt.clickAccordionByHeading("After Appointment Notes")

      expect(@appmt.getGeneralNote).to eq("")
      expect(@appmt.getAfterAppointmentDiagnosisNote).to eq("")
      expect(@appmt.getTestNote).to eq("")
      expect(@appmt.getDirectionsNote).to eq("")
      expect(@appmt.getActionsNote).to eq("")
      expect(@appmt.getFolloupNote).to eq("")
    end

  end

  context "#AC JRNL-1720|TC JRNL-1576:  Navigation for Plan Your Appointment" do

    it "4.2.	If a user selects the < symbol and there are unsaved changes on the screen, the system will prompt the user to save their changes via a modal:", :broken => true do
      @appmt.setActionsNote("Testing Navigation option")

      @common.clickBackButton
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      @modal.clickReturnButton()
      !45.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Appointment Plan")

      @mymedical.clickBackButton
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      @modal.clickContinueButton
      !45.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")

      @appmt_list.clickNthEntry(1)
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Plan")

      @appmt.setFirstName("Updated")

      @mymedical.clickFamilyHistory
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      @modal.clickContinueButton
      !45.times{ break if (getPrimaryHeader() == "Family History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Family History")

      @mymedical.clickPlanYourAppointment
      !45.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")

      tableHeaderArr = ["Clinic/Organization", "Provider", "Date/Time", "Status"]
      !45.times{ break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)
    end

  end

  context "#AC JRNL-1721|TC JRNL-1576: Accordion Save, Delete Functionality for Plan Your Appointment" do

    #3.1 Save changes tested
    it "3.2.	Delete", :broken => true do
      @appmt_list.clickNthEntry(1)
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Plan")

      click(:css, Plan_Your_Appointment::DELETE_BUTTON)
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }

      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")

      @modal.clickNoButton()
      !45.times{ break if (@modal.isConfirmationPopUpNotPresent == true); sleep 1 }
      expect(getPrimaryHeader).to eq("Edit Appointment Plan")

      click(:css, Plan_Your_Appointment::DELETE_BUTTON)
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")

      @modal.clickYesButton
      !45.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")

      !45.times{ break if (@appmt_list.getCount == 1); sleep 1 }
      expect(@appmt_list.getCount).to eq(1)

      tableHeaderArr = ["Clinic/Organization", "Provider", "Date/Time", "Status"]
      !45.times{ break if (@appmt_list.getTableHeaders == tableHeaderArr); sleep 1 }
      expect(@appmt_list.getTableHeaders).to eq(tableHeaderArr)

      @appmt_list.clickNthEntry(1)
      !45.times{ break if (getPrimaryHeader() == "Edit Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Edit Appointment Plan")

      click(:css, Plan_Your_Appointment::DELETE_BUTTON)
      !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")

      @modal.clickYesButton
      !45.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")
    end

    it "3.2.5.	All deletes are soft deletes, meaning they are removed from the user's screen but remain in the database for audit purposes." do
      expect(verifyDocumentsDeleted("plan", "previsitagendadb", "EDIPI", "D123401", "deletedFlag")).to eq(true)
    end

  end

end

