#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2457: Plan Your Appointment - Add]
          [Story #JRNL-1568: Items to discuss labels]
          [Story #JRNL-1789: Plan Your Appointment - No records found custom message]
          [Story #JRNL-1786: Appointment Plan Summary PDF]", :regression => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("plan", "previsitagendadb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @tomorrow = getDateNthDaysFromNow(1,  "%m/%d/%Y")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @expectedValidationSummaryHeader = "The following errors were found:"

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:id, "MyMedical").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    expect(@mymedical.isPlanYourAppointmentVisible).to eq(true)
    @mymedical.clickPlanYourAppointment
    !5.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Plan Your Appointment")

  end

  # after(:all) do
  #   quitDriver()
  # end

  context "#AC JRNL-1719|TC JRNL-1575: No record found custom message for Plan Your Appointment" do
    it "No Results Found mesage" do
      !5.times{ break if (@appmt_list.getNoResultsFoundMessage != ""); sleep 1 }
      expect(@appmt_list.getNoResultsFoundMessage).to eq("Please update your other My Medical information especially medications and allergies prior to your visit.")
    end
  end

  context "#AC JRNL-1723|TC JRNL-1576: Add New Entry for Plan your Appointment" do
    it "1.  Add New Entry" do
      expect(@common.isAddButtonVisible).to eq(true)
      expect(@common.getAddButtonAltText).to eq("Add")
      #@common.clickAddButton
      waitForPageToFinishLoading
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading
      !5.times{ break if (getPrimaryHeader() == "Add Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Appointment Plan")

      !5.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq(true)

    end

    it "1.3.1 Three sections are shown with the following default display" do
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::APPOINTMENT_INFORMATION_HEADING)).to eq(false)
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(true)
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_HEADING)).to eq(true)
    end

    it "1.3.2 Collapse sections are indicated by a right arrow icon in the header, shown to the left of the accordion label. Alt text reads, Expand <section name>" do
      expect(@appmt.isRightArrowIconDisplayed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(true)
      expect(@appmt.isRightArrowIconDisplayed(Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_HEADING)).to eq(true)

      expect(@appmt.getAccordionAltText(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq("Expand\nItems to Discuss")
      expect(@appmt.getAccordionAltText(Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_HEADING)).to eq("Expand\nAfter Appointment Notes")

    end

    it "1.3.4 Accordion section can be opened and closed", :broken => true do
      @appmt.clickAccordionByHeading(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)
      !5.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::TALK_ABOUT_TEXTAREA)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::TALK_ABOUT_TEXTAREA)).to eq(true)


      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(false)
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::APPOINTMENT_INFORMATION_HEADING)).to eq(true)
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_HEADING)).to eq(true)

      expect(@appmt.isDownArrowIconDisplayed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(true)

      @appmt.clickAccordionByHeading(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)
      !5.times{ break if (@appmt.isAccordionCollapsed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)); sleep 1 }
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(true)

    end

    it "1.3.5 Appointment Information (accordion label)", :broken => true do
      @appmt.clickAccordionByHeading("Appointment Information")
      !5.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq(true)

      ENTRY_FORM = [\
                     "Collapse",
                      "Appointment Information",
                      "* required field",
                      "* Appointment Status:",
                      "Select",
                      "Desired",
                      "Scheduled",
                      "Canceled",
                      "Completed",
                      "Date: M M / D D / Y Y Y Y:",
                     "Date:",
                      "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
                      "Time:",
                      "hh:mm AM/PM",
                      "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
                      "Calendar (icon)",
                      "Booked VA Appointments",
                      "Provider",
                      "First Name:",
                      "30 character maximum",
                      "Last Name:",
                      "20 character maximum",
                      "* Clinic/Organization:",
                      "50 character maximum",
                      "Reason for Appointment:",
                      "50 character maximum",
                      "Expand",
                      "Items to Discuss",
                      "Expand",
                      "Set Notifications",
                      "Expand",
                      "After Appointment Notes"]

      form = @appmt.getScreenContent().split("\n")

      ENTRY_FORM.each_with_index do | expectedScreenRow, i |
        expect(form[i]).to eq(expectedScreenRow)
      end
      expect(form.length).to eq(ENTRY_FORM.length)

    end

    it "1.3.5.1 Appointment Information (Accordion label)", :broken => true do
      expect(areAllTheseValuesAvailableInDropDown(Plan_Your_Appointment::APPOINTMENT_STATUS_SELECT, "Select;Desired;Scheduled;Canceled;Completed")).to eq(true)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_STATUS_SELECT)).to eq(true)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_DATE_INPUT)).to eq(false)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_TIME_INPUT)).to eq(false)

      @appmt.selectAppointmentStatus("Completed")
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_DATE_INPUT)).to eq(true)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_TIME_INPUT)).to eq(true)

      @appmt.clickSaveBtn

      !5.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Clinic/Organization field is required.")).to eq(true)

      @appmt.selectAppointmentStatus("Scheduled")
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_DATE_INPUT)).to eq(true)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_TIME_INPUT)).to eq(true)
      @appmt.clickSaveBtn

      !5.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Clinic/Organization field is required.")).to eq(true)

      @appmt.selectAppointmentStatus("Desired")
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_DATE_INPUT)).to eq(false)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_TIME_INPUT)).to eq(false)
      @appmt.clickSaveBtn

      !5.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "Clinic/Organization field is required.")).to eq(true)

      expect(getPlaceHolderByCSS(:css, Plan_Your_Appointment::APPOINTMENT_DATE_INPUT)).to eq("MM/DD/YYYY")
      expect(getPlaceHolderByCSS(:css, Plan_Your_Appointment::APPOINTMENT_TIME_INPUT)).to eq("HH:MM AM/PM")

      @appmt.setAppointmentTime("08:30 AM")

      @appmt.clickSaveBtn

      !5.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "Clinic/Organization field is required.")).to eq(true)

      @appmt.setAppointmentTime("")

    end

    it "1.3.5.1.4 Booked VA Appointments ", :broken => true do
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq(true)
      expect(getTextForElement(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq("Calendar (icon)\nBooked VA Appointments")

      click(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)
      !5.times{ break if (@modal.getConfirmationHeading() == "Future VA Appointments"); sleep 1 }

      expect(@modal.getConfirmationHeading()).to eq("Future VA Appointments")

      expect(@appmt.getFutureVAAppointmentsTableHeader(1)).to eq("Facility Name")
      expect(@appmt.getFutureVAAppointmentsTableHeader(2)).to eq("Clinic Name")
      expect(@appmt.getFutureVAAppointmentsTableHeader(3)).to eq("Date/Time")

      expect(@appmt.isSortedChronologicalOrder).to eq(true)

      @modal.clickOKFromInfoModal()

      !5.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }


    end

    it "1.3.5.1.5 Provider " do
      expect(getTextForElement(:css, Plan_Your_Appointment::PROVIDER_LABEL)).to eq("Provider")
    end

    it "1.3.5.1.6 First Name 	First Name (alphanumeric, text box, 30 characters)" do
      expect(getTextForElement(:css, Plan_Your_Appointment::PROVIDER_FIRST_NAME_LABEL )).to eq("First Name:")

      firstName_30 = "123456789012345678901234567890"
      @appmt.setFirstName(firstName_30)
      expect(@appmt.getFirstName()).to eq(firstName_30)

      firstName_40 = "123456789012345678901234567890ABCDEFGHIJ"
      @appmt.setFirstName(firstName_40)
      expect(@appmt.getFirstName).to eq(firstName_30)

      @appmt.setFirstName("John")

    end

    it "1.3.5.1.7	Last Name (alphanumeric, text box, 20 characters)" do
      expect(getTextForElement(:css, Plan_Your_Appointment::PROVIDER_LAST_NAME_LABEL)).to eq("Last Name:")

      lastName_20 = "12345678901234567890"
      @appmt.setLastName(lastName_20)
      expect(@appmt.getLastName).to eq(lastName_20)

      lastName_30 = "12345678901234567890ABCDEFGHIJ"
      @appmt.setLastName(lastName_30)
      expect(@appmt.getLastName).to eq(lastName_20)

      @appmt.setLastName("Do")

    end

    it "1.3.5.1.8	Clinic/Organization (required, alphanumeric, textbox, 50 characters) " do
      expect(getTextForElement(:css, Plan_Your_Appointment::CLINIC_NAME_LABEL)).to eq("Clinic/Organization:")

      clinic_50 = "12345678901234567890123456789012345678901234567890"
      @appmt.setClinic(clinic_50)
      expect(@appmt.getClinic).to eq(clinic_50)

      clinic_60 = clinic_50 + "ABCDEFGHIJ"
      @appmt.setClinic(clinic_60)
      expect(@appmt.getClinic).to eq(clinic_50)

      @appmt.setClinic("South Riding Clinic")

    end

    it "1.3.5.1.9.	Reason for Appointment (alphanumeric, textbox, 50 characters)" do
      expect(getTextForElement(:css, Plan_Your_Appointment::APPOINTMENT_REASON_LABEL)).to eq("Reason for Appointment:")

      reason_50 = "12345678901234567890123456789012345678901234567890"
      @appmt.setReason(reason_50)
      expect(@appmt.getReason).to eq(reason_50)

      reason_60 = reason_50 + "!?%#^&*(S#"
      @appmt.setReason(reason_60)
      expect(@appmt.getReason).to eq(reason_50)
      @appmt.setReason("Annual checkup")

    end

    it "1.3.5.2.1.	Instructional Text", :broken => true do
      @appmt.clickAccordionByHeading("Items to Discuss")

      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(false)
      expect(getTextForElement(:css, Plan_Your_Appointment::ITEMS_DISCUSS_INSTRUCTION_TEXT)).to eq("Complete the items below to help you prepare for your upcoming medical appointment")
    end

    it "1.3.5.2.2.	What do I want to talk about at this appointment?: (alphanumeric, text box, 250 characters with character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::TALK_ABOUT_LABEL)).to eq("What do I want to talk about at this appointment?")

      expect(getTextForElement(:css, Plan_Your_Appointment::TALKABOUT_CHARACTER_COUNTER)).to eq("250 characters left")

      talkAbout_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"

      @appmt.setTalkAbout(talkAbout_250)
      expect(@appmt.getTalkAbout).to eq(talkAbout_250)
      expect(getTextForElement(:css, Plan_Your_Appointment::TALKABOUT_CHARACTER_COUNTER)).to eq("0 characters left")

      talkAbout_260 = talkAbout_250 + "ABCDEFGHIJ"
      @appmt.setTalkAbout(talkAbout_260)
      expect(@appmt.getTalkAbout).to eq(talkAbout_250)
      expect(getTextForElement(:css, Plan_Your_Appointment::TALKABOUT_CHARACTER_COUNTER)).to eq("0 characters left")
    end

    it "1.3.5.2.3.	I have new symptoms: (single select, radio buttons, Yes/No, default to no)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::SYMPTOMS_LABEL)).to eq("I have new symptoms:")

      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::SYMPTOMS_RADIO)).to eq(true)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::SYMPTOMS_RADIO)).to eq(false)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::SYMPTOMS_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::SYMPTOMS_RADIO)).to eq(true)

      @appmt.selectRadioButton("false", Plan_Your_Appointment::SYMPTOMS_RADIO)
      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::SYMPTOMS_RADIO)).to eq(true)
    end

    it "1.3.5.2.4.	If user checks yes, a text box will appear (alphanumeric, text box, 250 characters with character countdown)", :broken => true do
      @appmt.selectRadioButton("true", Plan_Your_Appointment::SYMPTOMS_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::SYMPTOMS_RADIO)).to eq(true)

      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::SYMPTOMS_TEXTAREA)).to eq(true)

      symptomsNote_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setSymptomsNote(symptomsNote_250)
      expect(@appmt.getSymptomsNote).to eq(symptomsNote_250)
      expect(symptomsNote_250.length).to eq(250)

      symptomsNote_260 = symptomsNote_250 + "ABCDEFGHIJ"

      @appmt.setSymptomsNote(symptomsNote_260)
      expect(@appmt.getSymptomsNote).to eq(symptomsNote_250)

    end

    it "1.3.5.2.5.	I have medication questions: (single select, radio buttons, Yes/No, default to no)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::MEDICATION_QUESTION_LABEL)).to eq("I have medication questions:")

      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)).to eq(true)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)).to eq(false)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)).to eq(true)

      @appmt.selectRadioButton("false", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)).to eq(true)

    end

    it "1.3.5.2.6.	If user checks yes, a text box will appear (alphanumeric, text box, 250 characters with character countdown)", :broken => true do
      @appmt.selectRadioButton("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)).to eq(true)

      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::MEDICATIONS_QUESTION_TEXTAREA)).to eq(true)

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setMedicationsQuestionNote(note_250)
      expect(@appmt.getMedicationsQuestionNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setMedicationsQuestionNote(note_260)
      expect(@appmt.getMedicationsQuestionNote).to eq(note_250)
    end

    it "1.3.5.2.7.	I have questions about my diagnosis: (single select, radio buttons, Yes/No, default to no)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::DIAGNOSIS_QUESTION_LABEL)).to eq("I have questions about my diagnosis:")

      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)).to eq(true)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)).to eq(false)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)).to eq(true)

      @appmt.selectRadioButton("false", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)).to eq(true)
    end

    it "1.3.5.2.8.	If user checks yes, a text box will appear (alphanumeric, text box, 250 characters with character countdown)", :broken => true do
      @appmt.selectRadioButton("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)).to eq(true)
      !5.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::DIAGNOSIS_QUESTION_TEXTAREA) == true); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::DIAGNOSIS_QUESTION_TEXTAREA)).to eq(true)

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setDiagnosisNote(note_250)
      expect(@appmt.getDiagnosisQuestionNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setDiagnosisNote(note_260)
      expect(@appmt.getDiagnosisQuestionNote).to eq(note_250)
    end

    it "1.3.5.2.9.	I have questions about my tests: (single select, radio buttons, Yes/No, default to no)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::TESTS_QUESTION_LABEL)).to eq("I have questions about my tests:")

      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::TESTS_QUESTION_RADIO)).to eq(true)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)).to eq(false)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)).to eq(true)

      @appmt.selectRadioButton("false", Plan_Your_Appointment::TESTS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::TESTS_QUESTION_RADIO)).to eq(true)
    end

    it "1.3.5.2.10 If user checks yes, a text box will appear (alphanumeric, text box, 250 characters with character countdown)", :broken => true do
      @appmt.selectRadioButton("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)).to eq(true)

      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::TESTS_QUESTION_TEXTAREA)).to eq(true)

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setTestsNote(note_250)
      expect(@appmt.getTestsQuestionNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setTestsNote(note_260)
      expect(@appmt.getTestsQuestionNote).to eq(note_250)
    end

    it "1.3.5.2.11.	I have questions about my treatment plans: (single select, radio buttons, Yes/No, default to no)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::TREATMENT_QUESTION_LABEL)).to eq("I have questions about my treatment plans:")

      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(true)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(false)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(true)

      @appmt.selectRadioButton("false", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(true)
    end

    it "1.3.5.2.12.	If user checks yes, a text box will appear (alphanumeric, text box, 250 characters with character countdown)", :broken => true  do
      @appmt.selectRadioButton("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(true)

      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(true)

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setTreatmentPlanNote(note_250)
      expect(@appmt.getTreatmentPlanNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setTreatmentPlanNote(note_260)
      expect(@appmt.getTreatmentPlanNote).to eq(note_250)
    end

    it "1.3.5.2.13.	I have other concerns or life issues to discuss, such as my work, caring for others, finances, dealing with stress, understanding what the providers said to me, or choices made about my care: ", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::OTHER_CONCERN_LABEL)).to eq("I have other concerns or life issues to discuss, such as my work, caring for others, finances, dealing with stress, understanding what the providers said to me, or choices made about my care:")
    end

    it "1.3.5.2.14.	Add item button, alt text same as label; If the user selects the button, a text box appears (alphanumeric, textbox, 250 characters, character countdown) labeled as “Item 1” ", :broken => true do
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::OTHER_CONCERN_TEXTAREA)).to eq(true)
      expect(getTextForElement(:css, Plan_Your_Appointment::ADD_ITEM_BUTTON)).to eq("Add Item")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setNthConcernNote(1, note_250)
      expect(@appmt.getNthConcernNote(1)).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setNthConcernNote(1, note_260)
      expect(@appmt.getNthConcernNote(1)).to eq(note_250)

      for i in 2..10
        click(:css, Plan_Your_Appointment::ADD_ITEM_BUTTON)
        expect(@appmt.isNthOtherConcernsTextAreaVisible(i)).to eq(true)

        expect(getFocusedElementName()).to eq("item" + i.to_s)
        expect(@appmt.isNthDeleteItemButtonVisible(i)).to eq(true)
        expect(@appmt.getNthDeleteItemButtonName(i)).to eq("Delete")
        expect(@appmt.getNthDeleteItemAltText(i)).to eq("Delete Item #" + i.to_s)

        note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
        @appmt.setNthConcernNote(i, note_250)
        expect(@appmt.getNthConcernNote(i)).to eq(note_250)
        expect(note_250.length).to eq(250)

        note_260 = note_250 + "ABCDEFGHIJ"

        @appmt.setNthConcernNote(i, note_260)
        expect(@appmt.getNthConcernNote(i)).to eq(note_250)

      end

      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::ADD_ITEM_BUTTON)).to eq(false)

    end

    it "1.3.5.2.14.6.	Deletes may occur in any order and are not confirmed (no modal is shown); items are renumbered sequentially as needed", :broken => true do
      for j in 1..9
        @appmt.clickNthDeleteItemButton(1)
      end

      expect(@appmt.isNthDeleteItemButtonVisible(1)).to eq(false)
    end

    it "1.3.5.2.14.9. If a user adds Item fields and saves the fields without adding data the empty fields are still present when the user next views the record in edit mode.", :broken => true do
      @appmt.setNthConcernNote(1, "")

      for i in 2..10
        click(:css, Plan_Your_Appointment::ADD_ITEM_BUTTON)
        expect(@appmt.isNthOtherConcernsTextAreaVisible(i)).to eq(true)
      end

      @appmt.clickSaveBtn()

      !5.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
      expect(@appmt.isSaveButtonDisabled).to eq(true)


      for i in 1..10
        expect(@appmt.isNthOtherConcernsTextAreaVisible(i)).to eq(true)
        expect(@appmt.getNthConcernNote(i)).to eq("")
      end

      click(:css, Plan_Your_Appointment::BACK_BUTTON)

      !5.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")
    end

    it "1.3.5.3.	After Appointment Notes (Accordion label", :broken => true do
      !5.times{ break if (@common.isAddButtonVisible == true); sleep 1 }
      expect(@common.isAddButtonVisible).to eq(true)

      @common.clickAddButton

      !5.times{ break if (getPrimaryHeader() == "Add Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Appointment Plan")

      @appmt.clickAccordionByHeading("After Appointment Notes")

      !5.times{ break if (getTextForElement(:css, Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_INSTRUCTIONAL_TEXT)== "Use this section to record information that you received during your appointment."); sleep 1 }

    end

    it "1.3.5.3.1.	Instructional text: Use this section to record information that you received during your appointment.", :broken => true do

      expect(getTextForElement(:css, Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_INSTRUCTIONAL_TEXT)).to eq("Use this section to record information that you received during your appointment.")
    end

    it "1.3.5.3.2.	General Notes (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::GENERAL_NOTES_LABEL)).to eq("General Notes:")
      expect(@appmt.getCharacterCountDownTextByLabel("General Notes:")).to eq("250 characters left")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setGeneralNote(note_250)
      expect(@appmt.getGeneralNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setGeneralNote(note_260)
      expect(@appmt.getGeneralNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("General Notes:")).to eq("0 characters left")

    end

    it "1.3.5.3.3.	Diagnosis (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::DIAGNOSIS_NOTES_LABEL)).to eq("Diagnosis:")
      expect(@appmt.getCharacterCountDownTextByLabel("Diagnosis:")).to eq("250 characters left")
      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setAfterAppointmentDiagnosisNote(note_250)
      expect(@appmt.getAfterAppointmentDiagnosisNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setAfterAppointmentDiagnosisNote(note_260)
      expect(@appmt.getAfterAppointmentDiagnosisNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("Diagnosis:")).to eq("0 characters left")
    end

    it "1.3.5.3.4.	Test (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::TEST_NOTES_LABEL)).to eq("Test:")
      expect(@appmt.getCharacterCountDownTextByLabel("Test:")).to eq("250 characters left")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setAfterAppointmentTestNote(note_250)
      expect(@appmt.getTestNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setAfterAppointmentTestNote(note_260)
      expect(@appmt.getTestNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("Test:")).to eq("0 characters left")
    end

    it "1.3.5.3.5.	Directions given (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::DIRECTIONS_NOTES_LABEL)).to eq("Directions Given:")
      expect(@appmt.getCharacterCountDownTextByLabel("Directions Given:")).to eq("250 characters left")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setDirectionsGiveNote(note_250)
      expect(@appmt.getDirectionsNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setDirectionsGiveNote(note_260)
      expect(@appmt.getDirectionsNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("Directions Given:")).to eq("0 characters left")
    end

    it "1.3.5.3.6.	Actions I need to take (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::ACTIONS_NOTES_LABEL)).to eq("Actions I Need to Take:")
      expect(@appmt.getCharacterCountDownTextByLabel("Actions I Need to Take:")).to eq("250 characters left")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setActionsNote(note_250)
      expect(@appmt.getActionsNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setActionsNote(note_260)
      expect(@appmt.getActionsNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("Actions I Need to Take:")).to eq("0 characters left")
    end

    it "1.3.5.3.7.	Next Follow-up (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::NEXT_FOLLOWUP_NOTES_LABEL)).to eq("Next Follow-Up:")
      expect(@appmt.getCharacterCountDownTextByLabel("Next Follow-Up:")).to eq("250 characters left")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setFollwUpNote(note_250)
      expect(@appmt.getFolloupNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setFollwUpNote(note_260)
      expect(@appmt.getFolloupNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("Next Follow-Up:")).to eq("0 characters left")

      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.selectAppointmentStatus("Desired")
      @appmt.setClinic("Reston Clinic")

      @appmt.clickSaveBtn

      !5.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
      expect(@appmt.isSaveButtonDisabled).to eq(true)

    end

    it "#AC JRNL-1606|3284: Appointment Plan Summary PDF", :broken => true do
      click(:css, Plan_Your_Appointment::VIEW_PDF_BUTTON)
      switchWindowToWindowHandleLast()

      !5.times{ break if (getPageTitle() == "pdf"); sleep 1 }
      expect(getPageTitle).to eq("pdf")
      expect(@appmt.verifyEmbeddedPDF()).to eq(true)

      closeBrowser()
      switchWindowToWindowHandleFirst()
    end

  end

  context "#AC JRNL-1509|TC JRNL-1454: Items to discuss labels" do
    it "Modify Labels in Items to Discuss Accordion", :broken => true do
      @appmt.clickAccordionByHeading("Items to Discuss")
      expect(getTextForElement(:css, Plan_Your_Appointment::SYMPTOMS_LABEL)).to eq("I have new symptoms:")
      expect(getTextForElement(:css, Plan_Your_Appointment::MEDICATION_QUESTION_LABEL)).to eq("I have medication questions:")
      expect(getTextForElement(:css, Plan_Your_Appointment::DIAGNOSIS_QUESTION_LABEL)).to eq("I have questions about my diagnosis:")
      expect(getTextForElement(:css, Plan_Your_Appointment::TESTS_QUESTION_LABEL)).to eq("I have questions about my tests:")
      expect(getTextForElement(:css, Plan_Your_Appointment::TREATMENT_QUESTION_LABEL)).to eq("I have questions about my treatment plans:")
      expect(getTextForElement(:css, Plan_Your_Appointment::OTHER_CONCERN_LABEL)).to eq("I have other concerns or life issues to discuss, such as my work, caring for others, finances, dealing with stress, understanding what the providers said to me, or choices made about my care:")
    end
  end
end





















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
#!/bin/env ruby
# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2457: Plan Your Appointment - Add]
          [Story #JRNL-1568: Items to discuss labels]
          [Story #JRNL-1789: Plan Your Appointment - No records found custom message]
          [Story #JRNL-1786: Appointment Plan Summary PDF]", :regression => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("plan", "previsitagendadb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @tomorrow = getDateNthDaysFromNow(1,  "%m/%d/%Y")
    @today = getDateNthDaysAgo(0, "%m/%d/%Y")
    @expectedValidationSummaryHeader = "The following errors were found:"

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    expect(@mymedical.isPlanYourAppointmentVisible).to eq(true)
    @mymedical.clickPlanYourAppointment
    !45.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Plan Your Appointment")

  end

  after(:all) do
    quitDriver()
  end

  context "#AC JRNL-1719|TC JRNL-1575: No record found custom message for Plan Your Appointment" do
    it "No Results Found mesage" do
      !45.times{ break if (@appmt_list.getNoResultsFoundMessage != ""); sleep 1 }
      expect(@appmt_list.getNoResultsFoundMessage).to eq("No results were found with the current filters. Use the Add button above to create a new record.\nIt is a good idea to prepare for your healthcare visit ahead of time. To do that, think about what you want to talk about, questions you have, and any other issues you want to bring up. It’s also helpful to review your medication and allergies with your provider.\nAt your visit, don’t be afraid to ask questions or let the provider know if you don’t fully understand something they said. It’s OK to ask them to repeat what they said or to write it down for you. Use this app to write notes on what you were told and look at it later as a reminder.")
    end
  end

  context "#AC JRNL-1723|TC JRNL-1576: Add New Entry for Plan your Appointment" do
    it "1.  Add New Entry" do
      expect(@common.isAddButtonVisible).to eq(true)
      expect(@common.getAddButtonAltText).to eq("Add")

      @common.clickAddButton

      !45.times{ break if (getPrimaryHeader() == "Add Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Appointment Plan")

      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq(true)

    end

    it "1.3.1 Three sections are shown with the following default display" do
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::APPOINTMENT_INFORMATION_HEADING)).to eq(false)
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(true)
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_HEADING)).to eq(true)
    end

    it "1.3.2 Collapse sections are indicated by a right arrow icon in the header, shown to the left of the accordion label. Alt text reads, Expand <section name>" do
      expect(@appmt.isRightArrowIconDisplayed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(true)
      expect(@appmt.isRightArrowIconDisplayed(Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_HEADING)).to eq(true)

      expect(@appmt.getAccordionAltText(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq("Expand\nItems to Discuss")
      expect(@appmt.getAccordionAltText(Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_HEADING)).to eq("Expand\nAfter Appointment Notes")

    end

    it "1.3.4 Accordion section can be opened and closed", :broken => true do
      @appmt.clickAccordionByHeading(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::TALK_ABOUT_TEXTAREA)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::TALK_ABOUT_TEXTAREA)).to eq(true)


      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(false)
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::APPOINTMENT_INFORMATION_HEADING)).to eq(true)
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_HEADING)).to eq(true)

      expect(@appmt.isDownArrowIconDisplayed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(true)

      @appmt.clickAccordionByHeading(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)
      !45.times{ break if (@appmt.isAccordionCollapsed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)); sleep 1 }
      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(true)

    end

    it "1.3.5 Appointment Information (accordion label)", :broken => true do
      @appmt.clickAccordionByHeading("Appointment Information")
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq(true)

      ENTRY_FORM = [\
                     "Collapse",
                      "Appointment Information",
                      "* required field",
                      "* Appointment Status:",
                      "Select",
                      "Desired",
                      "Scheduled",
                      "Canceled",
                      "Completed",
                      "Date:",
                      "MM/DD/YYYY",
                      "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
                      "Time:",
                      "hh:mm AM/PM",
                      "This time selection control is not optimized for screen readers. Please directly enter the time in the text box provided. Open Time Picker",
                      "Calendar (icon)",
                      "Booked VA Appointments",
                      "Provider",
                      "First Name:",
                      "30 character maximum",
                      "Last Name:",
                      "20 character maximum",
                      "* Clinic/Organization:",
                      "50 character maximum",
                      "Reason for Appointment:",
                      "50 character maximum",
                      "Expand",
                      "Items to Discuss",
                      "Expand",
                      "Set Notifications",
                      "Expand",
                      "After Appointment Notes"]

      form = @appmt.getScreenContent().split("\n")

      ENTRY_FORM.each_with_index do | expectedScreenRow, i |
        expect(form[i]).to eq(expectedScreenRow)
      end
      expect(form.length).to eq(ENTRY_FORM.length)

    end

    it "1.3.5.1 Appointment Information (Accordion label)", :broken => true do
      expect(areAllTheseValuesAvailableInDropDown(Plan_Your_Appointment::APPOINTMENT_STATUS_SELECT, "Select;Desired;Scheduled;Canceled;Completed")).to eq(true)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_STATUS_SELECT)).to eq(true)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_DATE_INPUT)).to eq(false)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_TIME_INPUT)).to eq(false)

      @appmt.selectAppointmentStatus("Completed")
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_DATE_INPUT)).to eq(true)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_TIME_INPUT)).to eq(true)

      @appmt.clickSaveBtn

      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Clinic/Organization field is required.")).to eq(true)

      @appmt.selectAppointmentStatus("Scheduled")
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_DATE_INPUT)).to eq(true)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_TIME_INPUT)).to eq(true)
      @appmt.clickSaveBtn

      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Clinic/Organization field is required.")).to eq(true)

      @appmt.selectAppointmentStatus("Desired")
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_DATE_INPUT)).to eq(false)
      expect(isFieldRequired(:css, Plan_Your_Appointment::APPOINTMENT_TIME_INPUT)).to eq(false)
      @appmt.clickSaveBtn

      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "Clinic/Organization field is required.")).to eq(true)

      expect(getPlaceHolderByCSS(:css, Plan_Your_Appointment::APPOINTMENT_DATE_INPUT)).to eq("MM/DD/YYYY")
      expect(getPlaceHolderByCSS(:css, Plan_Your_Appointment::APPOINTMENT_TIME_INPUT)).to eq("HH:MM AM/PM")

      @appmt.setAppointmentTime("08:30 AM")

      @appmt.clickSaveBtn

      !45.times{ break if (@error.getValidationSummaryHeader("form") == @expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq(@expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("form", "Date field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Time field is required.")).to eq(false)
      expect(@error.isErrorMessageDisplayed("form", "Clinic/Organization field is required.")).to eq(true)

      @appmt.setAppointmentTime("")

    end

    it "1.3.5.1.4 Booked VA Appointments ", :broken => true do
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq(true)
      expect(getTextForElement(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)).to eq("Calendar (icon)\nBooked VA Appointments")

      click(:css, Plan_Your_Appointment::BOOKED_VA_APPOINTMENT_BUTTON)
      !45.times{ break if (@modal.getConfirmationHeading() == "Future VA Appointments"); sleep 1 }

      expect(@modal.getConfirmationHeading()).to eq("Future VA Appointments")

      expect(@appmt.getFutureVAAppointmentsTableHeader(1)).to eq("Facility Name")
      expect(@appmt.getFutureVAAppointmentsTableHeader(2)).to eq("Clinic Name")
      expect(@appmt.getFutureVAAppointmentsTableHeader(3)).to eq("Date/Time")

      expect(@appmt.isSortedChronologicalOrder).to eq(true)

      @modal.clickOKFromInfoModal()

      !45.times{ break if ( @modal.isConfirmationPopUpNotPresent); sleep 1 }


    end

    it "1.3.5.1.5 Provider " do
      expect(getTextForElement(:css, Plan_Your_Appointment::PROVIDER_LABEL)).to eq("Provider")
    end

    it "1.3.5.1.6 First Name 	First Name (alphanumeric, text box, 30 characters)" do
      expect(getTextForElement(:css, Plan_Your_Appointment::PROVIDER_FIRST_NAME_LABEL )).to eq("First Name:")

      firstName_30 = "123456789012345678901234567890"
      @appmt.setFirstName(firstName_30)
      expect(@appmt.getFirstName()).to eq(firstName_30)

      firstName_40 = "123456789012345678901234567890ABCDEFGHIJ"
      @appmt.setFirstName(firstName_40)
      expect(@appmt.getFirstName).to eq(firstName_30)

      @appmt.setFirstName("John")

    end

    it "1.3.5.1.7	Last Name (alphanumeric, text box, 20 characters)" do
      expect(getTextForElement(:css, Plan_Your_Appointment::PROVIDER_LAST_NAME_LABEL)).to eq("Last Name:")

      lastName_20 = "12345678901234567890"
      @appmt.setLastName(lastName_20)
      expect(@appmt.getLastName).to eq(lastName_20)

      lastName_30 = "12345678901234567890ABCDEFGHIJ"
      @appmt.setLastName(lastName_30)
      expect(@appmt.getLastName).to eq(lastName_20)

      @appmt.setLastName("Do")

    end

    it "1.3.5.1.8	Clinic/Organization (required, alphanumeric, textbox, 50 characters) " do
      expect(getTextForElement(:css, Plan_Your_Appointment::CLINIC_NAME_LABEL)).to eq("Clinic/Organization:")

      clinic_50 = "12345678901234567890123456789012345678901234567890"
      @appmt.setClinic(clinic_50)
      expect(@appmt.getClinic).to eq(clinic_50)

      clinic_60 = clinic_50 + "ABCDEFGHIJ"
      @appmt.setClinic(clinic_60)
      expect(@appmt.getClinic).to eq(clinic_50)

      @appmt.setClinic("South Riding Clinic")

    end

    it "1.3.5.1.9.	Reason for Appointment (alphanumeric, textbox, 50 characters)" do
      expect(getTextForElement(:css, Plan_Your_Appointment::APPOINTMENT_REASON_LABEL)).to eq("Reason for Appointment:")

      reason_50 = "12345678901234567890123456789012345678901234567890"
      @appmt.setReason(reason_50)
      expect(@appmt.getReason).to eq(reason_50)

      reason_60 = reason_50 + "!?%#^&*(S#"
      @appmt.setReason(reason_60)
      expect(@appmt.getReason).to eq(reason_50)
      @appmt.setReason("Annual checkup")

    end

    it "1.3.5.2.1.	Instructional Text", :broken => true do
      @appmt.clickAccordionByHeading("Items to Discuss")

      expect(@appmt.isAccordionCollapsed(Plan_Your_Appointment::ITEMS_TO_DISCUSS_HEADING)).to eq(false)
      expect(getTextForElement(:css, Plan_Your_Appointment::ITEMS_DISCUSS_INSTRUCTION_TEXT)).to eq("Complete the items below to help you prepare for your upcoming medical appointment")
    end

    it "1.3.5.2.2.	What do I want to talk about at this appointment?: (alphanumeric, text box, 250 characters with character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::TALK_ABOUT_LABEL)).to eq("What do I want to talk about at this appointment?")

      expect(getTextForElement(:css, Plan_Your_Appointment::TALKABOUT_CHARACTER_COUNTER)).to eq("250 characters left")

      talkAbout_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"

      @appmt.setTalkAbout(talkAbout_250)
      expect(@appmt.getTalkAbout).to eq(talkAbout_250)
      expect(getTextForElement(:css, Plan_Your_Appointment::TALKABOUT_CHARACTER_COUNTER)).to eq("0 characters left")

      talkAbout_260 = talkAbout_250 + "ABCDEFGHIJ"
      @appmt.setTalkAbout(talkAbout_260)
      expect(@appmt.getTalkAbout).to eq(talkAbout_250)
      expect(getTextForElement(:css, Plan_Your_Appointment::TALKABOUT_CHARACTER_COUNTER)).to eq("0 characters left")
    end

    it "1.3.5.2.3.	I have new symptoms: (single select, radio buttons, Yes/No, default to no)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::SYMPTOMS_LABEL)).to eq("I have new symptoms:")

      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::SYMPTOMS_RADIO)).to eq(true)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::SYMPTOMS_RADIO)).to eq(false)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::SYMPTOMS_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::SYMPTOMS_RADIO)).to eq(true)

      @appmt.selectRadioButton("false", Plan_Your_Appointment::SYMPTOMS_RADIO)
      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::SYMPTOMS_RADIO)).to eq(true)
    end

    it "1.3.5.2.4.	If user checks yes, a text box will appear (alphanumeric, text box, 250 characters with character countdown)", :broken => true do
      @appmt.selectRadioButton("true", Plan_Your_Appointment::SYMPTOMS_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::SYMPTOMS_RADIO)).to eq(true)

      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::SYMPTOMS_TEXTAREA)).to eq(true)

      symptomsNote_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setSymptomsNote(symptomsNote_250)
      expect(@appmt.getSymptomsNote).to eq(symptomsNote_250)
      expect(symptomsNote_250.length).to eq(250)

      symptomsNote_260 = symptomsNote_250 + "ABCDEFGHIJ"

      @appmt.setSymptomsNote(symptomsNote_260)
      expect(@appmt.getSymptomsNote).to eq(symptomsNote_250)

    end

    it "1.3.5.2.5.	I have medication questions: (single select, radio buttons, Yes/No, default to no)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::MEDICATION_QUESTION_LABEL)).to eq("I have medication questions:")

      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)).to eq(true)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)).to eq(false)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)).to eq(true)

      @appmt.selectRadioButton("false", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)).to eq(true)

    end

    it "1.3.5.2.6.	If user checks yes, a text box will appear (alphanumeric, text box, 250 characters with character countdown)", :broken => true do
      @appmt.selectRadioButton("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::MEDICATIONS_QUESTION_RADIO)).to eq(true)

      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::MEDICATIONS_QUESTION_TEXTAREA)).to eq(true)

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setMedicationsQuestionNote(note_250)
      expect(@appmt.getMedicationsQuestionNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setMedicationsQuestionNote(note_260)
      expect(@appmt.getMedicationsQuestionNote).to eq(note_250)
    end

    it "1.3.5.2.7.	I have questions about my diagnosis: (single select, radio buttons, Yes/No, default to no)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::DIAGNOSIS_QUESTION_LABEL)).to eq("I have questions about my diagnosis:")

      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)).to eq(true)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)).to eq(false)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)).to eq(true)

      @appmt.selectRadioButton("false", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)).to eq(true)
    end

    it "1.3.5.2.8.	If user checks yes, a text box will appear (alphanumeric, text box, 250 characters with character countdown)", :broken => true do
      @appmt.selectRadioButton("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::DIAGNOSIS_QUESTION_RADIO)).to eq(true)
      !45.times{ break if (isElementPresentAndVisible(:css, Plan_Your_Appointment::DIAGNOSIS_QUESTION_TEXTAREA) == true); sleep 1 }
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::DIAGNOSIS_QUESTION_TEXTAREA)).to eq(true)

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setDiagnosisNote(note_250)
      expect(@appmt.getDiagnosisQuestionNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setDiagnosisNote(note_260)
      expect(@appmt.getDiagnosisQuestionNote).to eq(note_250)
    end

    it "1.3.5.2.9.	I have questions about my tests: (single select, radio buttons, Yes/No, default to no)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::TESTS_QUESTION_LABEL)).to eq("I have questions about my tests:")

      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::TESTS_QUESTION_RADIO)).to eq(true)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)).to eq(false)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)).to eq(true)

      @appmt.selectRadioButton("false", Plan_Your_Appointment::TESTS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::TESTS_QUESTION_RADIO)).to eq(true)
    end

    it "1.3.5.2.10 If user checks yes, a text box will appear (alphanumeric, text box, 250 characters with character countdown)", :broken => true do
      @appmt.selectRadioButton("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TESTS_QUESTION_RADIO)).to eq(true)

      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::TESTS_QUESTION_TEXTAREA)).to eq(true)

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setTestsNote(note_250)
      expect(@appmt.getTestsQuestionNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setTestsNote(note_260)
      expect(@appmt.getTestsQuestionNote).to eq(note_250)
    end

    it "1.3.5.2.11.	I have questions about my treatment plans: (single select, radio buttons, Yes/No, default to no)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::TREATMENT_QUESTION_LABEL)).to eq("I have questions about my treatment plans:")

      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(true)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(false)

      @appmt.selectRadioButton("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(true)

      @appmt.selectRadioButton("false", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("false", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(true)
    end

    it "1.3.5.2.12.	If user checks yes, a text box will appear (alphanumeric, text box, 250 characters with character countdown)", :broken => true  do
      @appmt.selectRadioButton("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)
      expect(@appmt.isRadioButtonSelected("true", Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(true)

      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::TREATMENT_QUESTION_RADIO)).to eq(true)

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setTreatmentPlanNote(note_250)
      expect(@appmt.getTreatmentPlanNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setTreatmentPlanNote(note_260)
      expect(@appmt.getTreatmentPlanNote).to eq(note_250)
    end

    it "1.3.5.2.13.	I have other concerns or life issues to discuss, such as my work, caring for others, finances, dealing with stress, understanding what the providers said to me, or choices made about my care: ", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::OTHER_CONCERN_LABEL)).to eq("I have other concerns or life issues to discuss, such as my work, caring for others, finances, dealing with stress, understanding what the providers said to me, or choices made about my care:")
    end

    it "1.3.5.2.14.	Add item button, alt text same as label; If the user selects the button, a text box appears (alphanumeric, textbox, 250 characters, character countdown) labeled as “Item 1” ", :broken => true do
      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::OTHER_CONCERN_TEXTAREA)).to eq(true)
      expect(getTextForElement(:css, Plan_Your_Appointment::ADD_ITEM_BUTTON)).to eq("Add Item")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setNthConcernNote(1, note_250)
      expect(@appmt.getNthConcernNote(1)).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setNthConcernNote(1, note_260)
      expect(@appmt.getNthConcernNote(1)).to eq(note_250)

      for i in 2..10
        click(:css, Plan_Your_Appointment::ADD_ITEM_BUTTON)
        expect(@appmt.isNthOtherConcernsTextAreaVisible(i)).to eq(true)

        expect(getFocusedElementName()).to eq("item" + i.to_s)
        expect(@appmt.isNthDeleteItemButtonVisible(i)).to eq(true)
        expect(@appmt.getNthDeleteItemButtonName(i)).to eq("Delete")
        expect(@appmt.getNthDeleteItemAltText(i)).to eq("Delete Item #" + i.to_s)

        note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
        @appmt.setNthConcernNote(i, note_250)
        expect(@appmt.getNthConcernNote(i)).to eq(note_250)
        expect(note_250.length).to eq(250)

        note_260 = note_250 + "ABCDEFGHIJ"

        @appmt.setNthConcernNote(i, note_260)
        expect(@appmt.getNthConcernNote(i)).to eq(note_250)

      end

      expect(isElementPresentAndVisible(:css, Plan_Your_Appointment::ADD_ITEM_BUTTON)).to eq(false)

    end

    it "1.3.5.2.14.6.	Deletes may occur in any order and are not confirmed (no modal is shown); items are renumbered sequentially as needed", :broken => true do
      for j in 1..9
        @appmt.clickNthDeleteItemButton(1)
      end

      expect(@appmt.isNthDeleteItemButtonVisible(1)).to eq(false)
    end

    it "1.3.5.2.14.9. If a user adds Item fields and saves the fields without adding data the empty fields are still present when the user next views the record in edit mode.", :broken => true do
      @appmt.setNthConcernNote(1, "")

      for i in 2..10
        click(:css, Plan_Your_Appointment::ADD_ITEM_BUTTON)
        expect(@appmt.isNthOtherConcernsTextAreaVisible(i)).to eq(true)
      end

      @appmt.clickSaveBtn()

      !45.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
      expect(@appmt.isSaveButtonDisabled).to eq(true)


      for i in 1..10
        expect(@appmt.isNthOtherConcernsTextAreaVisible(i)).to eq(true)
        expect(@appmt.getNthConcernNote(i)).to eq("")
      end

      click(:css, Plan_Your_Appointment::BACK_BUTTON)

      !45.times{ break if (getPrimaryHeader() == "Plan Your Appointment"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Plan Your Appointment")
    end

    it "1.3.5.3.	After Appointment Notes (Accordion label", :broken => true do
      !45.times{ break if (@common.isAddButtonVisible == true); sleep 1 }
      expect(@common.isAddButtonVisible).to eq(true)

      @common.clickAddButton

      !45.times{ break if (getPrimaryHeader() == "Add Appointment Plan"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Appointment Plan")

      @appmt.clickAccordionByHeading("After Appointment Notes")

      !45.times{ break if (getTextForElement(:css, Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_INSTRUCTIONAL_TEXT)== "Use this section to record information that you received during your appointment."); sleep 1 }

    end

    it "1.3.5.3.1.	Instructional text: Use this section to record information that you received during your appointment.", :broken => true do

      expect(getTextForElement(:css, Plan_Your_Appointment::AFTER_APPOINTMENT_NOTES_INSTRUCTIONAL_TEXT)).to eq("Use this section to record information that you received during your appointment.")
    end

    it "1.3.5.3.2.	General Notes (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::GENERAL_NOTES_LABEL)).to eq("General Notes:")
      expect(@appmt.getCharacterCountDownTextByLabel("General Notes:")).to eq("250 characters left")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setGeneralNote(note_250)
      expect(@appmt.getGeneralNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setGeneralNote(note_260)
      expect(@appmt.getGeneralNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("General Notes:")).to eq("0 characters left")

    end

    it "1.3.5.3.3.	Diagnosis (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::DIAGNOSIS_NOTES_LABEL)).to eq("Diagnosis:")
      expect(@appmt.getCharacterCountDownTextByLabel("Diagnosis:")).to eq("250 characters left")
      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setAfterAppointmentDiagnosisNote(note_250)
      expect(@appmt.getAfterAppointmentDiagnosisNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setAfterAppointmentDiagnosisNote(note_260)
      expect(@appmt.getAfterAppointmentDiagnosisNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("Diagnosis:")).to eq("0 characters left")
    end

    it "1.3.5.3.4.	Test (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::TEST_NOTES_LABEL)).to eq("Test:")
      expect(@appmt.getCharacterCountDownTextByLabel("Test:")).to eq("250 characters left")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setAfterAppointmentTestNote(note_250)
      expect(@appmt.getTestNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setAfterAppointmentTestNote(note_260)
      expect(@appmt.getTestNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("Test:")).to eq("0 characters left")
    end

    it "1.3.5.3.5.	Directions given (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::DIRECTIONS_NOTES_LABEL)).to eq("Directions Given:")
      expect(@appmt.getCharacterCountDownTextByLabel("Directions Given:")).to eq("250 characters left")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setDirectionsGiveNote(note_250)
      expect(@appmt.getDirectionsNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setDirectionsGiveNote(note_260)
      expect(@appmt.getDirectionsNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("Directions Given:")).to eq("0 characters left")
    end

    it "1.3.5.3.6.	Actions I need to take (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::ACTIONS_NOTES_LABEL)).to eq("Actions I Need to Take:")
      expect(@appmt.getCharacterCountDownTextByLabel("Actions I Need to Take:")).to eq("250 characters left")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setActionsNote(note_250)
      expect(@appmt.getActionsNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setActionsNote(note_260)
      expect(@appmt.getActionsNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("Actions I Need to Take:")).to eq("0 characters left")
    end

    it "1.3.5.3.7.	Next Follow-up (Alphanumeric, text box, 250 characters, character countdown)", :broken => true do
      expect(getTextForElement(:css, Plan_Your_Appointment::NEXT_FOLLOWUP_NOTES_LABEL)).to eq("Next Follow-Up:")
      expect(@appmt.getCharacterCountDownTextByLabel("Next Follow-Up:")).to eq("250 characters left")

      note_250 = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"
      @appmt.setFollwUpNote(note_250)
      expect(@appmt.getFolloupNote).to eq(note_250)
      expect(note_250.length).to eq(250)

      note_260 = note_250 + "ABCDEFGHIJ"

      @appmt.setFollwUpNote(note_260)
      expect(@appmt.getFolloupNote).to eq(note_250)

      expect(@appmt.getCharacterCountDownTextByLabel("Next Follow-Up:")).to eq("0 characters left")

      @appmt.clickAccordionByHeading("Appointment Information")
      @appmt.selectAppointmentStatus("Desired")
      @appmt.setClinic("Reston Clinic")

      @appmt.clickSaveBtn

      !45.times{ break if (@appmt.isSaveButtonDisabled == true); sleep 1 }
      expect(@appmt.isSaveButtonDisabled).to eq(true)

    end

    it "#AC JRNL-1606|3284: Appointment Plan Summary PDF", :broken => true do
      click(:css, Plan_Your_Appointment::VIEW_PDF_BUTTON)
      switchWindowToWindowHandleLast()

      !45.times{ break if (getPageTitle() == "pdf"); sleep 1 }
      expect(getPageTitle).to eq("pdf")
      expect(@appmt.verifyEmbeddedPDF()).to eq(true)

      closeBrowser()
      switchWindowToWindowHandleFirst()
    end

  end

  context "#AC JRNL-1509|TC JRNL-1454: Items to discuss labels" do
    it "Modify Labels in Items to Discuss Accordion", :broken => true do
      @appmt.clickAccordionByHeading("Items to Discuss")
      expect(getTextForElement(:css, Plan_Your_Appointment::SYMPTOMS_LABEL)).to eq("I have new symptoms:")
      expect(getTextForElement(:css, Plan_Your_Appointment::MEDICATION_QUESTION_LABEL)).to eq("I have medication questions:")
      expect(getTextForElement(:css, Plan_Your_Appointment::DIAGNOSIS_QUESTION_LABEL)).to eq("I have questions about my diagnosis:")
      expect(getTextForElement(:css, Plan_Your_Appointment::TESTS_QUESTION_LABEL)).to eq("I have questions about my tests:")
      expect(getTextForElement(:css, Plan_Your_Appointment::TREATMENT_QUESTION_LABEL)).to eq("I have questions about my treatment plans:")
      expect(getTextForElement(:css, Plan_Your_Appointment::OTHER_CONCERN_LABEL)).to eq("I have other concerns or life issues to discuss, such as my work, caring for others, finances, dealing with stress, understanding what the providers said to me, or choices made about my care:")
    end
  end
end
=end