require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1297: Medications: List view and Filter]
          [Story #JRNL-1211: Medication PDF]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("medications", "medicalhistorydb", "medications")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times { break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !5.times { break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC #JRNL-1283|TC #JRNL-1254: Sub Feature Selection for Medications (List View)" do

    it "Visible" do
      expect(@nav_menu.isNavVisible("Medications")).to eq(true)
    end

    it "Label" do
      expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["Medications"]["navButton"])).to eq("Medications")
    end

    it "Location" do
      menuLocation = -1
      menu = getElements(:css, "div.secondary-content li")

      menu.each_with_index do |menuItem, i|
        if menuItem.text() == "Medications"
          menuLocation = i + 1
          break
        end
      end

      expect(@nav_menu.getNthSubFeatureName(menuLocation)).to eq("Medications")
      expect(@nav_menu.getNthSubFeatureName(menuLocation + 1)).to eq("Allergies")
    end

  end

  describe "AC #JRNL-1282|TC #JRNL-1254: Sub Feature Default View for Medications" do

    it "Header" do
      @mymedical.clickMedications()
      !5.times { break if (getPrimaryHeader() == "Medications"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Medications")
    end

    it "Filter Control", :broken => true do
      #Filter is expanded by default
      expect(getElementAttribute("li.filter-toggle button", "title")).to eq("Collapse filter options")

      #Collapse Filter
      @common.showOrHideFilter()
      sleep 1

      #Verify Filter options are hidden
      expect(getElementAttribute("li.filter-toggle button", "title")).to eq("Expand filter options")

      #Expand Filter options one more time
      @common.showOrHideFilter()
      sleep 1
      expect(getElementAttribute("li.filter-toggle button", "title")).to eq("Collapse filter options")
    end

  end

  describe "AC #JRNL-1281|TC #JRNL-1254: Filter Action and Results Display for Medications" do

    it "Records sorted in alphabetical order", :broken => true do
      !5.times { break if (getTextForRowColumn(1, 1) != nil); sleep 1 }
      medList = getAllMedicationsInDBSorted()
      verifyMedicationsList(getList(), getAllMedicationsInDBSorted())
      expect(getCount()).to eq(5)
    end

    it "Table Headers", :broken => true do
      expect(getTableHeaders()).to eq(["Medication", "Currently Taking", "Source"])

      expect(getTextForRowColumn(1, 1)).to include("Advil")
      expect(getTextForRowColumn(1, 2)).to include("Yes")
      expect(getTextForRowColumn(1, 3)).to include("Self")

      expect(getTextForRowColumn(4, 1)).to include("Crestor")
      expect(getTextForRowColumn(4, 2)).to include("No")
      expect(getTextForRowColumn(4, 3)).to include("Self")
    end

    it "Phone view display", :broken => true do
      resizeWindowToPhone()
      expect(getTableHeaders).to eq(["Medication", "Currently Taking", "Source"])

      expect(getTextForRowColumn(1, 1)).to eq("Advil 200 mg")
      expect(getTextForRowColumn(1, 2)).to eq("Yes")
      expect(getTextForRowColumn(1, 3)).to eq("Self")

      expect(getTextForRowColumn(4, 1)).to eq("Crestor 10 mg")
      expect(getTextForRowColumn(4, 2)).to eq("No")
      expect(getTextForRowColumn(4, 3)).to eq("Self")

      resizeWindowToDefault()
    end

    it "No Records were found" do
      removeCollection("medications", "medicalhistorydb")
      refreshBrowser()
      noRecordsMessage = "No results were found with the current filters. Use the Add button above to create a new record."
      !5.times { break if (getNoResultsFoundMessage() == noRecordsMessage); sleep 1 }
      expect(getNoResultsFoundMessage()).to match(noRecordsMessage)
    end

  end

  describe "AC #JRNL-1279|TC #JRNL-1254: Reset Filter Functionality" do

    it "Reset" do
      expect(@common.isTheResetButtonVisible()).to eq(true)
    end

  end

  describe "AC #JRNL-1179|TC #JRNL-1254: PDF Button" do

    it "PDF Button" do
      expect(isElementVisible(:css, "button[title='PDF']")).to eq(true)
    end

  end

  describe "AC #JRNL-1280|TC #JRNL-1254: Navigation for Medications" do

    it "Navigation", :broken => true do
      expect(@common.isBackButtonVisible()).to eq(false)
      resizeWindowToPhone()
      expect(@common.isBackButtonVisible()).to eq(true)
      expect(@common.getBackButtonAltText()).to eq("Return to My Medical options")

      @common.clickBackButton()
      !5.times { break if (getSecondaryHeader() == "My Medical"); sleep 1 }
      expect(getSecondaryHeader()).to eq("My Medical")
    end

  end

  #######################
  ### Local Functions ###
  #######################

  def getAllMedicationsInDBSorted
    def sortKeys(x, y)
      if x["usage"]["currentlyTaking"] === y["usage"]["currentlyTaking"]
        return x["medicationInfo"]["name"].upcase() < y["medicationInfo"]["name"].upcase() ? -1 : 1

      else
        return x["usage"]["currentlyTaking"] == true ? -1 : 1

      end
    end

    return retreiveAllDocumentsInCollection("medications", "medicalhistorydb").sort { |x, y| sortKeys(x, y) }
  end

  def verifyMedicationsList(screenList, dbList)
    dbList.each_with_index do |dbrow, i|
      screenRow = screenList[i].text.split("\n")
      expect(screenRow[1].strip.upcase).to include(dbrow['medicationInfo']['name'].upcase)
      currentlyTaking = dbrow['usage']['currentlyTaking'] ? "Yes" : "No"
      expect(screenRow[4].strip).to eq(currentlyTaking)
    end
  end

end
