require_relative '../../../globalized'
include Globalized

describe '[Story #JRNL-1296: My Medical - Medications - Add/Edit/Del/Nav]', :regression => true do

  before(:all) do
    @ENTRY_FORM = [
        '* required field',
        'Source: Self',
        '* Medication Name:',
        'Auto-complete input',
        'Strength:',
        'character maximum',
        'Directions:',
        'Dose:',
        '50 character maximum',
        '* Frequency:',
        'Select',
        'Once a Day',
        '2 times a Day',
        '3 times a Day',
        '4 times a Day',
        'Every 4 Hours',
        'Every 6 Hours',
        'Every 8 Hours',
        'Once a Week',
        'At Bedtime (Once a Day)',
        'Before Meals',
        'As Needed (PRN)',
        'Other',
        'Reason for Taking:',
        '50 character maximum',
        'Currently Taking:',
        'Yes',
        'No',
        'Why are you not taking this medication?:',
        'Select',
        'It made me feel bad',
        'It did not work',
        'I ran out',
        'I do not need it',
        'I stopped on my own',
        'Provider told me to stop',
        'Completed medication',
        'Medication Started: M M / D D / Y Y Y Y:',
        'Medication Started:',
        'This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.',
        'Medication Ended: M M / D D / Y Y Y Y:',
        'Medication Ended:',
        'This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.',
        'Prescription Information (if applicable):',
        'Prescription (Rx) Number:',
        '25 character maximum',
        'Prescribing Provider:',
        '50 character maximum',
        'Pharmacy Name:',
        '50 character maximum',
        'Pharmacy Phone:',
        'Enter 10 digits',
        'Unwanted Side Effects?:',
        'Yes',
        'No',
        'Notes:',
        '250 character maximum',
        '250 characters left',
        'Save Cancel'
    ]

    initializeConfigurations(BASE_URL)
    removeCollection('medications', 'medicalhistorydb')
    initializeAllObjects

    @common.loginEndsOnLandingPage('zztest.patient05', 'patient05, zztest')
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == 'App Options'); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq('App Options')
    waitForPageToFinishLoading
    @driver.find_element(:id, "MyMedical").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader() == 'My Medical'); sleep 1 }
    expect(getSecondaryHeader()).to eq('My Medical')

    @my_medical.click(:css, Nav_menu::NAV['Medications']['navButton'])
    !5.times{ break if (getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1 }
    expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])
  end

  # after(:all) do
  #   quitDriver()
  # end

  context 'AC #JRNL-1278|TC #JRNL-1205: Add New Entry for Medications' do

    it "Button Visibility" do
      expect(@common.isAddButtonVisible()).to eq(true)
    end

    it "Add Button Alt Text" do
      expect(@common.getAddButtonAltText()).to eq("Add")
    end

    it "Click Add Button" do
      #@common.clickAddButton()
      waitForPageToFinishLoading
      #@my_medical.clickAddEntryButton()
      @medications.clickAddEntryButton()
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])
    end

    it "Screen Content", :broken => true do
      !5.times{break if(isElementVisible(:css, "form[name='form']")); sleep 1}
      expect(isElementVisible(:css, "form[name='form']")).to eq(true)

      form = @medications.getScreenContent().split("\n")

      @ENTRY_FORM.each_with_index() do |expectedScreenRow, i|
        expect(form[i]).to eq(expectedScreenRow)
      end

    end

    it "Default Values" do
      expect(@medications.getFieldValue("MEDICATION_NAME")).to eq("")
      expect(@medications.getFieldValue("STRENGTH")).to eq("")
      expect(@medications.getFieldValue("DOSE")).to eq("")
      expect(@medications.getFieldValue("FREQUENCY")).to eq("")
      expect(@medications.getFieldValue("REASON")).to eq("")
      #expect(@medications.getFieldValue("CURRENTLY_TAKING")).to eq("Yes")
      expect(@medications.getFieldValue("SIDE_EFFECTS")).to eq("No")
      expect(@medications.getFieldValue("NOTES")).to eq("")

    end

    it "Medication Name" do
      expect(@medications.isFieldRequired?("MEDICATION_NAME")).to eq(true)

    end

    it "Strength" do
      expect(@medications.isFieldRequired?("STRENGTH")).to eq(false)
      expect(@medications.getFieldMaxLength("STRENGTH")).to eq("")

    end

    it "Dose" do
      expect(@medications.isFieldRequired?("DOSE")).to eq(false)
      expect(@medications.getFieldMaxLength("DOSE")).to eq("50")

    end

    it "Frequency" do
      expect(@medications.isFieldRequired?("FREQUENCY")).to eq(true)

    end

    it "Reason for Taking" do
      expect(@medications.isFieldRequired?("REASON")).to eq(false)
      expect(@medications.getFieldMaxLength("REASON")).to eq("50")

    end

    it "Currently Taking", :broken => true do
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "Yes","currentlyTaking" )).to eq(false)
      expect(@medications.isFieldVisible("TAKING_WHY_NOT")).to eq(true)
      expect(@medications.isFieldVisible("TAKING_WHY")).to eq(false)

      @medications.setFieldValue("CURRENTLY_TAKING", "No")
      expect(@medications.isFieldVisible("TAKING_WHY_NOT")).to eq(true)
      expect(@medications.isFieldVisible("TAKING_WHY")).to eq(false)
    end

    it "Side Effects", :broken => true do
      expect(isThisRadioButtonOrCheckBoxSelected("radio", "No", "sideEffects")).to eq(true)
      expect(@medications.isFieldVisible("SIDE_EFFECT_DESC")).to eq(false)
      @driver.find_element(:css, "input[name='sideEffects'][value='Yes']").click
      # @entry_form.clickSaveButton()
      # waitForPageToFinishLoading

      expect(@medications.isFieldVisible("SIDE_EFFECT_DESC")).to eq(true)
    end

    it "Add Side Effects", :broken => true do
      # @driver.find_element(:css, "input[name='sideEffect1']").send_keys "Nausea"
      # @driver.find_element(:css, "button[ng-click='addSideEffect()']").click
      # @driver.find_element(:css, "input[name='sideEffect2']").send_keys "Headache"
      # @driver.find_element(:css, "button[ng-click='addSideEffect()']").click
      # @driver.find_element(:css, "input[name='sideEffect3']").send_keys "Cotton Mouth"
      # @driver.find_element(:css, "button[ng-click='addSideEffect()']").click
      # @driver.find_element(:css, "input[name='sideEffect4']").send_keys "Dry Skin"
      # @driver.find_element(:css, "button[ng-click='addSideEffect()']").click
      # @driver.find_element(:css, "input[name='sideEffect5']").send_keys "Swelling"
      # @driver.find_element(:css, "button[ng-click='addSideEffect()']").click
      # @driver.find_element(:css, "input[name='sideEffect6']").send_keys "Hairloss"
      # @driver.find_element(:css, "button[ng-click='addSideEffect()']").click
      # @driver.find_element(:css, "input[name='sideEffect7']").send_keys "Cough"
      # @driver.find_element(:css, "button[ng-click='addSideEffect()']").click
      # @driver.find_element(:css, "input[name='sideEffect8']").send_keys "Stiff Muscles"
      # @driver.find_element(:css, "button[ng-click='addSideEffect()']").click
      # @driver.find_element(:css, "input[name='sideEffect9']").send_keys "Insomnia"
      # @driver.find_element(:css, "button[ng-click='addSideEffect()']").click
      # @driver.find_element(:css, "input[name='sideEffect10']").send_keys "Irritation"


      expect(isElementVisible(:css, "button[ng-click='addSideEffect()']")).to eq(true)
      #Add Side Effects
      sideEffect = Array.new
      sideEffect[1] = "Nausea"
      sideEffect[2] = "Headache"
      sideEffect[3] = "Cotton Mouth"
      sideEffect[4] = "Dry Skin"
      sideEffect[5] = "Swelling"
      sideEffect[6] = "Hairloss"
      sideEffect[7] = "Cough"
      sideEffect[8] = "Stiff Muscles"
      sideEffect[9] = "Insomnia"
      sideEffect[10] = "Irritation"
      sideEffectsEntryCount = @medications.getTotalSideEffectEntries()
      @medications.setFieldValue("SIDE_EFFECT_DESC", sideEffect[1])

    for i in 2 .. 10
      @medications.clickAddSideEffect()
      #@medications.setSideEffect(sideEffect[i], "input[name='sideEffect#{i.to_s}']")
      !5.times{break if(@medications.getTotalSideEffectEntries() > sideEffectsEntryCount); sleep 1}
      #expect(@medications.getTotalSideEffectEntries()).to eq(i)
    end

      #Add Side Effect button disappears after 10 entries
      expect(@medications.isFieldVisible("ADD_SIDE_EFFECT")).to eq(true)
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading

      @driver.find_element(:css, "input[name='sideEffect2']").send_keys "Headache"
      @driver.find_element(:css, "input[name='sideEffect3']").send_keys "Cotton Mouth"
      @driver.find_element(:css, "input[name='sideEffect4']").send_keys "Dry Skin"
      @driver.find_element(:css, "input[name='sideEffect5']").send_keys "Swelling"
      @driver.find_element(:css, "input[name='sideEffect6']").send_keys "Hairloss"
      @driver.find_element(:css, "input[name='sideEffect7']").send_keys "Cough"
      @driver.find_element(:css, "input[name='sideEffect8']").send_keys "Stiff Muscles"
      @driver.find_element(:css, "input[name='sideEffect9']").send_keys "Insomnia"
      waitForPageToFinishLoading
      # @medications.clickAddSideEffect()
      # waitForPageToFinishLoading
      # sleep 2
      # @driver.find_element(:css, "input[name='sideEffect10']").send_keys "Irritation"
    end

    it "Note" do
      expect(@medications.isFieldRequired?("NOTES"))
      expect(@medications.getFieldMaxLength("NOTES")).to eq("250")

    end

    it "Errors" do
      @medications.clickSaveButton()
      checkingInlineError("Medication Name field is required.", 0)
      checkingInlineError("Frequency field is required.", 1)

    end

    it "Save, Cancel and Delete buttons" do
        expect(@medications.isSaveButtonVisible()).to eq(true)
        expect(@medications.isDeleteButtonVisible()).to eq(false)
        expect(@medications.isCancelButtonVisible()).to eq(true)

    end

  end

  context 'AC #JRNL-1276|TC #JRNL-1205: Save and Cancel Functionality' do
    it "Cancel Functionality" do

      @medications.setFieldValue("MEDICATION_NAME", "Truth Serum")
      @medications.setFieldValue("FREQUENCY", "As Needed (PRN)")

      @medications.clickCancelButton()
      !5.times{ break if (getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1 }
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])

    end

    it "Save Functionality", :broken => true do
      @medications.clickAddEntryButton()
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])

      @medications.setFieldValue("MEDICATION_NAME", "Truth Serum")
      @medications.setFieldValue("FREQUENCY", "As Needed (PRN)")

      @medications.clickSaveButton()
      @driver.find_element(:css, "button[ng-click='save()']").click
      waitForPageToFinishLoading

      !5.times{ break if (getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1 }
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])
      @medications.clickApplyButton
      waitForPageToFinishLoading
      expect(getCount()).to eq(1)

    end

  end

  context 'AC #JRNL-1277, JRNL-1276|TC #JRNL-1205: Edit and Delete Functionality' do

    it "Edit Functionality", :broken => true do
      expect(getTextForRowColumn(1,1)).to eq("Truth Serum\nAs Needed (PRN)")

      clickNthRow(1)
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

      expect(@medications.isElementEnabled("MEDICATION_NAME")).to eq(true)
      @medications.setFieldValue("FREQUENCY", "Once a Day")

      @medications.clickSaveButton()
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[ng-click='save()']").click
      waitForPageToFinishLoading
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])
      expect(getTextForRowColumn(1,1)).to eq("Truth Serum\nOnce a Day")

    end

    it "Delete Functionality", :broken => true do
      clickNthRow(1)
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

      @medications.clickDeleteButton()
      !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq('Confirmation')
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
      expect(@modal.getConfirmButtonText()).to eq("Yes")
      expect(@modal.getCancelButtonText()).to eq("No")

      @modal.clickNoButton()
      !5.times{ break if (@modal.isConfirmationPopUpNotPresent()); sleep 1 }
      expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

      @medications.clickDeleteButton()
      !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq('Confirmation')

      @modal.clickYesButton()
      waitForPageToFinishLoading

      @main.clickNavMenu()
      waitForPageToFinishLoading
      @driver.find_element(:id, "MyMedical").click
      waitForPageToFinishLoading
      @my_medical.click(:css, Nav_menu::NAV['Medications']['navButton'])
      waitForPageToFinishLoading

      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])


      expect(getCount()).to eq(0)

    end

  end

  context 'AC #JRNL-1275|TC #JRNL-1205: Navigation ' do

    it "Back button no changes for ADD", :broken => true do

      @medications.clickAddEntryButton()
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])

      #Verifying '<' button is present
      expect(is_element_present(:css, "button[ng-click='goBack()']")).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      @common.clickBackButton()
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])

      expect(getCount()).to eq(0)

    end

    it "Back button after changes for ADD", :broken => true do

      @medications.clickAddEntryButton()
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])

      #Verifying '<' button is present
      expect(is_element_present(:css, "button[ng-click='goBack()']")).to eq(true)

      @medications.setFieldValue("FREQUENCY", "As Needed (PRN)")

      @common.clickBackButton()
      #Verifying Modal Popup
      !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")

      #Clicking Return to go back to Add View
      @modal.clickReturnButton()
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])
      waitForPageToFinishLoading
      #Clicking '<' button and continuing
      @common.clickBackButton()
      !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq('Confirmation')

      @modal.clickContinueButton()
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])

      expect(getCount()).to eq(0)

    end

    it "Back button no changes for EDIT", :broken => true do
      @medications.clickAddEntryButton()
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])

      @medications.setFieldValue("MEDICATION_NAME", "Truth Serum")
      @medications.setFieldValue("FREQUENCY", "As Needed (PRN)")

      @medications.clickSaveButton()
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[ng-click='save()']").click
      waitForPageToFinishLoading
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1}
      @medications.clickApplyButton
      waitForPageToFinishLoading
      expect(getTextForRowColumn(1,1)).to eq("Truth Serum\nAs Needed (PRN)")
      waitForPageToFinishLoading
      clickNthRow(1)
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

      #Verifying '<' button is present
      expect(is_element_present(:css, "button[ng-click='goBack()']")).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      waitForPageToFinishLoading
      @common.clickBackButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])

      expect(getCount()).to eq(1)

      #No changes were made
      expect(getTextForRowColumn(1,1)).to eq("Truth Serum\nAs Needed (PRN)")

    end

    it "Back button after changes for EDIT", :broken => true do

      clickNthRow(1)
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

      @medications.setFieldValue("FREQUENCY", "Once a Day")

      @common.clickBackButton()
      !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
      #Verifying Modal Popup
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")

      #Clicking Return to go back to Edit View
      @modal.clickReturnButton()
      !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

      #Clicking '<' button and continuing
      waitForPageToFinishLoading
      @common.clickBackButton()
      waitForPageToFinishLoading
      !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])

      expect(getCount()).to eq(1)

      #No changes were made
      expect(getTextForRowColumn(1,1)).to eq("Truth Serum\nAs Needed (PRN)")

    end

  end

  #######################
  ### Local Functions ###
  #######################

  def checkingInlineError(errMsg, seqNum)
    #Verify that the error message section header is displayed
    if seqNum == 0 then
      !5.times{ break if (@error.getValidationSummaryHeader('form') == 'The following errors were found:'); sleep 1 }
      expect(@error.getValidationSummaryHeader('form')).to eq('The following errors were found:')
    end
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed('form', errMsg)).to eq(true)
  end

end





















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe '[Story #JRNL-1296: My Medical - Medications - Add/Edit/Del/Nav]', :regression => true do

    before(:all) do
        @ENTRY_FORM = [
            '* required field',
            'Source: Self',
            '* Medication Name:',
            'Auto-complete input',
            'Strength:',
            '50 character maximum',
            'Directions:',
            'Dose:',
            '50 character maximum',
            '* Frequency:',
            'Select',
            'Once a Day',
            '2 times a Day',
            '3 times a Day',
            '4 times a Day',
            'Every 4 Hours',
            'Every 6 Hours',
            'Every 8 Hours',
            'Once a Week',
            'At Bedtime (Once a Day)',
            'Before Meals',
            'As Needed (PRN)',
            'Other',
            'Reason for Taking:',
            '50 character maximum',
            'Currently Taking:',
            'Yes',
            'No',
            'How are you taking this medication?:',
            'Taking as directed',
            'Taking differently than directed',
            'Take only when I need it',
            'Take on a different schedule',
            'Medication Started: M M / D D / Y Y Y Y:',
            'MM/DD/YYYY',
            'This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker',
            'Medication Ended:',
            'MM/DD/YYYY',
            'This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker',
            'Prescription Information (if applicable):',
            'Prescription (Rx) Number:',
            '25 character maximum',
            'Prescribing Provider:',
            '50 character maximum',
            'Pharmacy Name:',
            '50 character maximum',
            'Pharmacy Phone:',
            'Enter 10 digits',
            'Unwanted Side Effects?:',
            'Yes',
            'No',
            'Notes:',
            '250 character maximum',
            '250 characters left',
            'Save Cancel'
        ]

        initializeConfigurations(BASE_URL)
        removeCollection('medications', 'medicalhistorydb')
        initializeAllObjects

        @common.loginEndsOnLandingPage('zztest.patient05', 'patient05, zztest')
        expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

        @main.clickNavMenu()
        !5.times{ break if (@nav_menu.getNavMenuHeading() == 'App Options'); sleep 1 }
        expect(@nav_menu.getNavMenuHeading()).to eq('App Options')
        waitForPageToFinishLoading
        @driver.find_element(:id, "MyMedical").click
        waitForPageToFinishLoading
        !5.times{ break if (getSecondaryHeader() == 'My Medical'); sleep 1 }
        expect(getSecondaryHeader()).to eq('My Medical')

        @mymedical.click(:css, Nav_menu::NAV['Medications']['navButton'])
        !5.times{ break if (getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])
    end

    after(:all) do
        quitDriver()
    end

    context 'AC #JRNL-1278|TC #JRNL-1205: Add New Entry for Medications' do

        it "Button Visibility" do
            expect(@common.isAddButtonVisible()).to eq(true)
        end

        it "Add Button Alt Text" do
            expect(@common.getAddButtonAltText()).to eq("Add")
        end

        it "Click Add Button" do
            #@common.clickAddButton()
            waitForPageToFinishLoading
            #@my_medical.clickAddEntryButton()
            @medications.clickAddEntryButton()
            !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
            expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])
        end

        it "Screen Content", :broken => true do
            !5.times{break if(isElementVisible(:css, "form[name='form']")); sleep 1}
            expect(isElementVisible(:css, "form[name='form']")).to eq(true)

            form = @medications.getScreenContent().split("\n")

            @ENTRY_FORM.each_with_index() do |expectedScreenRow, i|
                expect(form[i]).to eq(expectedScreenRow)
            end

        end

        it "Default Values" do
          expect(@medications.getFieldValue("MEDICATION_NAME")).to eq("")
          expect(@medications.getFieldValue("STRENGTH")).to eq("")
          expect(@medications.getFieldValue("DOSE")).to eq("")
          expect(@medications.getFieldValue("FREQUENCY")).to eq("")
          expect(@medications.getFieldValue("REASON")).to eq("")
          expect(@medications.getFieldValue("CURRENTLY_TAKING")).to eq("Yes")
          expect(@medications.getFieldValue("SIDE_EFFECTS")).to eq("No")
          expect(@medications.getFieldValue("NOTES")).to eq("")

        end

        it "Medication Name" do
          expect(@medications.isFieldRequired?("MEDICATION_NAME")).to eq(true)

        end

        it "Strength" do
          expect(@medications.isFieldRequired?("STRENGTH")).to eq(false)
          expect(@medications.getFieldMaxLength("STRENGTH")).to eq("50")

        end

        it "Dose" do
          expect(@medications.isFieldRequired?("DOSE")).to eq(false)
          expect(@medications.getFieldMaxLength("DOSE")).to eq("50")

        end

        it "Frequency" do
          expect(@medications.isFieldRequired?("FREQUENCY")).to eq(true)

        end

        it "Reason for Taking" do
          expect(@medications.isFieldRequired?("REASON")).to eq(false)
          expect(@medications.getFieldMaxLength("REASON")).to eq("50")

        end

        it "Currently Taking", :broken => true do
          expect(isThisRadioButtonOrCheckBoxSelected("radio", "Yes","currentlyTaking" )).to eq(true)
          expect(@medications.isFieldVisible("TAKING_WHY_NOT")).to eq(false)
          expect(@medications.isFieldVisible("TAKING_WHY")).to eq(true)

          @medications.setFieldValue("CURRENTLY_TAKING", "No")
          expect(@medications.isFieldVisible("TAKING_WHY_NOT")).to eq(true)
          expect(@medications.isFieldVisible("TAKING_WHY")).to eq(false)

        end

        it "Side Effects", :broken => true do
          expect(isThisRadioButtonOrCheckBoxSelected("radio", "No", "sideEffects")).to eq(true)
          expect(@medications.isFieldVisible("SIDE_EFFECT_DESC")).to eq(false)

          @medications.setFieldValue("SIDE_EFFECTS", "Yes")
          expect(@medications.isFieldVisible("SIDE_EFFECT_DESC")).to eq(true)
          @modalp
        end

        it "Add Side Effects", :broken => true do
          expect(isElementVisible(:css, "button[ng-click='addSideEffect()']")).to eq(true)
          #Add Side Effects
          sideEffect = Array.new
          sideEffect[1] = "Nausea"
          sideEffect[2] = "Headache"
          sideEffect[3] = "Cotton Mouth"
          sideEffect[4] = "Dry Skin"
          sideEffect[5] = "Swelling"
          sideEffect[6] = "Hairloss"
          sideEffect[7] = "Cough"
          sideEffect[8] = "Stiff Muscles"
          sideEffect[9] = "Insomnia"
          sideEffect[10] = "Irritation"
          sideEffectsEntryCount = @medications.getTotalSideEffectEntries()
          @medications.setFieldValue("SIDE_EFFECT_DESC", sideEffect[1])

          for i in 2 .. 10
            @medications.clickAddSideEffect()
            @medications.setSideEffect(sideEffect[i], "input[name='sideEffect#{i.to_s}']")
            !5.times{break if(@medications.getTotalSideEffectEntries() > sideEffectsEntryCount); sleep 1}
            expect(@medications.getTotalSideEffectEntries()).to eq(i)
          end

          #Add Side Effect button disappears after 10 entries
          expect(@medications.isFieldVisible("ADD_SIDE_EFFECT")).to eq(false)

        end

        it "Note" do
          expect(@medications.isFieldRequired?("NOTES"))
          expect(@medications.getFieldMaxLength("NOTES")).to eq("250")

        end

        it "Errors" do
          @medications.clickSaveButton()
          checkingInlineError("Medication Name field is required.", 0)
          checkingInlineError("Frequency field is required.", 1)

        end

        it "Save, Cancel and Delete buttons" do
            expect(@medications.isSaveButtonVisible()).to eq(true)
            expect(@medications.isDeleteButtonVisible()).to eq(false)
            expect(@medications.isCancelButtonVisible()).to eq(true)

        end

    end

    context 'AC #JRNL-1276|TC #JRNL-1205: Save and Cancel Functionality' do
      it "Cancel Functionality" do

        @medications.setFieldValue("MEDICATION_NAME", "Truth Serum")
        @medications.setFieldValue("FREQUENCY", "As Needed (PRN)")

        @medications.clickCancelButton()
        !5.times{ break if (getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])

      end

      it "Save Functionality", :broken => true do
        @medications.clickAddEntryButton()
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])

        @medications.setFieldValue("MEDICATION_NAME", "Truth Serum")
        @medications.setFieldValue("FREQUENCY", "As Needed (PRN)")

        @medications.clickSaveButton()
        !5.times{ break if (getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])
        expect(getCount()).to eq(1)

      end

    end

    context 'AC #JRNL-1277, JRNL-1276|TC #JRNL-1205: Edit and Delete Functionality' do

      it "Edit Functionality", :broken => true do
        expect(getTextForRowColumn(1,1)).to eq("Truth Serum\nAs Needed (PRN)")

        clickNthRow(1)
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

        expect(@medications.isElementEnabled("MEDICATION_NAME")).to eq(false)
        @medications.setFieldValue("FREQUENCY", "Once a Day")

        @medications.clickSaveButton()

        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])
        expect(getTextForRowColumn(1,1)).to eq("Truth Serum\nOnce a Day")

      end

      it "Delete Functionality", :broken => true do
        clickNthRow(1)
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

        @medications.clickDeleteButton()
        !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq('Confirmation')
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickNoButton()
        !5.times{ break if (@modal.isConfirmationPopUpNotPresent()); sleep 1 }
        expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

        @medications.clickDeleteButton()
        !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq('Confirmation')

        @modal.clickYesButton()
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])

        expect(getCount()).to eq(0)

      end

    end

    context 'AC #JRNL-1275|TC #JRNL-1205: Navigation ' do

      it "Back button no changes for ADD", :broken => true do

        @medications.clickAddEntryButton()
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])

        #Verifying '<' button is present
        expect(is_element_present(:css, "button[ng-click='goBack()']")).to eq(true)

        #Clicking '<' button without any changes to return to the table view
        @common.clickBackButton()
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])

        expect(getCount()).to eq(0)

      end

      it "Back button after changes for ADD", :broken => true do

        @medications.clickAddEntryButton()
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])

        #Verifying '<' button is present
        expect(is_element_present(:css, "button[ng-click='goBack()']")).to eq(true)

        @medications.setFieldValue("FREQUENCY", "As Needed (PRN)")

        @common.clickBackButton()
        #Verifying Modal Popup
        !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

        #Clicking Return to go back to Add View
        @modal.clickReturnButton()
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])

        #Clicking '<' button and continuing
        @common.clickBackButton()
        !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq('Confirmation')

        @modal.clickContinueButton()
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])

        expect(getCount()).to eq(0)

      end

      it "Back button no changes for EDIT", :broken => true do
        @medications.clickAddEntryButton()
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['ADD']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['ADD'])

        @medications.setFieldValue("MEDICATION_NAME", "Truth Serum")
        @medications.setFieldValue("FREQUENCY", "As Needed (PRN)")

        @medications.clickSaveButton()
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['LIST']); sleep 1}
        expect(getTextForRowColumn(1,1)).to eq("Truth Serum\nAs Needed (PRN)")

        clickNthRow(1)
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

        #Verifying '<' button is present
        expect(is_element_present(:css, "button[ng-click='goBack()']")).to eq(true)

        #Clicking '<' button without any changes to return to the table view
        @common.clickBackButton()
        waitForPageToFinishLoading()
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])

        expect(getCount()).to eq(1)

        #No changes were made
        expect(getTextForRowColumn(1,1)).to eq("Truth Serum\nAs Needed (PRN)")

      end

      it "Back button after changes for EDIT", :broken => true do

        clickNthRow(1)
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

        @medications.setFieldValue("FREQUENCY", "Once a Day")

        @common.clickBackButton()
        !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
        #Verifying Modal Popup
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

        #Clicking Return to go back to Edit View
        @modal.clickReturnButton()
        !5.times{break if(getPrimaryHeader() == Medications::HEADERS['EDIT']); sleep 1}
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['EDIT'])

        #Clicking '<' button and continuing
        @common.clickBackButton()
        !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")

        @modal.clickContinueButton()
        waitForPageToFinishLoading()
        expect(getPrimaryHeader()).to eq(Medications::HEADERS['LIST'])

        expect(getCount()).to eq(1)

        #No changes were made
        expect(getTextForRowColumn(1,1)).to eq("Truth Serum\nAs Needed (PRN)")

      end

    end

    #######################
    ### Local Functions ###
    #######################

    def checkingInlineError(errMsg, seqNum)
        #Verify that the error message section header is displayed
        if seqNum == 0 then
            !5.times{ break if (@error.getValidationSummaryHeader('form') == 'The following errors were found:'); sleep 1 }
            expect(@error.getValidationSummaryHeader('form')).to eq('The following errors were found:')
        end
        #Verify the error message is displayed
        expect(@error.isErrorMessageDisplayed('form', errMsg)).to eq(true)
    end

end
=end