require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2481: Hospitalization Edit/Delete]", :broken => true, :acceptance => true  do

  before(:all) do

    @EXPECTED_ROW_0_FORM = [ \
        "* required field",
        "Dates of Hospitalization:",
        "* Start Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* End Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Is this range estimated?:",
        "* Facility/Hospital:",
        "100 character maximum",
        "Source: Self",
        "Reason for Hospitalization:",
        "250 character maximum",
        "238 characters left",
        "Save Delete Cancel",
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("hospitalization", "medicalhistorydb", "hospitalization")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (@mymedical.getSecondaryHeader == "My Medical"); sleep 1 }
    expect(@mymedical.getSecondaryHeader).to eq("My Medical")

    @mymedical.clickHospitalizations
    !45.times{ break if (@mymedical.getPrimaryHeader == "Hospitalizations"); sleep 1 }
    expect(@mymedical.getPrimaryHeader).to eq("Hospitalizations")

    expect(getCount()).to eq(23)
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-3307|TC #JRNL-2780: 2. When the user selects a Hospitalizations entry from the table view, the system displays the Hospitalizations record in the Detail screen in Edit mode." do
    clickNthRow(1)
    !45.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")
    !10.times{ break if (getFocusedElementText().include?("Edit Hospitalization Entry")); sleep 1 }
    expect(getFocusedElementText()).to eq("Edit Hospitalization Entry")

    expect(@hospitalizations.getStartDate()).to eq("09/23/2014")
    expect(@hospitalizations.getEndDate()).to eq("09/23/2014")
    expect(@hospitalizations.getIsRangeEstimated()).to be true
    expect(@hospitalizations.getFacilityHospital()).to eq("ANOVA Hospital")
    expect(@hospitalizations.getHospitalizationReason()).to eq("Broken ankle")

    hospitalizationForm = @hospitalizations.getScreenContent().split("\n")
    @EXPECTED_ROW_0_FORM.each_with_index do | expectedScreenRow, i |
      #DEBUG puts "checking [#{hospitalizationForm[i]}] with [#{expectedScreenRow}]"
      expect(hospitalizationForm[i]).to eq(expectedScreenRow)
    end
    expect(hospitalizationForm.length).to eq(@EXPECTED_ROW_0_FORM.length)

    expect(@hospitalizations.isDeleteButtonVisible()).to be true
    expect(@hospitalizations.isCancelButtonVisible()).to be true
    expect(@hospitalizations.isSaveButtonVisible()).to be true
  end

  it "AC #JRNL-3307|TC #JRNL-2780: When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
    @hospitalizations.setIsRangeEstimatedNo()
    @hospitalizations.setFacilityHospital("Test Facility")
    @hospitalizations.setHospitalizationReason("Test Reason")

    @hospitalizations.clickCancelButton()
    !45.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
    !10.times{ break if (getFocusedElementText().include?("Hospitalizations")); sleep 1 }
    expect(getFocusedElementText()).to eq("Hospitalizations")
  end

  it "AC #JRNL-3307|TC #JRNL-2780: When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
    expect(getCount()).to eq(23)

    clickNthRow(1)
    !45.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

    expect(@hospitalizations.getStartDate()).to eq("09/23/2014")
    expect(@hospitalizations.getEndDate()).to eq("09/23/2014")
    expect(@hospitalizations.getIsRangeEstimated()).to be true
    expect(@hospitalizations.getFacilityHospital()).to eq("ANOVA Hospital")
    expect(@hospitalizations.getHospitalizationReason()).to eq("Broken ankle")
  end

  it "AC #JRNL-3307|TC #JRNL-2780: Validation" do
    # Start Date must occur before End Date.
    @hospitalizations.setStartDate("09/19/2014")
    @hospitalizations.setEndDate("07/17/2010")
    @hospitalizations.clickSaveButton()
    validateErrorMessages(["Start Date must occur before End Date."])
    !10.times{ break if (getFocusedElementText().include?("The following errors were found:")); sleep 1 }
    expect(getFocusedElementText()).to eq("The following errors were found:")

    # Facility/Hospital field is required.
    @hospitalizations.setStartDate("03/24/2014")
    @hospitalizations.setEndDate("04/25/2014")
    @hospitalizations.setFacilityHospital("")
    @hospitalizations.clickSaveButton()
    validateErrorMessages(["Facility/Hospital field is required."])

    # Start Date field is required.
    @hospitalizations.setStartDate("")
    @hospitalizations.setFacilityHospital("Some Hospital")
    @hospitalizations.clickSaveButton()
    validateErrorMessages(["Start Date field is required."])

    # End Date field is required.
    @hospitalizations.setStartDate("03/24/2014")
    @hospitalizations.setEndDate("")
    @hospitalizations.clickSaveButton()
    validateErrorMessages(["End Date field is required."])
  end

  it "AC #JRNL-3307|TC #JRNL-2780: Save takes the user back to the list" do
    @hospitalizations.clickStartDateCalendarBtn()
    !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
    @date_picker.setDateFromGUI(1, 1, 1901)
    expect(@hospitalizations.getStartDate()).to eq("01/01/1901")

    @hospitalizations.clickEndDateCalendarBtn()
    !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
    @date_picker.setDateFromGUI(1, 1, 1902)
    expect(@hospitalizations.getEndDate()).to eq("01/01/1902")

    @hospitalizations.setIsRangeEstimatedNo()
    @hospitalizations.setFacilityHospital("A Test Facility")
    @hospitalizations.setHospitalizationReason("")

    @hospitalizations.clickSaveButton()
    !45.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
    !10.times{ break if (getFocusedElementText().include?("Hospitalizations")); sleep 1 }
    expect(getFocusedElementText()).to eq("Hospitalizations")
  end

  it "AC #JRNL-3307|TC #JRNL-2780: When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view." do
    expect(getCount()).to eq(23)
    expectedText = ['Start Date', '01/01/1901', 'End Date', '01/01/1902', 'Facility', 'A Test Facility', 'Source', 'Self']
    expect(getTextForRowAsArray(23)).to eq(expectedText)
  end

  it "AC #JRNL-3307|TC #JRNL-2780: All values previously saved are visible. If no value was previously saved for a field, the display defaults to null(empty)." do
    clickNthRow(23)
    !45.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

    expect(@hospitalizations.getStartDate()).to eq("01/01/1901")
    expect(@hospitalizations.getEndDate()).to eq("01/01/1902")
    expect(@hospitalizations.getIsRangeEstimated()).to be false
    expect(@hospitalizations.getFacilityHospital()).to eq("A Test Facility")
    expect(@hospitalizations.getHospitalizationReason()).to eq("")
  end

  it "AC #JRNL-3307|TC #JRNL-2780: When a user selects Delete, the system prompts the user to confirm the Delete by displaying a modal: Clicking No closes the modal and returns the user to the Detail entry, edit mode, with focus on the delete button." do
    @hospitalizations.clickDeleteButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickNoButton()
    !45.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")
    !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
    expect(getFocusedElementText()).to eq("Delete")

    @hospitalizations.clickCancelButton()
    !45.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")

    expect(getCount()).to eq(23)
  end

  it "AC #JRNL-3307|TC #JRNL-2780: When a user selects Delete, the system prompts the user to confirm the Delete by displaying a modal: Clicking Yes, closes the modal, and moves the user to the Detail view with the table shown and the deleted item is removed from the table list." do
    clickNthRow(23)
    !45.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

    puts "Confirm modal content"
    @hospitalizations.clickDeleteButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
    @modal.clickYesButton()
    !45.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
    !10.times{ break if (getFocusedElementText().include?("Hospitalizations")); sleep 1 }
    expect(getFocusedElementText()).to eq("Hospitalizations")

    expect(getCount()).to eq(22)
  end

  it "AC #JRNL-3308|TC #JRNL-2781: If the user tries to Navigate away from a detail record where a field has been updated without Saving, the user is prompted to confirm that they want to leave the record without saving via a modal." do
    clickNthRow(1)
    !45.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

    @hospitalizations.setFacilityHospital("ASDFGHJKL")
    @mymedical.clickHospitalizations()

    puts "Confirm modal content"
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
    @modal.clickReturnButton()
    !45.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

    @mymedical.clickHospitalizations()
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
    @modal.clickContinueButton()
    !45.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")

    clickNthRow(1)
    !45.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

    expect(@hospitalizations.getFacilityHospital()).not_to eq("ASDFGHJKL")
    @hospitalizations.clickCancelButton()
    !45.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
  end

  # Local functions starts

  def validateErrorMessages(errors)
    expectedValidationSummaryHeader = errors.length > 0 ? "The following errors were found:" : ""
    sleep 1

    !45.times{ break if (@errorSummary.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
    expect(@errorSummary.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)

    if(expectedValidationSummaryHeader != "")
      for i in 0..(errors.length - 1)
        if errors[i] != nil
          expect(@errorSummary.isErrorMessageDisplayed("form", errors[i])).to eq(true)
        else
          expect(@errorSummary.isErrorMessageDisplayed("form", errors[i])).to eq(false)
        end
      end
    else
      expect(@errorSummary.isErrorSummaryElementPresent("form")).to eq(false)
    end
  end

end