require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2481: Hospitalization Add]", :acceptance => true do

  before(:all) do
    @INITIAL_ENTRY_FORM = [ \
        "* required field",
        "Dates of Hospitalization:",
        "*",
        "Required: Start Date: M M / D D / Y Y Y Y:",
        "Start Date:",
        "This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.",
        "*",
        "Required: End Date: M M / D D / Y Y Y Y:",
        "End Date:",
        "This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.",
        "Is this range estimated?:",
        "* Facility/Hospital:",
        "100 character maximum",
        "Source: Self",
        "Reason for Hospitalization:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel",
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("hospitalization", "medicalhistorydb")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    waitForPageToFinishLoading
    @driver.find_element(:id, "MyMedical").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickHospitalizations()
    !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
  end

  # after(:all) do
  #   quitDriver()
  # end

  it "AC #JRNL-3306|TC #JRNL-2775: 1.  When the user views the Hospitalizations Table list, an Add button (+ icon, alt text Add), is available in the upper right corner of the Detail screen." do
    expect(@common.isAddButtonVisible()).to be true
  end

  it "AC #JRNL-3306|TC #JRNL-2775: a.  When a user selects Add, the Add Hospitalizations screen is shown, header:  Add Hospitalization Entry", :broken => true do
    waitForPageToFinishLoading
    @common.clickAddButton()
    waitForPageToFinishLoading
    !5.times{ break if (getPrimaryHeader() == "Add Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Add Hospitalization Entry")

    expect(@hospitalizations.getStartDate()).to eq("")
    expect(@hospitalizations.getEndDate()).to eq("")

    expect(@hospitalizations.isDeleteButtonVisible()).to be false
    expect(@hospitalizations.isCancelButtonVisible()).to be true
    expect(@hospitalizations.isSaveButtonVisible()).to be true

    hospitalizationForm = @hospitalizations.getScreenContent().split("\n")
    @INITIAL_ENTRY_FORM.each_with_index do | expectedScreenRow, i |
      #DEBUG puts "checking [#{hospitalizationForm[i]}] with [#{expectedScreenRow}]"
      expect(hospitalizationForm[i]).to eq(expectedScreenRow)
    end
    expect(hospitalizationForm.length).to eq(@INITIAL_ENTRY_FORM.length)
  end

  it "AC #JRNL-3306|TC #JRNL-2775: Required data: Start Date, End Date, Facility/Hospital", :broken => true do
    @hospitalizations.clickSaveButton()
    validateErrorMessages(["Start Date field is required.",
                           "End Date field is required.",
                           "Facility/Hospital field is required."])
  end

  it "AC #JRNL-3306|TC #JRNL-2775: a. Start Date (mm/dd/yyyy, date picker control, required) b. End Date (mm/dd/yyyy, date picker control, required) c. Start Date must be before End Date", :broken => true do
    @hospitalizations.setFacilityHospital("Chantilly Hospital")

    @hospitalizations.setStartDate("09/19/2014")
    @hospitalizations.setEndDate("07/17/2010")
    @hospitalizations.clickSaveButton()

    validateErrorMessages(["Start Date must occur before End Date."])    #Start Date > End Date should be error

    #Verify date picker for Start and End dates are on the screen
    @hospitalizations.setStartDate("03/24/2014")
    expect(@hospitalizations.getStartDate()).to eq("03/24/2014")
    @hospitalizations.setEndDate("04/25/2014")
    expect(@hospitalizations.getEndDate()).to eq("04/25/2014")

  end

  it "AC #JRNL-3306|TC #JRNL-2775: a.  Is this range estimated? Yes/No", :broken => true do
    expect(@hospitalizations.getIsRangeEstimated()).to be false
    @hospitalizations.setIsRangeEstimatedYes()
    expect(@hospitalizations.getIsRangeEstimated()).to be true
    @hospitalizations.setIsRangeEstimatedNo()
    expect(@hospitalizations.getIsRangeEstimated()).to be false
    @hospitalizations.setIsRangeEstimatedYes()
    expect(@hospitalizations.getIsRangeEstimated()).to be true
  end

  it "AC #JRNL-3306|TC #JRNL-2775: c.  Reason for Hospitalization (Text - 250 characters)", :broken => true do
    text99 = "12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789"
    @hospitalizations.setHospitalizationReason(text99)
    expect(@hospitalizations.getHospitalizationReason().length).to eq(89)
    expect(@hospitalizations.getHospitalizationReason()).to eq(text99)
    expect(@hospitalizations.getCountDownDisplayForReason()).to eq("161 characters left")

    text200 = "123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890x"
    @hospitalizations.setHospitalizationReason(text200)
    expect(@hospitalizations.getHospitalizationReason().length).to eq(181)
    expect(@hospitalizations.getHospitalizationReason()).to eq(text200)
    expect(@hospitalizations.getCountDownDisplayForReason()).to eq("69 characters left")

    text250 = text200 + "123567890123567890123567890123567890123567890"
    @hospitalizations.setHospitalizationReason(text250)
    expect(@hospitalizations.getHospitalizationReason().length).to eq(226)
    expect(@hospitalizations.getHospitalizationReason()).to eq(text250)
    expect(@hospitalizations.getCountDownDisplayForReason()).to eq("24 characters left")

    text251 = text250 + "x"
    @hospitalizations.setHospitalizationReason(text251)
    expect(@hospitalizations.getHospitalizationReason().length).to eq(227)
    expect(@hospitalizations.getHospitalizationReason()).to eq("123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890x123567890123567890123567890123567890123567890x")
    expect(@hospitalizations.getCountDownDisplayForReason()).to eq("23 characters left")
  end

  it "AC #JRNL-3306|TC #JRNL-2775: 1) Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header.  Updates made to the record are visible in the table, if included in that view.", :broken => true do
    @hospitalizations.setFacilityHospital("Mayo Clinic")

    @hospitalizations.clickSaveButton()
    !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
    waitForPageToFinishLoading
    @hospitalizations.clickApplyButton()
    waitForPageToFinishLoading
    expect(getCount()).to eq(1)

    text50 = "123567890123567890123567890123567890123567890"
    text100 = text50 + text50
    text250 = text100 + text100 + text50

    expectedText = ['Start Date', '03/24/2014', 'End Date', '04/25/2014', 'Facility', 'Mayo Clinic', 'Source', 'Self']
    expect(getTextForRowAsArray(1)).to eq (expectedText)

    #View details
    clickNthRow(1)
    !5.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

    expect(@hospitalizations.getStartDate()).to eq("03/24/2014")
    expect(@hospitalizations.getEndDate()).to eq("04/25/2014")
    expect(@hospitalizations.getIsRangeEstimated()).to be true
    expect(@hospitalizations.getSource()).to eq('Source: Self')
    expect(@hospitalizations.getFacilityHospital()).to eq("Mayo Clinic")
    expect(@hospitalizations.getHospitalizationReason).to eq("123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890x123567890123567890123567890123567890123567890x")

    @hospitalizations.clickCancelButton()
    !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
  end

  it "AC #JRNL-3306|TC #JRNL-2775: Save with minimum info", :broken => true do
    @common.clickAddButton()
    !5.times{ break if (getPrimaryHeader() == "Add Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Add Hospitalization Entry")

    @hospitalizations.setStartDate("02/10/2010")
    @hospitalizations.setEndDate("02/15/2010")
    @hospitalizations.setFacilityHospital("a")

    @hospitalizations.clickSaveButton()
    !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
    waitForPageToFinishLoading
    @hospitalizations.clickApplyButton()
    waitForPageToFinishLoading
    expect(getCount()).to eq(2)
    expectedText = ['Start Date', '03/24/2014', 'End Date', '04/25/2014', 'Facility', 'Mayo Clinic', 'Source', 'Self']
    expect(getTextForRowAsArray(2)).to eq (expectedText)

    clickNthRow(2)
    !5.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

    expect(@hospitalizations.getStartDate()).to eq("03/24/2014")
    expect(@hospitalizations.getEndDate()).to eq("04/25/2014")
    expect(@hospitalizations.getIsRangeEstimated()).to be true
    expect(@hospitalizations.getSource()).to eq('Source: Self')
    expect(@hospitalizations.getFacilityHospital()).to eq("Mayo Clinic")
    expect(@hospitalizations.getHospitalizationReason).to eq("123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890x123567890123567890123567890123567890123567890x")

    @hospitalizations.clickCancelButton()
    !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
  end

  it "AC #JRNL-3306|TC #JRNL-2775: Save duplicate ", :broken => true do
    @common.clickAddButton()
    !5.times{ break if (getPrimaryHeader() == "Add Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Add Hospitalization Entry")

    @hospitalizations.setStartDate("02/10/2010")
    @hospitalizations.setEndDate("02/15/2010")
    @hospitalizations.setFacilityHospital("a")

    @hospitalizations.clickSaveButton()
    !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
    waitForPageToFinishLoading
    @hospitalizations.clickApplyButton()
    waitForPageToFinishLoading
    expect(getCount()).to eq(3)

    #Duplicate - row 1
    expectedText = ['Start Date', '02/10/2010', 'End Date', '02/15/2010', 'Facility', 'a', 'Source', 'Self']
    expect(getTextForRowAsArray(2)).to eq (expectedText)

    clickNthRow(2)
    waitForPageToFinishLoading
    !5.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

    expect(@hospitalizations.getStartDate()).to eq("02/10/2010")
    expect(@hospitalizations.getEndDate()).to eq("02/15/2010")
    expect(@hospitalizations.getIsRangeEstimated()).to be false
    waitForPageToFinishLoading
    expect(@hospitalizations.getSource()).to eq('Source: Self')
    expect(@hospitalizations.getFacilityHospital()).to eq("a")
    expect(@hospitalizations.getHospitalizationReason()).to eq("")

    @hospitalizations.clickCancelButton()
    !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
    #Original - row 2
    expectedText2 = ['Start Date', '03/24/2014', 'End Date', '04/25/2014', 'Facility', 'Mayo Clinic', 'Source', 'Self']

    !5.times{ break if (expectedText2 == getTextForRowAsArray(3)); sleep 1 }
    expect(getTextForRowAsArray(3)).to eq (expectedText2)

    clickNthRow(3)
    !5.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

    expect(@hospitalizations.getStartDate()).to eq("03/24/2014")
    expect(@hospitalizations.getEndDate()).to eq("04/25/2014")
    expect(@hospitalizations.getIsRangeEstimated()).to be true
    expect(@hospitalizations.getSource()).to eq('Source: Self')
    expect(@hospitalizations.getFacilityHospital()).to eq("Mayo Clinic")
    expect(@hospitalizations.getHospitalizationReason()).to eq("123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890x123567890123567890123567890123567890123567890x")

    @hospitalizations.clickCancelButton()
    !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
  end

  it "AC #JRNL-3306|TC #JRNL-2775: b.  Facility/Hospital  (text, 100 characters, required)", :broken => true do
    #Putting max facility check at the end because on the Hospital List view, fac is too long
    #causing selenium to not able to get the 'Source' value on any of the entries
    @common.clickAddButton()
    !5.times{ break if (getPrimaryHeader() == "Add Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Add Hospitalization Entry")

    @hospitalizations.setStartDate("02/10/2010")
    @hospitalizations.setEndDate("02/15/2010")

    text50 = "123567890123567890123567890123567890123567890"
    text100 = text50 + text50
    text101 = text100 + "0"
    @hospitalizations.setFacilityHospital(text101)

    @hospitalizations.clickSaveButton()
    !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
    waitForPageToFinishLoading
    @hospitalizations.clickApplyButton()
    waitForPageToFinishLoading
    expect(getCount()).to eq(4)
    expectedText = ['Start Date', '02/10/2010', 'End Date', '02/15/2010', 'Facility', 'a', 'Source', 'Self']
    expect(getTextForRowAsArray(2)).to eq (expectedText)

    clickNthRow(2)
    !5.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

    expect(@hospitalizations.getStartDate()).to eq("02/10/2010")
    expect(@hospitalizations.getEndDate()).to eq("02/15/2010")
    expect(@hospitalizations.getIsRangeEstimated()).to be false
    expect(@hospitalizations.getSource()).to eq('Source: Self')
    expect(@hospitalizations.getFacilityHospital()).to eq(text100)
    expect(@hospitalizations.getHospitalizationReason()).to eq("")

    @hospitalizations.clickCancelButton()
    !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")
  end

  it "AC #JRNL-3306|TC #JRNL-2775: 2) Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header", :broken => true do
    @common.clickAddButton()
    !5.times{ break if (getPrimaryHeader() == "Add Hospitalization Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Add Hospitalization Entry")

    @hospitalizations.setStartDate("02/10/2010")
    @hospitalizations.setEndDate("02/15/2010")
    @hospitalizations.setFacilityHospital("a")

    @hospitalizations.clickCancelButton()
    !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Hospitalizations")

    expect(getCount()).to eq(4)
  end

  #######################
  ### Local Functions ###
  #######################

  def validateErrorMessages(errors)
    expectedValidationSummaryHeader = errors.length > 0 ? "The following errors were found:" : ""
    sleep 1

    !5.times{ break if (@errorSummary.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
    expect(@errorSummary.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)

    if(expectedValidationSummaryHeader != "")
      for i in 0..(errors.length - 1)
        if errors[i] != nil
          expect(@errorSummary.isErrorMessageDisplayed("form", errors[i])).to eq(true)
        else
          expect(@errorSummary.isErrorMessageDisplayed("form", errors[i])).to eq(false)
        end
      end
    else
      expect(@errorSummary.isErrorSummaryElementPresent("form")).to eq(false)
    end
  end

end






































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2481: Hospitalization Add]", :acceptance => true do

    before(:all) do
        @INITIAL_ENTRY_FORM = [ \
        "* required field",
        "Dates of Hospitalization:",
        "* Start Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "* End Date:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Is this range estimated?:",
        "* Facility/Hospital:",
        "100 character maximum",
        "Source: Self",
        "Reason for Hospitalization:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel",
        ]

        initializeConfigurations(BASE_URL)
        removeCollection("hospitalization", "medicalhistorydb")

        initializeAllObjects

        @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

        @main.clickNavMenu()
        !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
        expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

        @nav_menu.clickMyMedical()
        !5.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
        expect(getSecondaryHeader()).to eq("My Medical")

        @mymedical.clickHospitalizations()
        !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Hospitalizations")
    end

    after(:all) do
        quitDriver()
    end

    it "AC #JRNL-3306|TC #JRNL-2775: 1.  When the user views the Hospitalizations Table list, an Add button (+ icon, alt text Add), is available in the upper right corner of the Detail screen." do
        expect(@common.isAddButtonVisible()).to be true
    end

    it "AC #JRNL-3306|TC #JRNL-2775: a.  When a user selects Add, the Add Hospitalizations screen is shown, header:  Add Hospitalization Entry", :broken => true do
        @common.clickAddButton()
        !5.times{ break if (getPrimaryHeader() == "Add Hospitalization Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Add Hospitalization Entry")

        expect(@hospitalizations.getStartDate()).to eq("")
        expect(@hospitalizations.getEndDate()).to eq("")

        expect(@hospitalizations.isDeleteButtonVisible()).to be false
        expect(@hospitalizations.isCancelButtonVisible()).to be true
        expect(@hospitalizations.isSaveButtonVisible()).to be true

        hospitalizationForm = @hospitalizations.getScreenContent().split("\n")
        @INITIAL_ENTRY_FORM.each_with_index do | expectedScreenRow, i |
            #DEBUG puts "checking [#{hospitalizationForm[i]}] with [#{expectedScreenRow}]"
            expect(hospitalizationForm[i]).to eq(expectedScreenRow)
        end
        expect(hospitalizationForm.length).to eq(@INITIAL_ENTRY_FORM.length)
    end

    it "AC #JRNL-3306|TC #JRNL-2775: Required data: Start Date, End Date, Facility/Hospital", :broken => true do
        @hospitalizations.clickSaveButton()
        validateErrorMessages(["Start Date field is required.",
                               "End Date field is required.",
                               "Facility/Hospital field is required."])
    end

    it "AC #JRNL-3306|TC #JRNL-2775: a. Start Date (mm/dd/yyyy, date picker control, required) b. End Date (mm/dd/yyyy, date picker control, required) c. Start Date must be before End Date", :broken => true do
        @hospitalizations.setFacilityHospital("Chantilly Hospital")

        @hospitalizations.setStartDate("09/19/2014")
        @hospitalizations.setEndDate("07/17/2010")
        @hospitalizations.clickSaveButton()

        validateErrorMessages(["Start Date must occur before End Date."])    #Start Date > End Date should be error

        #Verify date picker for Start and End dates are on the screen
        @hospitalizations.clickStartDateCalendarBtn()
        !5.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(3, 24, 2014)
        expect(@hospitalizations.getStartDate()).to eq("03/24/2014")

        @hospitalizations.clickEndDateCalendarBtn()
        !5.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(4, 25, 2014)
        expect(@hospitalizations.getEndDate()).to eq("04/25/2014")
    end

    it "AC #JRNL-3306|TC #JRNL-2775: a.  Is this range estimated? Yes/No", :broken => true do
        expect(@hospitalizations.getIsRangeEstimated()).to be false

        @hospitalizations.setIsRangeEstimatedYes()
        expect(@hospitalizations.getIsRangeEstimated()).to be true

        @hospitalizations.setIsRangeEstimatedNo()
        expect(@hospitalizations.getIsRangeEstimated()).to be false

        @hospitalizations.setIsRangeEstimatedYes()
        expect(@hospitalizations.getIsRangeEstimated()).to be true
    end

    it "AC #JRNL-3306|TC #JRNL-2775: c.  Reason for Hospitalization (Text - 250 characters)", :broken => true do
        text99 = "12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789"
        @hospitalizations.setHospitalizationReason(text99)
        expect(@hospitalizations.getHospitalizationReason().length).to eq(99)
        expect(@hospitalizations.getHospitalizationReason()).to eq(text99)
        expect(@hospitalizations.getCountDownDisplayForReason()).to eq("151 characters left")

        text200 = "123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890123567890"
        @hospitalizations.setHospitalizationReason(text200)
        expect(@hospitalizations.getHospitalizationReason().length).to eq(200)
        expect(@hospitalizations.getHospitalizationReason()).to eq(text200)
        expect(@hospitalizations.getCountDownDisplayForReason()).to eq("50 characters left")

        text250 = text200 + "123567890123567890123567890123567890123567890"
        @hospitalizations.setHospitalizationReason(text250)
        expect(@hospitalizations.getHospitalizationReason().length).to eq(250)
        expect(@hospitalizations.getHospitalizationReason()).to eq(text250)
        expect(@hospitalizations.getCountDownDisplayForReason()).to eq("0 characters left")

        text251 = text250 + "x"
        @hospitalizations.setHospitalizationReason(text251)
        expect(@hospitalizations.getHospitalizationReason().length).to eq(250)
        expect(@hospitalizations.getHospitalizationReason()).to eq(text250)
        expect(@hospitalizations.getCountDownDisplayForReason()).to eq("0 characters left")
    end

    it "AC #JRNL-3306|TC #JRNL-2775: 1) Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header.  Updates made to the record are visible in the table, if included in that view.", :broken => true do
        @hospitalizations.setFacilityHospital("Mayo Clinic")

        @hospitalizations.clickSaveButton()
        !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Hospitalizations")

        expect(getCount()).to eq(1)

        text50 = "123567890123567890123567890123567890123567890"
        text100 = text50 + text50
        text250 = text100 + text100 + text50

        expectedText = ['Start Date', '03/24/2014', 'End Date', '04/25/2014', 'Facility', 'Mayo Clinic', 'Source', 'Self']
        expect(getTextForRowAsArray(1)).to eq (expectedText)

        #View details
        clickNthRow(1)
        !5.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

        expect(@hospitalizations.getStartDate()).to eq("03/24/2014")
        expect(@hospitalizations.getEndDate()).to eq("04/25/2014")
        expect(@hospitalizations.getIsRangeEstimated()).to be true
        expect(@hospitalizations.getSource()).to eq('Source: Self')
        expect(@hospitalizations.getFacilityHospital()).to eq("Mayo Clinic")
        expect(@hospitalizations.getHospitalizationReason).to eq(text250)

        @hospitalizations.clickCancelButton()
        !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Hospitalizations")
    end

    it "AC #JRNL-3306|TC #JRNL-2775: Save with minimum info", :broken => true do
        @common.clickAddButton()
        !5.times{ break if (getPrimaryHeader() == "Add Hospitalization Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Add Hospitalization Entry")

        @hospitalizations.setStartDate("02/10/2010")
        @hospitalizations.setEndDate("02/15/2010")
        @hospitalizations.setFacilityHospital("a")

        @hospitalizations.clickSaveButton()
        !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Hospitalizations")

        expect(getCount()).to eq(2)
        expectedText = ['Start Date', '02/10/2010', 'End Date', '02/15/2010', 'Facility', 'a', 'Source', 'Self']
        expect(getTextForRowAsArray(2)).to eq (expectedText)

        clickNthRow(2)
        !5.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

        expect(@hospitalizations.getStartDate()).to eq("02/10/2010")
        expect(@hospitalizations.getEndDate()).to eq("02/15/2010")
        expect(@hospitalizations.getIsRangeEstimated()).to be false
        expect(@hospitalizations.getSource()).to eq('Source: Self')
        expect(@hospitalizations.getFacilityHospital()).to eq("a")
        expect(@hospitalizations.getHospitalizationReason).to eq("")

        @hospitalizations.clickCancelButton()
        !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Hospitalizations")
    end

    it "AC #JRNL-3306|TC #JRNL-2775: Save duplicate ", :broken => true do
        @common.clickAddButton()
        !5.times{ break if (getPrimaryHeader() == "Add Hospitalization Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Add Hospitalization Entry")

        @hospitalizations.setStartDate("02/10/2010")
        @hospitalizations.setEndDate("02/15/2010")
        @hospitalizations.setFacilityHospital("a")

        @hospitalizations.clickSaveButton()
        !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Hospitalizations")

        expect(getCount()).to eq(3)

        #Duplicate - row 1
        expectedText = ['Start Date', '02/10/2010', 'End Date', '02/15/2010', 'Facility', 'a', 'Source', 'Self']
        expect(getTextForRowAsArray(2)).to eq (expectedText)

        clickNthRow(2)
        !5.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

        expect(@hospitalizations.getStartDate()).to eq("02/10/2010")
        expect(@hospitalizations.getEndDate()).to eq("02/15/2010")
        expect(@hospitalizations.getIsRangeEstimated()).to be false
        expect(@hospitalizations.getSource()).to eq('Source: Self')
        expect(@hospitalizations.getFacilityHospital()).to eq("a")
        expect(@hospitalizations.getHospitalizationReason()).to eq("")

        @hospitalizations.clickCancelButton()
        !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Hospitalizations")
        #Original - row 2
        expectedText2 = ['Start Date', '02/10/2010', 'End Date', '02/15/2010', 'Facility', 'a', 'Source', 'Self']

        !5.times{ break if (expectedText2 == getTextForRowAsArray(3)); sleep 1 }
        expect(getTextForRowAsArray(3)).to eq (expectedText2)

        clickNthRow(3)
        !5.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

        expect(@hospitalizations.getStartDate()).to eq("02/10/2010")
        expect(@hospitalizations.getEndDate()).to eq("02/15/2010")
        expect(@hospitalizations.getIsRangeEstimated()).to be false
        expect(@hospitalizations.getSource()).to eq('Source: Self')
        expect(@hospitalizations.getFacilityHospital()).to eq("a")
        expect(@hospitalizations.getHospitalizationReason()).to eq("")

        @hospitalizations.clickCancelButton()
        !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Hospitalizations")
    end

    it "AC #JRNL-3306|TC #JRNL-2775: b.  Facility/Hospital  (text, 100 characters, required)", :broken => true do
        #Putting max facility check at the end because on the Hospital List view, fac is too long
        #causing selenium to not able to get the 'Source' value on any of the entries
        @common.clickAddButton()
        !5.times{ break if (getPrimaryHeader() == "Add Hospitalization Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Add Hospitalization Entry")

        @hospitalizations.setStartDate("02/10/2010")
        @hospitalizations.setEndDate("02/15/2010")

        text50 = "123567890123567890123567890123567890123567890"
        text100 = text50 + text50
        text101 = text100 + "0"
        @hospitalizations.setFacilityHospital(text101)

        @hospitalizations.clickSaveButton()
        !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Hospitalizations")

        expect(getCount()).to eq(4)
        expectedText = ['Start Date', '02/10/2010', 'End Date', '02/15/2010', 'Facility', text100, 'Source', 'Self']
        expect(getTextForRowAsArray(2)).to eq (expectedText)

        clickNthRow(2)
        !5.times{ break if (getPrimaryHeader() == "Edit Hospitalization Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Edit Hospitalization Entry")

        expect(@hospitalizations.getStartDate()).to eq("02/10/2010")
        expect(@hospitalizations.getEndDate()).to eq("02/15/2010")
        expect(@hospitalizations.getIsRangeEstimated()).to be false
        expect(@hospitalizations.getSource()).to eq('Source: Self')
        expect(@hospitalizations.getFacilityHospital()).to eq(text100)
        expect(@hospitalizations.getHospitalizationReason()).to eq("")

        @hospitalizations.clickCancelButton()
        !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Hospitalizations")
    end

    it "AC #JRNL-3306|TC #JRNL-2775: 2) Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header", :broken => true do
        @common.clickAddButton()
        !5.times{ break if (getPrimaryHeader() == "Add Hospitalization Entry"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Add Hospitalization Entry")

        @hospitalizations.setStartDate("02/10/2010")
        @hospitalizations.setEndDate("02/15/2010")
        @hospitalizations.setFacilityHospital("a")

        @hospitalizations.clickCancelButton()
        !5.times{ break if (getPrimaryHeader() == "Hospitalizations"); sleep 1 }
        expect(getPrimaryHeader()).to eq("Hospitalizations")

        expect(getCount()).to eq(4)
    end

    #######################
    ### Local Functions ###
    #######################

    def validateErrorMessages(errors)
        expectedValidationSummaryHeader = errors.length > 0 ? "The following errors were found:" : ""
        sleep 1

        !5.times{ break if (@errorSummary.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
        expect(@errorSummary.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)

        if(expectedValidationSummaryHeader != "")
            for i in 0..(errors.length - 1)
                if errors[i] != nil
                    expect(@errorSummary.isErrorMessageDisplayed("form", errors[i])).to eq(true)
                else
                    expect(@errorSummary.isErrorMessageDisplayed("form", errors[i])).to eq(false)
                end
            end
        else
            expect(@errorSummary.isErrorSummaryElementPresent("form")).to eq(false)
        end
    end

end
=end