require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1959:  MyMedical_FamilyHistory_List_View_JRNL_1959_spec.rb]", :acceptance => true do

  list_view_header = "Family History"
  diagnosis_name_addscreen = "diagnosis1"
  diagnosis_name_listview = "diagnosis"
  name_name = "name"
  relative_name = "relative"
  relationship_name = "relationshipType"

  before(:all) do
    initializeConfigurations(BASE_URL)
    count = getTotalDocumentCountByPatientIdentifier("familyhistory", "medicalhistorydb", "EDIPI", "D123401")
    puts "Before importing failyHistoryList json count " + count.to_s
    removeCollection("familyhistory", "medicalhistorydb")
   # resetCollection("familyhistory", "medicalhistorydb", "familyHistoryList")
    count  = getTotalDocumentCountByPatientIdentifier("familyhistory", "medicalhistorydb", "EDIPI", "D123401")

    puts "After Imported List Count is " + count.to_s

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (@reminders.getTitle() == "My Medical"); sleep 1 }

  end

  after(:all) do
    quitDriver()
  end

  context 'AC#JRNL-1859|TC #JRNL-1748: Sub Feature Selection for Family History' do
    it ". 1.1. Verify that the sub feature label Family History is visibled and in the correct text" do
      expect(@nav_menu.isFamilyHistoryButtonVisible()).to eq(true)
      expect(@nav_menu.getFamilyHistoryButtonText()).to eq("Family History")
    end

    # Obsolete
    it ". 1.2. Verify that Family History is the 5th item on the list" do
      # 6th cause new items got added to the menu
      expect(@nav_menu.getNthSubFeatureName(8)).to eq("Family History")

    end

  end

  context 'AC#JRNL-1858|TC #JRNL-1748: Sub Feature Default View (Filter and Table List)' do
    it ". 2. Verify that List view header header is Family History" do

      @mymedical.clickFamilyHistory()
      !15.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
      expect(getPrimaryHeader()).to eq(list_view_header)

    end

    it ". 2.1.1 Verify that filter defaults to an expanded view. Filter button alt text reads Collapse Filter Options when expanded" do

      expect(isFilterButtonVisible()).to eq(true)
      expect(getFilterIconAriaLabel()).to eq("Collapse filter options")
      expect(isFilterExpanded()).to eq(true)

    end

    it ". 2.1.2 Verify when clicking on the Collapse filter icon, the filter icon alt text reads Expand Filter Options." do

      clickOnFilterIcon()
      expect(getFilterIconAriaLabel()).to eq("Expand filter options")

    end

    it ". 2.2. Verify that all Filter Options label names are displayed correctly" do

      clickOnFilterIcon()
      expect(getFilterOptionLabelText(MyMedical::DIAGNOSIS_LABEL)).to eq("Diagnosis:")
      expect(getFilterOptionLabelText(MyMedical::RELATIVE_NAME_LABEL)).to eq("Name:")
      expect(getFilterOptionLabelText(MyMedical::RELATIVE_LABEL)).to eq("Relative:")
      expect(getFilterOptionLabelText(MyMedical::RELATIONSHIP_TYPE_LABEL)).to eq("Relationship Type:")

    end

    it ". 2.2.3. Verify the Relative field has the following drop down values: Select, Mother, Father, Brother, Sister. And Select is set as default " do

      expect(areAllTheseValuesAvailableInDropDown("select[name='relative']", "Select,Mother,Father,Brother,Sister,Son,Daughter,Grandmother,Grandfather,Great Grandmother,Great Grandfather,Spouse,Niece,Nephew,Cousin,Other")).to eq(true)

    end

    it ". 2.2.4. Verify that the Relationship Type field has the following dorp down values: Select, Paternal, Maternal, Other" do

      expect(areAllTheseValuesAvailableInDropDown("select[name='relationshipType']", "Select,Paternal,Maternal,Other")).to eq(true)

    end

    it ". 2.3. Verify the Filter button text is Filter", :broken => true do

      expect(getFilterButtonLabel()).to eq("Filter")

    end

  end

  context 'AC#JRNL-1857|TC #JRNL-1748: Filter Action and Results Display for Family History' do
    it "Add Family History Entry", :broken => true do

     addFamilyHistory("Mother", "Bear", "Mother", "Paternal", ["High BP", "High Cholesterol", "MLS", "Tumor"])
     addFamilyHistory("Mother", "Maternal", "Mother", "Maternal", ["Diabetes"])
     addFamilyHistory("Mother", "Other", "Mother", "Other", ["Hypertension"])
     addFamilyHistory("Father", "Bear", "Father", "Paternal", ["Stroke"])
     addFamilyHistory("Father", "Maternal", "Father", "Maternal", [])
     addFamilyHistory("Father", "Other", "Father", "Other", [])
     addFamilyHistory("Brother", "Paternal", "Brother", "Paternal", ["Heartstroke"])
     addFamilyHistory("Brother", "Bear", "Brother", "Maternal", [])
     addFamilyHistory("Brother", "Other", "Brother", "Other", ["Brain infection", "Burn", "Diabetes", "Seizure"])
     addFamilyHistory("Sister", "Maternal", "Sister", "Maternal", [])
     addFamilyHistory("Son", "Other", "Son", "Other", ["Cystic Fibrosis"])
     addFamilyHistory("Daughter", "Maternal", "Daughter", "Maternal", [])
     addFamilyHistory("Grandmother", "Maternal", "Grandmother", "Maternal", [])
     addFamilyHistory("Grandfather", "Bear", "Grandfather", "Maternal", [])
     addFamilyHistory("Great Grandfather", "paternal", "Great Grandfather", "Paternal", [])
     addFamilyHistory("Spouse", "Maternal", "Spouse", "Maternal", [])
     addFamilyHistory("Spouse", "Other", "Spouse", "Other", [])
     addFamilyHistory("Niece", "Paternal", "Niece", "Paternal", [])
     addFamilyHistory("Niece", "Maternal", "Niece", "Maternal", [])
     addFamilyHistory("Nephew", "Paternal", "Nephew", "Paternal", ["Celiac Disease", "Pancreatitis"])
     addFamilyHistory("Nephew", "Maternal", "Nephew", "Maternal", [])
     addFamilyHistory("Nephew", "Other", "Nephew", "Other", [])
     addFamilyHistory("Cousin", "Paternal", "Cousin", "Paternal", [])

    end

    it ". 3.4.1. Verify that the returned results are displayed in the column of Name, Relative, Relationship Type and Diagnosis and verify that on the phone view Relative column is hidden", :broken => true do
      expect(getTableHeaders()).to eq(["Name", "Relative", "Relationship Type", "Diagnosis"])
      #Resizing the window to phone size.
      resizeWindowTo(320, 480)
      expect(getTableHeaders()).to eq(["Relative", "Diagnosis"])
      resizeWindowToDefault()

    end

    it ". 3.4.1. Verify that the Name field is formatted as Last Name, First Name. Also verify that the first three diagnoses are shown. Show text More if they are more than three.", :broken => true do

      expect(getTextForRowColumn(1, 1)).to eq("Bear, Mother")
      expect(getTextForRowColumn(1, 4)).to eq("High BP, High Cholesterol, MLS, more")

    end

    it ". 3.4. Verify that the returned results are sorted ascending by Name ", :broken => true do
      expect(getTextForRowColumn(1, 1)).to eq("Bear, Mother")
      expect(getTextForRowColumn(1, 2)).to eq("Mother")
      expect(getTextForRowColumn(1, 3)).to eq("Paternal")
      expect(getTextForRowColumn(1, 4)).to eq("High BP, High Cholesterol, MLS, more")

      expect(getTextForRowColumn(4, 1)).to eq("Bear, Father")
      expect(getTextForRowColumn(4, 2)).to eq("Father")
      expect(getTextForRowColumn(4, 3)).to eq("Paternal")
      expect(getTextForRowColumn(4, 4)).to eq("Stroke")

      expect(getTextForRowColumn(9, 1)).to eq("Other, Brother")
      expect(getTextForRowColumn(9, 2)).to eq("Brother")
      expect(getTextForRowColumn(9, 3)).to eq("Other")
      expect(getTextForRowColumn(9, 4)).to eq("Brain infection, Burn, Diabetes, more")

      expect(getTextForRowColumn(20, 1)).to eq("Paternal, Nephew")
      expect(getTextForRowColumn(20, 2)).to eq("Nephew")
      expect(getTextForRowColumn(20, 3)).to eq("Paternal")
      expect(getTextForRowColumn(20, 4)).to eq("Celiac Disease, Pancreatitis")

      expect(getTextForRowColumn(23, 1)).to eq("Paternal, Cousin")
      expect(getTextForRowColumn(23, 2)).to eq("Cousin")
      expect(getTextForRowColumn(23, 3)).to eq("Paternal")
      expect(getTextForRowColumn(23, 4)).to eq("")

    end

    it ". 3.5. Verify that null values are shown as empty table cells unless otherwise noted", :broken => true do

      #Edit the entry by removing the diagnosis then Save
      clickNthRow(5)
      !15.times{ break if (@entryForm.isSaveButtonVisible() == true); sleep 1 }
      clearField(diagnosis_name_addscreen)
      @entryForm.clickSaveButton()
      #Verify it displays a blank at Diagnosis
      expect(getTextForRowColumn(5, 4)).to eq("")
    end

    it ". 3.2. Verify that when there are no search criteria provided, it returns all the results", :broken => true do

      clickFilterButton()
      expect(getCount()).to eq(23)

    end

    it ". 3.1. When a user selects the filter button, the system updates the table view to show records that match the filter options entered. ", :broken => true do

      #Test search by Diagnosis field
      verifyFilterReturnsCorrectResults("H", diagnosis_name_listview, 4, 3)
      clearField(diagnosis_name_listview)
      clickFilterButton()

      puts "Story JRNL-1674|AC JRNL-1584: When searching using the diagnosis field, internal as well as initial string matches are returned"
      verifyFilterReturnsCorrectResults("p", diagnosis_name_listview, 4, 3)
      clearField(diagnosis_name_listview)
      clickFilterButton()

      #Test search by Name field
      verifyFilterReturnsCorrectResults("Bear", name_name, 1, 4)
      clearField(name_name)
      clickFilterButton()

      #Test search by Relative field
      verifyFilterReturnsCorrectResults("Mother", relative_name, 2, 3)
      #Negative testing: search by Relative drop down
      searchReturnedNoResult("Other", relative_name)
      clearField(relative_name)
      clickFilterButton()

      #Test search by Relationship field
      setValueAndClickFilter("Paternal", relationship_name)
      expect(getTextForRowColumn(1, 2)).to eq("Mother")
      expect(getTextForRowColumn(2, 2)).to eq("Father")
      #Negative testing: search by Relative drop down
      setValueAndClickFilter("Bear1", name_name)
      searchReturnedNoResult("Other", relationship_name)

    end

    it "Story JRNL-1696|AC JRNL-1583: Reset Button", :broken => true do
        expect(isResetButtonPresent()).to eq(true)
        expect(getResetButtonLabel()).to eq("Reset")

        clickResetBtn()
        !30.times { break if (getFocusedElementText().include?("Name")); sleep 1 }
        expect(getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
        expect(getCount()).to eq(23)

        # DEFAULTS
        expect(getTextFromInput(:css, "input[name='#{diagnosis_name_listview}']")).to eq("")
        expect(getTextFromInput(:css, "input[name='#{name_name}']")).to eq("")
        expect(getTextFromInput(:css, "select[name='#{relative_name}']")).to eq("")
        expect(getTextFromInput(:css, "select[name='#{relationship_name}']")).to eq("")
    end

    it ". 3.5. Verify that when there are no results returned, the text is displayed correctly", :broken => true do
      setValueAndClickFilter("Bear2", name_name)
      searchReturnedNoResult("Other", relationship_name)

      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
    end

  end

  ####### Local Functions #########

  def setValueAndClickFilter(text, fieldName)

    initalCount = getCount()
    #puts "initalCount=" + initalCount.to_s
    editField(fieldName, text)
    clickFilterButton()
    #puts "getCount()=" + getCount().to_s
    !10.times{ break if (((getCount() <= initalCount) and (getCount() != 0)) or getNoResultsFoundMessage() == "No results were found with the current filters. Use the Add button above to create a new record."); sleep 1 }

  end

  def verifyFilterReturnsCorrectResults(text, fieldName, column, totalCount)

    setValueAndClickFilter(text, fieldName)

    #Verify all returned records do have text in the field
    expect(isThisTextInTheSearchField(text, column)).to eq(true)
    #Verify that all that should have returned returned and no more left
    expect(getCount()).to eq(totalCount)

  end

  def searchReturnedNoResult(text, fieldName)

    setValueAndClickFilter(text, fieldName)
    expect(getCount()).to eq(0)

  end

  def addFamilyHistory(firstName, lastName, relative, relationShipType, diagnosisArr)
    entryCount = getCount
    @common.clickAddButton()
    waitForPageToFinishLoading()
    expect(getPrimaryHeader()).to eq("Add Family History Entry")

    setEntryValues({
                       MyMedical::FIRST_NAME=> firstName,
                       MyMedical::LAST_NAME=> lastName,
                       MyMedical::RELATIVE=> relative,
                       MyMedical::RELATIONSHIP_TYPE=> relationShipType
                   });

    diagnosisCount = diagnosisArr.size

    if(diagnosisCount > 0)
      #Add diagnosis
      expect(isElementVisible(:css, "button[ng-click='addDiagnosis()']")).to eq(true)


      for i in 0..(diagnosisCount -1)
        #Click Add Time button to add a time
        @mymedical.setDiagnosis(diagnosisArr[i], "input[name='diagnosis#{(i + 1).to_s}']")

        @mymedical.clickAddDiagnosis

      end
    end

    @common.clickSaveButton()
    waitForPageToFinishLoading()
    !15.times{ break if (getPrimaryHeader() == "Family History"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Family History")

    !15.times{ break if (getCount == entryCount + 1); sleep 1 }
  end

end