require_relative '../../../globalized'
include Globalized

describe "Story# JRNL-1958: [Family_History_Add_Edit_Delete_MVAH_1777_spec.rb]", :acceptance => true  do


    list_view_header = "Family History"
    first_name = "firstName"
    last_name = "lastName"
    diagnosis = "diagnosis1"

    before(:all) do
        initializeConfigurations(BASE_URL)
        removeCollection("familyhistory", "medicalhistorydb")
        initializeAllObjects

        @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
        expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

        @main.clickNavMenu()
        !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
        expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
        waitForPageToFinishLoading
        @driver.find_element(:css, "button[id='MyMedical']").click
        waitForPageToFinishLoading
        !5.times{ break if (@reminders.getTitle() == "My Medical"); sleep 1 }
        waitForPageToFinishLoading
        @driver.find_element(:css, "button[class='btn btn-default family-history']").click
        waitForPageToFinishLoading
        !5.times{ break if (@reminders.getPrimaryHeader() == list_view_header); sleep 1 }
        expect(@reminders.getPrimaryHeader()).to eq(list_view_header)
    end

    # after(:all) do
    #     quitDriver()
    # end

    context 'AC #JRNL-1855 |TC #JRNL-1747: Add New Entry for Family History' do

        it "When a user selects Add, the Add Family History screen is shown, header: Add Family History Entry." do
            expect(@common.isAddButtonVisible()).to eq(true)
            @common.clickAddButton()
            !5.times{ break if (isElementVisible(:css, "[name='Notes'] .input-label-content") == true); sleep 1 }
            expect(getPrimaryHeader()).to eq("Add Family History Entry")
        end

        it "Family History Detail View", :broken => true do
            #Clicking Save and Validating Error Messages
            waitForPageToFinishLoading
            @entry_form.clickSaveButton()
            !5.times{ break if (@error.getValidationSummaryHeader("form") == "The following errors were found:"); sleep 1 }
            expect(@error.getValidationSummaryHeader("form")).to eq("The following errors were found:")
            expect(@error.isErrorMessageDisplayed("form", "First Name field is required.")).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", "Last Name field is required.")).to eq(true)
            expect(@error.isErrorMessageDisplayed("form", "Relationship Type field is required.")).to eq(true)

            #Verifying Field Labels and Max Characters Allowed

            #First Name
            expect(getShortFieldLabel(first_name, true)).to eq("First Name:")
            textareaMaxLengthTest(first_name, 50, false)

            #Last Name
            expect(getShortFieldLabel(last_name, true)).to eq("Last Name:")
            textareaMaxLengthTest(last_name, 50, false)

            #Relationship Type
            expect(isFieldRequired(:css, "select[name='relationshipType']")).to eq(true)
            expect(areAllTheseValuesAvailableInDropDown("select[name='relationshipType']", "Select,Paternal,Maternal,Other"))

            #Date of Birth
            expect(isFieldRequired(:css, "[name='dateOfBirth'] input")).to eq(false)
            expect(getPlaceHolderByCSS(:css, "[name='dateOfBirth'] input")).to eq("MM/DD/YYYY")

            #Verifying Date of Birth cannot be future date
            today = getDateNthDaysFromNow(0, "%m/%d/%Y")
            futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
            setDate(futureDate, "[name='dateOfBirth'] input")
            @entry_form.clickSaveButton()
            !5.times{ break if (@error.getValidationSummaryHeader("form") == "The following errors were found:"); sleep 1 }
            expect(@error.getValidationSummaryHeader("form")).to eq("The following errors were found:")
            if Time.new.year.to_s != futureDate[-4..-1]
                expect(@error.isErrorMessageDisplayed("form", "Date of Birth must be formatted MM/DD/YYYY.")).to eq(true)
            else
                expect(@error.isErrorMessageDisplayed("form", "Date of Birth must be between 01/01/1900 and " +today +".")).to eq(true)
            end
            #Diagnosis and Year fields
            expect(isFieldRequired(:css, "input[name='diagnosis1']")).to eq(false)
            textareaMaxLengthTest(diagnosis, 50, false)
        end

        it "Add Diagnosis", :broken => true do
            expect(isElementVisible(:css, "button[ng-click='addDiagnosis()']")).to eq(true)

            @driver.find_element(:css, "input[name='diagnosis1']").clear
            @driver.find_element(:css, "input[name='diagnosis1']").send_keys "Hypertension"
            @driver.find_element(:css, "input[class='form-control date-input ng-pristine ng-untouched ng-empty ng-valid-maxlength ng-valid ng-valid-required']").send_keys "2001"
            waitForPageToFinishLoading

            @driver.find_element(:css, "button[ng-click='addDiagnosis()']").click
            @driver.find_element(:css, "input[name='diagnosis2']").send_keys "Cardiac"
            @driver.find_element(:css, "input[class='form-control date-input ng-pristine ng-untouched ng-empty ng-valid-maxlength ng-valid ng-valid-required']").send_keys "2002"
            waitForPageToFinishLoading

            @driver.find_element(:css, "button[ng-click='addDiagnosis()']").click
            @driver.find_element(:css, "input[name='diagnosis3']").send_keys "Blood Pressure"
            @driver.find_element(:css, "input[class='form-control date-input ng-pristine ng-untouched ng-empty ng-valid-maxlength ng-valid ng-valid-required']").send_keys "2003"
            waitForPageToFinishLoading

            @driver.find_element(:css, "button[ng-click='addDiagnosis()']").click
            @driver.find_element(:css, "input[name='diagnosis4']").send_keys "Common Cold"
            @driver.find_element(:css, "input[class='form-control date-input ng-pristine ng-untouched ng-empty ng-valid-maxlength ng-valid ng-valid-required']").send_keys "2004"
            waitForPageToFinishLoading

            @driver.find_element(:css, "textarea[name='Notes']").clear

            @driver.find_element(:css, "button[ng-click='addDiagnosis()']").click
            @driver.find_element(:css, "input[name='diagnosis5']").send_keys "Broken foot"
            @driver.find_element(:css, "input[class='form-control date-input ng-pristine ng-untouched ng-empty ng-valid-maxlength ng-valid ng-valid-required']").send_keys "2005"
            waitForPageToFinishLoading

            @driver.find_element(:css, "button[ng-click='addDiagnosis()']").click
            @driver.find_element(:css, "input[name='diagnosis6']").send_keys "Face lift"
            @driver.find_element(:css, "input[class='form-control date-input ng-pristine ng-untouched ng-empty ng-valid-maxlength ng-valid ng-valid-required']").send_keys "2006"
            waitForPageToFinishLoading

            @driver.find_element(:css, "button[ng-click='addDiagnosis()']").click
            @driver.find_element(:css, "input[name='diagnosis7']").send_keys "Swimmers Ear"
            @driver.find_element(:css, "input[class='form-control date-input ng-pristine ng-untouched ng-empty ng-valid-maxlength ng-valid ng-valid-required']").send_keys "2007"
            waitForPageToFinishLoading

            @driver.find_element(:css, "button[ng-click='addDiagnosis()']").click
            @driver.find_element(:css, "input[name='diagnosis8']").send_keys "Flu"
            @driver.find_element(:css, "input[class='form-control date-input ng-pristine ng-untouched ng-empty ng-valid-maxlength ng-valid ng-valid-required']").send_keys "2008"
            waitForPageToFinishLoading

            @driver.find_element(:css, "button[ng-click='addDiagnosis()']").click
            @driver.find_element(:css, "input[name='diagnosis9']").send_keys "Smallpox"
            @driver.find_element(:css, "input[class='form-control date-input ng-pristine ng-untouched ng-empty ng-valid-maxlength ng-valid ng-valid-required']").send_keys "2009"
            waitForPageToFinishLoading

            @driver.find_element(:css, "button[ng-click='addDiagnosis()']").click
            @driver.find_element(:css, "input[name='diagnosis10']").send_keys "Smoker"
            @driver.find_element(:css, "input[class='form-control date-input ng-pristine ng-untouched ng-empty ng-valid-maxlength ng-valid ng-valid-required']").send_keys "2010"
            waitForPageToFinishLoading

            #Add Diagnosis Button disappears after 10 entries
            expect(is_element_present(:css, "button[ng-click='addDiagnosis()']")).to eq(false)
        end

        it "Current Status of Relative", :broken => true do
            expect(isFieldRequired(:css, "select[name='outcome']")).to eq(false)
            expect(areAllTheseValuesAvailableInDropDown("select[name='outcome']", "Select,Living,Deceased,Unknown"))

            #Date of Death not present when nothing is selected
            expect(is_element_present(:css, "date-control[name='deceasedDate']")).to eq(false)

            #Date of Death is present when "Deceased" is selected
            @driver.find_element(:css, "select[name='outcome']").send_keys "Deceased"
            waitForPageToFinishLoading
            #expect(is_element_present(:css, "date-control[name='deceasedDate']")).to eq(true)
        end

        it "Note" do
            expect(isFieldRequired(:css, "textarea[name='Notes']")).to eq(false)
            textareaMaxLengthTest("Notes", 250, true)
        end

        it "Save and Cancel Buttons", :broken => true do
            expect(is_element_present(:css, "button[ng-click='confirmSave()']")).to eq(true)
            expect(is_element_present(:css, "button[ng-click='cancel()']")).to eq(true)

            @common.clickCancelButton()
            waitForPageToFinishLoading()
            !5.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
            expect(getPrimaryHeader()).to eq(list_view_header)
        end

    end

    context 'AC #JRNL-1854 |TC #JRNL-1747: Save and then Edit Family History Entry' do

        it "Save Family History Entry", :broken => true do
            waitForPageToFinishLoading
            @common.clickAddButton()
            waitForPageToFinishLoading
            #Completing Required Fields and Saving and Verifying
            setEntryValues({
                               MyMedical::FIRST_NAME => "John",
                               MyMedical::LAST_NAME => "Doe",
                               MyMedical::RELATIONSHIP_TYPE => "Father"
                           });

            @entry_form.clickSaveButton()
            waitForPageToFinishLoading()
            !15.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
            expect(getPrimaryHeader()).to eq(list_view_header)

            waitForPageToFinishLoading()

            expect(getTextForRowColumn(1,1)).to eq("John Doe")
        end

        it "Edit, Cancel and Edit, Save Family History Entry", :broken => true do
            #Editing Previously Saved Entry and Cancelling without Saving and Verifying
            #clickNthRow(1)
            @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[3]/list-table/div/div/ul/li[1]/span[4]").click
            waitForPageToFinishLoading
            setEntryValues({
                               MyMedical::FIRST_NAME=> "Matt",
                               MyMedical::LAST_NAME=> "Foley",
                               MyMedical::RELATIONSHIP_TYPE=> "Father"
                           });

            @common.clickCancelButton()
            waitForPageToFinishLoading()
            !5.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
            expect(getPrimaryHeader()).to eq(list_view_header)

            expect(getTextForRowColumn(1,1)).to eq("John Doe")

            #Editing Previously Saved Entry and Saving changes and Verifying
            #clickNthRow(1)
            @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[3]/list-table/div/div/ul/li[1]/span[4]").click
            setEntryValues({
                               MyMedical::FIRST_NAME=> "Matt",
                               MyMedical::LAST_NAME=> "Foley",
                               MyMedical::RELATIONSHIP_TYPE=> "Father"
                           });

            @entry_form.clickSaveButton()
            waitForPageToFinishLoading()
            !5.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
            expect(getPrimaryHeader()).to eq(list_view_header)

            expect(getTextForRowColumn(1,1)).to eq("Matt Foley")
        end

    end

    context 'AC #JRNL-1853 |TC #JRNL-1747: Delete Family History Entry' do

        it "Deleting a Family History Entry", :broken => true do
            #clickNthRow(1)
            @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[3]/list-table/div/div/ul/li[1]/span[4]").click
            waitForPageToFinishLoading

            #Verifying Delete button is Present
            expect(is_element_present(:css, "button[ng-click='delete()']")).to eq(true)

            #Deleting the Entry
            @common.clickDeleteButton()
            waitForPageToFinishLoading
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            #expect(@reminders.getModalBody()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
            @modal.clickNoButton()
            @entry_form.clickDeleteButton()
            @modal.clickYesButton()

            !5.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
            expect(getPrimaryHeader()).to eq(list_view_header)

            #Verifying the table is empty
            expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        end

    end

    context 'AC #JRNL-1852 |TC #JRNL-1747: Navigation for Family History' do

        it "Verifying '<' button is present for Add View and it functions as expected", :broken => true do
            waitForPageToFinishLoading
            @common.clickAddButton()
            waitForPageToFinishLoading()
            expect(getPrimaryHeader()).to eq("Add Family History Entry")

            #Verifying '<' button is present
            expect(is_element_present(:css, "button[ng-click='goBack()']")).to eq(true)

            #Clicking '<' button without any changes to return to the table view
            @common.clickBackButton()

            !5.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
            expect(getPrimaryHeader()).to eq(list_view_header)

            #Verifying No Results Message
            expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")

            #Verifying '<' button functionality after making changes on Add Screen
            waitForPageToFinishLoading
            @common.clickAddButton()
            waitForPageToFinishLoading()
            expect(getPrimaryHeader()).to eq("Add Family History Entry")

            setEntryValues({
                               MyMedical::FIRST_NAME=> "Hunter",
                               MyMedical::LAST_NAME=> "Pence",
                               MyMedical::RELATIONSHIP_TYPE=> "Mother"
                           });

            @common.clickBackButton()

            #Verifying Modal Popup
            #expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            #expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")

            #Clicking Return to go back to Add View
            @modal.clickReturnButton()
            expect(getPrimaryHeader()).to eq("Add Family History Entry")

            #Clicking '<' button and continuing
            @entry_form.clickBackButton()
            @modal.clickContinueButton()

            waitForPageToFinishLoading()

            !5.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
            expect(getPrimaryHeader()).to eq(list_view_header)

            #Verifying no results message to check nothing was added
            expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        end

        it "Verifying '<' button is present for Edit View and it functions as expected", :broken => true do
            #Adding and Saving an Entry to Edit
            waitForPageToFinishLoading
            @common.clickAddButton()
            waitForPageToFinishLoading
            expect(getPrimaryHeader()).to eq("Add Family History Entry")

            setEntryValues({
                               MyMedical::FIRST_NAME=> "Hunter",
                               MyMedical::LAST_NAME=> "Pence",
                               MyMedical::RELATIONSHIP_TYPE=> "Brother"
                           });
            waitForPageToFinishLoading
            @entry_form.clickSaveButton()
            waitForPageToFinishLoading
            expect(getTextForRowColumn(1,1)).to eq("Hunter Pence")

            #Clicking on the Saved entry to open it in Edit View
            #clickNthRow(1)
            @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[3]/list-table/div/div/ul/li[1]/span[4]").click
            #expect(getPrimaryHeader()).to eq("Edit Family History Entry")

            #Verifying '<' button is present
            expect(is_element_present(:css, "button[ng-click='goBack()']")).to eq(true)

            #Clicking '<' button without any changes to return to the table view
            @common.clickBackButton()
            waitForPageToFinishLoading()

            !5.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
            expect(getPrimaryHeader()).to eq(list_view_header)

            #Verifying no changes were made
            expect(getTextForRowColumn(1,1)).to eq("Hunter Pence")

            #Clicking on the Saved entry one more time to open it in Edit View
            waitForPageToFinishLoading
            @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div[3]/list-table/div/div/ul/li[1]/span[4]").click
            waitForPageToFinishLoading
            expect(getPrimaryHeader()).to eq("Edit Family History Entry")

            #Making changes and clicking the '<' button

            setEntryValues({
                               MyMedical::FIRST_NAME=> "Jane",
                               MyMedical::LAST_NAME=> "Doe",
                               MyMedical::RELATIONSHIP_TYPE=> "Sister"
                           });

            @common.clickBackButton()

            #Verifying Modal Popup
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")

            #Clicking Return to go back to Edit View
            @modal.clickReturnButton()
            expect(getPrimaryHeader()).to eq("Edit Family History Entry")

            #Clicking '<' button and continuing
            @entry_form.clickBackButton()
            @modal.clickContinueButton()

            waitForPageToFinishLoading

            !5.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
            expect(getPrimaryHeader()).to eq(list_view_header)

            #Verifying no changes were made
            expect(getTextForRowColumn(1,1)).to eq("Hunter Pence")
        end
     end
end















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "Story# JRNL-1958: [Family_History_Add_Edit_Delete_MVAH_1777_spec.rb]", :acceptance => true  do


  list_view_header = "Family History"
  first_name = "firstName"
  last_name = "lastName"
  diagnosis = "diagnosis1"

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("familyhistory", "medicalhistorydb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !5.times{ break if (@reminders.getTitle() == "My Medical"); sleep 1 }

    @mymedical.clickFamilyHistory()
    !5.times{ break if (@reminders.getPrimaryHeader() == list_view_header); sleep 1 }
    expect(@reminders.getPrimaryHeader()).to eq(list_view_header)
  end

  after(:all) do
    quitDriver()
  end

  context 'AC #JRNL-1855 |TC #JRNL-1747: Add New Entry for Family History' do

    it "When a user selects Add, the Add Family History screen is shown, header: Add Family History Entry." do
      expect(@common.isAddButtonVisible()).to eq(true)
      @common.clickAddButton()
      !5.times{ break if (isElementVisible(:css, "[name='Notes'] .input-label-content") == true); sleep 1 }
      expect(getPrimaryHeader()).to eq("Add Family History Entry")
    end

    it "Family History Detail View", :broken => true do
      #Clicking Save and Validating Error Messages
      @common.clickSaveButton()
      !5.times{ break if (@error.getValidationSummaryHeader("form") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq("The following errors were found:")
      expect(@error.isErrorMessageDisplayed("form", "First Name field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Last Name field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Relative field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Relationship Type field is required.")).to eq(true)

      #Verifying Field Labels and Max Characters Allowed

      #First Name
      expect(getShortFieldLabel(first_name, true)).to eq("First Name:")
      textareaMaxLengthTest(first_name, 50, false)

      #Last Name
      expect(getShortFieldLabel(last_name, true)).to eq("Last Name:")
      textareaMaxLengthTest(last_name, 50, false)

      #Relative
      expect(isFieldRequired(:css, "select[name='Relative']")).to eq(true)
      expect(areAllTheseValuesAvailableInDropDown("select[name='Relative']", "Select,Mother,Father,Brother,Sister,Son,Daughter,Grandmother,Grandfather,Great Grandmother,Great Grandfather,Spouse,Niece,Nephew,Cousin,Other")).to eq(true)

      #Relationship Type
      expect(isFieldRequired(:css, "select[name='relationshipType']")).to eq(true)
      expect(areAllTheseValuesAvailableInDropDown("select[name='relationshipType']", "Select,Paternal,Maternal,Other"))

      #Date of Birth
      expect(isFieldRequired(:css, "[name='dateOfBirth'] input")).to eq(false)
      expect(getPlaceHolderByCSS(:css, "[name='dateOfBirth'] input")).to eq("MM/DD/YYYY")

      #Verifying Date of Birth cannot be future date
      today = getDateNthDaysFromNow(0, "%m/%d/%Y")
      futureDate = getDateNthDaysFromNow(1, "%m/%d/%Y")
      setDate(futureDate, "[name='dateOfBirth'] input")
      @common.clickSaveButton()
      !5.times{ break if (@error.getValidationSummaryHeader("form") == "The following errors were found:"); sleep 1 }
      expect(@error.getValidationSummaryHeader("form")).to eq("The following errors were found:")
      if Time.new.year.to_s != futureDate[-4..-1]
        expect(@error.isErrorMessageDisplayed("form", "Date of Birth must be formatted MM/DD/YYYY.")).to eq(true)
      else
        expect(@error.isErrorMessageDisplayed("form", "Date of Birth must be between 01/01/1900 and " +today +".")).to eq(true)
      end

      #Diagnosis and Year fields
      expect(isFieldRequired(:css, "input[name='diagnosis1']")).to eq(false)
      textareaMaxLengthTest(diagnosis, 50, false)
    end

    it "Add Diagnosis", :broken => true do
      expect(isElementVisible(:css, "button[ng-click='addDiagnosis()']")).to eq(true)
      #Add Diagnosis entries
      diagStr = Array.new
      diagStr[1] = "Hypertension"
      diagStr[2] = "Cardiac"
      diagStr[3] = "Blood Pressure"
      diagStr[4] = "Common Cold"
      diagStr[5] = "Broken foot"
      diagStr[6] = "Face lift"
      diagStr[7] = "Swimmers Ear"
      diagStr[8] = "Flu"
      diagStr[9] = "Smallpox"
      diagStr[10]= "Smoker"
      diagnosisEntryCount = @mymedical.getTotalDiagnosisEntries()
      @mymedical.setDiagnosis(diagStr[1], "input[name='diagnosis1']")

      for i in 2..10
        #Click Add Time button to add a time
        @mymedical.clickAddDiagnosis
        @mymedical.setDiagnosis(diagStr[i], "input[name='diagnosis#{i.to_s}']")
        !5.times{ break if (@mymedical.getTotalDiagnosisEntries() > diagnosisEntryCount); sleep 1 }
        expect(@mymedical.getTotalDiagnosisEntries()).to eq(i)
      end

      #Add Diagnosis Button disappears after 10 entries
      expect(is_element_present(:css, "button[ng-click='addDiagnosis()']")).to eq(false)
    end

    it "Current Status of Relative", :broken => true do
      expect(isFieldRequired(:css, "select[name='outcome']")).to eq(false)
      expect(areAllTheseValuesAvailableInDropDown("select[name='outcome']", "Select,Living,Deceased,Unknown"))

      #Date of Death not present when nothing is selected
      expect(is_element_present(:css, "date-control[name='deceasedDate']")).to eq(false)

      #Date of Death is present when "Deceased" is selected
      @mymedical.selectCurrentStatusofRelative("Deceased")
      expect(is_element_present(:css, "date-control[name='deceasedDate']")).to eq(true)
    end

    it "Note" do
      expect(isFieldRequired(:css, "textarea[name='Notes']")).to eq(false)
      textareaMaxLengthTest("Notes", 250, true)
    end

    it "Save and Cancel Buttons", :broken => true do
      expect(is_element_present(:css, "button[ng-click='save()']")).to eq(true)
      expect(is_element_present(:css, "button[ng-click='cancel()']")).to eq(true)

      @common.clickCancelButton()
      waitForPageToFinishLoading()
      !15.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
      expect(getPrimaryHeader()).to eq(list_view_header)
    end

  end

  context 'AC #JRNL-1854 |TC #JRNL-1747: Save and then Edit Family History Entry' do

    it "Save Family History Entry", :broken => true do
      @common.clickAddButton()
      waitForPageToFinishLoading()
      #Completing Required Fields and Saving and Verifying
      setEntryValues({
          MyMedical::FIRST_NAME => "John",
          MyMedical::LAST_NAME => "Doe",
          MyMedical::RELATIVE => "Brother",
          MyMedical::RELATIONSHIP_TYPE => "Paternal"
      });

      @common.clickSaveButton()
      waitForPageToFinishLoading()
      !15.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
      expect(getPrimaryHeader()).to eq(list_view_header)

      waitForPageToFinishLoading()

      expect(getTextForRowColumn(1,1)).to eq("Doe, John")
    end

    it "Edit, Cancel and Edit, Save Family History Entry", :broken => true do
      #Editing Previously Saved Entry and Cancelling without Saving and Verifying
      clickNthRow(1)
      setEntryValues({
          MyMedical::FIRST_NAME=> "Matt",
          MyMedical::LAST_NAME=> "Foley",
          MyMedical::RELATIVE=> "Cousin",
          MyMedical::RELATIONSHIP_TYPE=> "Maternal"
                     });

      @common.clickCancelButton()
      waitForPageToFinishLoading()
      !15.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
      expect(getPrimaryHeader()).to eq(list_view_header)

      expect(getTextForRowColumn(1,1)).to eq("Doe, John")

      #Editing Previously Saved Entry and Saving changes and Verifying
      clickNthRow(1)
      setEntryValues({
                         MyMedical::FIRST_NAME=> "Matt",
                         MyMedical::LAST_NAME=> "Foley",
                         MyMedical::RELATIVE=> "Cousin",
                         MyMedical::RELATIONSHIP_TYPE=> "Maternal"
                     });

      @common.clickSaveButton()
      waitForPageToFinishLoading()
      !15.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
      expect(getPrimaryHeader()).to eq(list_view_header)

      expect(getTextForRowColumn(1,1)).to eq("Foley, Matt")
    end

  end

  context 'AC #JRNL-1853 |TC #JRNL-1747: Delete Family History Entry' do

    it "Deleting a Family History Entry", :broken => true do
      clickNthRow(1)

      #Verifying Delete button is Present
      expect(is_element_present(:css, "button[ng-click='delete()']")).to eq(true)

      #Deleting the Entry
      @common.clickDeleteButton()
      expect(@reminders.getModalHeader()).to eq("Confirmation")
      expect(@reminders.getModalBody()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
      @modal.clickNoButton()
      @common.clickDeleteButton()
      @modal.clickYesButton()

      !15.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
      expect(getPrimaryHeader()).to eq(list_view_header)

      #Verifying the table is empty
      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
    end

  end

  context 'AC #JRNL-1852 |TC #JRNL-1747: Navigation for Family History' do

    it "Verifying '<' button is present for Add View and it functions as expected", :broken => true do
      @common.clickAddButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Add Family History Entry")

      #Verifying '<' button is present
      expect(is_element_present(:css, "button[ng-click='goBack()']")).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      @common.clickBackButton()

      !15.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
      expect(getPrimaryHeader()).to eq(list_view_header)

      #Verifying No Results Message
      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")

      #Verifying '<' button functionality after making changes on Add Screen
      @common.clickAddButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Add Family History Entry")

      setEntryValues({
                         MyMedical::FIRST_NAME=> "Hunter",
                         MyMedical::LAST_NAME=> "Pence",
                         MyMedical::RELATIVE=> "Nephew",
                         MyMedical::RELATIONSHIP_TYPE=> "Maternal"
                     });

      @common.clickBackButton()

      #Verifying Modal Popup
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      #Clicking Return to go back to Add View
      @modal.clickReturnButton()
      expect(getPrimaryHeader()).to eq("Add Family History Entry")

      #Clicking '<' button and continuing
      @common.clickBackButton()
      @modal.clickContinueButton()

      waitForPageToFinishLoading()

      !15.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
      expect(getPrimaryHeader()).to eq(list_view_header)

      #Verifying no results message to check nothing was added
      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
    end

    it "Verifying '<' button is present for Edit View and it functions as expected", :broken => true do
      #Adding and Saving an Entry to Edit
      @common.clickAddButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Add Family History Entry")

      setEntryValues({
                         MyMedical::FIRST_NAME=> "Hunter",
                         MyMedical::LAST_NAME=> "Pence",
                         MyMedical::RELATIVE=> "Nephew",
                         MyMedical::RELATIONSHIP_TYPE=> "Maternal"
                     });

      @common.clickSaveButton()
      waitForPageToFinishLoading()
      expect(getTextForRowColumn(1,1)).to eq("Pence, Hunter")

      #Clicking on the Saved entry to open it in Edit View
      clickNthRow(1)
      expect(getPrimaryHeader()).to eq("Edit Family History Entry")

      #Verifying '<' button is present
      expect(is_element_present(:css, "button[ng-click='goBack()']")).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      @common.clickBackButton()
      waitForPageToFinishLoading()

      !15.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
      expect(getPrimaryHeader()).to eq(list_view_header)

      #Verifying no changes were made
      expect(getTextForRowColumn(1,1)).to eq("Pence, Hunter")

      #Clicking on the Saved entry one more time to open it in Edit View
      clickNthRow(1)
      expect(getPrimaryHeader()).to eq("Edit Family History Entry")

      #Making changes and clicking the '<' button

      setEntryValues({
                         MyMedical::FIRST_NAME=> "Jane",
                         MyMedical::LAST_NAME=> "Doe",
                         MyMedical::RELATIVE=> "Sister",
                         MyMedical::RELATIONSHIP_TYPE=> "Maternal"
                     });

      @common.clickBackButton()

      #Verifying Modal Popup
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      #Clicking Return to go back to Edit View
      @modal.clickReturnButton()
      expect(getPrimaryHeader()).to eq("Edit Family History Entry")

      #Clicking '<' button and continuing
      @common.clickBackButton()
      @modal.clickContinueButton()

      waitForPageToFinishLoading()

      !15.times{ break if (getPrimaryHeader() == list_view_header); sleep 1 }
      expect(getPrimaryHeader()).to eq(list_view_header)

      #Verifying no changes were made
      expect(getTextForRowColumn(1,1)).to eq("Pence, Hunter")
    end

  end

end
=end