# encoding: utf-8
require_relative '../../../globalized'
include Globalized

describe '[Story #JRNL-1197: My Medical - Diagnosis Select From List]', :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("diagnosis", 'medicalhistorydb')

    initializeAllObjects

    @char50 = "abcdefghij1234567890ABCDEFGHIJ1234567890abcdefghij"

    @common.loginEndsOnLandingPage('zztest.patient01', 'patient01, zztest')
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == 'App Options'); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq('App Options')

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == 'My Medical'); sleep 1 }
    expect(getSecondaryHeader()).to eq('My Medical')

    @mymedical.clickDiagnoses
    waitForPageToFinishLoading()

    @common.clickAddButton()
    waitForPageToFinishLoading()
  end

  after(:all) do
    quitDriver()
  end

  describe 'AC JRNL-1174|TC JRNL-1150: Control Display for Diagnosis' do

    it "50 Character Max" do
      setTypeaheadField(@char50 + @char50)
      expect(@diagnoses.getDiagnosis()).to eq(@char50)
    end

    it "Label" do
      expect(getElement(:css,"span[name='diagnosisLabel']").text).to eq("Diagnosis:")
    end

    it "Guidance text" do
       expect(@diagnoses.getDiagnosisElement().attribute("placeholder")).to eq("Enter a Diagnosis")
    end

    it "Screen reader" do
       expect(@diagnoses.getDiagnosisElement().attribute("title")).to \
            eq("Type to enter a diagnosis name or select a name from the list provided. "+
               "List suggestions are provided after 3 characters are typed.")
    end

  end

  describe 'AC JRNL-1173|TC JRNL-1150: Type, Search and Sort Action for Diagnosis' do

    it "After 3 chars list displays", :broken => true do
      setTypeaheadField( "a")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }
      expect(isElementVisible(:css, getSelectListCSS())).to eq(false)

      setTypeaheadField("as")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }
      expect(isElementVisible(:css, getSelectListCSS())).to eq(false)

      setTypeaheadField( "ast")
      !3.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }
      expect(isElementVisible(:css, getSelectListCSS())).to eq(true)
      expect(getSelectListCount()).to be > 0
    end

    it "List sort", :broken => true do
      setTypeaheadField("ast")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }

      expect(isElementVisible(:css, getSelectListCSS())).to eq(true)
      expect(getSelectListCount()).to be > 0

      startInternalMatch = 0

      #Find the point where beginning match changes to internal match
      selectionList = getSelectListText()
      for i in 0...getSelectListCount()
        if selectionList[i][0..2].upcase != "AST"
          startInternalMatch = i
          break
        end
      end

      expect(startInternalMatch).to be > 0
      expect(startInternalMatch).to be < getSelectListCount()-1

      #Verify no Beginning matches are in the bottom of list
      for i in startInternalMatch...getSelectListCount()
        expect(selectionList[i][0..2].upcase).to_not eq("AST")
      end
    end

    it "Refine match with more chars", :broken => true do
      setTypeaheadField( "ast")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }
      expect(isElementVisible(:css, getSelectListCSS())).to eq(true)

      threeCharMatchCount = getSelectListCount()

      setTypeaheadField( "asth")
      !5.times{ break if (getSelectListCount() < threeCharMatchCount); sleep 1 }

      expect(getSelectListCount()).to be > 0
      expect(getSelectListCount()).to be < threeCharMatchCount
    end

    it "Focus on input field" do
      expect(getActiveElement().attribute("name")).to eq("diagnosis")
    end

  end

  describe 'AC JRNL-1172|TC JRNL-1150: Selecting a List Value for Diagnosis' do

    it "Focus on first item and can navigate through list", :broken => true do
      setTypeaheadField( "dia")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }

      selectionList = getSelectList()
      selectListCount = getSelectListCount()
      for i in 0...selectListCount
        for j in 0...selectListCount
          if i == j
            expect(selectionList[j].attribute("class")).to eq("ng-scope active")
          else
            expect(selectionList[j].attribute("class")).to eq("ng-scope")
          end
        end
        typeaheadField.send_keys(:arrow_down)
        sleep 0.5
      end
    end

    it "Select term", :broken => true do
      #Wraparound to last selection
      typeaheadField().send_keys(:arrow_up)
      sleep 0.5

      currentlyHighlighted = getSelectListText[getSelectListCount()-1].strip

      typeaheadField.send_keys(:return)
      sleep 0.5

      expect(@diagnoses.getDiagnosis().strip).to eq(currentlyHighlighted)
    end

    it "Move to next field of focus", :broken => true do
      expect(getActiveElement().attribute("name")).to eq("diagnosis")

      typeaheadField.send_keys(:tab)
      sleep 0.5

      #Check focus is on next field
      expect(getActiveElement().attribute("name")).to eq("date")
    end

    it "SNOMED info stored", :broken => true do
      @diagnoses.setCurrentChecked()
      name = @diagnoses.getDiagnosis().strip

      @diagnoses.clickSaveButton()
      waitForPageToFinishLoading()
      sleep 4.0
      coding = getSNOMEDInfo("diagnosis", "medicalhistorydb", "", name)
      expect(coding["system"]).to  eq("http://snomed.info/sct")
      expect(coding["code"]).to    eq("65363002")
      expect(coding["display"]).to eq("Otitis media")
      expect(coding["version"]).to eq("20140931-US")
    end

  end

  context 'AC JRNL-1171|TC JRNL-1150: Entering a Verbatim Term for Diagnosis' do

    it "No match", :broken => true do
      @common.clickAddButton()
      waitForPageToFinishLoading()

      setTypeaheadField("asparx")
      !2.times{ break if (isElementVisible(:css, getSelectListCSS())); sleep 1 }
      expect(isElementVisible(:css, getSelectListCSS())).to eq(false)
    end

    it "Shift focus", :broken => true do
      setTypeaheadField(@char50)
      expect(getActiveElement().attribute("name")).to eq("diagnosis")

      typeaheadField.send_keys(:tab)
      sleep 0.5

      #Check focus is on next field
      expect(getActiveElement().attribute("name")).to eq("date")
    end

    it "Value Retained" do
      expect(@diagnoses.getDiagnosis()).to eq(@char50)
    end

    it "Save - Verbatim term - SNOMED info not stored" do
      @diagnoses.setCurrentChecked()

      @diagnoses.clickSaveButton()
      waitForPageToFinishLoading()
      sleep 4.0
      coding = getSNOMEDInfo('diagnosis', "medicalhistorydb", "", @char50)

      expect(coding).to eq([])
    end

  end

end