require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2468: Diagnoses List and Filter]", :acceptance => true do

  before(:all) do
    @DIAGNOSES_FILTER = [
        "Status:",
        "Current",
        "Past",
        "All",
        "Filter Reset"
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("diagnosis", "medicalhistorydb", "diagnoses")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")

    @mymedical.clickDiagnoses()
    !45.times{ break if (getPrimaryHeader() == "Diagnoses"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Diagnoses")
  end

  after(:all) do
    quitDriver()
  end

  context "AC #JRNL-2891|TC #MVAH-1680: (1) When a user selects Diagnoses from the My Medical feature, the system displays the Diagnoses filter and table list view in the Detail screen (header = Diagnoses) with the following components" do

    context "(a) Filter Feature" do

      it "(i) Filter defaults to an expanded view. Filter button alt text reads 'Collapse filter' when expanded.", :broken => true do
        expect(@diagnoses_filter.isFilterAccordionExpanded()).to be true

        diagnosesFilterForm = @diagnoses_filter.getScreenContent().split("\n")
        @DIAGNOSES_FILTER.each_with_index do | expectedScreenRow, i |
          expect(diagnosesFilterForm[i]).to eq(expectedScreenRow)
        end

        expect(@diagnoses_filter.getFilterAccordionAltText()).to eq("Collapse filter options")
      end

      it "(ii) Users can collapse the filter list by clicking on the Collapse filter icon.  When collapsed, the filter icon alt text reads Expand Filter.", :broken => true do
        @diagnoses_filter.clickFilterAccordion()
        expect(@diagnoses_filter.isFilterAccordionExpanded()).to be false
        expect(@diagnoses_filter.getFilterAccordionAltText()).to eq("Expand filter options")
      end

    end

    context "(b) Filter Options" do

      it "(i) Status (radio button, values: Current, Past, All, default to Current)", :broken => true do
        @diagnoses_filter.clickFilterAccordion()
        expect(@diagnoses_filter.getFilterHeader()).to eq("Status:")
        expect(@diagnoses_filter.getFilterRadioLabels()).to eq("Current\nPast\nAll")
        expect(@diagnoses_filter.isCurrentSelected()).to be true
        expect(@diagnoses_filter.isPastSelected()).to be false
        expect(@diagnoses_filter.isAllSelected()).to be false
      end

    end

    context "(c) Filter Button" do

      it "alt text = Filter", :broken => true do
        expect(@diagnoses_filter.getFilterButtonLabel()).to eq("Filter")
      end

      it "(i) Adding a value to any of the filter fields and selecting Filter button updates the table view to show records match the filter selections.", :broken => true do
        @diagnoses_filter.clickPastRadioButton()
        expect(@diagnoses_filter.isPastSelected()).to be true

        @diagnoses_filter.clickFilterBtn()
      end

      it "(iii) After the filter button is selected, the focus moves to the returned results, first row, or the No results found message.", :broken => true do
        !10.times{ break if (getFocusedElementText().include?("J Diagnosis")); sleep 1 }
        expect(getFocusedElementText()).to match("J Diagnosis")
        expect(getCount()).to eq(7)

        @diagnoses_filter.clickCurrentRadioButton()
        expect(@diagnoses_filter.isCurrentSelected()).to be true

        @diagnoses_filter.clickFilterBtn()
        !10.times{ break if (getFocusedElementText().include?("e Diagnosis")); sleep 1 }
        expect(getFocusedElementText()).to match("e Diagnosis")
        expect(getCount()).to eq(6)

        @diagnoses_filter.clickAllRadioButton()
        expect(@diagnoses_filter.isAllSelected()).to be true

        @diagnoses_filter.clickFilterBtn()
        !10.times{ break if (getFocusedElementText().include?("e Diagnosis")); sleep 1 }
        expect(getFocusedElementText()).to match("e Diagnosis")
        expect(getCount()).to eq(13)
      end

    end

  end

  context "AC #JRNL-2891|TC #MVAH-1680: (2) Diagnosis entries are displayed in a table format, sorted first by status with Current records shown before Past records, then sorted in reverse chronological order by Onset Date. Null values are shown as empty table cell. Records with a null onset date are shown at the bottom of their respective status group sorted alphabetically." do

      it "Verify table rows", :broken => true do
        expect(getTableHeaders()).to eq(["Diagnosis", "Date of Onset", "Status", "Source"])

        @diagnoses_filter.clickPastRadioButton()
        @diagnoses_filter.clickFilterBtn()
        !10.times{ break if (getFocusedElementText().include?("J Diagnosis")); sleep 1 }
        verifyDiagnosesList(getList(), getSortedDiagnosesByDiagnosis("Past"))
        expectedText1 = ['Diagnosis', 'J Diagnosis', 'Date of Onset', '10/06/2014','Status', 'Past', 'Source', 'Self']
        expect(getTextForRowAsArray(1)).to eq(expectedText1)

        expect(getTextForRowColumn(1, 1)).to eq("J Diagnosis")
        expect(getTextForRowColumn(1, 2)).to eq("10/06/2014")
        expect(getTextForRowColumn(1, 3)).to eq("Past")
        expect(getTextForRowColumn(1, 4)).to eq("Self")

        expect(getTextForRowColumn(2, 1)).to eq("G Diagnosis")
        expect(getTextForRowColumn(2, 2)).to eq("09/06/2014")
        expect(getTextForRowColumn(2, 3)).to eq("Past")
        expect(getTextForRowColumn(2, 4)).to eq("Self")

        expect(getTextForRowColumn(3, 1)).to eq("F Diagnosis")
        expect(getTextForRowColumn(3, 2)).to eq("")
        expect(getTextForRowColumn(3, 3)).to eq("Past")
        expect(getTextForRowColumn(3, 4)).to eq("Self")

        expect(getTextForRowColumn(4, 1)).to eq("H Diagnosis")
        expect(getTextForRowColumn(4, 2)).to eq("")
        expect(getTextForRowColumn(4, 3)).to eq("Past")
        expect(getTextForRowColumn(4, 4)).to eq("Self")

        expect(getTextForRowColumn(5, 1)).to eq("I Diagnosis")
        expect(getTextForRowColumn(5, 2)).to eq("")
        expect(getTextForRowColumn(5, 3)).to eq("Past")
        expect(getTextForRowColumn(5, 4)).to eq("Self")

        expect(getTextForRowColumn(6, 1)).to eq("k Diagnosis")
        expect(getTextForRowColumn(6, 2)).to eq("")
        expect(getTextForRowColumn(6, 3)).to eq("Past")
        expect(getTextForRowColumn(6, 4)).to eq("Self")

        expect(getTextForRowColumn(7, 1)).to eq("K Diagnosis")
        expect(getTextForRowColumn(7, 2)).to eq("")
        expect(getTextForRowColumn(7, 3)).to eq("Past")
        expect(getTextForRowColumn(7, 4)).to eq("Self")


        @diagnoses_filter.clickCurrentRadioButton()
        @diagnoses_filter.clickFilterBtn()
        !10.times{ break if (getFocusedElementText().include?("e Diagnosis")); sleep 1 }
        verifyDiagnosesList(getList(), getSortedDiagnosesByDiagnosis("Current"))
        expectedText2 = ['Diagnosis', 'e Diagnosis', 'Date of Onset', '11/06/2014', 'Status', 'Current', 'Source', 'Self']
        expect(getTextForRowAsArray(1)).to eq(expectedText2)

        expect(getTextForRowColumn(1, 1)).to eq("e Diagnosis")
        expect(getTextForRowColumn(1, 2)).to eq("11/06/2014")
        expect(getTextForRowColumn(1, 3)).to eq("Current")
        expect(getTextForRowColumn(1, 4)).to eq("Self")

        expect(getTextForRowColumn(2, 1)).to eq("E Diagnosis")
        expect(getTextForRowColumn(2, 2)).to eq("11/06/2014")
        expect(getTextForRowColumn(2, 3)).to eq("Current")
        expect(getTextForRowColumn(2, 4)).to eq("Self")

        expect(getTextForRowColumn(3, 1)).to eq("C Diagnosis")
        expect(getTextForRowColumn(3, 2)).to eq("08/06/2014")
        expect(getTextForRowColumn(3, 3)).to eq("Current")
        expect(getTextForRowColumn(3, 4)).to eq("Self")

        expect(getTextForRowColumn(4, 1)).to eq("A Diagnosis")
        expect(getTextForRowColumn(4, 2)).to eq("")
        expect(getTextForRowColumn(4, 3)).to eq("Current")
        expect(getTextForRowColumn(4, 4)).to eq("Self")

        expect(getTextForRowColumn(5, 1)).to eq("B Diagnosis")
        expect(getTextForRowColumn(5, 2)).to eq("")
        expect(getTextForRowColumn(5, 3)).to eq("Current")
        expect(getTextForRowColumn(5, 4)).to eq("Self")

        expect(getTextForRowColumn(6, 1)).to eq("D Diagnosis")
        expect(getTextForRowColumn(6, 2)).to eq("")
        expect(getTextForRowColumn(6, 3)).to eq("Current")
        expect(getTextForRowColumn(6, 4)).to eq("Self")

        @diagnoses_filter.clickAllRadioButton()
        @diagnoses_filter.clickFilterBtn()
        !10.times{ break if (getFocusedElementText().include?("A Diagnosis")); sleep 1 }
        verifyDiagnosesList(getList(), getSortedDiagnosesByDiagnosis("All"))

        expectedText3 = ['Diagnosis', 'e Diagnosis', 'Date of Onset', '11/06/2014', 'Status', 'Current', 'Source', 'Self']
        expect(getTextForRowAsArray(1)).to eq(expectedText3)

        expect(getTextForRowColumn(1, 1)).to eq("e Diagnosis")
        expect(getTextForRowColumn(1, 2)).to eq("11/06/2014")
        expect(getTextForRowColumn(1, 3)).to eq("Current")
        expect(getTextForRowColumn(1, 4)).to eq("Self")

        expect(getTextForRowColumn(2, 1)).to eq("E Diagnosis")
        expect(getTextForRowColumn(2, 2)).to eq("11/06/2014")
        expect(getTextForRowColumn(2, 3)).to eq("Current")
        expect(getTextForRowColumn(2, 4)).to eq("Self")

        expect(getTextForRowColumn(3, 1)).to eq("C Diagnosis")
        expect(getTextForRowColumn(3, 2)).to eq("08/06/2014")
        expect(getTextForRowColumn(3, 3)).to eq("Current")
        expect(getTextForRowColumn(3, 4)).to eq("Self")

        expect(getTextForRowColumn(4, 1)).to eq("A Diagnosis")
        expect(getTextForRowColumn(4, 2)).to eq("")
        expect(getTextForRowColumn(4, 3)).to eq("Current")
        expect(getTextForRowColumn(4, 4)).to eq("Self")

        expect(getTextForRowColumn(5, 1)).to eq("B Diagnosis")
        expect(getTextForRowColumn(5, 2)).to eq("")
        expect(getTextForRowColumn(5, 3)).to eq("Current")
        expect(getTextForRowColumn(5, 4)).to eq("Self")

        expect(getTextForRowColumn(6, 1)).to eq("D Diagnosis")
        expect(getTextForRowColumn(6, 2)).to eq("")
        expect(getTextForRowColumn(6, 3)).to eq("Current")
        expect(getTextForRowColumn(6, 4)).to eq("Self")

        expect(getTextForRowColumn(7, 1)).to eq("J Diagnosis")
        expect(getTextForRowColumn(7, 2)).to eq("10/06/2014")
        expect(getTextForRowColumn(7, 3)).to eq("Past")
        expect(getTextForRowColumn(7, 4)).to eq("Self")

        expect(getTextForRowColumn(8, 1)).to eq("G Diagnosis")
        expect(getTextForRowColumn(8, 2)).to eq("09/06/2014")
        expect(getTextForRowColumn(8, 3)).to eq("Past")
        expect(getTextForRowColumn(8, 4)).to eq("Self")

        expect(getTextForRowColumn(9, 1)).to eq("F Diagnosis")
        expect(getTextForRowColumn(9, 2)).to eq("")
        expect(getTextForRowColumn(9, 3)).to eq("Past")
        expect(getTextForRowColumn(9, 4)).to eq("Self")

        expect(getTextForRowColumn(10, 1)).to eq("H Diagnosis")
        expect(getTextForRowColumn(10, 2)).to eq("")
        expect(getTextForRowColumn(10, 3)).to eq("Past")
        expect(getTextForRowColumn(10, 4)).to eq("Self")

        expect(getTextForRowColumn(11, 1)).to eq("I Diagnosis")
        expect(getTextForRowColumn(11, 2)).to eq("")
        expect(getTextForRowColumn(11, 3)).to eq("Past")
        expect(getTextForRowColumn(11, 4)).to eq("Self")

        expect(getTextForRowColumn(12, 1)).to eq("k Diagnosis")
        expect(getTextForRowColumn(12, 2)).to eq("")
        expect(getTextForRowColumn(12, 3)).to eq("Past")
        expect(getTextForRowColumn(12, 4)).to eq("Self")

        expect(getTextForRowColumn(13, 1)).to eq("K Diagnosis")
        expect(getTextForRowColumn(13, 2)).to eq("")
        expect(getTextForRowColumn(13, 3)).to eq("Past")
        expect(getTextForRowColumn(13, 4)).to eq("Self")

      end

  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Present" do
      expect(@diagnoses_filter.isResetButtonPresent()).to eq(true)
    end

    it "Label" do
      expect(@diagnoses_filter.getResetButtonLabel()).to eq("Reset")
    end

    it "Result", :broken => true do
      @diagnoses_filter.clickResetBtn()
      !10.times { break if (@diagnoses_filter.getFocusedElementText().include?("Diagnosis")); sleep 1 }
      expect(@diagnoses_filter.getFocusedElementText()).to eq(getTextForRow(1) + "\n ")
      expect(getCount()).to eq(6)
      verifyDiagnosesList(getList(), getSortedDiagnosesByDiagnosis("Current"))

      # DEFAULT
      expect(@diagnoses_filter.isCurrentSelected()).to eq(true)
    end

  end

  context "AC #JRNL-2891|TC #MVAH-1680: (1) When a user selects Diagnoses from the My Medical feature, the system displays the Diagnoses filter and table list view in the Detail screen (header = Diagnoses) with the following components" do

      it "(ii) If no records are found when a filter is applied the message \"No results found.\" Is displayed in the screen area in place of the table view.", :broken => true do
        removeCollection("diagnosis", "medicalhistorydb")

        @diagnoses_filter.clickAllRadioButton()
        expect(@diagnoses_filter.isAllSelected()).to be true

        @diagnoses_filter.clickFilterBtn()
        puts "AC #JRNL-2891|TC #JRNL-2468: (c) Filter Button (iii) After the filter button is selected, the focus moves to the returned results, first row, or the No results found message."
        !10.times{ break if (getFocusedElementText().include?("No results were found with the current filters. Use the Add button above to create a new record.")); sleep 1 }
        expect(getFocusedElementText()).to match("No results were found with the current filters. Use the Add button above to create a new record.")
      end

  end

  #######################
  ### Local Functions ###
  #######################

  def getAllDiagnosesInDBSorted

    def sortDiagnosesKeys(x,y)
      return (x["diagnosis"].upcase() <=> y["diagnosis"].upcase())
    end

    return retreiveAllDocumentsInCollection("diagnoses", "medicalhistorydb").sort { |x, y| sortDiagnosesKeys(x,y) }
  end

  def getSortedDiagnosesByDiagnosis(status)
    #Given a status, extract the diagnoses that are in the db
    selectedDiagnoses = []
    getAllDiagnosesInDBSorted.each_with_index do |diagnosis_event, rowIndex|
      if status == "all" or status == "All"
        selectedDiagnoses << diagnosis_event
      elsif diagnosis_event["diagnosis"] == status
        selectedDiagnoses << diagnosis_event
      end
    end

    return selectedDiagnoses
  end

  def verifyDiagnosesList(screenList, dbList)
    dbList.each_with_index do |dbrow, i|
      screenRow = screenList[i]
      expect(screenRow[0]).to eq(dbrow['diagnosis'])
      expect(screenRow[1]).to eq(dbrow['onsetDate'].strftime('%m/%d/%Y'))
      expect(screenRow[2]).to eq(dbrow['status'])
      expect(screenRow[3]).to eq(dbrow['source'])
    end
  end

end