require_relative '../../../globalized'
include Globalized

describe "[Story JRNL-2467: Diagnoses Edit/Delete]", :broken => true, :regression => true  do

  before(:all) do
    @INITIAL_ENTRY_FORM = [ \
        "* required field",
        "* Diagnosis:",
        # JRNL-1197 changed 'Diagnosis' to a type-ahead input
        "Auto-complete input",
        # "50 character maximum",
        "Date of Onset:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Provider/Facility:",
        "100 character maximum",
        "* Status:",
        "Current",
        "Past",
        "Source: Self",
        "Note:",
        "250 character maximum",
        "243 characters left",
        "Save Delete Cancel",
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("diagnosis", "medicalhistorydb", "diagnoses")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    waitForPageToFinishLoading
    @driver.find_element(:id, "MyMedical").click
    waitForPageToFinishLoading
    !5.times{ break if (getSecondaryHeader == "My Medical"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Medical")

    @mymedical.clickDiagnoses
    !5.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
    expect(getPrimaryHeader).to eq("Diagnoses")

    #expect(getCount()).to eq(6)
  end

  # after(:all) do
  #   quitDriver()
  # end

  context "AC #JRNL-2893|TC #JRNL-2916: (1) When the user selects a Diagnosis entry from the table view, the system displays the Diagnosis record in the Detail screen in Edit mode." do

      it "(a) All fields available in add mode are shown." do
        clickNthRow(1)
        !5.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")
        !5.times{ break if (getFocusedElementText().include?("Edit Diagnosis")); sleep 1 }
        expect(getFocusedElementText()).to eq("Edit Diagnosis")

        expect(@diagnoses.getDiagnosis()).to eq("e Diagnosis")
        expect(@diagnoses.getOnsetDate()).to eq("11/06/2014")
        expect(@diagnoses.getProviderFacility()).to eq("A Provider")
        expect(@diagnoses.isCurrentChecked()).to be true
        expect(@diagnoses.isPastChecked()).to be false
        expect(@diagnoses.getNote()).to eq("My Note")

        diagnosesForm = @diagnoses.getScreenContent().split("\n")
        @INITIAL_ENTRY_FORM.each_with_index do | expectedScreenRow, i |
          expect(diagnosesForm[i]).to eq(expectedScreenRow)
        end
        expect(diagnosesForm.length).to eq(@INITIAL_ENTRY_FORM.length)
      end

      it "(b) Standard Edit functions are available (Save, Cancel, Delete)" do
        expect(@diagnoses.isDeleteButtonVisible()).to be true
        expect(@diagnoses.isCancelButtonVisible()).to be true
        expect(@diagnoses.isSaveButtonVisible()).to be true
      end

  end

  context "AC #JRNL-1862|TC #JRNL-2917: (2) Save, Cancel, Delete Functionality" do

      it "(2) Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        @diagnoses.setDiagnosis("SOME NEW DIAGNOSIS")
        @diagnoses.clickOnsetDateCalendarBtn()
        !5.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(3, 7, 1991)
        @diagnoses.setProviderFacility("Test Facility")
        @diagnoses.setPastChecked()
        @diagnoses.setNote("Test Note")

        @diagnoses.clickCancelButton()
        !5.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
        expect(getPrimaryHeader).to eq("Diagnoses")
        !5.times{ break if (getFocusedElementText().include?("Diagnoses")); sleep 1 }
        expect(getFocusedElementText()).to eq("Diagnoses")
      end

      it "(2) Cancel -  When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        expect(getCount()).to eq(6)

        clickNthRow(1)
        !5.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")

        expect(@diagnoses.getDiagnosis()).to eq("e Diagnosis")
        expect(@diagnoses.getOnsetDate()).to eq("11/06/2014")
        expect(@diagnoses.getProviderFacility()).to eq("A Provider")
        expect(@diagnoses.isCurrentChecked()).to be true
        expect(@diagnoses.isPastChecked()).to be false
        expect(@diagnoses.getNote()).to eq("My Note")
      end

      it "Validation" do
        @diagnoses.setDiagnosis("")
        @diagnoses.setOnsetDate("")
        @diagnoses.setProviderFacility("")
        @diagnoses.setNote("")
        @diagnoses.clickSaveButton()
        validateErrorMessages(["Diagnosis field is required."])
      end

      it "(1) Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view." do
        @diagnoses.setDiagnosis("SOME NEW DIAGNOSIS")

        @diagnoses.clickSaveButton()
        !5.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
        expect(getPrimaryHeader).to eq("Diagnoses")
        !5.times{ break if (getFocusedElementText().include?("Diagnoses")); sleep 1 }
        expect(getFocusedElementText()).to eq("Diagnoses")

        expect(getCount()).to eq(6)

        expectedText = ['Diagnosis', 'SOME NEW DIAGNOSIS', 'Date of Onset', 'Status', 'Current', 'Source', 'Self']
        expect(getTextForRowAsArray(6)).to eq(expectedText)
      end

      it "(1) Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view." do
        clickNthRow(6)
        !5.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")

        expect(@diagnoses.getDiagnosis()).to eq("SOME NEW DIAGNOSIS")
        expect(@diagnoses.getOnsetDate()).to eq("")
        expect(@diagnoses.getProviderFacility()).to eq("")
        expect(@diagnoses.isCurrentChecked()).to be true
        expect(@diagnoses.isPastChecked()).to be false
        expect(@diagnoses.getNote()).to eq("")

        @diagnoses.setDiagnosis("SOME NEWER DIAGNOSIS")
        @diagnoses.setOnsetDate("03/07/1991")
        @diagnoses.setProviderFacility("Provider Facility")
        @diagnoses.setPastChecked()
        @diagnoses.setNote("My little note.")

        @diagnoses.clickSaveButton()
        !5.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
        expect(getPrimaryHeader).to eq("Diagnoses")
        !5.times{ break if (getFocusedElementText().include?("Diagnoses")); sleep 1 }
        expect(getFocusedElementText()).to eq("Diagnoses")

        expect(getCount()).to eq(5)

        @diagnoses_filter.clickPastRadioButton()
        @diagnoses_filter.clickFilterBtn()
        !5.times{ break if (getFocusedElementText().include?("F Diagnosis")); sleep 1 }

        expect(getCount()).to eq(8)

        expectedText = ['Diagnosis', 'SOME NEWER DIAGNOSIS', 'Date of Onset', '03/07/1991', 'Status', 'Past', 'Source', 'Self']
        expect(getTextForRowAsArray(3)).to eq(expectedText)
      end

      context "(3) Delete" do

          it "When a user selects Delete, the system prompts the user to confirm the Delete by displaying a modal" do
            clickNthRow(3)
            !5.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
            expect(getPrimaryHeader).to eq("Edit Diagnosis")

            expect(@diagnoses.getDiagnosis()).to eq("SOME NEWER DIAGNOSIS")
            expect(@diagnoses.getOnsetDate()).to eq("03/07/1991")
            expect(@diagnoses.getProviderFacility()).to eq("Provider Facility")
            expect(@diagnoses.isCurrentChecked()).to be false
            expect(@diagnoses.isPastChecked()).to be true
            expect(@diagnoses.getNote()).to eq("My little note.")

            @diagnoses.clickDeleteButton()
            !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Yes")
            expect(@modal.getCancelButtonText()).to eq("No")
          end

          it "Clicking No closes the modal and returns the user to the Detail entry, edit mode, with focus on the delete button." do
            @modal.clickNoButton()
            !5.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
            expect(getPrimaryHeader).to eq("Edit Diagnosis")
            !5.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
            expect(getFocusedElementText()).to eq("Delete")

            @diagnoses.clickCancelButton()
            !5.times{ break if (@mymedical.getPrimaryHeader == "Diagnoses"); sleep 1 }
            expect(@mymedical.getPrimaryHeader).to eq("Diagnoses")

            expect(getCount()).to eq(8)
          end

          it "Clicking Yes, closes the modal, and moves the user to the Detail view with the table shown and the deleted item is removed from the table list." do
            clickNthRow(3)
            !5.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
            expect(getPrimaryHeader).to eq("Edit Diagnosis")

            expect(@diagnoses.getDiagnosis()).to eq("SOME NEWER DIAGNOSIS")
            expect(@diagnoses.getOnsetDate()).to eq("03/07/1991")
            expect(@diagnoses.getProviderFacility()).to eq("Provider Facility")
            expect(@diagnoses.isCurrentChecked()).to be false
            expect(@diagnoses.isPastChecked()).to be true
            expect(@diagnoses.getNote()).to eq("My little note.")

            @diagnoses.clickDeleteButton()
            !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Yes")
            expect(@modal.getCancelButtonText()).to eq("No")

            @modal.clickYesButton()
            !5.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
            expect(getPrimaryHeader).to eq("Diagnoses")
            !5.times{ break if (getFocusedElementText().include?("Diagnoses")); sleep 1 }
            expect(getFocusedElementText()).to eq("Diagnoses")

            expect(getCount()).to eq(7)
          end

      end

  end

  context "AC #JRNL-2895|TC #JRNL-2921: (3) Navigation Without Saving" do

      it "(b) If the user tries to Navigate away from a detail record where a field has been updated without Saving, the user is prompted to confirm that they want to leave the record without saving via a modal." do
        clickNthRow(1)
        !5.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")

        @diagnoses.setDiagnosis("ASDFGHJKL")
        @mymedical.clickDiagnoses()

        !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickReturnButton()
        !5.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")

        @mymedical.clickDiagnoses()
        !5.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickContinueButton()
        !5.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
        expect(getPrimaryHeader).to eq("Diagnoses")

        clickNthRow(1)
        !5.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")

        expect(@diagnoses.getDiagnosis()).not_to eq("ASDFGHJKL")
        @diagnoses.clickCancelButton()
        !5.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
        expect(getPrimaryHeader).to eq("Diagnoses")
      end

  end

  # Local functions starts

  def validateErrorMessages(errors)
    expectedValidationSummaryHeader = errors.length > 0 ? "The following errors were found:" : ""
    sleep 1

    !5.times{ break if (@errorSummary.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
    expect(@errorSummary.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)

    if(expectedValidationSummaryHeader != "")
      for i in 0..(errors.length - 1)
        if errors[i] != nil
          expect(@errorSummary.isErrorMessageDisplayed("form", errors[i])).to eq(true)
        else
          expect(@errorSummary.isErrorMessageDisplayed("form", errors[i])).to eq(false)
        end
      end
    else
      expect(@errorSummary.isErrorSummaryElementPresent("form")).to eq(false)
    end
  end
end


























































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "[Story JRNL-2467: Diagnoses Edit/Delete]", :broken => true, :regression => true  do

  before(:all) do
    @INITIAL_ENTRY_FORM = [ \
        "* required field",
        "* Diagnosis:",
        # JRNL-1197 changed 'Diagnosis' to a type-ahead input
        "Auto-complete input",
        # "50 character maximum",
        "Date of Onset:",
        "MM/DD/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Provider/Facility:",
        "100 character maximum",
        "* Status:",
        "Current",
        "Past",
        "Source: Self",
        "Note:",
        "250 character maximum",
        "243 characters left",
        "Save Delete Cancel",
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("diagnosis", "medicalhistorydb", "diagnoses")

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()

    !45.times{ break if (getSecondaryHeader == "My Medical"); sleep 1 }
    expect(getSecondaryHeader).to eq("My Medical")

    @mymedical.clickDiagnoses
    !45.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
    expect(getPrimaryHeader).to eq("Diagnoses")

    expect(getCount()).to eq(6)
  end

  after(:all) do
    quitDriver()
  end

  context "AC #JRNL-2893|TC #JRNL-2916: (1) When the user selects a Diagnosis entry from the table view, the system displays the Diagnosis record in the Detail screen in Edit mode." do

      it "(a) All fields available in add mode are shown." do
        clickNthRow(1)
        !45.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")
        !10.times{ break if (getFocusedElementText().include?("Edit Diagnosis")); sleep 1 }
        expect(getFocusedElementText()).to eq("Edit Diagnosis")

        expect(@diagnoses.getDiagnosis()).to eq("e Diagnosis")
        expect(@diagnoses.getOnsetDate()).to eq("11/06/2014")
        expect(@diagnoses.getProviderFacility()).to eq("A Provider")
        expect(@diagnoses.isCurrentChecked()).to be true
        expect(@diagnoses.isPastChecked()).to be false
        expect(@diagnoses.getNote()).to eq("My Note")

        diagnosesForm = @diagnoses.getScreenContent().split("\n")
        @INITIAL_ENTRY_FORM.each_with_index do | expectedScreenRow, i |
          expect(diagnosesForm[i]).to eq(expectedScreenRow)
        end
        expect(diagnosesForm.length).to eq(@INITIAL_ENTRY_FORM.length)
      end

      it "(b) Standard Edit functions are available (Save, Cancel, Delete)" do
        expect(@diagnoses.isDeleteButtonVisible()).to be true
        expect(@diagnoses.isCancelButtonVisible()).to be true
        expect(@diagnoses.isSaveButtonVisible()).to be true
      end

  end

  context "AC #JRNL-1862|TC #JRNL-2917: (2) Save, Cancel, Delete Functionality" do

      it "(2) Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        @diagnoses.setDiagnosis("SOME NEW DIAGNOSIS")
        @diagnoses.clickOnsetDateCalendarBtn()
        !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
        @date_picker.setDateFromGUI(3, 7, 1991)
        @diagnoses.setProviderFacility("Test Facility")
        @diagnoses.setPastChecked()
        @diagnoses.setNote("Test Note")

        @diagnoses.clickCancelButton()
        !45.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
        expect(getPrimaryHeader).to eq("Diagnoses")
        !10.times{ break if (getFocusedElementText().include?("Diagnoses")); sleep 1 }
        expect(getFocusedElementText()).to eq("Diagnoses")
      end

      it "(2) Cancel -  When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        expect(getCount()).to eq(6)

        clickNthRow(1)
        !45.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")

        expect(@diagnoses.getDiagnosis()).to eq("e Diagnosis")
        expect(@diagnoses.getOnsetDate()).to eq("11/06/2014")
        expect(@diagnoses.getProviderFacility()).to eq("A Provider")
        expect(@diagnoses.isCurrentChecked()).to be true
        expect(@diagnoses.isPastChecked()).to be false
        expect(@diagnoses.getNote()).to eq("My Note")
      end

      it "Validation" do
        @diagnoses.setDiagnosis("")
        @diagnoses.setOnsetDate("")
        @diagnoses.setProviderFacility("")
        @diagnoses.setNote("")
        @diagnoses.clickSaveButton()
        validateErrorMessages(["Diagnosis field is required."])
      end

      it "(1) Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view." do
        @diagnoses.setDiagnosis("SOME NEW DIAGNOSIS")

        @diagnoses.clickSaveButton()
        !45.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
        expect(getPrimaryHeader).to eq("Diagnoses")
        !10.times{ break if (getFocusedElementText().include?("Diagnoses")); sleep 1 }
        expect(getFocusedElementText()).to eq("Diagnoses")

        expect(getCount()).to eq(6)

        expectedText = ['Diagnosis', 'SOME NEW DIAGNOSIS', 'Date of Onset', 'Status', 'Current', 'Source', 'Self']
        expect(getTextForRowAsArray(6)).to eq(expectedText)
      end

      it "(1) Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view." do
        clickNthRow(6)
        !45.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")

        expect(@diagnoses.getDiagnosis()).to eq("SOME NEW DIAGNOSIS")
        expect(@diagnoses.getOnsetDate()).to eq("")
        expect(@diagnoses.getProviderFacility()).to eq("")
        expect(@diagnoses.isCurrentChecked()).to be true
        expect(@diagnoses.isPastChecked()).to be false
        expect(@diagnoses.getNote()).to eq("")

        @diagnoses.setDiagnosis("SOME NEWER DIAGNOSIS")
        @diagnoses.setOnsetDate("03/07/1991")
        @diagnoses.setProviderFacility("Provider Facility")
        @diagnoses.setPastChecked()
        @diagnoses.setNote("My little note.")

        @diagnoses.clickSaveButton()
        !45.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
        expect(getPrimaryHeader).to eq("Diagnoses")
        !10.times{ break if (getFocusedElementText().include?("Diagnoses")); sleep 1 }
        expect(getFocusedElementText()).to eq("Diagnoses")

        expect(getCount()).to eq(5)

        @diagnoses_filter.clickPastRadioButton()
        @diagnoses_filter.clickFilterBtn()
        !10.times{ break if (getFocusedElementText().include?("F Diagnosis")); sleep 1 }

        expect(getCount()).to eq(8)

        expectedText = ['Diagnosis', 'SOME NEWER DIAGNOSIS', 'Date of Onset', '03/07/1991', 'Status', 'Past', 'Source', 'Self']
        expect(getTextForRowAsArray(3)).to eq(expectedText)
      end

      context "(3) Delete" do

          it "When a user selects Delete, the system prompts the user to confirm the Delete by displaying a modal" do
            clickNthRow(3)
            !45.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
            expect(getPrimaryHeader).to eq("Edit Diagnosis")

            expect(@diagnoses.getDiagnosis()).to eq("SOME NEWER DIAGNOSIS")
            expect(@diagnoses.getOnsetDate()).to eq("03/07/1991")
            expect(@diagnoses.getProviderFacility()).to eq("Provider Facility")
            expect(@diagnoses.isCurrentChecked()).to be false
            expect(@diagnoses.isPastChecked()).to be true
            expect(@diagnoses.getNote()).to eq("My little note.")

            @diagnoses.clickDeleteButton()
            !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Yes")
            expect(@modal.getCancelButtonText()).to eq("No")
          end

          it "Clicking No closes the modal and returns the user to the Detail entry, edit mode, with focus on the delete button." do
            @modal.clickNoButton()
            !45.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
            expect(getPrimaryHeader).to eq("Edit Diagnosis")
            !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
            expect(getFocusedElementText()).to eq("Delete")

            @diagnoses.clickCancelButton()
            !45.times{ break if (@mymedical.getPrimaryHeader == "Diagnoses"); sleep 1 }
            expect(@mymedical.getPrimaryHeader).to eq("Diagnoses")

            expect(getCount()).to eq(8)
          end

          it "Clicking Yes, closes the modal, and moves the user to the Detail view with the table shown and the deleted item is removed from the table list." do
            clickNthRow(3)
            !45.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
            expect(getPrimaryHeader).to eq("Edit Diagnosis")

            expect(@diagnoses.getDiagnosis()).to eq("SOME NEWER DIAGNOSIS")
            expect(@diagnoses.getOnsetDate()).to eq("03/07/1991")
            expect(@diagnoses.getProviderFacility()).to eq("Provider Facility")
            expect(@diagnoses.isCurrentChecked()).to be false
            expect(@diagnoses.isPastChecked()).to be true
            expect(@diagnoses.getNote()).to eq("My little note.")

            @diagnoses.clickDeleteButton()
            !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("Confirmation")
            expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
            expect(@modal.getConfirmButtonText()).to eq("Yes")
            expect(@modal.getCancelButtonText()).to eq("No")

            @modal.clickYesButton()
            !45.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
            expect(getPrimaryHeader).to eq("Diagnoses")
            !10.times{ break if (getFocusedElementText().include?("Diagnoses")); sleep 1 }
            expect(getFocusedElementText()).to eq("Diagnoses")

            expect(getCount()).to eq(7)
          end

      end

  end

  context "AC #JRNL-2895|TC #JRNL-2921: (3) Navigation Without Saving" do

      it "(b) If the user tries to Navigate away from a detail record where a field has been updated without Saving, the user is prompted to confirm that they want to leave the record without saving via a modal." do
        clickNthRow(1)
        !45.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")

        @diagnoses.setDiagnosis("ASDFGHJKL")
        @mymedical.clickDiagnoses()

        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickReturnButton()
        !45.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")

        @mymedical.clickDiagnoses()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickContinueButton()
        !45.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
        expect(getPrimaryHeader).to eq("Diagnoses")

        clickNthRow(1)
        !45.times{ break if (getPrimaryHeader == "Edit Diagnosis"); sleep 1 }
        expect(getPrimaryHeader).to eq("Edit Diagnosis")

        expect(@diagnoses.getDiagnosis()).not_to eq("ASDFGHJKL")
        @diagnoses.clickCancelButton()
        !45.times{ break if (getPrimaryHeader == "Diagnoses"); sleep 1 }
        expect(getPrimaryHeader).to eq("Diagnoses")
      end

  end

  # Local functions starts

  def validateErrorMessages(errors)
    expectedValidationSummaryHeader = errors.length > 0 ? "The following errors were found:" : ""
    sleep 1

    !45.times{ break if (@errorSummary.getValidationSummaryHeader("form") == expectedValidationSummaryHeader); sleep 1 }
    expect(@errorSummary.getValidationSummaryHeader("form")).to eq(expectedValidationSummaryHeader)

    if(expectedValidationSummaryHeader != "")
      for i in 0..(errors.length - 1)
        if errors[i] != nil
          expect(@errorSummary.isErrorMessageDisplayed("form", errors[i])).to eq(true)
        else
          expect(@errorSummary.isErrorMessageDisplayed("form", errors[i])).to eq(false)
        end
      end
    else
      expect(@errorSummary.isErrorSummaryElementPresent("form")).to eq(false)
    end
  end
end
=end