require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-1295: Allergies: List view]
          [Story #JRNL-1210: Allergies PDF]
          [Story #JRNL-1214: Allergy Filter]", :regression => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    resetCollection("allergies", "medicalhistorydb", "allergies")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickMyMedical()
    !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
    expect(getSecondaryHeader()).to eq("My Medical")
  end

  after(:all) do
    quitDriver()
  end

  describe "AC #JRNL-1265|TC #JRNL-1251: Sub Feature Selection for Allergies (List View)" do

    it "Visible" do
      expect(@nav_menu.isNavVisible("Allergies")).to eq(true)
    end

    it "Label" do
      expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["Allergies"]["navButton"])).to eq("Allergies")
    end

    it "Location" do
      menuLocation = -1
      menu = getElements(:css, "div.secondary-content li")

      menu.each_with_index do | menuItem, i |
        if menuItem.text() == "Allergies"
          menuLocation = i + 1
          break
        end
      end

      expect(@nav_menu.getNthSubFeatureName(menuLocation)).to eq("Allergies")
      expect(@nav_menu.getNthSubFeatureName(menuLocation + 1)).to eq("Diagnoses")
    end

  end

  describe "AC #JRNL-1264|TC #JRNL-1251: Sub Feature Selection for Allergies" do

    it "Header" do
      @mymedical.clickAllergies()
      !45.times{ break if (getPrimaryHeader() == "Allergies"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Allergies")
    end

    it "Records sorted in alphabetical order", :broken => true do
      !5.times{ break if (getTextForRowColumn(1, 1) != nil); sleep 1 }
      verifyAllergiesList(getList(), getAllAllergiesInDBSorted())
      expect(getCount()).to eq(23)
    end

    it "Table Headers", :broken => true do
      expect(getTableHeaders()).to eq(["Allergy", "Reaction", "Type", "Source"])

      expect(getTextForRowColumn(1, 1)).to eq("Carrots")
      expect(getTextForRowColumn(1, 2)).to eq("Cramps")
      expect(getTextForRowColumn(1, 4)).to eq("Self")

      expect(getTextForRowColumn(23, 1)).to eq("Wool")
      expect(getTextForRowColumn(23, 2)).to eq("Sweating")
      expect(getTextForRowColumn(23, 4)).to eq("Self")
    end

    it "Phone view display", :broken => true do
      resizeWindowToPhone()
      expect(getTableHeaders).to eq(["Allergy", "Source"])

      expect(getTextForRowColumn(1, 1)).to eq("Carrots")
      expect(getTextForRowColumn(1, 2)).to eq("")
      expect(getTextForRowColumn(1, 4)).to eq("Self")

      expect(getTextForRowColumn(23, 1)).to eq("Wool")
      expect(getTextForRowColumn(23, 2)).to eq("")
      expect(getTextForRowColumn(23, 4)).to eq("Self")

      resizeWindowToDefault()
    end

    it "No Records were found" do
      removeCollection("allergies", "medicalhistorydb")
      refreshBrowser()
      noRecordsMessage = "No results were found. Use the Add button above to create a new record."
      !5.times{ break if (getNoResultsFoundMessage() == noRecordsMessage ); sleep 1 }
      expect(getNoResultsFoundMessage()).to match(noRecordsMessage)
    end

  end

  describe "AC #JRNL-1176|TC #JRNL-1251: PDF Button" do

    it "PDF Button" do
      expect(isElementVisible(:css, "button[title='PDF']")).to eq(true)
    end

  end

  describe "#AC JRNL-1263|TC #JRNL-1251: Navigation for Allergies" do

    it "Navigation", :broken => true do
      expect(@common.isBackButtonVisible()).to eq(false)
      resizeWindowToPhone()
      expect(@common.isBackButtonVisible()).to eq(true)
      expect(@common.getBackButtonAltText()).to eq("Return to My Medical options")

      @common.clickBackButton()
      !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }
      expect(getSecondaryHeader()).to eq("My Medical")
    end

  end

  #######################
  ### Local Functions ###
  #######################

  def getAllAllergiesInDBSorted
    def sortKeys(x,y)
      #The key is in "exposure =>{"substance" : text} format
      return x["exposure"]["substance"].upcase <=> y["exposure"]["substance"].upcase
    end

    return retreiveAllDocumentsInCollection("allergies", "medicalhistorydb").sort { |x, y| sortKeys(x,y) }
  end

  def verifyAllergiesList(screenList, dbList)
    dbList.each_with_index do |dbrow, i|
      screenRow = screenList[i].text.split("\n")
      expect(screenRow[1].strip.upcase).to eq(dbrow['exposure']['substance'].upcase)
      expect(screenRow[7].strip).to eq(dbrow['source'])
    end
  end
end
