require_relative '../../../globalized'
include Globalized

describe '[Story #JRNL-1294: My Medical - Allergies - Edit/Delete/Nav]', :broken => true, :regression => true do

  before(:all) do
    @ENTRY_FORM = [
        '* required field',
        'Source: Self',
        'Type:',
        'Medication',
        'Food/Environmental',
        '* Allergy:',
        'Auto-complete input',
        '* Date first occurred:',
        'MM/DD/YYYY',
        'This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker',
        'Is this date estimated?',
        'Yes',
        'No',
        'Severity:',
        'Select',
        'Mild',
        'Moderate',
        'Severe',
        'Reaction:',
        '250 character maximum',
        '242 characters left',
        'Was the allergy diagnosed?',
        'Yes',
        'No',
        'Note:',
        '250 character maximum',
        '250 characters left',
        'Save Delete Cancel'
    ]

    initializeConfigurations(BASE_URL)
    resetCollection('allergies', 'medicalhistorydb', 'allergies')

    initializeAllObjects

    @common.loginEndsOnLandingPage('zztest.patient01', 'patient01, zztest')
    expect(@main.getFooterText()).to eq('Logged in as patient01, zztest')

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == 'App Options'); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq('App Options')

    @nav_menu.clickMyMedical()
    !5.times{ break if (getSecondaryHeader() == 'My Medical'); sleep 1 }
    expect(getSecondaryHeader()).to eq('My Medical')

    @mymedical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
    waitForPageToFinishLoading()

    expect(getCount()).to eq(23)

    RECORD_COUNT = retreiveAllDocumentsInCollection('allergies', 'medicalhistorydb').length()
  end

  after(:all) do
    quitDriver()
  end

  describe 'AC JRNL-1261|TC JRNL-1252: Edit' do

      it 'Header' do
        clickNthRow(23)
        waitForPageToFinishLoading()
      end

      it 'Values' do
        expect(@allergies.getFieldValue('ALLERGY')).to eq('Wool')
        expect(@allergies.getFieldValue('DATE')).to eq('05/15/2014')
        expect(@allergies.getFieldValue('ESTIMATED')).to eq('No')
        expect(@allergies.getFieldValue('SEVERITY')).to eq('Moderate')
        expect(@allergies.getFieldValue('REACTION')).to eq('Sweating')
        expect(@allergies.getFieldValue('DIAGNOSED')).to eq('No')
        expect(@allergies.getFieldValue('NOTE')).to eq('')
      end

      describe 'Same Elements as Add' do

        it 'Screen Content' do
          form = @allergies.getScreenContent().split("\n")

          @ENTRY_FORM.each_with_index do | expectedScreenRow, i |
            expect(form[i]).to eq(expectedScreenRow)
          end

          expect(form.length()).to eq(@ENTRY_FORM.length())
        end

        it 'Allergy' do
          expect(@allergies.isFieldRequired?('ALLERGY')).to eq(true)
          expect(@allergies.getFieldMaxLength('ALLERGY')).to eq('50')
          expect(@allergies.getPlaceHolderByCSS(:css, Allergies::FIELDS['ALLERGY']['selector'])).to eq('Enter an Allergy')
        end

        it 'Date first occurred' do
          expect(@allergies.isFieldRequired?('DATE')).to eq(true)
        end

        it 'Severity' do
          expect(@allergies.isFieldRequired?('SEVERITY')).to eq(false)
        end

        it 'Reaction' do
          expect(@allergies.isFieldRequired?('REACTION')).to eq(false)
          expect(@allergies.getFieldMaxLength('REACTION')).to eq('250')
        end

        it 'Was the allergy diagnosed?' do
          expect(@allergies.isFieldVisible('PROVIDER_FACILITY')).to eq(false)

          @allergies.setFieldValue('DIAGNOSED', 'Yes')

          expect(@allergies.isFieldVisible('PROVIDER_FACILITY')).to eq(true)
        end

        it 'Provider and Facility' do
          expect(@allergies.isFieldRequired?('PROVIDER_FACILITY')).to eq(false)
          expect(@allergies.getFieldMaxLength('PROVIDER_FACILITY')).to eq('250')
        end

        it 'Note' do
          expect(@allergies.isFieldRequired?('NOTE')).to eq(false)
          expect(@allergies.getFieldMaxLength('NOTE')).to eq('250')
        end

        it 'Errors' do
          @allergies.setFieldValue('ALLERGY', '')
          @allergies.setFieldValue('DATE', '')

          @allergies.clickSaveButton()
          checkingInlineError('Allergy field is required.', 0)
          checkingInlineError('Date first occurred field is required.', 1)

          @allergies.setFieldValue('DATE', '01/01')

          @allergies.clickSaveButton()
          checkingInlineError('Allergy field is required.', 0)
          checkingInlineError('Date first occurred must be formatted MM/DD/YYYY.', 1)

          if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
            @allergies.setFieldValue('DATE', getDateNthDaysFromNow(1, '%m/%d/%Y'))

            @allergies.clickSaveButton()
            checkingInlineError('Allergy field is required.', 0)
            checkingInlineError('Date first occurred must be between 01/01/1900 and ' + getDateNthDaysFromNow(0, '%m/%d/%Y') + '.', 1)
          end
        end

        it 'Save, Delete and Cancel Available' do
          expect(@allergies.isDeleteButtonVisible()).to eq(true)
          expect(@allergies.isCancelButtonVisible()).to eq(true)
          expect(@allergies.isSaveButtonVisible()).to eq(true)
        end

      end

  end

  describe 'AC JRNL-1260|TC JRNL-1252: Save, Cancel and Delete Functionality' do

      it 'Cancel' do
        @allergies.clickCancelButton()
        waitForPageToFinishLoading()
        !3.times{ break if (getFocusedElementText() == Allergies::HEADERS['LIST']); sleep 1 }
        expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])
      end

      it 'Verify No Changes' do
        expect(getCount()).to eq(23)

        clickNthRow(23)
        waitForPageToFinishLoading()

        expect(@allergies.getFieldValue('ALLERGY')).to eq('Wool')
        expect(@allergies.getFieldValue('DATE')).to eq('05/15/2014')
        expect(@allergies.getFieldValue('ESTIMATED')).to eq('No')
        expect(@allergies.getFieldValue('SEVERITY')).to eq('Moderate')
        expect(@allergies.getFieldValue('REACTION')).to eq('Sweating')
        expect(@allergies.getFieldValue('DIAGNOSED')).to eq('No')
        expect(@allergies.getFieldValue('NOTE')).to eq('')
      end

      describe 'Save' do

        it 'Min' do
          @allergies.setFieldValue('ALLERGY', 'A Cat')

          @allergies.clickDatePickerButton()
          !5.times{ break if (@date_picker.getSetButtonText() == 'SET'); sleep 1 }
          @date_picker.setDateFromGUI(2, 2, 2015)
          expect(@allergies.getFieldValue('DATE')).to eq('02/02/2015')

          @allergies.setFieldValue('SEVERITY', 'Select')
          @allergies.setFieldValue('REACTION', '')

          @allergies.clickSaveButton()
          waitForPageToFinishLoading()
          !3.times{ break if (getFocusedElementText() == Allergies::HEADERS['LIST']); sleep 1 }
          expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])

          expect(getCount()).to eq(23)

          expect(getTextForRow(1).include?('A Cat')).to eq(true)
        end

        it 'Verify Values' do
          clickNthRow(1)
          waitForPageToFinishLoading()

          expect(@allergies.getFieldValue('ALLERGY')).to eq('A Cat')
          expect(@allergies.getFieldValue('DATE')).to eq('02/02/2015')
          expect(@allergies.getFieldValue('ESTIMATED')).to eq('No')
          expect(@allergies.getFieldValue('SEVERITY')).to eq('')
          expect(@allergies.getFieldValue('REACTION')).to eq('')
          expect(@allergies.getFieldValue('DIAGNOSED')).to eq('No')
          expect(@allergies.getFieldValue('NOTE')).to eq('')
        end

        it 'Max' do
          @allergies.setFieldValue('ALLERGY', 'ZZTEST!?@#$%^&*()_+-{}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-{}[]:;<>,.12356789')
          @allergies.setFieldValue('DATE', '01/01/2015')
          @allergies.setFieldValue('ESTIMATED', 'Yes')
          @allergies.setFieldValue('SEVERITY', 'Mild')
          @allergies.setFieldValue('REACTION', 'ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789')
          @allergies.setFieldValue('DIAGNOSED', 'Yes')
          @allergies.setFieldValue('PROVIDER_FACILITY', 'ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789')
          @allergies.setFieldValue('NOTE', 'ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789')

          @allergies.clickSaveButton()
          waitForPageToFinishLoading()
          !3.times{ break if (getFocusedElementText() == Allergies::HEADERS['LIST']); sleep 1 }
          expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])

          expect(getCount()).to eq(23)

          expect(getTextForRow(23).include?('ZZTEST!?@#$%^&*()_+-{}[]:;<>,.12356789ZZTEST!?@#')).to eq(true)
        end

        it 'Verify Values' do
          clickNthRow(23)
          waitForPageToFinishLoading()

          expect(@allergies.getFieldValue('ALLERGY')).to eq('ZZTEST!?@#$%^&*()_+-{}[]:;<>,.12356789ZZTEST!?@#$')
          expect(@allergies.getFieldValue('DATE')).to eq('01/01/2015')
          expect(@allergies.getFieldValue('ESTIMATED')).to eq('Yes')
          expect(@allergies.getFieldValue('SEVERITY')).to eq('Mild')
          expect(@allergies.getFieldValue('REACTION')).to eq('ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#')
          expect(@allergies.getFieldValue('DIAGNOSED')).to eq('Yes')
          expect(@allergies.getFieldValue('PROVIDER_FACILITY')).to eq('ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#')
          expect(@allergies.getFieldValue('NOTE')).to eq('ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#$%^&*()_+-={}[]:;<>,.12356789ZZTEST!?@#')
        end

        it 'Provider/Facility clears if Diagnosed is set to No' do
          @allergies.setFieldValue('DIAGNOSED', 'No')

          @allergies.clickSaveButton()
          waitForPageToFinishLoading()
          !3.times{ break if (getFocusedElementText() == Allergies::HEADERS['LIST']); sleep 1 }
          expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])

          clickNthRow(23)
          waitForPageToFinishLoading()

          expect(@allergies.getFieldValue('DIAGNOSED')).to eq('No')

          @allergies.setFieldValue('DIAGNOSED', 'Yes')
          expect(@allergies.getFieldValue('PROVIDER_FACILITY')).to eq('')
        end

      end

      describe 'Delete' do

          it 'Click No' do
            @allergies.clickDeleteButton()
            !3.times{ break if(@modal.isConfirmationPopUpPresent()); sleep 1 }
            expect(@modal.isConfirmationPopUpPresent()).to eq(true)
            expect(@modal.getConfirmationHeading()).to eq('Confirmation')
            expect(@modal.getConfirmationMessage()).to eq('Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.')
            expect(@modal.getConfirmButtonText()).to eq('Yes')
            expect(@modal.getCancelButtonText()).to eq('No')

            @modal.clickNoButton()
            !3.times{ break if (@modal.isConfirmationPopUpNotPresent()); sleep 1 }
            expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)
            !3.times{ break if (getFocusedElementText() == 'Delete'); sleep 1 }
            expect(getFocusedElementText()).to eq('Delete')
          end

          it 'Click Yes' do
            @allergies.clickDeleteButton()
            !3.times{ break if(@modal.isConfirmationPopUpPresent()); sleep 1 }
            expect(@modal.isConfirmationPopUpPresent()).to eq(true)
            expect(@modal.getConfirmationHeading()).to eq('Confirmation')
            expect(@modal.getConfirmationMessage()).to eq('Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.')
            expect(@modal.getConfirmButtonText()).to eq('Yes')
            expect(@modal.getCancelButtonText()).to eq('No')

            @modal.clickYesButton()
            waitForPageToFinishLoading()
            !3.times{ break if (getFocusedElementText() == Allergies::HEADERS['LIST']); sleep 1 }
            expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])

            expect(getCount()).to eq(22)
          end

          it 'Soft Deletes' do
            expect(retreiveAllDocumentsInCollection('allergies', 'medicalhistorydb').length()).to eq(RECORD_COUNT)
          end

      end

  end

  describe 'AC JRNL-1259|TC JRNL-1252: Navigation' do

      context 'Back Button' do

          it 'Visible' do
            clickNthRow(1)
            waitForPageToFinishLoading()

            expect(@allergies.isBackButtonVisible()).to eq(true)
          end

          it 'Alt Text' do
            expect(@allergies.getBackButtonAltText()).to eq('Return to Previous Screen')
          end

          it 'No changes' do
            @allergies.clickBackButton()
            waitForPageToFinishLoading()
          end

          it 'With changes' do
            clickNthRow(1)
            waitForPageToFinishLoading()

            @allergies.setFieldValue('NOTE', 'Navigation Test')

            @allergies.clickBackButton()
            !3.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq('Confirmation')
            expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. You may continue without saving or return to the entry screen.')
            expect(@modal.getConfirmButtonText()).to eq('Continue')
            expect(@modal.getCancelButtonText()).to eq('Return')

            @modal.clickReturnButton()
            !3.times{ break if (@modal.isConfirmationPopUpNotPresent()); sleep 1 }
            expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

            @allergies.clickBackButton()
            !3.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq('Confirmation')
            expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. You may continue without saving or return to the entry screen.')
            expect(@modal.getConfirmButtonText()).to eq('Continue')
            expect(@modal.getCancelButtonText()).to eq('Return')

            @modal.clickContinueButton()
            waitForPageToFinishLoading()
          end

          it 'Verify No Changes' do
            clickNthRow(1)
            waitForPageToFinishLoading()

            expect(@allergies.getFieldValue('ALLERGY')).to eq('Carrots')
          end

      end

      context 'Menu Item' do

          it 'No changes' do
            @mymedical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
            waitForPageToFinishLoading()
          end

          it 'With changes' do
            clickNthRow(1)
            waitForPageToFinishLoading()

            @allergies.setFieldValue('NOTE', 'Navigation Test')

            @mymedical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
            !3.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq('Confirmation')
            expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. You may continue without saving or return to the entry screen.')
            expect(@modal.getConfirmButtonText()).to eq('Continue')
            expect(@modal.getCancelButtonText()).to eq('Return')

            @modal.clickReturnButton()
            !3.times{ break if (@modal.isConfirmationPopUpNotPresent()); sleep 1 }
            expect(@modal.isConfirmationPopUpNotPresent()).to eq(true)

            @mymedical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
            !3.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq('Confirmation')
            expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. You may continue without saving or return to the entry screen.')
            expect(@modal.getConfirmButtonText()).to eq('Continue')
            expect(@modal.getCancelButtonText()).to eq('Return')

            @modal.clickContinueButton()
            waitForPageToFinishLoading()
          end

          it 'Verify No Changes' do
            clickNthRow(1)
            waitForPageToFinishLoading()

            expect(@allergies.getFieldValue('ALLERGY')).to eq('Carrots')

            @allergies.clickCancelButton()
            waitForPageToFinishLoading()
          end

      end

  end

  #######################
  ### Local Functions ###
  #######################

  def checkingInlineError(errMsg, seqNum)
    #Verify that the error message section header is displayed
    if seqNum == 0 then
      !5.times{ break if (@error.getValidationSummaryHeader('form') == 'The following errors were found:'); sleep 1 }
      expect(@error.getValidationSummaryHeader('form')).to eq('The following errors were found:')
    end
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed('form', errMsg)).to eq(true)
  end

end
