require_relative '../../../globalized'
include Globalized

describe '[Story #JRNL-1294: My Medical - Allergies - Add]', :regression => true do


    before(:all) do
        @ENTRY_FORM_MIN = [
            '* required field',
            'Source: Self',
            'Type:',
            'Medication',
            'Food',
            'Environment',
            '* Allergy:',
            'Auto-complete input',
            '*',
            'Required: Date first occurred: M M / D D / Y Y Y Y:',
            'Date first occurred:',
            'This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.',
            'Is this date estimated?',
            'Yes',
            'No',
            'Severity:',
            'Select',
            'Mild',
            'Moderate',
            'Severe',
            'Reaction:',
            '250 character maximum',
            '250 characters left',
            'Was the allergy diagnosed?',
            'Yes',
            'No',
            'Note:',
            '250 character maximum',
            '250 characters left',
            'Save Cancel'
        ]

        @ENTRY_FORM_MAX = [
            '* required field',
            'Source: Self',
            'Type:',
            'Medication',
            'Food',
            'Environment',
            '* Allergy:',
            'Auto-complete input',
            '*',
            'Required: Date first occurred: M M / D D / Y Y Y Y:',
            'Date first occurred:',
            'This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open Calendar Control.',
            'Is this date estimated?',
            'Yes',
            'No',
            'Severity:',
            'Select',
            'Mild',
            'Moderate',
            'Severe',
            'Reaction:',
            '250 character maximum',
            '110 characters left',
            'Was the allergy diagnosed?',
            'Yes',
            'No',
            'Provider:',
            '50 character maximum',
            '50 characters left',
            'Facility:',
            '50 character maximum',
            '0 characters left',
            'Note:'
        ]

        initializeConfigurations(BASE_URL)
        removeCollection('allergies', 'medicalhistorydb')
        initializeAllObjects

        @common.loginEndsOnLandingPage('zztest.patient05', 'patient05, zztest')
        expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

        @main.clickNavMenu()
        !5.times{ break if (@nav_menu.getNavMenuHeading() == 'App Options'); sleep 1 }
        expect(@nav_menu.getNavMenuHeading()).to eq('App Options')
        waitForPageToFinishLoading
        @driver.find_element(:id, "MyMedical").click
        waitForPageToFinishLoading
        !5.times{ break if (getSecondaryHeader() == 'My Medical'); sleep 1 }
        expect(getSecondaryHeader()).to eq('My Medical')

        @my_medical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
      end

    # after(:all) do
    #     quitDriver()
    # end

    describe 'AC JRNL-1262|TC JRNL-1255: Add' do

        it 'Button Visibility' do
            expect(@common.isAddButtonVisible()).to eq(true)
        end

        it 'Button Alt Text' do
            expect(@common.getAddButtonAltText()).to eq('Add')
        end

        it 'Click Add Button' do
            waitForPageToFinishLoading
            @allergies.clickAddEntryButton
            !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
            expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])
        end


        it 'Screen Content', :broken => true do
            !5.times{ break if (isElementVisible(:css, 'form[name="form"]')); sleep 1 }
            expect(isElementVisible(:css, 'form[name="form"]')).to eq(true)

            form = @allergies.getScreenContent().split("\n")

            @ENTRY_FORM_MIN.each_with_index do | expectedScreenRow, i |
                expect(form[i]).to eq(expectedScreenRow)
            end

            expect(form.length()).to eq(@ENTRY_FORM_MIN.length())
        end

        it 'Defaults', :broken => true do
            expect(isThisRadioButtonOrCheckBoxSelected('radio', 'Medication', 'allergyType')).to eq(true)
            #@common.selectRadioButton('allergyType', 'Food/Environmental')
            @driver.find_element(:xpath, "//input[@value='Food']").click
            waitForPageToFinishLoading
            expect(@allergies.getFieldValue('ALLERGY')).to eq('')
            expect(@allergies.getFieldValue('DATE')).to eq('')
            expect(@allergies.getFieldValue('ESTIMATED')).to eq('No')
            expect(@allergies.getFieldValue('SEVERITY')).to eq('')
            expect(@allergies.getFieldValue('REACTION')).to eq('')
            expect(@allergies.getFieldValue('DIAGNOSED')).to eq('No')
            expect(@allergies.getFieldValue('NOTE')).to eq('')
        end

        it 'Allergy', :broken => true do
            expect(@allergies.isFieldRequired?('ALLERGY')).to eq(true)
            expect(@allergies.getFieldMaxLength('ALLERGY')).to eq('50')
            expect(@allergies.getPlaceHolderByCSS(:css, Allergies::FIELDS['ALLERGY']['selector'])).to eq('Enter an Allergy')
        end

        it 'Date first occurred' do
            expect(@allergies.isFieldRequired?('DATE')).to eq(true)
        end

        it 'Severity' do
            expect(@allergies.isFieldRequired?('SEVERITY')).to eq(false)
        end

        it 'Reaction' do
            expect(@allergies.isFieldRequired?('REACTION')).to eq(false)
            expect(@allergies.getFieldMaxLength('REACTION')).to eq('250')

            text150 = '12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890='
            @allergies.setFieldValue('REACTION', text150)
            expect(@allergies.getFieldValue('REACTION')).to eq(text150)
            expect(@allergies.getFieldValue('REACTION').length()).to eq(text150.length())

            # @allergies.setFieldValue('REACTION', text150 + text150)
            # expect(@allergies.getFieldValue('REACTION')).to eq((text150 + text150)[0..-51])
            # expect(@allergies.getFieldValue('REACTION').length()).to eq((text150 + text150)[0..-51].length())
        end

        it 'Was the allergy diagnosed?', :broken => true do
            expect(@allergies.isFieldVisible('PROVIDER_FACILITY')).to eq(false)

            @allergies.setFieldValue('DIAGNOSED', 'Yes')

            expect(@allergies.isFieldVisible('PROVIDER_FACILITY')).to eq(true)
        end

        it 'Provider and Facility' do
            expect(@allergies.isFieldRequired?('PROVIDER_FACILITY')).to eq(false)
            expect(@allergies.getFieldMaxLength('PROVIDER_FACILITY')).to eq('50')

            text150 = '12356789012356789012356789012356789012356789012356'
            @allergies.setFieldValue('PROVIDER_FACILITY', text150)
            expect(@allergies.getFieldValue('PROVIDER_FACILITY')).to eq(text150)
            expect(@allergies.getFieldValue('PROVIDER_FACILITY').length()).to eq(text150.length())

            # @allergies.setFieldValue('PROVIDER_FACILITY', text150 + text150)
            # expect(@allergies.getFieldValue('PROVIDER_FACILITY')).to eq((text150 + text150)[0..-51])
            # expect(@allergies.getFieldValue('PROVIDER_FACILITY').length()).to eq((text150 + text150)[0..-51].length())
        end

        it 'Toggle Diagnosed field, and check Provider/Facility does not clear', :broken => true do
            @allergies.setFieldValue('DIAGNOSED', 'No')
            expect(@allergies.isFieldVisible('PROVIDER_FACILITY')).to eq(true)

            @allergies.setFieldValue('DIAGNOSED', 'Yes')
            expect(@allergies.isFieldVisible('PROVIDER_FACILITY')).to eq(true)

            text150 = '12356789012356789012356789012356789012356789012356'
            expect(@allergies.getFieldValue('PROVIDER_FACILITY')).to eq((text150 + text150)[0..-51])
            expect(@allergies.getFieldValue('PROVIDER_FACILITY').length()).to eq((text150 + text150)[0..-51].length())

        end

        it 'Note' do
            expect(@allergies.isFieldRequired?('NOTE')).to eq(false)
            expect(@allergies.getFieldMaxLength('NOTE')).to eq('250')

            text150 = '12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890='
            @allergies.setFieldValue('NOTE', text150)
            expect(@allergies.getFieldValue('NOTE')).to eq(text150)
            expect(@allergies.getFieldValue('NOTE').length()).to eq(text150.length())

            # @allergies.setFieldValue('NOTE', text150 + text150)
            # expect(@allergies.getFieldValue('NOTE')).to eq((text150 + text150)[0..-51])
            # expect(@allergies.getFieldValue('NOTE').length()).to eq((text150 + text150)[0..-51].length())
        end

        it 'Screen Content', :broken => true do
            form = @allergies.getScreenContent().split("\n")

            @ENTRY_FORM_MAX.each_with_index do | expectedScreenRow, i |
                expect(form[i]).to eq(expectedScreenRow)
            end

            expect(form.length()).to eq(36)
        end


        it 'Errors' do
            #@common.selectRadioButton('allergyType', 'Food/Environmental')
            @driver.find_element(:xpath, "//input[@value='Food']").click
            @allergies.setFieldValue('ALLERGY', '')

            @allergies.clickSaveButton()
            checkingInlineError('Allergy field is required.', 0)
            checkingInlineError('Date first occurred field is required.', 1)

            @allergies.setFieldValue('DATE', '01/01')

            @allergies.clickSaveButton()
            checkingInlineError('Allergy field is required.', 0)
            checkingInlineError('Date first occurred must be formatted MM/DD/YYYY.', 1)

            if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
                @allergies.setFieldValue('DATE', getDateNthDaysFromNow(1, '%m/%d/%Y'))

                @allergies.clickSaveButton()
                checkingInlineError('Allergy field is required.', 0)
                checkingInlineError('Date first occurred must be between 01/01/1900 and ' + getDateNthDaysFromNow(0, '%m/%d/%Y') + '.', 1)
            end
        end

        it 'Save and Cancel Available' do
            expect(@allergies.isDeleteButtonVisible()).to eq(false)
            expect(@allergies.isCancelButtonVisible()).to eq(true)
            expect(@allergies.isSaveButtonVisible()).to eq(true)
        end

    end

    describe 'AC JRNL-1260|TC JRNL-1255: Save and Cancel Functionality' do

        it 'Save - Max', :broken => true do
            @allergies.setFieldValue('ALLERGY', '!@$%^&*()_+:?><,.;-~`123567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,.;-~`')
            @allergies.setFieldValue('ESTIMATED', 'Yes')
            @allergies.setFieldValue('SEVERITY', 'Severe')
            # @allergies.clickDatePickerButton()
            # !5.times{ break if (@date_picker.getSetButtonText() == 'SET'); sleep 1 }
            # @date_picker.setDateFromGUI(2, 14, 2015)
            @driver.find_element(:xpath, "//input[@id='date']").clear
            @driver.find_element(:xpath, "//input[@id='date']").send_keys "02/14/2015"
            waitForPageToFinishLoading
            expect(@allergies.getFieldValue('DATE')).to eq('02/14/2015')
            @allergies.clickSaveButton()
            waitForPageToFinishLoading
            @driver.find_element(:css, "button[ng-click='save()']").click
            waitForPageToFinishLoading
            !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
            expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
            !5.times{ break if(getFocusedElementText() == Allergies::HEADERS['LIST']) }
            expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])
            waitForPageToFinishLoading
            @driver.find_element(:css, "input[value='All']").click
            waitForPageToFinishLoading
            @driver.find_element(:css, "button[ng-click='filter()']").click
            waitForPageToFinishLoading
            expect(getCount()).to eq(1)
        end

        it 'Verify Max Data', :broken => true do
            text150 = '12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890='

            clickNthRow(1)
            !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['EDIT']); sleep 1 }
            expect(getPrimaryHeader()).to eq(Allergies::HEADERS['EDIT'])

            expect(@allergies.getFieldValue('ALLERGY')).to eq ('!@$%^&*()_+:?><,.;-~`123567890qwertyuioplkjhgfdasz')
            expect(@allergies.getFieldValue('DATE')).to eq('02/14/2015')
            expect(@allergies.getFieldValue('ESTIMATED')).to eq('Yes')
            expect(@allergies.getFieldValue('SEVERITY')).to eq('Severe')
            expect(@allergies.getFieldValue('REACTION')).to eq("12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890=")
            expect(@allergies.getFieldValue('DIAGNOSED')).to eq('Yes')
            expect(@allergies.getFieldValue('PROVIDER_FACILITY')).to eq("12356789012356789012356789012356789012356789012356")
            expect(@allergies.getFieldValue('NOTE')).to eq("12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890=")

            @allergies.clickCancelButton()
            !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
            expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
            !30.times{ break if(getFocusedElementText() == Allergies::HEADERS['LIST']) }
            expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])
        end

        it 'Save - Min', :broken => true do
            @common.clickAddButton()
            !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
            expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])
            #@common.selectRadioButton('allergyType', 'Food/Environmental')
            @driver.find_element(:css, "input[value='Food']").click
            waitForPageToFinishLoading
            @allergies.setFieldValue('ALLERGY', 'Pollen')
            @allergies.setFieldValue('DATE', '03/07/1991')

            @allergies.clickSaveButton()
            waitForPageToFinishLoading
            @common.clickSaveButton()
            waitForPageToFinishLoading
            !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
            expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
            !30.times{ break if(getFocusedElementText() == Allergies::HEADERS['LIST']) }
            expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])
            waitForPageToFinishLoading
            @driver.find_element(:css, "input[value='All']").click
            waitForPageToFinishLoading
            @driver.find_element(:css, "button[aria-label='Apply']").click
            waitForPageToFinishLoading
            expect(getCount()).to eq(2)
        end

        it 'Verify Min Data', :broken => true do
            clickNthRow(1)

            expect(@allergies.getFieldValue('ALLERGY')).to eq ('Pollen')
            expect(@allergies.getFieldValue('DATE')).to eq('03/07/1991')
            expect(@allergies.getFieldValue('ESTIMATED')).to eq('No')
            expect(@allergies.getFieldValue('SEVERITY')).to eq('')
            expect(@allergies.getFieldValue('REACTION')).to eq('')
            expect(@allergies.getFieldValue('DIAGNOSED')).to eq('No')
            expect(@allergies.getFieldValue('NOTE')).to eq('')

            @allergies.clickCancelButton()
            !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
            expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
            !5.times{ break if(getFocusedElementText() == Allergies::HEADERS['LIST']) }
            expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])
        end

        it 'Cancel', :broken => true do
            @common.clickAddButton()
            !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
            expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])
            #@common.selectRadioButton('allergyType', 'Food/Environmental')
            @driver.find_element(:css, "input[value='Environment']").click
            waitForPageToFinishLoading
            @allergies.setFieldValue('ALLERGY', 'Pet Dander')

            @allergies.clickCancelButton()
            !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
            expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
            !5.times{ break if(getFocusedElementText() == Allergies::HEADERS['LIST']) }
            expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])

            expect(getCount()).to eq(2)
        end
    end







    describe 'AC JRNL-1259|TC-5006: Navigation Without Saving' do

        context 'Clicking Back Button' do

            it 'No changes', :broken => true do
                @common.clickAddButton()
                !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
                expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

                @allergies.clickBackButton()
                !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
                expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])

                expect(getCount()).to eq(2)
            end

            it 'Changes', :broken => true do
                @common.clickAddButton()
                !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
                expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

                @allergies.setFieldValue('NOTE', 'Navigation Test')

                @allergies.clickBackButton()
                !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
                expect(@modal.getConfirmationHeading()).to eq('Confirmation')
                expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.')
                expect(@modal.getConfirmButtonText()).to eq('Continue without Saving')
                expect(@modal.getCancelButtonText()).to eq('Return to Form')

                @modal.clickReturnButton()
                !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
                expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

                @allergies.clickBackButton()
                !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
                expect(@modal.getConfirmationHeading()).to eq('Confirmation')
                expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.')
                expect(@modal.getConfirmButtonText()).to eq('Continue without Saving')
                expect(@modal.getCancelButtonText()).to eq('Return to Form')

                @modal.clickContinueButton()
                !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
                expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])

                expect(getCount()).to eq(2)
            end

        end

        context 'Clicking Menu Item' do

            it 'No changes', :broken => true do
                @common.clickAddButton()
                !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
                expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

                @my_medical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
                !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
                expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])

                expect(getCount()).to eq(2)
            end

            it 'Changes', :broken => true do
                @common.clickAddButton()
                !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
                expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

                @allergies.setFieldValue('NOTE', 'Navigation Test')

                @my_medical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
                !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
                expect(@modal.getConfirmationHeading()).to eq('Confirmation')
                expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.')
                expect(@modal.getConfirmButtonText()).to eq('Continue without Saving')
                expect(@modal.getCancelButtonText()).to eq('Return to Form')

                @modal.clickReturnButton()
                !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
                expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])
                waitForPageToFinishLoading
                #@my_medical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
                @driver.find_element(:css, "button[class='btn btn-default allergies active']").click
                waitForPageToFinishLoading
                !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
                expect(@modal.getConfirmationHeading()).to eq('Confirmation')
                expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.')
                expect(@modal.getConfirmButtonText()).to eq('Continue without Saving')
                expect(@modal.getCancelButtonText()).to eq('Return to Form')

                @modal.clickContinueButton()
                !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
                expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])

                expect(getCount()).to eq(2)
            end
        end
    end


    #######################
    ### Local Functions ###
    #######################

    def checkingInlineError(errMsg, seqNum)
        #Verify that the error message section header is displayed
        if seqNum == 0 then
            !5.times{ break if (@error.getValidationSummaryHeader('form') == 'The following errors were found:'); sleep 1 }
            expect(@error.getValidationSummaryHeader('form')).to eq('The following errors were found:')
        end
        #Verify the error message is displayed
        expect(@error.isErrorMessageDisplayed('form', errMsg)).to eq(true)
    end

end





















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe '[Story #JRNL-1294: My Medical - Allergies - Add]', :regression => true do


  before(:all) do
    @ENTRY_FORM_MIN = [
        '* required field',
        'Source: Self',
        'Type:',
        'Medication',
        'Food/Environmental',
        '* Allergy:',
        'Auto-complete input',
        '*',
        'Required: Date first occurred: M M / D D / Y Y Y Y:',
        'Date first occurred:',
        'This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker',
        'Is this date estimated?',
        'Yes',
        'No',
        'Severity:',
        'Select',
        'Mild',
        'Moderate',
        'Severe',
        'Reaction:',
        '250 character maximum',
        '250 characters left',
        'Was the allergy diagnosed?',
        'Yes',
        'No',
        'Note:',
        '250 character maximum',
        '250 characters left',
        'Save Cancel'
    ]

    @ENTRY_FORM_MAX = [
        '* required field',
        'Source: Self',
        'Type:',
        'Medication',
        'Food/Environmental',
        '* Allergy:',
        'Auto-complete input',
        '* Date first occurred:',
        'MM/DD/YYYY',
        'This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker',
        'Is this date estimated?',
        'Yes',
        'No',
        'Severity:',
        'Select',
        'Mild',
        'Moderate',
        'Severe',
        'Reaction:',
        '250 character maximum',
        '0 characters left',
        'Was the allergy diagnosed?',
        'Yes',
        'No',
        'Provider and Facility:',
        '250 character maximum',
        '0 characters left',
        'Note:',
        '250 character maximum',
        '0 characters left',
        'Save Cancel'
    ]

    initializeConfigurations(BASE_URL)
    removeCollection('allergies', 'medicalhistorydb')
    initializeAllObjects

    @common.loginEndsOnLandingPage('zztest.patient01', 'patient01, zztest')
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !5.times{ break if (@nav_menu.getNavMenuHeading() == 'App Options'); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq('App Options')

    @nav_menu.clickMyMedical()
    !5.times{ break if (getSecondaryHeader() == 'My Medical'); sleep 1 }
    expect(getSecondaryHeader()).to eq('My Medical')

    @my_medical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
    !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
    expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
  end

  after(:all) do
    quitDriver()
  end

  describe 'AC JRNL-1262|TC JRNL-1255: Add' do

      it 'Button Visibility' do
        expect(@common.isAddButtonVisible()).to eq(true)
      end

      it 'Button Alt Text' do
        expect(@common.getAddButtonAltText()).to eq('Add')
      end

      it 'Click Add Button' do
        @common.clickAddButton()
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])
      end

      it 'Screen Content', :broken => true do
        !30.times{ break if (isElementVisible(:css, 'form[name="form"]')); sleep 1 }
        expect(isElementVisible(:css, 'form[name="form"]')).to eq(true)

        form = @allergies.getScreenContent().split("\n")

        @ENTRY_FORM_MIN.each_with_index do | expectedScreenRow, i |
          expect(form[i]).to eq(expectedScreenRow)
        end

        expect(form.length()).to eq(@ENTRY_FORM_MIN.length())
      end

      it 'Defaults', :broken => true do
        expect(isThisRadioButtonOrCheckBoxSelected('radio', 'Medication', 'allergyType')).to eq(true)
        @common.selectRadioButton('allergyType', 'Food/Environmental')
        expect(@allergies.getFieldValue('ALLERGY')).to eq('')
        expect(@allergies.getFieldValue('DATE')).to eq('')
        expect(@allergies.getFieldValue('ESTIMATED')).to eq('No')
        expect(@allergies.getFieldValue('SEVERITY')).to eq('')
        expect(@allergies.getFieldValue('REACTION')).to eq('')
        expect(@allergies.getFieldValue('DIAGNOSED')).to eq('No')
        expect(@allergies.getFieldValue('NOTE')).to eq('')
      end

      it 'Allergy', :broken => true do
        expect(@allergies.isFieldRequired?('ALLERGY')).to eq(true)
        expect(@allergies.getFieldMaxLength('ALLERGY')).to eq('50')
        expect(@allergies.getPlaceHolderByCSS(:css, Allergies::FIELDS['ALLERGY']['selector'])).to eq('Enter an Allergy')
      end

      it 'Date first occurred' do
        expect(@allergies.isFieldRequired?('DATE')).to eq(true)
      end

      it 'Severity' do
        expect(@allergies.isFieldRequired?('SEVERITY')).to eq(false)
      end

      it 'Reaction' do
        expect(@allergies.isFieldRequired?('REACTION')).to eq(false)
        expect(@allergies.getFieldMaxLength('REACTION')).to eq('250')

        text150 = '12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890='
        @allergies.setFieldValue('REACTION', text150)
        expect(@allergies.getFieldValue('REACTION')).to eq(text150)
        expect(@allergies.getFieldValue('REACTION').length()).to eq(text150.length())

        @allergies.setFieldValue('REACTION', text150 + text150)
        expect(@allergies.getFieldValue('REACTION')).to eq((text150 + text150)[0..-51])
        expect(@allergies.getFieldValue('REACTION').length()).to eq((text150 + text150)[0..-51].length())
      end

      it 'Was the allergy diagnosed?', :broken => true do
        expect(@allergies.isFieldVisible('PROVIDER_FACILITY')).to eq(false)

        @allergies.setFieldValue('DIAGNOSED', 'Yes')

        expect(@allergies.isFieldVisible('PROVIDER_FACILITY')).to eq(true)
      end

      it 'Provider and Facility' do
        expect(@allergies.isFieldRequired?('PROVIDER_FACILITY')).to eq(false)
        expect(@allergies.getFieldMaxLength('PROVIDER_FACILITY')).to eq('250')

        text150 = '12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890='
        @allergies.setFieldValue('PROVIDER_FACILITY', text150)
        expect(@allergies.getFieldValue('PROVIDER_FACILITY')).to eq(text150)
        expect(@allergies.getFieldValue('PROVIDER_FACILITY').length()).to eq(text150.length())

        @allergies.setFieldValue('PROVIDER_FACILITY', text150 + text150)
        expect(@allergies.getFieldValue('PROVIDER_FACILITY')).to eq((text150 + text150)[0..-51])
        expect(@allergies.getFieldValue('PROVIDER_FACILITY').length()).to eq((text150 + text150)[0..-51].length())
      end

      it 'Toggle Diagnosed field, and check Provider/Facility does not clear', :broken => true do
        @allergies.setFieldValue('DIAGNOSED', 'No')
        expect(@allergies.isFieldVisible('PROVIDER_FACILITY')).to eq(false)

        @allergies.setFieldValue('DIAGNOSED', 'Yes')
        expect(@allergies.isFieldVisible('PROVIDER_FACILITY')).to eq(true)

        text150 = '12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890='
        expect(@allergies.getFieldValue('PROVIDER_FACILITY')).to eq((text150 + text150)[0..-51])
        expect(@allergies.getFieldValue('PROVIDER_FACILITY').length()).to eq((text150 + text150)[0..-51].length())

      end

      it 'Note' do
        expect(@allergies.isFieldRequired?('NOTE')).to eq(false)
        expect(@allergies.getFieldMaxLength('NOTE')).to eq('250')

        text150 = '12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890='
        @allergies.setFieldValue('NOTE', text150)
        expect(@allergies.getFieldValue('NOTE')).to eq(text150)
        expect(@allergies.getFieldValue('NOTE').length()).to eq(text150.length())

        @allergies.setFieldValue('NOTE', text150 + text150)
        expect(@allergies.getFieldValue('NOTE')).to eq((text150 + text150)[0..-51])
        expect(@allergies.getFieldValue('NOTE').length()).to eq((text150 + text150)[0..-51].length())
      end

      it 'Screen Content', :broken => true do
        form = @allergies.getScreenContent().split("\n")

        @ENTRY_FORM_MAX.each_with_index do | expectedScreenRow, i |
          expect(form[i]).to eq(expectedScreenRow)
        end

        expect(form.length()).to eq(@ENTRY_FORM_MAX.length())
      end

      it 'Errors' do
        @common.selectRadioButton('allergyType', 'Food/Environmental')
        @allergies.setFieldValue('ALLERGY', '')

        @allergies.clickSaveButton()
        checkingInlineError('Allergy field is required.', 0)
        checkingInlineError('Date first occurred field is required.', 1)

        @allergies.setFieldValue('DATE', '01/01')

        @allergies.clickSaveButton()
        checkingInlineError('Allergy field is required.', 0)
        checkingInlineError('Date first occurred must be formatted MM/DD/YYYY.', 1)

        if Time.new.to_date != Date.new(Time.now.year, Time.now.month, -1) then
          @allergies.setFieldValue('DATE', getDateNthDaysFromNow(1, '%m/%d/%Y'))

          @allergies.clickSaveButton()
          checkingInlineError('Allergy field is required.', 0)
          checkingInlineError('Date first occurred must be between 01/01/1900 and ' + getDateNthDaysFromNow(0, '%m/%d/%Y') + '.', 1)
        end
      end

      it 'Save and Cancel Available' do
        expect(@allergies.isDeleteButtonVisible()).to eq(false)
        expect(@allergies.isCancelButtonVisible()).to eq(true)
        expect(@allergies.isSaveButtonVisible()).to eq(true)
      end

  end

  describe 'AC JRNL-1260|TC JRNL-1255: Save and Cancel Functionality' do

    it 'Save - Max', :broken => true do
      @allergies.setFieldValue('ALLERGY', '!@$%^&*()_+:?><,.;-~`123567890qwertyuioplkjhgfdaszxmncbvABCDEFGHIJKJLMNOPQRSTUVWXYZ!@$%^&*()_+:?><,.;-~`')
      @allergies.setFieldValue('ESTIMATED', 'Yes')
      @allergies.setFieldValue('SEVERITY', 'Severe')

      @allergies.clickDatePickerButton()
      !5.times{ break if (@date_picker.getSetButtonText() == 'SET'); sleep 1 }
      @date_picker.setDateFromGUI(2, 14, 2015)
      expect(@allergies.getFieldValue('DATE')).to eq('02/14/2015')

      @allergies.clickSaveButton()
      !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
      expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
      !30.times{ break if(getFocusedElementText() == Allergies::HEADERS['LIST']) }
      expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])

      expect(getCount()).to eq(1)
    end

    it 'Verify Max Data', :broken => true do
      text150 = '12356789012356789012356789012356789012356789012356789012356789012356789012356789012356789AbCdeFghIjklMNoPQRstuVWXyZz!?.,><*&^%$@12343567890='

      clickNthRow(1)
      !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['EDIT']); sleep 1 }
      expect(getPrimaryHeader()).to eq(Allergies::HEADERS['EDIT'])

      expect(@allergies.getFieldValue('ALLERGY')).to eq ('!@$%^&*()_+:?><,.;-~`123567890qwertyuioplkjhgfdas')
      expect(@allergies.getFieldValue('DATE')).to eq('02/14/2015')
      expect(@allergies.getFieldValue('ESTIMATED')).to eq('Yes')
      expect(@allergies.getFieldValue('SEVERITY')).to eq('Severe')
      expect(@allergies.getFieldValue('REACTION')).to eq((text150 + text150)[0..-51])
      expect(@allergies.getFieldValue('DIAGNOSED')).to eq('Yes')
      expect(@allergies.getFieldValue('PROVIDER_FACILITY')).to eq((text150 + text150)[0..-51])
      expect(@allergies.getFieldValue('NOTE')).to eq((text150 + text150)[0..-51])

      @allergies.clickCancelButton()
      !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
      expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
      !30.times{ break if(getFocusedElementText() == Allergies::HEADERS['LIST']) }
      expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])
    end

    it 'Save - Min', :broken => true do
      @common.clickAddButton()
      !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
      expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

      @common.selectRadioButton('allergyType', 'Food/Environmental')
      @allergies.setFieldValue('ALLERGY', 'Pollen')
      @allergies.setFieldValue('DATE', '03/07/1991')

      @allergies.clickSaveButton()
      !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
      expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
      !30.times{ break if(getFocusedElementText() == Allergies::HEADERS['LIST']) }
      expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])

      expect(getCount()).to eq(2)
    end

    it 'Verify Min Data', :broken => true do
      clickNthRow(2)

      expect(@allergies.getFieldValue('ALLERGY')).to eq ('Pollen')
      expect(@allergies.getFieldValue('DATE')).to eq('03/07/1991')
      expect(@allergies.getFieldValue('ESTIMATED')).to eq('No')
      expect(@allergies.getFieldValue('SEVERITY')).to eq('')
      expect(@allergies.getFieldValue('REACTION')).to eq('')
      expect(@allergies.getFieldValue('DIAGNOSED')).to eq('No')
      expect(@allergies.getFieldValue('NOTE')).to eq('')

      @allergies.clickCancelButton()
      !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
      expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
      !30.times{ break if(getFocusedElementText() == Allergies::HEADERS['LIST']) }
      expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])
    end

    it 'Cancel', :broken => true do
      @common.clickAddButton()
      !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
      expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

      @common.selectRadioButton('allergyType', 'Food/Environmental')
      @allergies.setFieldValue('ALLERGY', 'Pet Dander')

      @allergies.clickCancelButton()
      !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
      expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])
      !30.times{ break if(getFocusedElementText() == Allergies::HEADERS['LIST']) }
      expect(getFocusedElementText()).to eq(Allergies::HEADERS['LIST'])

      expect(getCount()).to eq(2)
    end

  end

  describe 'AC JRNL-1259|TC-5006: Navigation Without Saving' do

    context 'Clicking Back Button' do

      it 'No changes', :broken => true do
        @common.clickAddButton()
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

        @allergies.clickBackButton()
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])

        expect(getCount()).to eq(2)
      end

      it 'Changes', :broken => true do
        @common.clickAddButton()
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

        @allergies.setFieldValue('NOTE', 'Navigation Test')

        @allergies.clickBackButton()
        !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq('Confirmation')
        expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. You may continue without saving or return to the entry screen.')
        expect(@modal.getConfirmButtonText()).to eq('Continue')
        expect(@modal.getCancelButtonText()).to eq('Return')

        @modal.clickReturnButton()
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

        @allergies.clickBackButton()
        !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq('Confirmation')
        expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. You may continue without saving or return to the entry screen.')
        expect(@modal.getConfirmButtonText()).to eq('Continue')
        expect(@modal.getCancelButtonText()).to eq('Return')

        @modal.clickContinueButton()
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])

        expect(getCount()).to eq(2)
      end

    end

    context 'Clicking Menu Item' do

      it 'No changes', :broken => true do
        @common.clickAddButton()
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

        @my_medical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])

        expect(getCount()).to eq(2)
      end

      it 'Changes', :broken => true do
        @common.clickAddButton()
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

        @allergies.setFieldValue('NOTE', 'Navigation Test')

        @my_medical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
        !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq('Confirmation')
        expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. You may continue without saving or return to the entry screen.')
        expect(@modal.getConfirmButtonText()).to eq('Continue')
        expect(@modal.getCancelButtonText()).to eq('Return')

        @modal.clickReturnButton()
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['ADD']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['ADD'])

        @my_medical.click(:css, Nav_menu::NAV['Allergies']['navButton'])
        !5.times{ break if (@modal.getConfirmationHeading() == 'Confirmation'); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq('Confirmation')
        expect(@modal.getConfirmationMessage()).to eq('You have not saved your changes. You may continue without saving or return to the entry screen.')
        expect(@modal.getConfirmButtonText()).to eq('Continue')
        expect(@modal.getCancelButtonText()).to eq('Return')

        @modal.clickContinueButton()
        !5.times{ break if (getPrimaryHeader() == Allergies::HEADERS['LIST']); sleep 1 }
        expect(getPrimaryHeader()).to eq(Allergies::HEADERS['LIST'])

        expect(getCount()).to eq(2)
      end

    end

  end

  #######################
  ### Local Functions ###
  #######################

  def checkingInlineError(errMsg, seqNum)
    #Verify that the error message section header is displayed
    if seqNum == 0 then
      !5.times{ break if (@error.getValidationSummaryHeader('form') == 'The following errors were found:'); sleep 1 }
      expect(@error.getValidationSummaryHeader('form')).to eq('The following errors were found:')
    end
    #Verify the error message is displayed
    expect(@error.isErrorMessageDisplayed('form', errMsg)).to eq(true)
  end

end
=end