require_relative '../../globalized'
include Globalized

describe "Story #JRNL-2483: [MyMedical_Add_My_Medical_Feature_JRNL_2483_spec.rb]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
  end

  after(:all) do
    quitDriver()
  end

  context "AC JRNL-3301|TC JRNL-2737: The 'My Medical' feature for a male" do

    it "Visible" do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      expect(@nav_menu.isMyMedicalButtonVisible).to eq("My Medical")
    end

    it "Label" do
      expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["MyProfile"]["navButton"])).to eq("My Profile")
    end

    it "Location" do
      ## JRNL-1724 AC states the "My Profile" should now be the first nav item.
      expect(@nav_menu.getNthOptionName(4)).to eq("My Medical")
    end

    it "Secondary Header" do
      @nav_menu.clickMyMedical()

      !45.times{ break if (@my_medical.getFocusedElementText() == @my_medical.getSecondaryHeader()); sleep 1 }
      expect(@my_medical.getFocusedElementText()).to eq("My Medical")
      expect(@my_medical.getSecondaryHeader()).to eq("My Medical")
    end

    it "Primary Header" do
      expect(@my_medical.getPrimaryHeader()).to eq("My Medical")
    end

    it "Default Message" do
      !30.times{ break if(isElementVisible(:css, "div.page.row span")); sleep 1 }
      expect(@common.getDefaultMsg()).to eq("Select an item from the My Medical list to view details or add a new My Medical entry.")
    end

    describe "AC JRNL-3302|TC JRNL-2737: Sub-Features - AC JRNL-1728|JRNL-1656 : Sub Feature Selection for Plan Your Appointment" do

      it "Plan Your Appointment" do
        # JRNL-2459 AC make "Plan Your Appointment" the first item
        expect(@my_medical.getNthMyMedicalFeatureName(1)).to eq("Plan Your Appointment")
      end

      it "Symptom Diary" do
        # JRNL-1743 AC place "Symptom Diary" above "Diagnoses"
        expect(@my_medical.getNthMyMedicalFeatureName(2)).to eq("Symptom Diary")
      end

      it "Medications" do
        # JRNL-1283 AC - "Medications" goes below "Symptom Diary"
        expect(@my_medical.getNthMyMedicalFeatureName(3)).to eq("Medications")
      end

      it "Allergies" do
        # JRNL-1265 AC - "Allergies" goes above "Diagnoses"
        expect(@my_medical.getNthMyMedicalFeatureName(4)).to eq("Allergies")
      end

      it "Diagnoses" do
        expect(@my_medical.getNthMyMedicalFeatureName(5)).to eq("Diagnoses")
      end

      it "Surgeries" do
        expect(@my_medical.getNthMyMedicalFeatureName(6)).to eq("Surgeries")
      end

      it "Hospitalizations" do
        expect(@my_medical.getNthMyMedicalFeatureName(7)).to eq("Hospitalizations")
      end

      it "Pregnancy History" do
        ## JRNL-1749 hides the "Pregnancy History" sub-feature when the user is a male
        expect(@my_medical.is_element_present(:css, Nav_menu::NAV["PregnancyHistory"]["navButton"])).to eq(false)
      end

      it "Family History" do
        expect(@my_medical.getNthMyMedicalFeatureName(8)).to eq("Family History")
      end

    end

  end

  context "AC JRNL-3301|TC JRNL-2737: The 'My Medical' feature for a female" do

    it "Logout male. Login female.", :broken => true do
      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.female96", "female96, zztest")
    end

    it "Visible", :broken => true do
      expect(@nav_menu.isMyMedicalButtonVisible).to eq("My Medical")
    end

    it "Label", :broken => true do
      expect(@nav_menu.getTextForElement(:css, Nav_menu::NAV["MyProfile"]["navButton"])).to eq("My Profile")
    end

    it "Location", :broken => true do
      ## JRNL-1724 AC states the "My Profile" should now be the first nav item. So "My Medical" is now the second.
      ## JRNL-3301 AC states the "My Profile" should now be the first nav item. It is now the 4th as altered by JRNL-3138.
      expect(@nav_menu.getNthOptionName(4)).to eq("My Medical")
    end

    it "Secondary Header", :broken => true do
      @nav_menu.clickMyMedical()

      !45.times{ break if (@my_medical.getFocusedElementText() == @my_medical.getSecondaryHeader()); sleep 1 }
      expect(@my_medical.getFocusedElementText()).to eq("My Medical")
      expect(@my_medical.getSecondaryHeader()).to eq("My Medical")
    end

    it "Primary Header", :broken => true do
      expect(@my_medical.getPrimaryHeader()).to eq("My Medical")
    end

    it "Default Message", :broken => true do
      !30.times{ break if(isElementVisible(:css, "div.page.row span")); sleep 1 }
      expect(@common.getDefaultMsg()).to eq("Select an item from the My Medical list to view details or add a new My Medical entry.")
    end

    describe "AC JRNL-3302|TC JRNL-2737: Sub-Features  -  AC JRNL-1728|TC JRNL-1656: Sub Feature Selection for Plan Your Appointment" do

      it "Plan Your Appointment", :broken => true do
        # JRNL-2459 AC make "Plan Your Appointment" the first item
        expect(@my_medical.getNthMyMedicalFeatureName(1)).to eq("Plan Your Appointment")
      end

      it "Symptom Diary", :broken => true do
        # JRNL-1743 AC place "Symptom Diary" above "Diagnoses"
        expect(@my_medical.getNthMyMedicalFeatureName(2)).to eq("Symptom Diary")
      end

      it "Medications", :broken => true do
        # JRNL-1283 AC - "Medications" goes below "Symptom Diary"
        expect(@my_medical.getNthMyMedicalFeatureName(3)).to eq("Medications")
      end

      it "Allergies", :broken => true do
        # JRNL-1265 AC - "Allergies" goes above "Diagnoses"
        expect(@my_medical.getNthMyMedicalFeatureName(4)).to eq("Allergies")
      end

      it "Diagnoses", :broken => true do
        expect(@my_medical.getNthMyMedicalFeatureName(5)).to eq("Diagnoses")
      end

      it "Surgeries", :broken => true do
        expect(@my_medical.getNthMyMedicalFeatureName(6)).to eq("Surgeries")
      end

      it "Hospitalizations", :broken => true do
        expect(@my_medical.getNthMyMedicalFeatureName(7)).to eq("Hospitalizations")
      end

      it "Pregnancy History", :broken => true do
        expect(@my_medical.getNthMyMedicalFeatureName(8)).to eq("Pregnancy History")
      end

      it "Family History", :broken => true do
        expect(@my_medical.getNthMyMedicalFeatureName(9)).to eq("Family History")
      end

    end

  end

end
