require_relative '../../../globalized'
include Globalized

describe "Story JRNL-1779: [Images_Documents_Add_Edit_Delete_Other_View_MVAH_2418_spec.rb]", :regression => true do

  header_text = "Images and Documents"
  other_header_text = "Other"
  add_header_text = "Add Images and Documents"
  category = "category"
  type = "type"
  date = "date"
  add_attachment = "addFile"
  notes = "Notes"

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("attachments.chunks", "attachmentsdb")
    removeCollection("attachments.files", "attachmentsdb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !5.times{break if(@nav_menu.getNavMenuHeading()== "App Options"); sleep 1}
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
  end

  # after(:all) do
  #   quitDriver()
  # end

  context 'AC#JRNL-1716|TC #JRNL-1529: Add Images and Documents for Images and Documents "Other" View' do

    it "Images and Documents table list inside 'Other' view" do
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='ImagesandDocuments']").click
      waitForPageToFinishLoading
      !5.times{break if(getPrimaryHeader()== header_text); sleep 1}
      expect(getPrimaryHeader()).to eq(header_text)

      #Click on 'All' Sub-Feature and Verify '+' button is visible and verifying Alt text for '+' button
      @driver.find_element(:css, "button[class='btn btn-default other']").click
      !5.times{break if(getPrimaryHeader()== other_header_text); sleep 1}
      expect(@common.isAddButtonVisible()).to eq(true)
      expect(@common.getAddButtonAltText()).to eq("Add")
    end

    it "Clicking the '+' button displays the Detail View" do

      #Clicking '+' to get to the detail screen
      waitForPageToFinishLoading
      @common.clickAddButton()
      waitForPageToFinishLoading
      !5.times{break if(getPrimaryHeader() == add_header_text); sleep 1}
      expect(getPrimaryHeader()).to eq(add_header_text)
    end
  end

  context 'AC#JRNL-1715|TC #JRNL-1529: Add Images and Documents for Images and Documents Detail "Other" View' do

    it "Required Field Error Message Validation" do
      #Clicking the 'Save' button without entering any data
      waitForPageToFinishLoading
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading
      !5.times{break if(@error.getValidationSummaryHeader("form") == "The following errors were found:"); sleep 1}

      #Verifying Error Messages
      expect(@error.getValidationSummaryHeader("form")).to eq("The following errors were found:")
      # expect(@error.isErrorMessageDisplayed("form", "Category field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Type field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Date of Document field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "File Attachment is required.")).to eq(true)
    end

    it "Category" do
      #Verifying Field Label, is the field required and the content
      expect(getShortFieldLabel(category, true)).to eq("Category:")
      expect(isFieldRequired(:css, Images_Documents::CATEGORY)).to eq(true)
      expect(areAllTheseValuesAvailableInDropDown(Images_Documents::CATEGORY, "Select,All,Medical,Military,Other")).to eq(true)
    end

    it "Type" do
      expect(getShortFieldLabel(type, true)).to eq("Type:")
      expect(isFieldRequired(:css, Images_Documents::TYPE)).to eq(true)
      expect(areAllTheseValuesAvailableInDropDown(Images_Documents::TYPE, "Select, EKG, X-Ray Report, Test Results, Legal, Power of Attorney, Living Will, Line of Duty Injury Report, DD214, Medication, Hospital Discharge Summary, Other"))
    end

    it "Date of Document", :broken => true do
      expect(getShortFieldLabel(date, true)).to eq("Required: Date of Document: M M / D D / Y Y Y Y:")
      expect(isFieldRequired(:css, Images_Documents::DATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Images_Documents::DATE)).to eq("MM/DD/YYYY")
    end

    it "Info Modal", :broken => true do
      expect(is_element_present(:css, Images_Documents::INFO_MODAL)).to eq(true)

      #Clicking and Verifying Info Modal Content
      waitForPageToFinishLoading
      @images_docs.clickInfoModal()
      waitForPageToFinishLoading
      expect(@modal.getConfirmationHeading()).to eq("File Information")
      expect(@modal.getConfirmationMessage()).to eq("Individual files must not exceed 10 MB in size and must be a supported file type:
jpeg, jpg, png, rtf, pdf, tif, tiff, doc, docx, xml, xmlx, txt
If the total amount of storage space used by your files is more than 100 MB, you will be asked to delete files before additional files may be added.")

      @modal.clickReturnButton()
    end

    it "Attach File Button", :broken => true do
      expect(is_element_present(:css, Images_Documents::ATTACH_FILE)).to eq(true)

      #Attaching an unsupported file type and verifying
      addAttachment(add_attachment, "Attach_File_Unsupported.xlsx")
      @entry_form.clickSaveButton()
      expect(@error.isErrorMessageDisplayed("form", "Your file could not be added. Attachments must be one of the following types: jpeg, jpg, rtf, pdf, tif, tiff, doc, docx, xml, xmlx, txt, xml. In addition, each file can be no bigger than 10 MB, and only one file may be added at time. Please check the file and try again.")).to eq(true)
      @images_docs.deleteAttachedFile()
      expect(is_element_present(:css, Images_Documents::ATTACH_FILE)).to eq(true)

      #Attaching a supported file type and verifying that the 'Attach File' button disappears
      addAttachment(add_attachment, "testSat.jpg")
      expect(is_element_present(:css, Images_Documents::ATTACH_FILE)).to eq(false)

      #Verifying 'X Delete' button is present beside the filename
      # sleep 10
      # expect(is_element_present(:css, Images_Documents::X_DELETE)).to eq(true)
      #
      # #Clicking 'X Delete' button to delete the attachment and verifying 'Attach File' button is present
      # @images_docs.deleteAttachedFile()
      # expect(is_element_present(:css, Images_Documents::ATTACH_FILE)).to eq(true)


    end

    it "Note" do
      expect(isFieldRequired(:css,Images_Documents::NOTES )).to eq(false)
      textareaMaxLengthTest(notes, 250, true)
    end

    it "Save and Cancel" do
      expect(@entry_form.isSaveButtonVisible()).to eq(true)
      expect(@entry_form.isCancelButtonVisible()).to eq(true)

      @entry_form.clickCancelButton()
      waitForPageToFinishLoading()
      !5.times{ break if (getPrimaryHeader() == other_header_text); sleep 1 }
      expect(getPrimaryHeader()).to eq("Other")
    end
  end

  context 'AC#JRNL-1713, JRNL-1714|TC #JRNL-1529: Save Add Images and Documents entry "Other" View; Edit Images and Documents Entry; Cancel Images and Documents Entry' do

    it "Save Images and Documents Entry", :broken => true do
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()

      #Completing Required Fields
      setEntryValues({
                         category =>"Other",
                         type=>"EKG",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my EKG",

                     });

      #Adding Attachment and clicking Save button
      addAttachment(add_attachment, "heartbeat.jpg")
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()

      !5.times{ break if (getTextForRowColumn(1,1) == "Other"); sleep 1 }

      #Verifying that correct information is displayed in the table view
      expect(getTextForRowColumn(1,1)).to eq("Other")

    end

    it "Cancel and Edit Images and Documents entry", :broken => true do

      #Selecting the previously saved entry from the table
      #clickNthRow(1)
      waitForPageToFinishLoading
      @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div/div[2]/list-table/div/div/ul/li[1]/span[6]").click
      waitForPageToFinishLoading

      #Edit all required fields, attach a different image and click 'Cancel' button
      setEntryValues({
                         category =>"Other",
                         type=>"X-Ray Report",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my X-ray",

                     });

      @images_docs.deleteAttachedFile()

      addAttachment(add_attachment, "imgo.jpeg")
      @entry_form.clickCancelButton()

      #Verify that nothing was saved
      expect(getTextForRowColumn(1,2)).to eq("EKG")

      #Selecting the saved entry from the table once more
      #clickNthRow(1)
      waitForPageToFinishLoading
      @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div/div[2]/list-table/div/div/ul/li[1]/span[6]").click
      waitForPageToFinishLoading

      #Edit all required fields, attach a different image and click 'Save' button
      setEntryValues({
                         category =>"Other",
                         type=>"X-Ray Report",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my X-ray",

                     });
      @images_docs.deleteAttachedFile()
      sleep 1

      addAttachment(add_attachment, "imgo.jpeg")
      @entry_form.clickSaveButton()

      !5.times{ break if (getTextForRowColumn(1,2) == "X-Ray Report"); sleep 1 }

      #Verify that the Edited entry was saved
      #expect(getTextForRowColumn(1,2)).to eq("X-Ray Report")


    end

  end

  context 'AC#JRNL-1713|TC #JRNL-1529: Delete Images and Documents Entry "All" View'  do

    it "Deleting Images and Documents Entry", :broken => true do
      #Selecting a previously saved Entry
      #clickNthRow(1)
      waitForPageToFinishLoading
      @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div/div[2]/list-table/div/div/ul/li[1]/span[6]").click
      waitForPageToFinishLoading

      #Verifying 'Delete' button is present
      expect(@entry_form.isDeleteButtonVisible()).to eq(true)

      #Deleting the Entry
      @entry_form.clickDeleteButton()
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
      @modal.clickNoButton()
      @entry_form.clickDeleteButton()
      @modal.clickYesButton()

      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Other")

      #Verifying the table is empty
      expect(getNoResultsFoundMessage()). to eq("")

    end

  end

  context 'AC #JRNL-1579 |TC #JRNL-3008: Navigation for Images and Documents' do

    it "Verifying '<' button is present for Add View and it functions as expected", :broken => true do
      waitForPageToFinishLoading
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Add Images and Documents")

      #Verifying '<' button is present
      expect(@entry_form.isBackButtonVisible()).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      @entry_form.clickBackButton()

      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Other")

      #Verifying No Results Message
      expect(getNoResultsFoundMessage()).to eq("")



      #Verifying '<' button functionality after making changes on Add Screen
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Add Images and Documents")

      setEntryValues({
                         category =>"Other",
                         type=>"X-Ray Report",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my X-ray",

                     });

      @entry_form.clickBackButton()

      #Verifying Modal Popup
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")

      #Clicking Return to go back to Add View
      @modal.clickReturnButton()
      expect(getPrimaryHeader()).to eq("Add Images and Documents")

      #Clicking '<' button and continuing
      @entry_form.clickBackButton()
      @modal.clickContinueButton()

      waitForPageToFinishLoading()

      expect(getPrimaryHeader()).to eq("Other")

      #Verifying no results message to check nothing was added
      #expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")


    end

    it "Verifying '<' button is present for Edit View and it functions as expected", :broken => true do

      #Adding and Saving an Entry to Edit
      waitForPageToFinishLoading
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading
      expect(getPrimaryHeader()).to eq("Add Images and Documents")

      setEntryValues({
                         category =>"Other",
                         type=>"X-Ray Report",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my X-ray",

                     });

      addAttachment(add_attachment, "pinball9mb.jpg")

      @entry_form.clickSaveButton()
      waitForPageToFinishLoading
      expect(getTextForRowColumn(1,1)).to eq("Military")

      #Clicking on the Saved entry to open it in Edit View
      #clickNthRow(1)
      waitForPageToFinishLoading
      @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div/div[2]/list-table/div/div/ul/li[1]/span[6]").click
      waitForPageToFinishLoading
      # expect(getPrimaryHeader()).to eq("Edit Images and Documents")

      #Verifying '<' button is present
      expect(@entry_form.isBackButtonVisible()).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      @entry_form.clickBackButton()
      waitForPageToFinishLoading()

      expect(getPrimaryHeader()).to eq(other_header_text)

      #Verifying no changes were made
      expect(getTextForRowColumn(1,1)).to eq("Other")

      #Clicking on the Saved entry one more time to open it in Edit View
      #clickNthRow(1)
      waitForPageToFinishLoading
      @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div/div[2]/list-table/div/div/ul/li[1]/span[6]").click
      waitForPageToFinishLoading
      # expect(getPrimaryHeader()).to eq("Edit Family History Entry")

      #Making changes and clicking the '<' button
      setEntryValues({
                         category =>"Other",
                         type=>"EKG",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my EKG",

                     });
      @images_docs.deleteAttachedFile()
      sleep 1
      addAttachment(add_attachment, "spidey.jpg")

      @entry_form.clickBackButton()

      #Verifying Modal Popup
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      #Clicking Return to go back to Edit View
      @modal.clickReturnButton()
      # expect(getPrimaryHeader()).to eq("Edit Images and Documents")

      waitForPageToFinishLoading()

      #Clicking '<' button and continuing
      @entry_form.clickBackButton()
      @modal.clickContinueButton()

      waitForPageToFinishLoading()

      expect(getPrimaryHeader()).to eq(other_header_text)

      #Verifying no changes were made
      expect(getTextForRowColumn(1,1)).to eq("Other")

    end

  end

end









































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "Story JRNL-1779: [Images_Documents_Add_Edit_Delete_Other_View_MVAH_2418_spec.rb]", :regression => true do

  header_text = "Images and Documents"
  other_header_text = "Other"
  add_header_text = "Add Images and Documents"
  category = "category"
  type = "type"
  date = "date"
  add_attachment = "addFile"
  notes = "Notes"

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("attachments.chunks", "attachmentsdb")
    removeCollection("attachments.files", "attachmentsdb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{break if(@nav_menu.getNavMenuHeading()== "App Options"); sleep 1}
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")


  end

  after(:all) do
    quitDriver()

  end

  context 'AC#JRNL-1716|TC #JRNL-1529: Add Images and Documents for Images and Documents "Other" View' do

    it "Images and Documents table list inside 'Other' view" do
      @nav_menu.clickImagesDocuments()
      !15.times{break if(getPrimaryHeader()== header_text); sleep 1}
      expect(getPrimaryHeader()).to eq(header_text)

      #Click on 'All' Sub-Feature and Verify '+' button is visible and verifying Alt text for '+' button
      @nav_menu.clickOther()
      !15.times{break if(getPrimaryHeader()== other_header_text); sleep 1}
      expect(@common.isAddButtonVisible()).to eq(true)
      expect(@common.getAddButtonAltText()).to eq("Add")

    end

    it "Clicking the '+' button displays the Detail View" do

      #Clicking '+' to get to the detail screen
      @common.clickAddButton()
      !15.times{break if(getPrimaryHeader() == add_header_text); sleep 1}
      expect(getPrimaryHeader()).to eq(add_header_text)

    end

  end

  context 'AC#JRNL-1715|TC #JRNL-1529: Add Images and Documents for Images and Documents Detail "Other" View' do

    it "Required Field Error Message Validation" do
      #Clicking the 'Save' button without entering any data
      @entry_form.clickSaveButton()
      !15.times{break if(@error.getValidationSummaryHeader("form") == "The following errors were found:"); sleep 1}

      #Verifying Error Messages
      expect(@error.getValidationSummaryHeader("form")).to eq("The following errors were found:")
      # expect(@error.isErrorMessageDisplayed("form", "Category field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Type field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "Date of Document field is required.")).to eq(true)
      expect(@error.isErrorMessageDisplayed("form", "File Attachment is required.")).to eq(true)

    end

    it "Category" do
      #Verifying Field Label, is the field required and the content
      expect(getShortFieldLabel(category, true)).to eq("Category:")
      expect(isFieldRequired(:css, Images_Documents::CATEGORY)).to eq(true)
      expect(areAllTheseValuesAvailableInDropDown(Images_Documents::CATEGORY, "Select,All,Medical,Military,Other")).to eq(true)

    end

    it "Type" do
      expect(getShortFieldLabel(type, true)).to eq("Type:")
      expect(isFieldRequired(:css, Images_Documents::TYPE)).to eq(true)
      expect(areAllTheseValuesAvailableInDropDown(Images_Documents::TYPE, "Select, EKG, X-Ray Report, Test Results, Legal, Power of Attorney, Living Will, Line of Duty Injury Report, DD214, Medication, Hospital Discharge Summary, Other"))

    end

    it "Date of Document", :broken => true do
      expect(getShortFieldLabel(date, true)).to eq("Date of Document:")
      expect(isFieldRequired(:css, Images_Documents::DATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Images_Documents::DATE)).to eq("MM/DD/YYYY")

    end

    it "Info Modal", :broken => true do
      expect(is_element_present(:css, Images_Documents::INFO_MODAL)).to eq(true)

      #Clicking and Verifying Info Modal Content
      @images_docs.clickInfoModal()
      expect(@modal.getConfirmationHeading()).to eq("File Information")
      expect(@modal.getConfirmationMessage()).to eq("Individual files must not exceed 10 MB in size and must be a supported file type:
jpeg, jpg, png, rtf, pdf, tif, tiff, doc, docx, xml, xmlx, txt
If the total amount of storage space used by your files is more than 100 MB, you will be asked to delete files before additional files may be added.")

      @modal.clickReturnButton()
    end

    it "Attach File Button", :broken => true do
      expect(is_element_present(:css, Images_Documents::ATTACH_FILE)).to eq(true)

      #Attaching an unsupported file type and verifying
      addAttachment(add_attachment, "Attach_File_Unsupported.xlsx")
      @entry_form.clickSaveButton()
      expect(@error.isErrorMessageDisplayed("form", "Your file could not be added. Attachments must be one of the following types: jpeg, jpg, rtf, pdf, tif, tiff, doc, docx, xml, xmlx, txt, xml. In addition, each file can be no bigger than 10 MB, and only one file may be added at time. Please check the file and try again.")).to eq(true)
      @images_docs.deleteAttachedFile()
      expect(is_element_present(:css, Images_Documents::ATTACH_FILE)).to eq(true)

      #Attaching a supported file type and verifying that the 'Attach File' button disappears
      addAttachment(add_attachment, "testSat.jpg")
      expect(is_element_present(:css, Images_Documents::ATTACH_FILE)).to eq(false)

      #Verifying 'X Delete' button is present beside the filename
      expect(is_element_present(:css, Images_Documents::X_DELETE)).to eq(true)

      #Clicking 'X Delete' button to delete the attachment and verifying 'Attach File' button is present
      @images_docs.deleteAttachedFile()
      expect(is_element_present(:css, Images_Documents::ATTACH_FILE)).to eq(true)


    end

    it "Note" do
      expect(isFieldRequired(:css,Images_Documents::NOTES )).to eq(false)
      textareaMaxLengthTest(notes, 250, true)

    end

    it "Save and Cancel" do


      expect(@entry_form.isSaveButtonVisible()).to eq(true)
      expect(@entry_form.isCancelButtonVisible()).to eq(true)

      @entry_form.clickCancelButton()
      waitForPageToFinishLoading()
      !15.times{ break if (getPrimaryHeader() == other_header_text); sleep 1 }
      expect(getPrimaryHeader()).to eq(other_header_text)

    end

  end

  context 'AC#JRNL-1713, JRNL-1714|TC #JRNL-1529: Save Add Images and Documents entry "Other" View; Edit Images and Documents Entry; Cancel Images and Documents Entry' do

    it "Save Images and Documents Entry", :broken => true do
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()

      #Completing Required Fields
      setEntryValues({
                         category =>"Other",
                         type=>"EKG",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my EKG",

                     });

      #Adding Attachment and clicking Save button
      addAttachment(add_attachment, "heartbeat.jpg")
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()

      !30.times{ break if (getTextForRowColumn(1,1) == "Other"); sleep 1 }

      #Verifying that correct information is displayed in the table view
      expect(getTextForRowColumn(1,1)).to eq("Other")

    end

    it "Cancel and Edit Images and Documents entry", :broken => true do

      #Selecting the previously saved entry from the table
      clickNthRow(1)
      waitForPageToFinishLoading()

      #Edit all required fields, attach a different image and click 'Cancel' button
      setEntryValues({
                         category =>"Other",
                         type=>"X-Ray Report",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my X-ray",

                     });

      @images_docs.deleteAttachedFile()

      addAttachment(add_attachment, "imgo.jpeg")
      @entry_form.clickCancelButton()

      #Verify that nothing was saved
      expect(getTextForRowColumn(1,2)).to eq("EKG")

      #Selecting the saved entry from the table once more
      clickNthRow(1)
      waitForPageToFinishLoading()

      #Edit all required fields, attach a different image and click 'Save' button
      setEntryValues({
                         category =>"Other",
                         type=>"X-Ray Report",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my X-ray",

                     });
      @images_docs.deleteAttachedFile()
      sleep 1

      addAttachment(add_attachment, "imgo.jpeg")
      @entry_form.clickSaveButton()

      !30.times{ break if (getTextForRowColumn(1,2) == "X-Ray Report"); sleep 1 }

      #Verify that the Edited entry was saved
      expect(getTextForRowColumn(1,2)).to eq("X-Ray Report")


    end

  end

  context 'AC#JRNL-1713|TC #JRNL-1529: Delete Images and Documents Entry "All" View'  do

    it "Deleting Images and Documents Entry", :broken => true do
      #Selecting a previously saved Entry
      clickNthRow(1)

      #Verifying 'Delete' button is present
      expect(@entry_form.isDeleteButtonVisible()).to eq(true)

      #Deleting the Entry
      @entry_form.clickDeleteButton()
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
      @modal.clickNoButton()
      @entry_form.clickDeleteButton()
      @modal.clickYesButton()

      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(other_header_text)

      #Verifying the table is empty
      expect(getNoResultsFoundMessage()). to eq("No results were found with the current filters. Use the Add button above to create a new record.")

    end

  end

  context 'AC #JRNL-1579 |TC #JRNL-3008: Navigation for Images and Documents' do

    it "Verifying '<' button is present for Add View and it functions as expected", :broken => true do
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Add Images and Documents")

      #Verifying '<' button is present
      expect(@entry_form.isBackButtonVisible()).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      @entry_form.clickBackButton()

      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(other_header_text)

      #Verifying No Results Message
      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")



      #Verifying '<' button functionality after making changes on Add Screen
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Add Images and Documents")

      setEntryValues({
                         category =>"Other",
                         type=>"X-Ray Report",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my X-ray",

                     });

      @entry_form.clickBackButton()

      #Verifying Modal Popup
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      #Clicking Return to go back to Add View
      @modal.clickReturnButton()
      expect(getPrimaryHeader()).to eq("Add Images and Documents")

      #Clicking '<' button and continuing
      @entry_form.clickBackButton()
      @modal.clickContinueButton()

      waitForPageToFinishLoading()

      expect(getPrimaryHeader()).to eq(other_header_text)

      #Verifying no results message to check nothing was added
      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")


    end

    it "Verifying '<' button is present for Edit View and it functions as expected", :broken => true do

      #Adding and Saving an Entry to Edit
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Add Images and Documents")

      setEntryValues({
                         category =>"Other",
                         type=>"X-Ray Report",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my X-ray",

                     });

      addAttachment(add_attachment, "pinball9mb.jpg")

      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()
      expect(getTextForRowColumn(1,1)).to eq("Other")

      #Clicking on the Saved entry to open it in Edit View
      clickNthRow(1)
      waitForPageToFinishLoading()
      # expect(getPrimaryHeader()).to eq("Edit Images and Documents")

      #Verifying '<' button is present
      expect(@entry_form.isBackButtonVisible()).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      @entry_form.clickBackButton()
      waitForPageToFinishLoading()

      expect(getPrimaryHeader()).to eq(other_header_text)

      #Verifying no changes were made
      expect(getTextForRowColumn(1,1)).to eq("Other")

      #Clicking on the Saved entry one more time to open it in Edit View
      clickNthRow(1)
      waitForPageToFinishLoading()
      # expect(getPrimaryHeader()).to eq("Edit Family History Entry")

      #Making changes and clicking the '<' button
      setEntryValues({
                         category =>"Other",
                         type=>"EKG",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my EKG",

                     });
      @images_docs.deleteAttachedFile()
      sleep 1
      addAttachment(add_attachment, "spidey.jpg")

      @entry_form.clickBackButton()

      #Verifying Modal Popup
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")
      expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      #Clicking Return to go back to Edit View
      @modal.clickReturnButton()
      # expect(getPrimaryHeader()).to eq("Edit Images and Documents")

      waitForPageToFinishLoading()

      #Clicking '<' button and continuing
      @entry_form.clickBackButton()
      @modal.clickContinueButton()

      waitForPageToFinishLoading()

      expect(getPrimaryHeader()).to eq(other_header_text)

      #Verifying no changes were made
      expect(getTextForRowColumn(1,1)).to eq("Other")

    end

  end

end
=end