require_relative '../../../globalized'
include Globalized

describe "Story# JRNL-1777: [Images and Documents - All List and Filter View]", :regression=>true do

  header_text = "Images and Documents"
  all_header_text = "All"
  category = "category"
  filterCategory = "filterCategory"
  type = "type"
  date = "date"
  startDate = "startDate"
  endDate = "endDate"
  add_attachment = "addFile"
  notes = "Notes"

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("attachments.chunks", "attachmentsdb")
    removeCollection("attachments.files", "attachmentsdb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !5.times{break if(@nav_menu.getNavMenuHeading()== "App Options"); sleep 1}
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")


  end

  # after(:all) do
  #   quitDriver()
  # end

  context 'AC#JRNL-1702|TC #JRNL-1645: Filter "All" for Images and Documents - All List and Filter View' do

    it "Images and Documents table list inside 'All' view" do
      waitForPageToFinishLoading
      @driver.find_element(:css, "button[id='ImagesandDocuments']").click
      !5.times{break if(getPrimaryHeader()== header_text); sleep 1}
      expect(getPrimaryHeader()).to eq(header_text)

      @driver.find_element(:css, "button[class='btn btn-default all']").click
      !5.times{break if(getPrimaryHeader()== all_header_text); sleep 1}
      expect(@common.isAddButtonVisible()).to eq(true)
      expect(@common.getAddButtonAltText()).to eq("Add")

    end

    it "Filter Control", :broken => true do
      #Click the hide filter button
      waitForPageToFinishLoading
      @images_docs.showOrHideFilter()
      sleep 1
      #Verify the status filter options are hidden
      expect(@images_docs.isFilterCollapsed).to eq(true)

      #Flip the hide filter button again
      @images_docs.showOrHideFilter()
      sleep 1
      expect(@images_docs.isTheFilterButtonVisible()).to eq(true)
    end

    it "Start Date", :broken => true do
      expect(getShortFieldLabel(startDate, true)).to eq("Required: : M M / D D / Y Y Y Y:")
      expect(isFieldRequired(:css, Images_Documents::STARTDATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Images_Documents::STARTDATE)).to eq("MM/DD/YYYY")

    end

    it "End Date", :broken => true do
      expect(getShortFieldLabel(endDate, true)).to eq("Required: : M M / D D / Y Y Y Y:")
      expect(isFieldRequired(:css, Images_Documents::ENDDATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Images_Documents::ENDDATE)).to eq("MM/DD/YYYY")

    end

    it "Category" do
      expect(getLongFieldLabel(filterCategory)).to eq("Category:")
      expect(areAllTheseValuesAvailableInDropDown(Images_Documents::FILTERCATEGORY, "Select,Medical,Military,Other")).to eq(true)

    end

    it "Type" do
      expect(getLongFieldLabel(type)).to eq("Type:")
      expect(areAllTheseValuesAvailableInDropDown(Images_Documents::TYPE, "Select, EKG, X-Ray Report, Test Results, Legal, Power of Attorney, Living Will, Line of Duty Injury Report, DD214, Medication, Hospital Discharge Summary, Other"))

    end

    it "Filter and Reset button" do
      expect(@images_docs.isTheFilterButtonVisible()).to eq(true)
      expect(@images_docs.isTheResetButtonVisible()).to eq(true)
    end

  end

  context 'AC #JRNL-1701 |TC #JRNL-1645: Filter Action and Results Display for Images and Documents - All List and Filter View' do

    it "Prevent Future date" do
      time = Time.new()
      today = time.strftime("%m/%d/%Y")
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      dayAfterTomorrow = getDateNthDaysFromNow(2, "%m/%d/%Y")
      setDate(dayAfterTomorrow, "input[name='startDate']")
      setDate(tomorrow, "input[name='endDate']")
      @images_docs.clickFilter
      @error.isErrorMessageDisplayed("filterForm","Start Date must occur before End Date")
      @error.isErrorMessageDisplayed("filterForm","Start date must be between 01/01/1900 and " + today + ".")
      @error.isErrorMessageDisplayed("filterForm","End date must be between 01/01/1900 and " + today + ".")
      sleep 2
      setDate("11/31/2013", "input[name='startDate']")
      setDate("09/31/2014", "input[name='endDate']")
      @images_docs.clickFilter
      @error.isErrorMessageDisplayed("filterForm","Start Date is an invalid date")
      @error.isErrorMessageDisplayed("filterForm","End Date is an invalid date")
      sleep 2
    end

    it "Add Entry" do
      #1st entry
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()

      #Completing Required Fields
      setEntryValues({
                         category =>"Medical",
                         type=>"EKG",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my EKG",

                     });

      #Adding Attachment and clicking Save button
      addAttachment(add_attachment, "heartbeat.jpg")
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()

      #2nd entry
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      setEntryValues({
                         category =>"Military",
                         type=>"X-Ray Report",
                         date => getDateNthDaysAgo(5, "%m/%d/%Y"),
                         notes => "This is my X-ray",

                     });

      addAttachment(add_attachment, "imgo.jpeg")
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()
      expect(getTextForRowColumn(2,1)).to eq("Medical")

      #3rd entry
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      setEntryValues({
                         category =>"Other",
                         type=>"Test Results",
                         date => getDateNthDaysAgo(10, "%m/%d/%Y"),
                         notes => "Talk to Veterans Affair",

                     });

      addAttachment(add_attachment, "imgo.jpeg")
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()

      #4th entry
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      setEntryValues({
                         category =>"Other",
                         type=>"Legal",
                         date => getDateNthDaysAgo(10, "%m/%d/%Y"),
                         notes => "Talk to Veterans Affair",

                     });

      addAttachment(add_attachment, "imgo.jpeg")
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()
    end

    it "Filter Action and Results Display", :broken => true do
      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that correct information is displayed in the table view
      expect(getTableHeaders()).to eq(["Category", "Type", "Document Date", "File Type", "Size"])
      expect(getTextForRowColumn(1,1)).to eq("Medical")
      expect(getTextForRowColumn(2,1)).to eq("Medical")
      expect(getTextForRowColumn(3,1)).to eq("Medical")
      sleep 2
      waitForPageToFinishLoading
      #@images_docs.selectCategory("Medical")
      @driver.find_element(:css, "select[name='filterCategory']").send_keys "Medical"
      waitForPageToFinishLoading
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that correct information is displayed in the table view
      expect(getTextForRowColumn(1,1)).to eq("Medical")
      sleep 2
      waitForPageToFinishLoading
      #@images_docs.selectCategory("Military")
      @driver.find_element(:css, "select[name='filterCategory']").send_keys "Military"
      waitForPageToFinishLoading
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that correct information is displayed in the table view
      expect(getTextForRowColumn(1,1)).to eq("Medical")
      sleep 2
      waitForPageToFinishLoading
      #@images_docs.selectCategory("Other")
      @driver.find_element(:css, "select[name='filterCategory']").send_keys "Other"
      waitForPageToFinishLoading
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that correct information is displayed in the table view
      expect(getTextForRowColumn(1,1)).to eq("Other")
      sleep 2

      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that correct information is displayed in the table view
      expect(getTextForRowColumn(1,1)).to eq("Medical")
      expect(getTextForRowColumn(2,1)).to eq("Military")
      expect(getTextForRowColumn(3,1)).to eq("Other")
      sleep 2

      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.selectType("Test Results")
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      expect(getTextForRowColumn(1,1)).to eq("Other")
      sleep 2
    end
  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible" do
      expect(isResetButtonPresent()).to eq(true)
    end

    it "Label" do
      expect(getResetButtonLabel()).to eq("Reset")
    end

    it "Result" do
      nowDate = Time.new()
      thenDate = Time.new(nowDate.year() - 1, nowDate.month(), nowDate.day())

      clickResetBtn()
      waitForPageToFinishLoading()
      expect(getTextForRowColumn(1,1)).to eq("Medical")
      expect(getTextForRowColumn(2,1)).to eq("Medical")
      expect(getTextForRowColumn(3,1)).to eq("Medical")

      # DEFAULTS
      expect(getTextFromInput(:css, "input[name='#{startDate}']")).to eq(thenDate.strftime("%m/%d/%Y"))
      expect(getTextFromInput(:css, "input[name='#{endDate}']")).to eq(nowDate.strftime("%m/%d/%Y"))
      expect(getTextFromInput(:css, "select[name='#{type}']")).to eq("")
      expect(getTextFromInput(:css, "select[name='#{filterCategory}']")).to eq("Military")
    end

  end

  context 'AC #JRNL-1700 |TC #JRNL-1645: Sub Feature Default View (Table List) from Images and Documents - All List and Filter View' do
    it " no results found", :broken => true do
      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.selectType("Test Results")
      waitForPageToFinishLoading
      #@images_docs.selectCategory("Medical")
      @driver.find_element(:css, "select[name='filterCategory']").send_keys "Medical"
      waitForPageToFinishLoading
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that No results found message displays
      expect(getNoResultsFoundMessage()).to eq("")

      #sorted in reverse chronological order by document date
      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      isSortedByChronologicalOrder("%m/%d/%Y", 3)

      #Deleting  Entry
      #clickNthRow(1)
      waitForPageToFinishLoading
      @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div/div[2]/list-table/div/div/ul/li[1]/span[6]").click
      waitForPageToFinishLoading
      @entry_form.clickDeleteButton()
      @modal.clickYesButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(all_header_text)
      waitForPageToFinishLoading
      @driver.find_element(:xpath, ".//*[@id='main-content-div']/div[2]/div/div[2]/list-table/div/div/ul/li[1]/span[6]").click
      waitForPageToFinishLoading
      @entry_form.clickDeleteButton()
      @modal.clickYesButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(all_header_text)

      # secondary sort is on document type
      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      isSortedAlphabeticallyByThisColumn(2)
    end

  end

  context 'AC #JRNL-1699 |TC #JRNL-1645: Navigation for Images and Documents - All List and Filter View' do

    it "Verifying '<' button" do
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Add Images and Documents")

      #Verifying '<' button is present
      expect(@entry_form.isBackButtonVisible()).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      @entry_form.clickBackButton()

      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(all_header_text)

      #Resizing the window to phone size and verifying link is still visible.
      resizeWindowTo(320, 480)
      expect(isElementVisible(:css, 'button[ng-click="goBack()"]')).to be true
      closeBrowser
    end

  end

  # Local Function

  def getNoResultsFoundMessage()
    return getTextForElement(:css, '.no-results-message')
  end

end



























































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin
require_relative '../../../globalized'
include Globalized

describe "Story# JRNL-1777: [Images and Documents - All List and Filter View]", :regression=>true do

  header_text = "Images and Documents"
  all_header_text = "All"
  category = "category"
  filterCategory = "filterCategory"
  type = "type"
  date = "date"
  startDate = "startDate"
  endDate = "endDate"
  add_attachment = "addFile"
  notes = "Notes"

  before(:all) do
    initializeConfigurations(BASE_URL)
    removeCollection("attachments.chunks", "attachmentsdb")
    removeCollection("attachments.files", "attachmentsdb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{break if(@nav_menu.getNavMenuHeading()== "App Options"); sleep 1}
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")


  end

  after(:all) do
    quitDriver()

  end

  context 'AC#JRNL-1702|TC #JRNL-1645: Filter "All" for Images and Documents - All List and Filter View' do

    it "Images and Documents table list inside 'All' view" do
      @nav_menu.clickImagesDocuments()
      !15.times{break if(getPrimaryHeader()== header_text); sleep 1}
      expect(getPrimaryHeader()).to eq(header_text)

      @nav_menu.clickAll()
      !15.times{break if(getPrimaryHeader()== all_header_text); sleep 1}
      expect(@common.isAddButtonVisible()).to eq(true)
      expect(@common.getAddButtonAltText()).to eq("Add")

    end

    it "Filter Control", :broken => true do
      #Click the hide filter button
      @images_docs.showOrHideFilter()
      sleep 1
      #Verify the status filter options are hidden
      expect(@images_docs.isFilterCollapsed).to eq(true)

      #Flip the hide filter button again
      @images_docs.showOrHideFilter()
      sleep 1
      expect(@images_docs.isTheFilterButtonVisible()).to eq(true)
    end

    it "Start Date", :broken => true do
      expect(getShortFieldLabel(startDate, true)).to eq("Start Date:")
      expect(isFieldRequired(:css, Images_Documents::STARTDATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Images_Documents::STARTDATE)).to eq("MM/DD/YYYY")

    end

    it "End Date", :broken => true do
      expect(getShortFieldLabel(endDate, true)).to eq("End Date:")
      expect(isFieldRequired(:css, Images_Documents::ENDDATE)).to eq(true)
      expect(getPlaceHolderByCSS(:css, Images_Documents::ENDDATE)).to eq("MM/DD/YYYY")

    end

    it "Category" do
      expect(getLongFieldLabel(filterCategory)).to eq("Category:")
      expect(areAllTheseValuesAvailableInDropDown(Images_Documents::FILTERCATEGORY, "Select,Medical,Military,Other")).to eq(true)

    end

    it "Type" do
      expect(getLongFieldLabel(type)).to eq("Type:")
      expect(areAllTheseValuesAvailableInDropDown(Images_Documents::TYPE, "Select, EKG, X-Ray Report, Test Results, Legal, Power of Attorney, Living Will, Line of Duty Injury Report, DD214, Medication, Hospital Discharge Summary, Other"))

    end

    it "Filter and Reset button" do
      expect(@images_docs.isTheFilterButtonVisible()).to eq(true)
      expect(@images_docs.isTheResetButtonVisible()).to eq(true)
    end


  end

  context 'AC #JRNL-1701 |TC #JRNL-1645: Filter Action and Results Display for Images and Documents - All List and Filter View' do

    it "Prevent Future date" do
      time = Time.new()
      today = time.strftime("%m/%d/%Y")
      tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
      dayAfterTomorrow = getDateNthDaysFromNow(2, "%m/%d/%Y")
      setDate(dayAfterTomorrow, "input[name='startDate']")
      setDate(tomorrow, "input[name='endDate']")
      @images_docs.clickFilter
      @error.isErrorMessageDisplayed("filterForm","Start Date must occur before End Date")
      @error.isErrorMessageDisplayed("filterForm","Start date must be between 01/01/1900 and " + today + ".")
      @error.isErrorMessageDisplayed("filterForm","End date must be between 01/01/1900 and " + today + ".")
      sleep 2
      setDate("11/31/2013", "input[name='startDate']")
      setDate("09/31/2014", "input[name='endDate']")
      @images_docs.clickFilter
      @error.isErrorMessageDisplayed("filterForm","Start Date is an invalid date")
      @error.isErrorMessageDisplayed("filterForm","End Date is an invalid date")
      sleep 2
    end

    it "Add Entry" do
      #1st entry
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()

      #Completing Required Fields
      setEntryValues({
                         category =>"Medical",
                         type=>"EKG",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y"),
                         notes => "This is my EKG",

                     });

      #Adding Attachment and clicking Save button
      addAttachment(add_attachment, "heartbeat.jpg")
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()

      #2nd entry
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      setEntryValues({
                         category =>"Military",
                         type=>"X-Ray Report",
                         date => getDateNthDaysAgo(5, "%m/%d/%Y"),
                         notes => "This is my X-ray",

                     });

      addAttachment(add_attachment, "imgo.jpeg")
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()
      expect(getTextForRowColumn(2,1)).to eq("Military")

      #3rd entry
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      setEntryValues({
                         category =>"Other",
                         type=>"Test Results",
                         date => getDateNthDaysAgo(10, "%m/%d/%Y"),
                         notes => "Talk to Veterans Affair",

                     });

      addAttachment(add_attachment, "imgo.jpeg")
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()

      #4th entry
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      setEntryValues({
                         category =>"Other",
                         type=>"Legal",
                         date => getDateNthDaysAgo(10, "%m/%d/%Y"),
                         notes => "Talk to Veterans Affair",

                     });

      addAttachment(add_attachment, "imgo.jpeg")
      @entry_form.clickSaveButton()
      waitForPageToFinishLoading()
    end

    it "Filter Action and Results Display", :broken => true do
      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that correct information is displayed in the table view
      expect(getTableHeaders()).to eq(["Category", "Type", "Document Date", "File Type", "Size"])
      expect(getTextForRowColumn(1,1)).to eq("Medical")
      expect(getTextForRowColumn(2,1)).to eq("Military")
      expect(getTextForRowColumn(3,1)).to eq("Other")
      sleep 2

      @images_docs.selectCategory("Medical")
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that correct information is displayed in the table view
      expect(getTextForRowColumn(1,1)).to eq("Medical")
      sleep 2

      @images_docs.selectCategory("Military")
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that correct information is displayed in the table view
      expect(getTextForRowColumn(1,1)).to eq("Military")
      sleep 2

      @images_docs.selectCategory("Other")
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that correct information is displayed in the table view
      expect(getTextForRowColumn(1,1)).to eq("Other")
      sleep 2

      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that correct information is displayed in the table view
      expect(getTextForRowColumn(1,1)).to eq("Medical")
      expect(getTextForRowColumn(2,1)).to eq("Military")
      expect(getTextForRowColumn(3,1)).to eq("Other")
      sleep 2

      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.selectType("Test Results")
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      expect(getTextForRowColumn(1,1)).to eq("Other")
      sleep 2
    end
  end

  context "Story JRNL-1696|AC JRNL-1583: Reset Button" do

    it "Visible" do
      expect(isResetButtonPresent()).to eq(true)
    end

    it "Label" do
      expect(getResetButtonLabel()).to eq("Reset")
    end

    it "Result" do
      nowDate = Time.new()
      thenDate = Time.new(nowDate.year() - 1, nowDate.month(), nowDate.day())

      clickResetBtn()
      waitForPageToFinishLoading()
      expect(getTextForRowColumn(1,1)).to eq("Medical")
      expect(getTextForRowColumn(2,1)).to eq("Military")
      expect(getTextForRowColumn(3,1)).to eq("Other")

      # DEFAULTS
      expect(getTextFromInput(:css, "input[name='#{startDate}']")).to eq(thenDate.strftime("%m/%d/%Y"))
      expect(getTextFromInput(:css, "input[name='#{endDate}']")).to eq(nowDate.strftime("%m/%d/%Y"))
      expect(getTextFromInput(:css, "select[name='#{type}']")).to eq("")
      expect(getTextFromInput(:css, "select[name='#{filterCategory}']")).to eq("")
    end

  end

  context 'AC #JRNL-1700 |TC #JRNL-1645: Sub Feature Default View (Table List) from Images and Documents - All List and Filter View' do
    it " no results found", :broken => true do
      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.selectType("Test Results")
      @images_docs.selectCategory("Medical")
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      #Verifying that No results found message displays
      expect(getNoResultsFoundMessage()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")

      #sorted in reverse chronological order by document date
      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      isSortedByChronologicalOrder("%m/%d/%Y", 3)

      #Deleting  Entry
      clickNthRow(1)
      @entry_form.clickDeleteButton()
      @modal.clickYesButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(all_header_text)
      clickNthRow(1)
      @entry_form.clickDeleteButton()
      @modal.clickYesButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(all_header_text)

      # secondary sort is on document type
      @images_docs.clickReset
      waitForPageToFinishLoading()
      @images_docs.clickFilter
      waitForPageToFinishLoading()
      isSortedAlphabeticallyByThisColumn(2)
    end

  end

  context 'AC #JRNL-1699 |TC #JRNL-1645: Navigation for Images and Documents - All List and Filter View' do

    it "Verifying '<' button" do
      @entry_form.clickAddEntryButton()
      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq("Add Images and Documents")

      #Verifying '<' button is present
      expect(@entry_form.isBackButtonVisible()).to eq(true)

      #Clicking '<' button without any changes to return to the table view
      @entry_form.clickBackButton()

      waitForPageToFinishLoading()
      expect(getPrimaryHeader()).to eq(all_header_text)

      #Resizing the window to phone size and verifying link is still visible.
      resizeWindowTo(320, 480)
      expect(isElementVisible(:css, 'button[ng-click="goBack()"]')).to be true
      closeBrowser
    end

  end

  # Local Function

  def getNoResultsFoundMessage()
    return getTextForElement(:css, '.no-results-message')
  end

end
=end