require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1778:  ImagesDoc_Add_to_Left_Nav_JRNL_1778_spec.rb]", :regression=>true do

  header_text = "Images and Documents"

  before(:all) do
    initializeConfigurations(BASE_URL)

    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

  end

  after(:all) do
    quitDriver()
  end

  context 'AC#JRNL-1698|TC #JRNL-1651: Add Images and Documents to left navigation' do
    it ". 1) When a user opens the Left Panel navigation, the system displays a navigation option for the Images and Documents feature at the bottom of the list and named as Images and Documents" do


      expect(@nav_menu.isImagesDocumentButtonVisible()).to eq(true)
      expect(@nav_menu.getImagesDocumentsButtonText()).to eq("Images and Documents")
      @nav_menu.clickImagesDocuments()
      !15.times{ break if (getPrimaryHeader() == header_text); sleep 1 }

    end

    it ". 2) When the user selects the Images and Documents feature, the system displays the Feature groups in the Main Screen. And correct header text was displayed on primary and secondary screen " do

      expect(@nav_menu.isAllButtonVisible()).to eq(true)
      expect(@nav_menu.getNthSubFeatureName(1)).to eq("All")
      expect(@nav_menu.isMedicalButtonVisible()).to eq(true)
      expect(@nav_menu.getNthSubFeatureName(2)).to eq("Medical")
      expect(@nav_menu.isMilitaryButtonVisible()).to eq(true)
      expect(@nav_menu.getNthSubFeatureName(3)).to eq("Military")
      expect(@nav_menu.isIMGOtherButtonVisible()).to eq(true)
      expect(@nav_menu.getNthSubFeatureName(4)).to eq("Other")

      expect(getPrimaryHeader()).to eq(header_text)
      expect(getSecondaryHeader()).to eq(header_text)

    end

    it ". 2) Verify that the correct instructional text is displayed in the Detail screen" do
      expect(getTextForElement(:css, @misc.defaultPlaceholderMessage)).to eq("Select an item from the Images and Documents list to view details or add a new Images and Documents entry.")
    end

    it ". 3) Verify that when clicking on each subgroup the table view displays" do
      @nav_menu.clickAll()
      !15.times{ break if (getPrimaryHeader() == "All"); sleep 1 }
      expect(getPrimaryHeader()).to eq("All")

      @nav_menu.clickMedical()
      !15.times{ break if (getPrimaryHeader() == "Medical"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Medical")

      @nav_menu.clickMilitary()
      !15.times{ break if (getPrimaryHeader() == "Military"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Military")

      @nav_menu.clickIMGOther()
      !15.times{ break if (getPrimaryHeader() == "Other"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Other")
    end

  end


end
