# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-1059: Health Report Feature Available on Main Navigation]
          [Story #JRNL-1058: Healthcare Summary - Report and Generation]
          [Story #JRNL-1057: Detailed Medical and Personal Data - Contact Info, Meds, Allergies, Surgery, Diagnoses, Hospitalizations]
          [Story #JRNL-1034: Detailed Medical and Personal Data - Pregnancy, Family, and Military History Data]
          [Story #JRNL-1051: Tracked Data - Report Selection and Generation]
          [Story #JRNL-1049: Other Trackers - Goals - Report Generation and Selection]", :acceptance => true do


  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

  end

  after(:all) do
    quitDriver()
  end

  context "AC JRNL-1055|TC JRNL-1041: Health Report Feature Available on Main Navigation Criteria" do
    it "When a user opens the App Options menu, a feature labeled “Health Report” is available at the bottom of the feature list." do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
      expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
      expect(@nav_menu.getNthOptionName(11)).to eq("Health Report")
    end

    it "When a user selects Health Report the report selection options display in the detail screen" do
      @nav_menu.clickHealthReport()
      !45.times{ break if (getMainHeader== "Health Report"); sleep 1 }
      expect(getMainHeader).to eq("Health Report")
      expect(getTextForElement(:css,  INSTRUCTIONAL_TEXT)).to eq("Important: Protect your information and your identity. Send your information to a safe site or device that someone you trust controls. Remember, once you have downloaded your information, it is your responsibility to keep it safe and private.")
    end

    it "Generate Report (button)" do
      expect(isElementPresentAndVisible(:css, GENERATE_REPORT_BTN)).to eq(true)
      expect(getTextForElement(:css, GENERATE_REPORT_BTN)).to eq("Generate Report")
    end
  end

  context "AC JRNL-1053|TC JRNL-1043: Personal and Healthcare Summary -- Report Selection and Generation"  do
    it "Title: Healthcare Summary and Instructional Text" do
      expect(getTextForElement(:css,  HEALTHCARE_SUMMARY_HEADER)).to eq("Healthcare Summary")
      expect(getTextForElement(:css,  HEALTHCARE_SUMMARY_INSTRUCTIONAL_TEXT)).to eq("The Healthcare Summary includes your most recently entered vital signs, current/active self-entered medical data, and personal contact information.")
    end

    it "Checkbox: Include Healthcare Summary (default to checked)" do
      expect(getTextForElement(:css,  INCLUDE_SUMMARY_LABEL)).to eq("Include Healthcare Summary")
      expect(@health_report.isIncludeHealthSummaryChecked).to eq(true)

      click(:css,  INCLUDE_SUMMARY_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

      click(:css,  INCLUDE_SUMMARY_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

    end

  end

  context "AC JRNL-1052|TC JRNL-1031: Current Medical Data – Report Selection and Generation Criteria (Contact Info, Meds, Allergies, Surgery, Diagnoses, Hospitalizations)"  do
    it "Title: Detailed Medical and Personal Data" do
      expect(getTextForElement(:css,  DETAILED_MEDICAL_PERSONAL_DATA_HEADER)).to eq("Detailed Medical and Personal Data")
      expect(getTextForElement(:css,  DETAILED_MEDICAL_INSTRUCTIONAL_TEXT)).to eq("Includes detailed self-entered information from the My Medical and the Profile features. Select categories to include in your report.")
    end

    it "Checkboxes: Contact Information, Diagnoses, Medications, Allergies, Surgeries, Hospitalizations" do
      click(:css,  INCLUDE_SUMMARY_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN) == false); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(false)

      expect(getTextForElement(:css,  DETAILED_CONTACT_LABEL)).to eq("Contact Information")

      click(:css,  DETAILED_CONTACT_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      click(:css,  DETAILED_CONTACT_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN) == true); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

      expect(getTextForElement(:css,  DETAILED_DIAGNOSIS_LABEL)).to eq("Diagnoses")

      click(:css,  DETAILED_DIAGNOSIS_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      click(:css,  DETAILED_DIAGNOSIS_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

      expect(getTextForElement(:css,  DETAILED_MEDICATION_LABEL)).to eq("Medications")

      click(:css,  DETAILED_MEDICATION_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      click(:css,  DETAILED_MEDICATION_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

      expect(getTextForElement(:css,  DETAILED_ALLERGY_LABEL)).to eq("Allergies")

      click(:css,  DETAILED_ALLERGY_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      click(:css,  DETAILED_ALLERGY_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN) ); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

      expect(getTextForElement(:css,  DETAILED_SURGERY_LABEL)).to eq("Surgeries")

      click(:css,  DETAILED_SURGERY_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      click(:css,  DETAILED_SURGERY_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

      expect(getTextForElement(:css,  DETAILED_HOSPITALIZATION_LABEL)).to eq("Hospitalizations")

      click(:css,  DETAILED_HOSPITALIZATION_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      click(:css,  DETAILED_HOSPITALIZATION_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN) ); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)
    end

  end

  context "AC JRNL-1030|TC JRNL-1025: Detailed Medical and Personal Data – Pregnancy, Family, and Military History Data"  do
    it "Checkboxes: Pregnancy, Family, and Military History Data", :broken => true do
      expect(getTextForElement(:css,  DETAIL_FAMILY_HISTORY_LABEL)).to eq("Family History")
      click(:css,  DETAIL_FAMILY_HISTORY_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      click(:css,  DETAIL_FAMILY_HISTORY_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

      expect(getTextForElement(:css,  DETAIL_MILITARY_HISTORY_LABEL)).to eq("Military History")
      click(:css,  DETAIL_MILITARY_HISTORY_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      click(:css,  DETAIL_MILITARY_HISTORY_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.female96", "female96, zztest")

      @nav_menu.clickHealthReport()

      !45.times{ break if (getMainHeader== "Health Report"); sleep 1 }
      expect(getMainHeader).to eq("Health Report")
      click(:css,  INCLUDE_SUMMARY_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN) == false); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(false)

      expect(getTextForElement(:css,  DETAIL_PREGNANCY_LABEL)).to eq("Pregnancy History")
      click(:css,  DETAIL_PREGNANCY_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      click(:css,  DETAIL_PREGNANCY_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

    end
  end

  context "AC JRNL-1050|TC JRNL-1024: Personal/Tracker Data - Report Selection and Generation " do
    it "Checkbox: Incude Personal Trackers (default to unchecked)", :broken => true do

      @common.switchUserThenLogBackInAndGoToLeftSideNav("zztest.patient01", "patient01, zztest")

      @nav_menu.clickHealthReport()

      !45.times{ break if (getMainHeader== "Health Report"); sleep 1 }
      expect(getMainHeader).to eq("Health Report")

      click(:css,  INCLUDE_SUMMARY_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

      expect(isElementEnabled?(:css,  INCLUDE_PERSONAL_TRACKERS_CHECKBOX))
      expect(getElement(:css, INCLUDE_PERSONAL_TRACKERS_CHECKBOX).selected?).to eq(false)

    end

    it "If Checkbox checked, enable date fields and all personal tracker domain checkboxes", :broken => true do
      click(:css,  INCLUDE_PERSONAL_TRACKERS_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      expect(getTextForElement(:css,  INCLUDE_PERSONAL_TRACKERS_LABEL)).to eq("Include Personal Trackers")

      expect(getTextForElement(:css, BP_AND_PULSE_LABEL)).to eq("Blood Pressure and Pulse")
      expect(getTextForElement(:css, CHOLESTEROL_LIPID_LABEL)).to eq("Cholesterol/Lipid")
      expect(getTextForElement(:css, GLUCOSE_LABEL)).to eq("Glucose (Self Tested)")
      expect(getTextForElement(:css, HEIGHT_LABEL )).to eq("Height")
      expect(getTextForElement(:css, PAIN_LABEL )).to eq("Pain")
      expect(getTextForElement(:css, RESPIRATION_LABEL)).to eq("Respiration")
      expect(getTextForElement(:css, TEMPERATURE_LABEL)).to eq("Temperature")
      expect(getTextForElement(:css, WEIGHT_LABEL)).to eq("Weight")

      expect(getTextForElement(:css,  REQUIRED_FIELD_FOR_TD_TEXT)).to eq("* required field")
      expect(@date_filter.isStartDateEnabled).to eq(true)
      expect(@date_filter.isEndDateEnabled).to eq(true)

      expect(@date_filter.isStartDateRequiredField()).to eq(true)
      expect(@date_filter.isEndDateRequiredField()).to eq(true)

      expect(isElementEnabled?(:css, BP_AND_PULSE_CHECKBOX)).to eq(true)
      expect(isElementEnabled?(:css, CHOLESTEROL_LIPID_CHECKBOX)).to eq(true)
      expect(isElementEnabled?(:css, GLUCOSE_CHECKBOX)).to eq(true)
      expect(isElementEnabled?(:css, HEIGHT_CHECKBOX)).to eq(true)
      expect(isElementEnabled?(:css, PAIN_CHECKBOX)).to eq(true)
      expect(isElementEnabled?(:css, RESPIRATION_CHECKBOX)).to eq(true)
      expect(isElementEnabled?(:css, TEMPERATURE_CHECKBOX)).to eq(true)
      expect(isElementEnabled?(:css, WEIGHT_CHECKBOX)).to eq(true)

      click(:css,  INCLUDE_PERSONAL_TRACKERS_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

      expect(@date_filter.isStartDateEnabled).to eq(false)
      expect(@date_filter.isEndDateEnabled).to eq(false)

      expect(@date_filter.isStartDateRequiredField()).to eq(false)
      expect(@date_filter.isEndDateRequiredField()).to eq(false)

      expect(@date_filter.getStartDate).to eq("")
      expect(@date_filter.getEndDate).to eq("")

      expect(isThisElementDisabled(:css, BP_AND_PULSE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, CHOLESTEROL_LIPID_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, GLUCOSE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, HEIGHT_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, PAIN_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, RESPIRATION_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, TEMPERATURE_CHECKBOX)).to eq(true)
      expect(isThisElementDisabled(:css, WEIGHT_CHECKBOX)).to eq(true)

    end

    it "Date Range", :broken => true do
      tomorrow = getDateNthDaysFromNow(1,  "%m/%d/%Y")
      today = getDateNthDaysAgo(0, "%m/%d/%Y")
      expectedValidationSummaryHeader = "The following errors were found:"
      twoDaysAgo = getDateNthDaysFromNow(-2, "%m/%d/%Y")
      pastSixYears = getDateNThYearFromGivenDate(twoDaysAgo, -6)
      sixYearsAgo = getDateNthYearsAgo(6, "%m/%d/%Y")
      thirtyDaysAgo = getDateNthDaysFromNow(-30,  "%m/%d/%Y")

      click(:css,  INCLUDE_PERSONAL_TRACKERS_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      expect(@date_filter.getStartDate).to eq(thirtyDaysAgo)
      expect(@date_filter.getEndDate).to eq(today)

      @date_filter.setDateRange(tomorrow, today)
      click(:css,  GENERATE_REPORT_BTN)

      !45.times{ break if (@error.getValidationSummaryHeader("trackedDataForm") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("trackedDataForm")).to eq(expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("trackedDataForm", "Start Date must occur before End Date.")).to eq(true)

      @date_filter.setDateRange(pastSixYears, today)
      click(:css,  GENERATE_REPORT_BTN)

      !45.times{ break if (@error.getValidationSummaryHeader("trackedDataForm") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("trackedDataForm")).to eq(expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("trackedDataForm", "Start Date must be between " + sixYearsAgo + " and " + today + ".")).to eq(true)

      twoDaysLater =  getDateNthDaysFromNow(2,  "%m/%d/%Y")

      @date_filter.setDateRange(tomorrow, twoDaysLater)
      click(:css,  GENERATE_REPORT_BTN)

      !45.times{ break if (@error.getValidationSummaryHeader("trackedDataForm") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("trackedDataForm")).to eq(expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("trackedDataForm", "Start Date must be between " + sixYearsAgo + " and " + today + ".")).to eq(true)

      @date_filter.setDateRange(today, twoDaysLater)
      click(:css,  GENERATE_REPORT_BTN)

      !45.times{ break if (@error.getValidationSummaryHeader("trackedDataForm") == expectedValidationSummaryHeader); sleep 1 }
      expect(@error.getValidationSummaryHeader("trackedDataForm")).to eq(expectedValidationSummaryHeader)
      expect(@error.isErrorMessageDisplayed("trackedDataForm", "End Date must be between " + sixYearsAgo + " and " + today + ".")).to eq(true)
    end

    it "Tracker Domain checkbox", :broken => true do
      click(:css,  BP_AND_PULSE_CHECKBOX)
      click(:css,  CHOLESTEROL_LIPID_CHECKBOX)
      click(:css,  GLUCOSE_CHECKBOX)
      click(:css,  HEIGHT_CHECKBOX)
      click(:css,  PAIN_CHECKBOX)
      click(:css,  RESPIRATION_CHECKBOX)
      click(:css,  TEMPERATURE_CHECKBOX)
      click(:css,  WEIGHT_CHECKBOX)

      expect(getElement(:css, BP_AND_PULSE_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, CHOLESTEROL_LIPID_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, GLUCOSE_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, HEIGHT_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, PAIN_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, RESPIRATION_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, TEMPERATURE_CHECKBOX).selected?).to eq(true)
      expect(getElement(:css, WEIGHT_CHECKBOX).selected?).to eq(true)

      click(:css,  INCLUDE_PERSONAL_TRACKERS_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

      expect(getElement(:css, BP_AND_PULSE_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, CHOLESTEROL_LIPID_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, GLUCOSE_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, HEIGHT_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, PAIN_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, RESPIRATION_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, TEMPERATURE_CHECKBOX).selected?).to eq(false)
      expect(getElement(:css, WEIGHT_CHECKBOX).selected?).to eq(false)
    end

  end

  context "AC JRNL-1048|TC JRNL-1022: Other Tracker - Goals Report Selection and Generation Criteria" do
    it "Include Other Trackers checkbox", :broken => true do
      expect(getElement(:css,  INCLUDE_OTHER_TRACKERS_CHECKBOX).selected?).to eq(false)
      expect(getTextForElement(:css,  INCLUDE_OTHER_TRACKERS_LABEL)).to eq("Include Other Trackers")

      click(:css,  INCLUDE_OTHER_TRACKERS_CHECKBOX)
      !45.times{ break if (isElementEnabled?(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isElementEnabled?(:css, GENERATE_REPORT_BTN)).to eq(true)

      click(:css,  INCLUDE_OTHER_TRACKERS_CHECKBOX)
      !45.times{ break if (isThisElementDisabled(:css, GENERATE_REPORT_BTN)); sleep 1 }
      expect(isThisElementDisabled(:css, GENERATE_REPORT_BTN)).to eq(true)

     end
    end

end