require_relative '../../globalized'
include Globalized

describe "Story #JRNL-406: Time Picker", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteDailyEventTable("D123401")
    initializeAllObjects
    @personalTrackers = PersonalTrackers.new(@driver, nil)

    !45.times { break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times { break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times { break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times { break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @nav_menu.clickDailyEvents()

  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-452|TC #JRNL-815: Time picker is displayed" do

    @personalTrackers.clickAddEntryButton()
    waitForPageToFinishLoading
    @timePicker.clickTimePickerButton()
    !45.times { break if (@timePicker.getSetButtonText() == "SET"); sleep 1 }

    expect(@timePicker.getSetButtonText()).to eq("SET")
    waitForPageToFinishLoading
    @timePicker.clickCloseBtn()
  end

  it "AC #JRNL-453|TC #JRNL-815: The time picker will allow a user to select the time (HH:MM) via a set controls." do
    waitForPageToFinishLoading
    @timePicker.clickTimePickerButton()
    !45.times { break if (@timePicker.getSetButtonText() == "SET"); sleep 1 }
    expect(@timePicker.getSetButtonText()).to eq("SET")
    @timePicker.setAMPM("PM")
    !45.times { break if (@timePicker.getSelectedTimePeriod() == "PM"); sleep 1 }
    @timePicker.setMinute("12")
    !45.times { break if (@timePicker.getSelectedMinute() == "12"); sleep 1 }
    @timePicker.setHour("03")
    !45.times { break if (@timePicker.getSelectedHour() == "03"); sleep 1 }

    expect(@timePicker.getSelectedTimePeriod()).to eq("PM")
    expect(@timePicker.getSelectedMinute()).to eq("12")
    expect(@timePicker.getSelectedHour()).to eq("03")

    @timePicker.setAMPM("AM")
    !45.times { break if (@timePicker.getSelectedTimePeriod() == "AM"); sleep 1 }
    @timePicker.setMinute("04")
    !45.times { break if (@timePicker.getSelectedMinute() == "04"); sleep 1 }
    @timePicker.setHour("12")
    !45.times { break if (@timePicker.getSelectedHour() == "12"); sleep 1 }

    expect(@timePicker.getSelectedTimePeriod()).to eq("AM")
    expect(@timePicker.getSelectedMinute()).to eq("04")
    expect(@timePicker.getSelectedHour()).to eq("12")
    @timePicker.clickCloseBtn()

  end

  it "AC #JRNL-453|TC #JRNL-815: Once the user has entered the time, the user must select 'set' to close the time picker and populate the time field display. All time components (hours, minutes) must have a valid selection before a 'set' action can be invoked." do
    time = Time.new
    today = time.strftime("%m/%d/%Y")
    puts today
    yesterday = getDateNthDaysAgo(1, "%m/%d/%Y")

    setDate(yesterday, "input[name='date']")

    @timePicker.clickTimePickerButton()
    !45.times { break if (@timePicker.getSetButtonText() == "SET"); sleep 1 }
    expect(@timePicker.getSetButtonText()).to eq("SET")
    @timePicker.setAMPM("AM")
    !45.times { break if (@timePicker.getSelectedTimePeriod() == "AM"); sleep 1 }
    @timePicker.setMinute("04")
    !45.times { break if (@timePicker.getSelectedMinute() == "04"); sleep 1 }
    @timePicker.setHour("04")
    !45.times { break if (@timePicker.getSelectedHour() == "04"); sleep 1 }

    expect(@timePicker.getSelectedTimePeriod()).to eq("AM")
    expect(@timePicker.getSelectedMinute()).to eq("04")
    expect(@timePicker.getSelectedHour()).to eq("04")

    @timePicker.clickSet()
    !45.times { break if (@timePicker.getTime() == "04:04 AM"); sleep 1 }
    expect(@timePicker.getTime()).to eq("04:04 AM")
  end

  it "AC #JRNL-453|TC #JRNL-815: Users shall be able to exit out of the time picker without selecting a time. This action will retain the last 'set' time or a null time if the field was previously empty." do
    defaultTime = @timePicker.getTime()
    waitForPageToFinishLoading
    @timePicker.clickTimePickerButton()
    !45.times { break if (@timePicker.getSetButtonText() == "SET"); sleep 1 }
    expect(@timePicker.getSetButtonText()).to eq("SET")

    @timePicker.setAMPM("PM")
    !45.times { break if (@timePicker.getSelectedTimePeriod() == "PM"); sleep 1 }
    @timePicker.setMinute("10")
    !45.times { break if (@timePicker.getSelectedMinute() == "10"); sleep 1 }
    @timePicker.setHour("01")
    !45.times { break if (@timePicker.getSelectedHour() == "01"); sleep 1 }

    @timePicker.clickCloseBtn()
    expect(@timePicker.getTime() == defaultTime)

    clearDateOrTime("input[name='time']")
    expect(@timePicker.getTime()).to eq("")
    waitForPageToFinishLoading
    @timePicker.clickTimePickerButton()
    !45.times { break if (@timePicker.getSetButtonText == "SET"); sleep 1 }
    expect(@timePicker.getSetButtonText).to eq("SET")

    @timePicker.setAMPM("AM")
    !45.times { break if (@timePicker.getSelectedTimePeriod() == "AM"); sleep 1 }
    @timePicker.setMinute("11")
    !45.times { break if (@timePicker.getSelectedMinute() == "11"); sleep 1 }
    @timePicker.setHour("05")
    !45.times { break if (@timePicker.getSelectedHour() == "05"); sleep 1 }

    @timePicker.clickCloseBtn()
    expect(@timePicker.getTime() == "")
  end

  it "AC #JRNL-453|TC #JRNL-815: The time entered via the time picker must match the time populated in the time field display.", :broken => true do
    # refreshBrowser()
    waitForPageToFinishLoading
    @timePicker.clickTimePickerButton()
    # !45.times{ break if (@timePicker.getSetButtonText() == "SET"); sleep 1 }
    expect(@timePicker.getSetButtonText()).to eq("SET")

    @timePicker.setTimeFromGUI("02", "12", "PM")
    expect(@timePicker.getTime()).to eq("02:12 PM")
  end

  it "AC #JRNL-453|TC #JRNL-815: The spinner time display shall be shown in the format of hour (HH), and minute (MM)", :broken => true do
    waitForPageToFinishLoading
    @timePicker.clickTimePickerButton()
    !45.times{ break if (@timePicker.getSetButtonText() == "SET"); sleep 1 }
    expect(@timePicker.getSetButtonText()).to eq("SET")
    @timePicker.setAMPM("PM")
    !45.times{ break if (@timePicker.getSelectedTimePeriod() == "PM"); sleep 1 }
    @timePicker.setMinute("03")
    !45.times{ break if (@timePicker.getSelectedMinute() == "03"); sleep 1 }
    @timePicker.setHour("01")
    !45.times{ break if (@timePicker.getSelectedHour() == "01"); sleep 1 }

    expect(@timePicker.getSelectedTimePeriod()).to eq("PM")
    expect(@timePicker.getSelectedMinute()).to eq("03")
    expect(@timePicker.getSelectedHour()).to eq("01")

    expect(isTimeFormatValid?("01:03 PM", "%I:%M %p")).to eq(true)

    @timePicker.clickCloseBtn()
  end

  it "AC #JRNL-454|TC #JRNL-815: If the user has already entered/selected a time and invokes the time picker, the time picker will display the previously entered/selected time", :broken => true do
    setTime("02:45 PM", "input[name='time']")
    waitForPageToFinishLoading
    @timePicker.clickTimePickerButton()
    expect(@timePicker.getSelectedTimePeriod()).to eq("PM")
    expect(@timePicker.getSelectedMinute()).to eq("45")
    expect(@timePicker.getSelectedHour()).to eq("02")

    @timePicker.clickCloseBtn()
  end

  it "AC #JRNL-453|TC #JRNL-815: Once the user selects and sets the time, the time will appear in the correct format for the app (e.g. HH:MM).", :broken => true do
    waitForPageToFinishLoading
    @timePicker.clickTimePickerButton()
    !45.times{ break if (@timePicker.getSetButtonText() == "SET"); sleep 1 }
    @timePicker.setTimeFromGUI("08", "22", "AM")
    expect(@timePicker.getTime()).to eq("08:22 AM")

    expect(isTimeFormatValid?(@timePicker.getTime(), "%I:%M %p")).to eq(true)
  end
end
