require_relative '../../globalized'
include Globalized

describe "Story# JRNL-75 [Right_Side_Nav_JRNL_75_spec.rb] Right Menu navigation when user is logged in - Story # JRNL-11: Return to Launchpad journal", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-128 | AC# JRNL-168| TC# JRNL-130: Verify that the About, Logout and Launchpad buttons are present" do
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 } 
     @eula.clickAccept()  
    
    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")
    
    #Click the Right Side Toggle button
    @main.clickUserMenu()
    !45.times{ break if (@menu.getMenuHeading() == "User Menu"); sleep 1 }
   # !45.times{ break if (getTextForElement(:id, "about") == "About"); sleep 1 }
      
   # @menu.getMenuHeading().should == "User Menu"
    expect(@menu.verifyAboutButtonPresent()).to eq("About")
    expect(@menu.verifyLoginButtonPresent()).to eq("Login")
    expect(@menu.isHelpButtonVisible()).to be false
    expect(@menu.verifyLaunchpadButtonPresent()).to eq("Launchpad")
   
    @menu.clickLaunchpadBtn()
    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }
    waitForPageToFinishLoading
    @launchpad.clickJournal()
    
    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    @main.clickUserMenu()
    waitForPageToFinishLoading
    @menu.clickLoginBtn()
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    expect(getPageTitle()).to eq("Department of Veterans Affairs - Veteran Login Page")

    gotoHome(BASE_URL)

    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Click the Right Side Toggle button
    @main.clickUserMenu()
    !45.times{ break if (getTextForElement(:id, "about") == "About"); sleep 1 }
    expect(@menu.verifyAboutButtonPresent()).to eq("About")
    expect(@menu.verifyLogoutButtonPresent()).to eq("Logout")
    expect(@menu.verifyHelpButtonPresent()).to eq("Help")
    expect(@menu.verifyLaunchpadButtonPresent()).to eq("Launchpad")

  end

  it "AC #JRNL-128| TC# JRNL-130: Verify the Logout button functions as expected" do
    #Click the Logout button
    @menu.clickLogoutBtn()
    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }

    #Verify it's logged out
    waitForPageToFinishLoading
    expect(@launchpad.isLogInVisible()).to be true
    #Verify the user is logged out
    expect(@launchpad.getFooterUserName().include?("Not logged in")).to be true

    #Click the Back button on browser
    clickBackButtonOnBrowser()
    #Verify that user lands on the DSLogon screen, and no previous app data was displayed.
    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")

  end

  it "AC # JRNL-128| TC# JRNL-130: Verify the Launchpad button functions as expected" do
    #Reload angular-boilerplate
    gotoHome(BASE_URL)

    #Click Logon from Landing pages
    waitForPageToFinishLoading
    @landing.clickLogin()

    #Login to the project again
    @loginpage.loginAsVeteran("zztest.patient01")
    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }

    #Click the Right Side Toggle button
    @main.clickUserMenu()
    !45.times{ break if (getTextForElement(:id, "about") == "About"); sleep 1 }

    #Click Launchpad button
    waitForPageToFinishLoading
    @menu.clickLaunchpadBtn()
    waitForPageToFinishLoading
    @eula.clickAcceptLaunchpadEula()
    !45.times{ break if (getPageTitle() == "Launchpad"); sleep 1 }

    #Verify that Log Out button is visible, which means user is NOT logged out
    waitForPageToFinishLoading
    expect(@launchpad.isLogoutVisible()).to be true
    #Verify the user is still logged in
    expect(@launchpad.getFooterUserName().include?("Logged in as")).to be true
   end

end
