# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "[Story JRNL-1795: Resources][Story JRNL-1572: Resources - Update][Story JRNL-1420: Add DoD Resources]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @buttonOrder = ["About", "Help", "Resources"];

    @modalHeader = "Resources";

    @totalWindows = 1;

    @urgentItems = [
        {   "name" => nil,
            "nameHyperlink" => nil,
            "description" => "Crisis Line: Veterans & Military",
            "phone" => "1-800-273-8255 and Press 1",
            "additionalInfo" => "Confidential support is available 24 hours a day, 7 days a week, 365 days a year through the Veteran and Military Crisis Line, Online Chat, and text (838255)."
        },
        {   "name" => nil,
            "nameHyperlink" => nil,
            "description" => "VA Suicide Prevention Hot Line",
            "phone" => "1-800-273-TALK (8255)",
            "additionalInfo" => nil
        },
        {   "name" => nil,
            "nameHyperlink" => nil,
            "description" => "DoD Safe Helpline (Sexual Assault Support)",
            "phone" => "1-877-995-5247",
            "additionalInfo" => nil
        },
        {   "name" => nil,
            "nameHyperlink" => nil,
            "description" => "Caregiver Support Line",
            "phone" => "1-855-260-3274",
            "additionalInfo" => nil
        },
        {   "name" => nil,
            "nameHyperlink" => nil,
            "description" => "Call Center for Homeless Veterans",
            "phone" => "1-877-4AID VET (1-877-424-3838)",
            "additionalInfo" => nil
        },
        {   "name" => nil,
            "nameHyperlink" => nil,
            "description" => "Women Veteran Call Center",
            "phone" => "1-855-829-6636",
            "additionalInfo" => nil
        }
    ]

    @remainingItems = [
        {   "name" => "Facility Locator",
            "nameHyperlink" => "http://www.va.gov/directory/guide/home.asp",
            "description" => "VA Facility",
            "phone" => nil,
            "additionalInfo" => nil
        },
        {   "name" => nil,
            "nameHyperlink" => "http://www.tricare.mil/mtf/",
            "description" => "Military Treatment Facilities (MTF)",
            "phone" => nil,
            "additionalInfo" => "Find a Hospital or Clinic"
        },
        {   "name" => "Department of Veteran Affairs",
            "nameHyperlink" => "http://www.va.gov/",
            "description" => "Department of Veteran Affairs",
            "phone" => nil,
            "additionalInfo" => "The VA Web site provides one-stop shopping for VA benefits, special programs, health information and services, and a health education library that gives up-to-date information about medications and conditions, tools for measuring your health status, and the latest health news."
        },
        {   "name" => nil,
            "nameHyperlink" => "http://www1.va.gov/health/index.asp",
            "description" => "Veterans Health Benefits and Services Homepage",
            "phone" => nil,
            "additionalInfo" => nil
        },
        {   "name" => nil,
            "nameHyperlink" => "http://www.va.gov/healthbenefits/apply/returning_servicemembers.asp",
            "description" => "VA Health Care Benefits for Service Members Returning from OEF/OIF/OND",
            "phone" => nil,
            "additionalInfo" => nil
        },
        {   "name" => nil,
            "nameHyperlink" => "http://URL/",
            "description" => "Vet Centers",
            "phone" => nil,
            "additionalInfo" => nil
        },
        {   "name" => nil,
            "nameHyperlink" => "http://www.va.gov/opa/publications/benefits_book.asp",
            "description" => "Federal Benefits for Veterans, Dependents and Survivor Booklet",
            "phone" => nil,
            "additionalInfo" => nil
        },
        {   "name" => "Women's Health",
            "nameHyperlink" => "http://URL/WOMENSHEALTH/index.asp",
             "description" => "VA Women's Health Services",
            #"description" => "VA Women’s Health Services",
            "phone" => nil,
            "additionalInfo" => "National Women Veterans Health Care Program website"
        },
        {   "name" => nil,
            "nameHyperlink" => nil,
            "description" => "Women Veterans Call Center",
            "phone" => "1-855-829-6636",
            "additionalInfo" => "Information about benefits, eligibility, and health care services.Monday-Friday 8am - 10pm Eastern and Saturday 8am to 6:30pm Eastern."
        },
        {   "name" => nil,
            "nameHyperlink" => nil,
            "description" => "Women Veteran Program Manager",
            "phone" => nil,
            "additionalInfo" => "For medical center specific questions call your local VA and ask to speak to the Women Veterans Program Manager. She or he can help you get to VA services and programs, state and federal benefits, and resources in the area where you live."
        },
        {   "name" => "Military Health System and TRICARE",
            "nameHyperlink" => "http://www.militaryonesource.mil/",
            "description" => "Military OneSource",
            "phone" => "1-800-342-9647",
            "additionalInfo" => "A confidential Department of Defense-funded program providing comprehensive information on every aspect of military life at no cost to active duty, National Guard, and reserve members, and their families."
        },
        {   "name" => nil,
            "nameHyperlink" => "http://www.pdhealth.mil/reservist/personnel.asp#ngrshss",
            "description" => "National Guard/Reserve-Specific Healthcare and Support Services",
            "phone" => nil,
            "additionalInfo" => "Supports the provision of medical care to remotely located Active Duty and Reserve Component service members within the 50 United States and District of Columbia through TRICARE Prime Remote and the Supplemental Health Care Program."
        },
        {   "name" => nil,
            "nameHyperlink" => "http://rhrp.fhpr.osd.mil/home.aspx",
            "description" => "Reserve Health Readiness Program",
            "phone" => nil,
            "additionalInfo" => "Supporting readiness related medical and dental support for the Reserve Component.",
            "hasMore" =>  false
        },
        {   "name" => nil,
            "nameHyperlink" => "http://www.tricare.mil/",
            "description" => "TRICARE",
            "phone" => nil,
            "additionalInfo" => "The health care program serving active duty service members, retirees, their families, survivors and certain former spouses worldwide."
        },
        {   "name" => nil,
            "nameHyperlink" => "https://www.tricareonline.com/portal/page/portal/TricareOnline/Portal",
            "description" => "TRICARE Online",
            "phone" => nil,
            "additionalInfo" => "A secure Web portal designed to increase access to care for authorized TRICARE beneficiaries"
        }
    ]
  end

  after(:all) do
    quitDriver()
  end

  describe "AC #JRNL-1690|TC #JRNL-1667 && AC JRNL-1160|TC JRNL-1141: Resources (Right Panel Menu and Options)" do

    it "Right Panel Content" do
      @main.clickUserMenu()
      !45.times{ break if (@menu.getMenuHeading() == "User Menu"); sleep 0.5 }
      expect(@menu.getMenuHeading()).to eq("User Menu")

      @buttonOrder.each_index{ |i|
          expect(getTextForElement(:css, @menu.nthOptionSelector(i + 1))).to eq(@buttonOrder[i])
      }
    end

    it "Click Resources" do
      @menu.clickResourcesBtn()
      !45.times{ break if (@modal.getConfirmationHeading() == @modalHeader); sleep 0.5 }
      expect(@modal.getConfirmationHeading()).to eq(@modalHeader)
    end

    it "OK Button" do
      @modal.clickNoButton() # Equivalent to clicking 'OK'
      !45.times{ break if (@modal.isConfirmationPopUpNotPresent); sleep 0.5 }
      expect(@modal.isConfirmationPopUpNotPresent).to eq(true)
    end

  end

  describe "AC JRNL-1689|TC JRNL-1667: Content Display and Format for Resources" do

    it "Click Resources" do
      @menu.clickResourcesBtn()
      !45.times{ break if (@modal.getConfirmationHeading() == @modalHeader); sleep 0.5 }
      expect(@modal.getConfirmationHeading()).to eq(@modalHeader)
    end

    it "AC JRNL-1160|TC JRNL-1141: Verify Content" do
      @remainingItems.each_with_index { |item, index|
        offset = index + 2
        nthModalItem = @resources.nthModalItem(offset) + " "
        verifyContent(nthModalItem, item)

        if(offset == 3 || offset == 11) # Verify horizontal rules
          expect(isElementPresentAndVisible(:css, nthModalItem + "hr")).to eq(true)
        end
      }
    end

  end

  describe "AC JRNL-1495|TC JRNL-1439: Resources Update" do

    it "Verify Urgent Header" do
      expect(getTextForElement(:css, Resources::URGENT_LABEL)).to eq(Resources::URGENT_LABEL_TEXT)
    end

    it "AC JRNL-1160|TC JRNL-1141: Verify Urgent Content" do
      @urgentItems.each_with_index { |item, index|
        nthModalItem = @resources.nthUrgentModalItem(index + 1) + " ";
        verifyContent(nthModalItem, item)
      }
    end

  end

  #######################
  ### Local Functions ###
  #######################
  def verifyContent(modalItem, contentItem)
    name = modalItem + Resources::NAME
    nameLink = modalItem + Resources::NAME_LINK
    description = modalItem + Resources::DESCRIPTION
    phone = modalItem + Resources::PHONE
    additionalInfo = modalItem + Resources::ADDITIONAL_INFO

    expectedName = contentItem["name"]
    expectedNameLink = contentItem["nameHyperlink"]
    expectedPhone = contentItem["phone"]
    expectedDescription = contentItem["description"]
    expectedAdditionalInfo = contentItem["additionalInfo"]

    if(expectedName != nil)
      expect(getTextForElement(:css, name)).to eq(expectedName)
    end

    if(expectedNameLink != nil)
      click(:css, nameLink)
      @totalWindows += 1
      expect(getTotalWindowsOpen()).to eq(@totalWindows)
    end

    if(expectedPhone != nil)
      expect(getTextForElement(:css, phone)).to eq(expectedPhone)
    end

    if(expectedDescription != nil)
      expect(getTextForElement(:css, description)).to eq(expectedDescription)
    end

    if(expectedAdditionalInfo != nil)
      expect(getTextsForElements(:css, additionalInfo).join("")).to eq(expectedAdditionalInfo)
    end
  end

end