require_relative '../../globalized'
include Globalized

describe "Story# JRNL-1580: [Previous_Screen_Text_Modifications_JRNL_1580_spec.rb]", :regression => true do

  add_screen_alt_text = "Return to Previous Screen"
  primaryPhone = "primaryPhone"
  primaryPhoneType = "primaryPhoneType"
  eventTitle = "eventTitle"
  date = "date"
  lastCompleted = "lastCompleted"
  startDate = "startDate"
  dateStarted = "dateStarted"
  firstName = "firstName"
  title = "title"
  company = "company"
  myStory_header = "My Story"
  myStoryBackButton_text = "Return to My Story options"

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")

    @main.clickNavMenu()
    !45.times { break if (@nav_menu.getNavMenuHeading()== "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
  end

  after(:all) do
    quitDriver()
  end

  context 'AC#JRNL-1496|TC #JRNL-1434: Add/Edit/Delete Screen' do

    it "Add/Edit/Delete Screen My Contact Information " do
      @nav_menu.clickMyProfile()
      waitForPageToFinishLoading()

      @nav_menu.click(:css, Nav_menu::NAV["MyContactInformation"]["navButton"])
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         primaryPhone => "4434445555",
                         primaryPhoneType => "Home"
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ############################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ############################################################################
      ############################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ############################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ############################################################################
      ############################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Military/Occupational History " do
      @nav_menu.click(:css, Nav_menu::NAV["OccupationalHistory"]["navButton"])
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         eventTitle => "Event Test",
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ############################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ############################################################################
      ############################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ############################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ############################################################################
      ############################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Plan Your Appointment" do
      @main.clickNavMenu
      @nav_menu.clickMyMedical()
      @myMedical.clickPlanYourAppointment()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################


      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Symptom Diary" do
      @myMedical.clickSymptom()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Diagnoses" do
      @myMedical.clickDiagnoses()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Surgeries" do
      @myMedical.clickSurgeries()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Hospitalizations" do
      @myMedical.clickHospitalizations()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         startDate => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Pregnancy History" do
      @myMedical.clickPregnancyHistory()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         dateStarted => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Family History" do
      @myMedical.clickFamilyHistory()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         firstName => "John"
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Blood Pressure and Pulse" do
      @main.clickNavMenu
      @nav_menu.clickBPAndPulse()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Daily Events" do
      @nav_menu.clickDailyEvents()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Diet" do
      @nav_menu.clickDiet()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Exercise" do
      @nav_menu.clickExercise()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Glucose" do
      @nav_menu.clickGlucose()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Height" do
      @nav_menu.clickHeight()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Mood" do
      @nav_menu.clickMood()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Pain" do
      @nav_menu.clickPain()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Respiration" do
      @nav_menu.clickRespiration()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Sleep" do
      @nav_menu.clickSleep()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         startDate => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Stress" do
      @nav_menu.click(:css, Nav_menu::NAV["Stress"]["navButton"])
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Temperature" do
      @nav_menu.clickTemperature()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Weight" do
      @nav_menu.clickWeight()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Appointments" do
      @main.clickNavMenu
      @nav_menu.clickReminders()
      waitForPageToFinishLoading
      @nav_menu.clickAppointments()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Medication Reminders" do
      @nav_menu.clickMedications()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         title => "Medications"
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Preventive Services" do
      @nav_menu.clickPreventiveServices()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         lastCompleted => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Other Reminders" do
      @nav_menu.clickOther()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         title => "Other"
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Healthcare Contacts" do
      @main.clickNavMenu
      @nav_menu.clickContacts()
      waitForPageToFinishLoading
      @nav_menu.clickHealthCareContacts()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         firstName => "John"
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Insurance Contacts" do
      @nav_menu.clickInsuranceContacts()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         company => "Agilex"
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Personal Contacts" do
      @nav_menu.clickPersonalContacts()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         firstName => "John"
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

    it "Add/Edit/Delete Screen Communications Log" do
      @nav_menu.clickCommunicationsLog()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end


    it "Add/Edit/Delete Screen Communications Log" do
      @main.clickNavMenu
      @nav_menu.clickImagesDocuments()
      @nav_menu.clickAll()
      waitForPageToFinishLoading()

      @common.clickAddButton()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(add_screen_alt_text)

      #Adding data and clicking the '<' button to verify modal
      setEntryValues({
                         date => getDateNthDaysAgo(0, "%m/%d/%Y")
                     });

      @common.clickBackButton()
      !15.times{ break if(@modal.getConfirmationHeading() == "Confirmation"); sleep 1}
      expect(@modal.getConfirmationHeading()).to eq("Confirmation")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")

      ################################################################################################################################################################################################################
      # THE CONFIRMATION MESSAGE TEXT IS DISPLAYING AS "You have not saved your changes. You may continue without saving or return to the entry screen." IN THE APP  #
      ########################################################### SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ################################################################################################
      ################################################################################################################################################################################################################

      @modal.clickContinueButton()
      waitForPageToFinishLoading()
    end

  end

  context 'AC#JRNL-1496|TC #JRNL-1434: "<" button in My Story' do

    it "Summary" do
      @main.clickNavMenu
      @nav_menu.clickMyStory()
      waitForPageToFinishLoading
      @nav_menu.clickSummary()
      waitForPageToFinishLoading()
      resizeWindowToPhone()

      expect(@common.getBackButtonAltText()).to eq(myStoryBackButton_text)

      @common.clickBackButton()
      expect(getSecondaryHeader()).to eq(myStory_header)
    end

    it "Personal Values" do
      @nav_menu.clickPersonalValues()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(myStoryBackButton_text)

      @common.clickBackButton()
      expect(getSecondaryHeader()).to eq(myStory_header)
    end

    it "Assessment" do
      @nav_menu.clickAssessment()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(myStoryBackButton_text)

      @common.clickBackButton()
      expect(getSecondaryHeader()).to eq(myStory_header)
    end

    it "Reflections" do
      @nav_menu.clickReflections()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(myStoryBackButton_text)

      @common.clickBackButton()
      expect(getSecondaryHeader()).to eq(myStory_header)
    end

    it "Goals" do
      @nav_menu.clickGoals()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(myStoryBackButton_text)

      @common.clickBackButton()
      expect(getSecondaryHeader()).to eq(myStory_header)
    end

    it "Learn" do
      @nav_menu.clickLearn()
      waitForPageToFinishLoading()

      expect(@common.getBackButtonAltText()).to eq(myStoryBackButton_text)

      @common.clickBackButton()
      expect(getSecondaryHeader()).to eq(myStory_header)
    end

  end

end
