require_relative '../../globalized'
include Globalized

describe "[Story #JRNL-2460:  No_Results_Found_JRNL_2460_spec.rb]", :regression => true do

  no_result_found_msg_long = "No results were found with the current filters. Use the Add button above to create a new record."
  no_result_found_msg_short = "Use the Add button above to create a new record."

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
    #Clear up the db to ensure no data returns to the List View
    deleteAllRecordsFromTable("DAILY_EVENT")
    deleteAllRecordsFromTable("VITAL_OBSERVATION")
    deleteAllRecordsFromTable("VITAL_ENTRY")
    deleteAllRecordsFromTable("DIET")
    deleteAllRecordsFromTable("EXERCISE")
    deleteAllRecordsFromTable("MOOD")

    removeCollection("appointments", "medicalhistorydb")
    removeCollection("diagnosis", "medicalhistorydb")
    removeCollection("familyhistory", "medicalhistorydb")
    removeCollection("hospitalization", "medicalhistorydb")
    removeCollection("pregnancies", "medicalhistorydb")
    removeCollection("reminders", "remindersdb")
    removeCollection("goals", "healthinventorydb")

    @common.loginEndsOnLandingPage("zztest.patient14", "patien14, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient14, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
  end

  after(:all) do
    quitDriver()
  end

  context 'AC#JRNL-1902|TC #JRNL-1680: Update no results found message' do

    it ". 1) 2) Verify that for all areas required in the story, when no records are returned, display the message: No results were found with the current filters. Use the Add button above to create a new record. or the short message: Use the Add button above to create a new record.", :broken => true do
      # My Medical
      waitForPageToFinishLoading
      @nav_menu.clickMyMedical()
      !45.times{ break if (getPrimaryHeader() == "My Medical"); sleep 1 }
      expect(getPrimaryHeader()).to eq("My Medical")

      waitForPageToFinishLoading
      @nav_menu.clickDiagnoses()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickSurgeries()
      !15.times{ break if (getPrimaryHeader() == "Surgeries"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Surgeries")
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_short)

      waitForPageToFinishLoading
      @nav_menu.clickHospitalizations()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickPregnancyHistory()
      !15.times{ break if (getPrimaryHeader() == "Pregnancy History"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Pregnancy History")
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_short)

      waitForPageToFinishLoading
      @nav_menu.clickFamilyHistory()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      # My Story
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickMyStory()
      !45.times{ break if (getPrimaryHeader() == "My Story"); sleep 1 }
      expect(getPrimaryHeader()).to eq("My Story")

      waitForPageToFinishLoading
      @nav_menu.clickGoals()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      # Personal Tracker
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickPersonalTrackers()
      !45.times{ break if (getPrimaryHeader() == "Personal Trackers"); sleep 1 }
      expect(getPrimaryHeader()).to eq("Personal Trackers")

      waitForPageToFinishLoading
      @nav_menu.clickBPAndPulse()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @personaltracker.clickGraphButton()
      !15.times{ break if(isElementPresentAndVisible(:css, tableButton())); sleep 1 }
      expect(isElementPresentAndVisible(:css, tableButton())).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickDailyEvents()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickDiet()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickExercise()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickHeight()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @personaltracker.clickGraphButton()
      !15.times{ break if(isElementPresentAndVisible(:css, tableButton())); sleep 1 }
      expect(isElementPresentAndVisible(:css, tableButton())).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickMood()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickPain()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @personaltracker.clickGraphButton()
      !15.times{ break if(isElementPresentAndVisible(:css, tableButton())); sleep 1 }
      expect(isElementPresentAndVisible(:css, tableButton())).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickRespiration()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @personaltracker.clickGraphButton()
      !15.times{ break if(isElementPresentAndVisible(:css, tableButton())); sleep 1 }
      expect(isElementPresentAndVisible(:css, tableButton())).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickTemperature()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @personaltracker.clickGraphButton()
      !15.times{ break if(isElementPresentAndVisible(:css, tableButton())); sleep 1 }
      expect(isElementPresentAndVisible(:css, tableButton())).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickWeight()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @personaltracker.clickGraphButton()
      !15.times{ break if(isElementPresentAndVisible(:css, tableButton())); sleep 1 }
      expect(isElementPresentAndVisible(:css, tableButton())).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      # My Reminders
      waitForPageToFinishLoading
      @main.clickNavMenu
      @nav_menu.clickReminders()
      !45.times{ break if (getPrimaryHeader() == "My Reminders"); sleep 1 }
      expect(getPrimaryHeader()).to eq("My Reminders")

      waitForPageToFinishLoading
      @nav_menu.clickAppointments()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickMedications()
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)

      waitForPageToFinishLoading
      @nav_menu.clickOther
      !15.times{ break if (isFilterButtonVisible()); sleep 1 }
      expect(isFilterButtonVisible()).to eq(true)
      expect(getNoResultsFoundMessage()).to eq(no_result_found_msg_long)
    end

  end

end