require_relative '../../globalized'
include Globalized

describe "Story# JRNL-2513: [MBB_Homepage_Link_JRNL_2513_spec.rb]", :broken=>true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "Logged in as patient01, zztest")
  end

  after(:all) do
    quitDriver()
  end

  context 'AC(MVAH-1740), AC(MVAH-1742) | TC(JRNL-2935): MBB link opens in separate window; MBB app link on landing page' 'JRNL-467 mobile blue button has been removed' do
    it "MBB Link is located on the Landing Page after login and it is visible without scrolling on phone device" do

      #Verifying if the link is visible
      expect(isElementVisible(:css, "div > a > img")).to be false

      #Resizing the window to phone size and verifying link is still visible.
      resizeWindowTo(320, 480)
      expect(isElementVisible(:css, "div > a > img")).to be false

    end

    xit "MBB link opens in a new window, JRNL-467 this script will not work since the mobile blue button has been removed", :broken => true do
      @landing.clickMBB()

      #switching to the New Window and verifying the title
      switchWindowToWindowHandleLast()
      # @eula.clickAcceptMBBEula()
      expect(getPageTitle()).to eq("MBB")
      puts "The New Window Header is: " +getPageTitle()

      #switching to Original Window and resizing
      switchWindowToWindowHandleFirst()
      resizeWindowToDefault()
      expect(getMainHeader()).to eq("My VA Health")
    end
  end
end