require_relative '../../globalized'
include Globalized

describe "Story #JRNL-17: Left Menu Journal Navigation - Story #NR-89: Order Left Navigation", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-169| TC #JRNL-221 : Left (App Options) Menu - User not logged in." do
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 } 
     @eula.clickAccept()  
    
    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @main.clickNavMenu()
   
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

    ####################################################################################################################
    ################### Contact, Assessment and My Story BUTTON ARE NOT DISPLAYING  IN THE APP  ########################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # expect(@nav_menu.isAssessmentButtonVisible()).to eq(false)
    # expect(@nav_menu.isContactsButtonVisible()).to eq(false)
    # expect(@nav_menu.isMyStoryButtonVisible()).to eq(false)

    ####################################################################################################################
    ################### Contact, Assessment and My Story BUTTON ARE NOT DISPLAYING  IN THE APP  ########################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    @main.clickNavMenu()
    
  end  
    
  it "AC #JRNL-170| TC #JRNL-221:  Left (App Options) Menu - User logged in" do

    #Passing by the landing page before the Eula

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu()
    expect(@nav_menu.isAssessmentButtonVisible()).to eq(true)
    expect(@nav_menu.isContactsButtonVisible()).to eq(true)
    expect(@nav_menu.isMyStoryButtonVisible()).to eq(true)

    expect(@nav_menu.getAssessmentButtonText()).to eq("Assessments")
    expect(@nav_menu.getContactsButtonText()).to eq("Contacts")
    expect(@nav_menu.getMyStoryButtonText()).to eq("My Story")

  end

  it "AC #JRNL-3138| TC JRNL-1577: Order left navigation" do
    #Was associated with AC #NR-213 | |TC JRNL-221
    expect(@nav_menu.getNthOptionName(1).chomp("\nselected")).to eq("Home")
    expect(@nav_menu.getNthOptionName(3)).to eq("My Story")
    expect(@nav_menu.getNthOptionName(4)).to eq("My Medical")
    expect(@nav_menu.getNthOptionName(5)).to eq("Personal Trackers")
    expect(@nav_menu.getNthOptionName(6)).to eq("My Reminders")
    expect(@nav_menu.getNthOptionName(7)).to eq("Notifications")
    expect(@nav_menu.getNthOptionName(8)).to eq("Contacts")
    expect(@nav_menu.getNthOptionName(9)).to eq("Assessments")

  end

  it "AC #JRNL-1660| TC JRNL-1577:Home Link" do
    expect(@nav_menu.getNthOptionName(1).chomp("\nselected")).to eq("Home")
  end

end
