require_relative '../../globalized'
include Globalized

describe "[Story#JRNL-137|JRNL-365|JRNL-366|JRNL-754|NR-181: LandingScreen_JRNL_137_754_NR_181_spec.rb]
[Story #JRNL-1198: Add Landing Page Disclaimer]", :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC#JRNL-166;372|TC#JRNL-218,483|AC#JRNL-785;JRNL-787|TC#:JRNL-810|AC#:NR-367|TC#:NR-415: Journal Landing page for non logged in user " do
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 } 
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")
    expect(@landing.getWelcomeMessageBeforeLogin()).to eq("Welcome to My VA Health")
    expect(@landing.getWelcomeMessagePart1()).to eq("Select Login to access the My VA Health app.")
    expect(@landing.getWelcomeMessagePart2()).to eq("Learn more about this application by selecting the button above.")

    ####################################################################################################################
    ########## THE TEXT IS SHOWING AS ""Wishing you good health and welfare,\n\nYour VA Care Team"IN THE APP  ##########
    ################ APP IS DISPLAYING "You VA Care Team" AND AUTOMATION SCRIPT IS SAYING "Your VA Care Team" #################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # expect(@landing.getWelcomeMessagePart3()).to eq("Wishing you good health and welfare,\n\nYour VA Care Team")

    ####################################################################################################################
    ######## THE TEXT IS SHOWING AS "Wishing you good health and welfare,\n\nYour VA Care Team" IN THE APP  ############
    ################ APP IS DISPLAYING "You VA Care Team" AND AUTOMATION SCRIPT IS SAYING "Your VA Care Team" #################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    expect(@landing.isLoginBtnVisible()).to eq(true)
  end
  
  it "AC #JRNL-167;JRNL-373|TC #JRNL-218;JRNL-483: Right Navigation (User menu) from Landing page when user not logged in" do
    @main.clickUserMenu()
    !45.times{ break if (getTextForElement(:id, "about") == "About"); sleep 1 }
    expect(@menu.verifyAboutButtonPresent()).to eq("About")
    expect(@menu.verifyLoginButtonPresent()).to eq("Login")
    expect(@menu.isHelpButtonVisible()).to eq(false)
    expect(@menu.verifyLaunchpadButtonPresent()).to eq("Launchpad")
    sleep 1
    @main.clickUserMenu()
    expect(@landing.isLoginBtnVisible()).to eq(true)
  end


  it "AC #JRNL-374;JRNL-375|TC#JRNL-483|AC#NR-92|AC-368|TC#NR-415 AC #JRNL-1177|TC #5373: Landing screen for Journal when the user has logged in " do
    @landing.clickLogin()
    !45.times{ break if (@loginpage.getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    expect(@loginpage.getPageTitle()).to eq("Department of Veterans Affairs - Veteran Login Page")
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    !45.times{ break if (@landing.getWelcomeMessageAfterLogin() == "Welcome zztest patient01"); sleep 1}
    expect(@landing.getWelcomeMessageAfterLogin()).to eq("Welcome zztest patient01")
    today = getDateNthDaysAgo(0, "%B %d, %Y")
    puts "today=" + today
    expect(@landing.getDisplayedDate()).to eq(today)
    expect(@landing.getNotificationButtonName()).to eq("Notifications")
    expect(@landing.notificationType()).to eq("Unread in last 30 days")
    expect(@landing.getInformationalTextAfterLogin()).to eq("Information you enter into this app will not be automatically reviewed by your health care providers, but can be shared at your next appointment. For immediate medical needs, contact your provider. In the case of an emergency, dial 911.")
    expect(@landing.getInstructionTextAfterLogin()).to eq("Access My VA Health features using the button above.")
    @main.clickUserMenu()
    !45.times{ break if (getTextForElement(:id, "about") == "About"); sleep 1 }
    expect(@menu.verifyAboutButtonPresent()).to eq("About")
    expect(@menu.verifyHelpButtonPresent()).to eq("Help")
    expect(@menu.verifyLaunchpadButtonPresent()).to eq("Launchpad")
    expect(@menu.verifyLogoutButtonPresent()).to eq("Logout")
  end

end
