require_relative '../../globalized'
include Globalized

describe "[Story#JRNL-2526: Home_JRNL_2526_spec.rb]" , :regression => true do

  before(:all) do
  initializeConfigurations(BASE_URL)
  initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");
    waitForPageToFinishLoading
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");
    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }
  end


  after(:all) do
    quitDriver()
  end


  it "AC #JRNL-1660|TC#JRNL-1577:: Landing on Home button click " do

    @navMenu.clickHome()

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")
    !45.times{ break if (@landing.getWelcomeMessageAfterLogin() == "Welcome zztest patient01"); sleep 1}
    expect(@landing.getWelcomeMessageAfterLogin()).to eq("Welcome zztest patient01")
    today = getDateNthDaysAgo(0, "%B %d, %Y")
    puts "today=" + today
    expect(@landing.getDisplayedDate()).to eq(today)
    expect(@landing.getNotificationButtonName()).to eq("Notifications")
    expect(@landing.notificationType()).to eq("Unread in last 30 days")
    expect(@landing.getInstructionTextAfterLogin()).to eq("Access My VA Health features using the button above.")
  end

end
