require_relative '../../globalized'
include Globalized

describe "[Story# JRNL-292: Help Function Text - Right Menu - Story #NR-61: User Guide and Help Update - Story #JRNL-849: Update Final User Guide  - Story #MVAH-839:  Update User Guide for My Story - #MVAH-1727:  Client feedback update on 1.0 - Story #MVAH-1266: User Guide Updates for 2.0 - Story #MVAH-322: Help text update]
          [Story JRNL-1334: Update User Guide for 2.1]
          [Story JRNL-1121: User Guide 3.0.0]", :broken => true, :acceptance => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-292 | TC #JRNL-368: User can only see Help once they have logged in and created profile." do

    @common.loginEndsOnLandingPage("zztest.patient01", "Logged in as patient01, zztest")

    @main.clickUserMenu()
    !45.times{ break if (@menu.getMenuHeading() == "User Menu"); sleep 1 }
    #Help link is listed in the menu options when user is logged in
    expect(@menu.isHelpButtonVisible()).to eq(true)
  end

  it "AC ##JRNL-1356 Update Help hyperlink; AC #JRNL-352| TC #JRNL-368: Help will contain the text provided in the story - AC #NR-211: Reminders in guide-AC JRNL1004-Help Function Text - Right Menu" do
    @menu.clickHelpBtn()
    !45.times{ break if (@modal.getConfirmationHeading() == "Help"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Help")
    expect(@modal.getNthConfirmationMessage(1)).to eq("Help Desk (toll free): (877) 470-5947 Weekdays 7 a.m. - 7 p.m. (CT)")

    expect(@modal.getNthConfirmationMessage(2)).to eq("If you need assistance with the My VA Health, dial 1-844-482-6624 to speak with a VA Mobile Solutions Service Desk Representative. The VA Mobile Solutions Service Desk is open Monday - Friday from 7 a.m. to 7 p.m. CST. For TTY assistance, dial 711. You may also receive 24/7 assistance by visiting the VA Mobile Solutions Service Desk online at help.vamobile.us. Mobile App Training: Please visit http://URL/appstore, and search for the My VA Health App to access training materials.")
    expect(@modal.getNthConfirmationMessage(3)).to eq("Emergencies
If you feel that your information may have been compromised, contact your local VA facility to obtain the contact information for your Privacy Officer. To identify your local VA facility, visit VA’s Facility Locator here, or by copying and pasting the following link into your browser: http://1.usa.gov/1TTdj42. Note that you should never use this app in an emergency situation. If you encounter an emergency, call your local medical center or dial 911.")

    @userGuide.clickMobileVAHealthAppStoreLink
    switchWindowToWindowHandleLast()
    expect(@userGuide.getPageTitle()).to eq("VA App Store | VA Mobile")
    switchWindowToWindowHandleFirst

    @userGuide.clickVAFacilityLocatorLink
    switchWindowToWindowHandleLast()
    expect(@userGuide.getPageTitle()).to eq("Find Locations - Locations")
    switchWindowToWindowHandleFirst

    @userGuide.clickGeneralFeedbackToVALink
    switchWindowToWindowHandleLast()
    expect(@userGuide.getPageTitle()).to eq("My VA Health | VA Mobile")
    switchWindowToWindowHandleFirst

    @userGuide.clickUserGuideLinkNew()
    switchWindowToWindowHandleLast()
    expect(@userGuide.getPageTitle()).to eq("My VA Health - User Guide")
    switchWindowToWindowHandleFirst

    remindersPath = @userGuide.getFeaturesPath("my-reminders")

    expect(@userGuide.isLinkVisible(remindersPath)).to eq(true)
    expect(@userGuide.isContentDisplayedOnPage(remindersPath)).to eq(false)

    @userGuide.clickLink(remindersPath)
    expect(@userGuide.isContentDisplayedOnPage(remindersPath)).to eq(true)

    expect(@userGuide.getHeaderContent(remindersPath).include?("My Reminders")).to eq(true)
    expect(@userGuide.getRemindersContent).to eq("The My Reminders feature allows you to manage Appointment, Preventive Service, Medication, and Other reminders, all of which can be configured to provide notifications at specific time intervals.")
    expect(@userGuide.getFeatureParagraphText(6, 2)).to eq("All reminders provide Notification functionality where you may elect to receive a notification related to the reminder via email or the in-app Notification feature.")
    @userGuide.clickBackToTop()
  end

  it "AC #JRNL-876 | AC #JRNL-877 | AC #JRNL-878 | AC #JRNL-1665 | TC #JRNL-988 && [AC JRNL-1161|TC JRNL-1146]: Verify that all expected links are visible and navigate to correct section" do
    def sectionCheckHelper(path)
      ### path, e.g. '/features/vitals'
      expect(@userGuide.isLinkVisible(path)).to eq(true)
      @userGuide.clickLink(path)
      expect(@userGuide.isContentDisplayedOnPage(path)).to eq(true);
      sleep 1
      @userGuide.clickBackToTop()
    end

    for link in @userGuide.getFeatureLinks do
        path = @userGuide.getFeaturesPath(link)
        sectionCheckHelper(path)
    end

    for link in @userGuide.getGeneralUseLinks do
      path = @userGuide.getGeneralUsePath(link)
      sectionCheckHelper(path)
    end

    for link in @userGuide.getUserMenuLinks do
      path = @userGuide.getUserMenuFeaturesPath(link)
      sectionCheckHelper(path)
    end

    @userGuide.clickBackToTop()
  end

  ###########  GENERAL USE  ###########
  it "AC #JRNL-876 | AC #JRNL-877 | AC #JRNL-878 | | AC #JRNL-1665 | TC #JRNL-988: Verify User Guide -- General Use/To Use App content" do
    path = @userGuide.getGeneralUsePath("to-use-this-app")
    headerContent = "To Use This App"
    bodyContent = "This app requires a Premium (Level 2) DS Logon account so that access can be controlled. You can go to the DoD Self-Service Access Center (DEERS) to find out more information about DS Logon. Before you access the app features, you must also complete a Right of Access (ROA) form and agree to the End User License Agreement (EULA). You only need to sign one Right of Access form to use any VA mobile application. The ROA form covers your request to receive your information from VA systems. All apps require that you agree to a separate EULA, and for web apps you will need to agree to the EULA on each device and browser you use to access the app. If you need to complete either of these documents they will be presented to you."

    @userGuide.clickLink(path)
    expect(@userGuide.getHeaderContent(path).include?(headerContent)).to eq(true)
    expect(@userGuide.getToUseAppContent).to eq(bodyContent)
  end

  it "AC #JRNL-876 | AC #JRNL-877 | AC #JRNL-878 | TC #JRNL-988: Verify User Guide -- General Use/New Users content", :broken => true do
    path = @userGuide.getGeneralUsePath("new-users")
    headerContent = "New Users"
    bodyContent = "The first time you open the app, after logging in, you will be asked to confirm your Notification settings. Settings include establishing your preferred time zone preference, and electing to receive notices from Your Care Team. After you save your Notification settings, the standard My VA Health home page is shown and the app features in the left panel menu become available."

    @userGuide.clickLink(path)
    expect(@userGuide.getHeaderContent(path).include?(headerContent)).to eq(true)
    expect(@userGuide.getNewUsersContent).to eq(bodyContent)
  end

  it "AC #JRNL-876 | AC #JRNL-877 | AC #JRNL-878 | TC #JRNL-988 && [AC JRNL-1161|TC JRNL-1146]: Verify User Guide -- General Use/Navigation content", :broken => true do
    expectedFirstPara = "App functionality is shown in two menus: the App Options Menu (menu icon in the upper left corner) and the User Menu (menu icon in the upper right corner)."
    expectedSecondPara = "App Options menu: The app menu includes a list of the features available, including:"
    expectedThirdPara = "User Menu: The user menu allows you to manage your interaction with the app, and includes the following functions:"
    expectedListOne = ["Home", "My Profile", "My Story", "My Medical", "Personal Trackers", "My Reminders", "Notifications", "Contacts", "Assessments", "Images and Documents", "Health Report"].join("\n")
    expectedListTwo = ["About", "Help", "Resources", "Login/Logout", "Launchpad"].join("\n")

    path = @userGuide.getGeneralUsePath("navigation")
    headerContent = "Navigation"

    @userGuide.clickLink(path)
    expect(@userGuide.getHeaderContent(path).include?(headerContent)).to eq(true)
    expect(@userGuide.getNavigationParaText(1)).to eq(expectedFirstPara)
    expect(@userGuide.getNavigationParaText(2)).to eq(expectedSecondPara)
    expect(@userGuide.getNavigationParaText(3)).to eq(expectedThirdPara)
    expect(@userGuide.getNavigationListElements(1)).to eq(expectedListOne)
    expect(@userGuide.getNavigationListElements(2)).to eq(expectedListTwo)
  end

  it "AC JRNL-1161|TC JRNL-1146: Verify User Guide -- General Use/Self Entered Data Available Across Apps content", :broken => true do
    path = @userGuide.getGeneralUsePath("self-entered-data")
    headerContent = "Self Entered Data Available Across Apps"
    bodyContent = "The Veteran apps available on Launchpad store patient-entered data in a shared location. As a result, any data you add or update in this app will also be available in other apps that use the same information."

    @userGuide.clickLink(path)
    expect(@userGuide.getHeaderContent(path).include?(headerContent)).to eq(true)
    expect(@userGuide.getSelfEnteredDataContent).to eq(bodyContent)
  end

  ###########  MAIN FEATURES  ###########
  ### Assessments and Notifications are checked in separate files
  ### Reminders section is checked earlier in this file -- but need to preserve them in sectionList to preserve order checking
  it "AC #JRNL-876 | AC #JRNL-877 | AC #JRNL-878 | AC #JRNL-3278 | AC #JRNL-1665 | TC #JRNL-988 && [AC JRNL-1161|TC JRNL-1146]: Verify User Guide -- Features - Home, My Profile, My Story, My Medical, Personal Trackers, My Reminders, Notifications, Contacts, Assessments, Images and Documents, Health Report" do
    skipFeatures = ["my-reminders", "notifications", "assessments"]

    firstParagraphHash = {
      "home"                  =>  "The Home feature allows you to view a count of unread notifications received in the last thirty days, and provides quick access to the notification section.",
      "my-profile"            =>  "The My Profile feature allows you to store your contact information and add any military or occupational history data that you would like save as a future reference.",
      "my-story"              =>  "The My Story feature allows you to reflect on your personal values, rate your current state of health and wellness in comparison to your long-term goals, and reflect on areas for improvement. You can:",
      "my-medical"            =>  "The My Medical feature allows you to create appointment plans, maintain a diary of any medical related symptoms and record your medical events including hospitalizations, surgeries, diagnoses, allergies, medications as well as medical history including both family and pregnancy history. For each medical entry, where relevant, you can:",
      "personal-trackers"     =>  "The Personal Trackers feature allows you to enter and track information about a variety of health-related items over time, including tracking:",
      "contacts"              =>  "The Contacts feature allows you to enter your Healthcare Contacts, Personal Contacts and Insurance Contacts as well as log any communications you have had with your care team or other contacts. Both Contact and Communication information is available in a list format that can be filtered.",
      "images-and-documents"  =>  "The Images and Documents feature allows you to save documents related to your military service and healthcare.",
      "health-report"         =>  "The Health Report feature allows you create a report with data selections from the My VA Health app. The report is organized based on the options you selected. Depending on your selections, this report may include the following sections:",
    }

    sectionsListHash = {
      "home"                  =>  "",
      "my-profile"            =>  "",
      "my-story"              =>  ["Learn about the components of proactive health and well-being", "Answer questions about your personal values", "Rate your life in key areas and view your rating history", "Reflect on next steps", "View and share a summary of your story"].join("\n"),
      "my-medical"            =>  ["View and filter a list of entries", "Add or edit an entry", "Save, Cancel or Delete an entry"].join("\n"),
      "personal-trackers"     =>  ["Blood Pressure and Pulse", "Cholesterol/Lipid", "Daily Events", "Diet", "Exercise", "Glucose (Self-Tested)", "Height", "Mood", "Pain", "Respiration", "Sleep", "Stress", "Temperature", "Weight"].join("\n"),
      "contacts"              =>  "",
      "images-and-documents"  =>  "",
      "health-report"         =>  ["Healthcare Summary: The Healthcare Summary displays the most recent vital sign entries, as well as select personal and medical data, all shown in a brief summary format.", "Detailed Medical and Personal Data: The Detailed Medical and Personal Data report includes detailed information on the areas of information that you selected.", "Tracked Data: The Tracked Data report includes detailed information for the areas and date range you selected."].join("\n"),
    }

    personalTrackersSecondParagraph = "For each Personal Tracker you can:"
    personalTrackersThirdParagraph = "In addition, for Blood Pressure and Pulse, and Weight trackers you may also elect to generate a PDF of the list of entries. For the Daily Events tracker you may add four images (up to 10 MB in size) to an event entry (accepted formats: jpg, jpeg, png)."
    personalTrackersSecondList = ["View and filter a list of entries", "View a graphical representation of a set of entries (select trackers)", "Add or edit an entry", "Save, Cancel or Delete an entry"].join("\n")

    healthReportSecondParagraph = "The generated report is provided in a PDF format that can be shared."

    def checkFeatureHelper(section, sectionIndex, paragraphHash, listHash)
      expectedHeader = section.dup
      expectedHeader.gsub! "-", " "
      expectedHeader = "2." + sectionIndex.to_s + " " +  expectedHeader
      expectedListElements = listHash[section]
      expectedFirstPara = paragraphHash[section]

      sectionList = @userGuide.getFeatureListElements(sectionIndex, 1)
      path = @userGuide.getFeaturesPath(section)
      @userGuide.clickLink(path)

      expect(@userGuide.getHeaderContent(path).downcase).to eq(expectedHeader)

      expect(@userGuide.getFeatureParagraphText(sectionIndex, 1)).to eq(expectedFirstPara)
if section == 'health-report'
 puts "Section is " + section.to_s
 puts "expectedHeader " + @userGuide.getHeaderContent(path).downcase
puts "expectedFirstPara " + @userGuide.getFeatureParagraphText(sectionIndex, 1)
end

      expect(sectionList).to eq(expectedListElements)

      sleep 1
    end

    @userGuide.getFeatureLinks.each_with_index do |section, index|
      unless skipFeatures.include? section
        # index + 1 because Ruby arrays start at index 0
        checkFeatureHelper(section, index + 1, firstParagraphHash, sectionsListHash)
      end

      if section == 'personal-trackers'
        expect(@userGuide.getFeatureParagraphText(index + 1, 2)).to eq(personalTrackersSecondParagraph)
        expect(@userGuide.getFeatureParagraphText(index + 1, 3)).to eq(personalTrackersThirdParagraph)
        expect(@userGuide.getFeatureListElements(index + 1, 2)).to eq(personalTrackersSecondList)
      end

      if section == 'health-report'
        expect(@userGuide.getFeatureParagraphText(index + 1, 2)).to eq(healthReportSecondParagraph)
      end
    end

  end

  ###########  USER MENU FEATURES  ###########
  it "AC #JRNL-876 | AC #JRNL-877 | AC #JRNL-878 | TC #JRNL-988 && [AC JRNL-1161|TC JRNL-1146]: Verify User Guide -- User Menu Features content" do
    map = {
      "about"         =>   "The About feature provides general information about the App, including the version number, and a link to the End User License Agreement.",
      "help"          =>   "The Help feature provides support contact information and link to this User Guide.",
      "resources"     =>   "The Resource feature provides Crisis Line contact information, important phone numbers, and web links to additional information and services.",
      "login-logout"  =>   "The Login/Logout feature allows you to enable or disable your authentication session for ALL VA apps. Note that once you logout you will need to login again to use any app and you will no longer see an indicator that you are logged in at the bottom right of the app.",
      "launchpad"     =>   "The Launchpad feature allows you to quickly access the apps included on the VA Launchpad, including apps that you may not be aware of that the VA is providing to help improve your health and healthcare."
    }

    def checkUserMenuContentHelper(section, sectionIndex, map)
      expectedContent = map[section]
      expectedHeader = section.dup

      #login/logout section has path with '-' but header with '/' between "login" and "logout" parts
      if expectedHeader.include?("login")
        expectedHeader.sub! "-", "/"
      end

      path = @userGuide.getUserMenuFeaturesPath(section)
      @userGuide.clickLink(path)

      expect(@userGuide.getHeaderContent(path).downcase.include?(expectedHeader)).to eq(true)
      expect(@userGuide.getUserMenuFeatureContent(sectionIndex)).to eq(expectedContent)
      @userGuide.clickBackToTop()

      sleep 1
    end

    map.keys.each_with_index do |section, index|
      checkUserMenuContentHelper(section, index + 1, map)
    end
  end

    ###########  USER MENU FEATURES  ###########
  it 'AC #JRNL-1665', :broken => true do
    tableMap = {
      "bpm"      =>  "beats per minute",
      "°F"       =>  "degrees Fahrenheit",
      "G"        =>  "gram",
      "kcal"     =>  "kilocalorie",
      "lb/lbs"   =>  "pound/pounds",
      "MB"       =>  "megabyte",
      "min"      =>  "minute",
      "mmHg"     =>  "millimeters of mercury"
    }
    path = "/user-menu-app-abbreviations"
    expect(@userGuide.isLinkVisible(path)).to eq(true)
    @userGuide.clickLink(path)
    expect(@userGuide.isContentDisplayedOnPage(path)).to eq(true)

    def checkTableRowContent(abbreviation, rowIndex, map)
      row = @userGuide.getAbbreviationTableRow(rowIndex)
      expectedContent = abbreviation + " " + map[abbreviation]
      expect(row).to eq(expectedContent)
    end

    tableMap.keys.each_with_index do |rowAbbreviation, index|
      # we want to start checking table content starting at row 2
      checkTableRowContent(rowAbbreviation, index + 2, tableMap)
    end

  end

  it "AC #JRNL-352| TC #JRNL-368: Should close user guide and return to landing page", :broken => true do
    closeBrowser()
    switchWindowToWindowHandleFirst()
    @modal.clickOKFromHelp()
    !45.times{ break if (@landing.getTitle() == "Home"); sleep 1 }
    expect(@landing.getTitle()).to eq("Home")
  end

end
