require_relative '../../globalized'
include Globalized

describe "[Story#JRNL-620: [Guidance_Text_JRNL_620_spec.rb]", :broken => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    # Remove Daily Events
    removeCollection("notes", "medicalhistorydb")

    # Mood
    removeCollection("mood", "medicalhistorydb")

    # Height, Weight, Pain, Respiration, Temperature
    removeCollection("vitalsigns", "medicalhistorydb")

    # Blood Pressure and Pulse
    removeCollection("vitalsignsbundles", "medicalhistorydb")

    removeCollection("contacts", "personalprofiledb")
    removeCollection("communicationlogs", "personalprofiledb")

    @common.loginEndsOnLandingPage("zztest.patient05", "Logged in as patient05, zztest")
  end

  after (:all) do
    quitDriver()
  end

  it "AC#JRNL-714,715,716,717,718|TC#JRNL-744: Restrict Field input length; Input for Floating Data Fields; Character Counter for long fields; Guidance Text for sighted users" do

    time = Time.new
    today = time.strftime("%m/%d/%Y").to_s
    puts today

    yesterday = getDateNthDaysAgo(1, "%m/%d/%Y").to_s

    @main.clickNavMenu
    @navMenu.clickContacts
    @contacts.clickCommunicationsLog

    !45.times{ break if (getPrimaryHeader() == "Communications Log"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Communications Log")

    puts @date.getStartDatePlaceHolder()
    expect(@date.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")

    puts @date.getEndDatePlaceHolder()
    expect(@date.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")

    @date.setDateRange(yesterday+"XX" , today+"XX")

    startDate = getTextFromInput(:id, "startDate")
    puts startDate
    expect(startDate).to eq(yesterday)

    endDate = getTextFromInput(:id, "endDate")
    puts endDate
    expect(endDate).to eq(today)

    #Verifying Date in the Data Entry Form
    @communications.clickAddCommunicationBtn()
    !45.times{ break if (getPrimaryHeader() == "Add Communications Log Entry"); sleep 1 }
    expect(getPrimaryHeader()).to eq("Add Communications Log Entry")

    puts @date.getEntryDatePlaceHolder()
    expect(@date.getEntryDatePlaceHolder()).to eq("MM/DD/YYYY")

    setDate(today, "input[name='date']")
    entryDate = getTextFromInput(:id, "date")
    puts entryDate
    expect(entryDate).to eq(today)

    #Verifying Subject Field Length and Character Counter

    @communications.setSubject("Call my doctor every monday to get a follow up appointment")
    @communications.selectType("Phone")

    expect(@communications.verifyTotalCharacterInNarrative()).to be true
    commLogCount = @communications.getCommunicationsLogCount()
    @communications.clickSaveButton

    !45.times{ break if (@communications.getCommunicationsLogCount() == ( commLogCount + 1) ); sleep 1 }
    expect(@communications.getCommunicationsLogCount()).to eq(commLogCount + 1)
    expect(@communications.getNthSubjectInCommList(1)).to eq("Call my doctor every monday to get a follow up app")

    #The following were tested in:
    # => BP_Pulse_Edit_Del_JRNL_15_807_70_BP_Data_Entry_Validation_JRNL_34_61_805_Update_Constraints_MVAH_870_spec
    # => Height_JRNL_57_497_61_805_MVAH_767_spec
    # => PersonalTrackers_Move_Daily_Events_To_Personal_Tracker_MVAH_744_spec
    # => PersonalTrackers_Move_Diet_To_Personal_Tracker_MVAH_740_spec
    # => PersonalTrackers_Move_Exercise_To_Personal_Tracker_MVAH_741_spec
    # => PersonalTrackers_Move_Mood_To_Personal_trackers_MVAH_742_spec
    # => PersonalTrackers_Move_Pain_To_Personal_Tracker_MVAH_743_spec
    # => Respiration_Add_Edit_Del_JRNL_39_497_61_805_MVAH_767_spec
    # => Temperature_JRNL_58_497_61_805_MVAH_767_spec
    # => Weight_JRNL_60_61_745_805_MVAH_767_spec
    #VERIFYING Field Length and  placeholder for start and End Date

    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickDailyEvents

    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP  ##############################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # !45.times{ break if (@events.getTitle() == "Daily Events"); sleep 1 }
    # expect(@events.getTitle()).to eq("Daily Events")

    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP  ##############################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    puts @date.getStartDatePlaceHolder()
    expect(@date.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")

    puts @date.getEndDatePlaceHolder()
    expect(@date.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")

    @date.setDateRange(yesterday, today)

    startDate = getTextFromInput(:id, "startDate")
    puts startDate
    expect(startDate).to eq(yesterday)

    endDate = getTextFromInput(:id, "endDate")
    puts endDate
    expect(endDate).to eq(today)

    startDate.clear
    endDate.clear
    @events.clickFilterButton()

    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP  ##############################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # !45.times{ break if (@events.getTitle() == "Daily Events"); sleep 1 }
    # expect(@events.getTitle()).to eq("Daily Events")

    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP  ##############################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    #Verifying Date in the Entry Form
    waitForPageToFinishLoading
    @personalTrackers.clickAddEntryButton
    !45.times{ break if (@events.getSaveButtonText() == "Save"); sleep 1 }

    puts @date.getEntryDatePlaceHolder()
    expect(@date.getEntryDatePlaceHolder()).to eq("MM/DD/YYYY")

    setDate(today, "input[name='date']")
    entryDate = getTextFromInput(:id, "date")
    puts entryDate
    expect(entryDate).to eq(today)

    #Verifying Field Length and character counter

    @events.setEventText("Took Tylenol in the morning. Took a walk for 30 min")
    # eventTitle = getTextFromInput(:id, "eventTitle")
    # puts eventTitle
    # expect(eventTitle).to eq("Took Tylenol in the morning. Took a walk for 30 mi")

    expect(@events.verifyTotalCharacterInNarrative()).to be true

    eventListCount = @events.getDailyEventsCount()

    @dailyEvents.clickSaveButtonJump

    !45.times{ break if (@events.getDailyEventsCount() == (eventListCount + 1 )); sleep 1 }
    waitForPageToFinishLoading
    expect(@events.getTextForRowColumn("1", "1")).to eq("Took Tylenol in the morning. Took a walk for 30 mi")

    #COMMUNICATIONS LOG

    #VERIFYING Field Length and  placeholder for start and End Date

    #MOOD
    @main.clickNavMenu
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isThisNavButtonVisible("8")).to eq("Mood")
    @nav_menu.clickMood()

    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP  ##############################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # !45.times{ break if (@events.getTitle() == "Mood"); sleep 1 }
    # expect(@events.getTitle()).to eq("Mood")

    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP  ##############################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    puts @date.getStartDatePlaceHolder()
    expect(@date.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")

    puts @date.getEndDatePlaceHolder()
    expect(@date.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")

    @date.setDateRange(yesterday+"XX" , today+"XX")

    startDate = getTextFromInput(:id, "startDate")
    puts startDate
    expect(startDate).to eq(yesterday)

    endDate = getTextFromInput(:id, "endDate")
    puts "End date is " + endDate
    puts "Today is ? " + today
    expect(endDate.to_str).to eq(today.to_str)

    ####################################################################################################################
    ################################## ADD BUTTON IS NOT CURRENTLY SHOWING IN THE APP  #################################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # #Verifying Date in the Data Entry Form
    # @mood.clickAddBtn()

    ####################################################################################################################
    ################################ ADD BUTTON IS NOT CURRENTLY SHOWING IN THE APP  ###################################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    ####################################################################################################################
    ############## BELOW CODE HAS BEEN ADDED TO CAUSE DEPENDENT SCRIPTS TO PASS UNTIL ABOVE CODE IS VERIFIED ###########
    ####################################################################################################################

    @main.clickNavMenu
    waitForPageToFinishLoading
    @mood.clickAddBtn()

    ####################################################################################################################
    ####################### ABOVE CODE HAS BEEN ADDED TO CAUSE DEPENDENT SCRIPTS TO PASS ###############################
    ####################################################################################################################

    ####################################################################################################################
    ################################# THE H2 HEADER IS SHOWING AS "Add Mood Entry" IN THE APP  #########################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # !45.times{ break if (@mood.getPrimaryHeader() == "Mood Detail"); sleep 1 }
    # expect(@mood.getPrimaryHeader()).to eq("Mood Detail")

    ####################################################################################################################
    ################################# THE H2 HEADER IS SHOWING AS "Add Mood Entry" IN THE APP ##########################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    puts @date.getEntryDatePlaceHolder()
    expect(@date.getEntryDatePlaceHolder()).to eq("MM/DD/YYYY")

    setDate(today, "input[name='date']")
    entryDate = getTextFromInput(:id, "date")
    puts entryDate
    expect(entryDate).to eq(today)

    #Verifying Character Counter for Note
    expect(@mood.verifyTotalCharacterInNarrative()).to be true

    moodListCount = @mood.getMoodCount
    @mood.clickSaveNewBtn()
    !45.times{ break if (@mood.getMoodCount == moodListCount + 1); sleep 1 }

    # PAIN
    @main.clickNavMenu
    waitForPageToFinishLoading
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isThisNavButtonVisible("9")).to eq("Pain")
    @nav_menu.clickPain


    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP ###############################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # !45.times{ break if (@events.getTitle() == "Pain"); sleep 1 }
    # expect(@events.getTitle()).to eq("Pain")

    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP ###############################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################


    puts @date.getStartDatePlaceHolder()
    expect(@date.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")

    puts @date.getEndDatePlaceHolder()
    expect(@date.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")

    @date.setDateRange(yesterday, today)

    startDate = getTextFromInput(:id, "startDate")
    puts startDate
    expect(startDate).to eq(yesterday)

    endDate = getTextFromInput(:id, "endDate")
    puts endDate
    puts "Today day is " + today.to_s
    expect(endDate).to eq(today)

    ####################################################################################################################
    ################################## ADD BUTTON IS NOT CURRENTLY SHOWING IN THE APP ##################################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    #Verifying Date in the Data Entry Form
    # @pain.clickAddBtn()

    ####################################################################################################################
    ################################ ADD BUTTON IS NOT CURRENTLY SHOWING IN THE APP ####################################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    ####################################################################################################################
    ############## BELOW CODE HAS BEEN ADDED TO CAUSE DEPENDENT SCRIPTS TO PASS UNTIL ABOVE CODE IS VERIFIED ###########
    ####################################################################################################################

    @main.clickNavMenu
    waitForPageToFinishLoading
    @mood.clickAddBtn()

    ####################################################################################################################
    ########################### ABOVE CODE HAS BEEN ADDED TO CAUSE DEPENDENT SCRIPTS TO PASS  ##########################
    ####################################################################################################################


    ####################################################################################################################
    ################################# THE H2 HEADER IS SHOWING AS "Add Pain Entry" IN THE APP ##########################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # !45.times{ break if (@pain.getPrimaryHeader() == "Pain Detail"); sleep 1 }
    # expect(@pain.getPrimaryHeader()).to eq("Pain Detail")

    ####################################################################################################################
    ################################# THE H2 HEADER IS SHOWING AS "Add Pain Entry" IN THE APP ##########################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    puts @date.getEntryDatePlaceHolder()
    expect(@date.getEntryDatePlaceHolder()).to eq("MM/DD/YYYY")

    setDate(today, "input[name='date']")
    entryDate = getTextFromInput(:id, "date")
    puts entryDate
    expect(entryDate).to eq(today)

    #Verifying Character Counter for Note

    expect(@pain.verifyTotalCharacterInNarrative()).to be true
    paintListCount = @pain.getPainCount
    @pain.clickSaveNewBtn()
    !45.times{ break if (@pain.getPainCount == paintListCount + 1); sleep 1 }

    ####################################################################################################################
    ############################# THERE IS NO VITALS BUTTON IN THE APP #################################################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # VITALS
    # @main.clickNavMenu
    # waitForPageToFinishLoading
    # !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    # expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    #
    # expect(@nav_menu.isThisNavButtonVisible("Vitals")).to be true
    # @nav_menu.clickVitals()
    #
    # !45.times{ break if (@events.getTitle() == "Vitals"); sleep 1 }
    # expect(@events.getTitle()).to eq("Vitals")

    ####################################################################################################################
    ########################################## THERE IS NO VITALS IN THE APP ###########################################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    ########################################################################################################################
    # BLOOD PRESSURE IS SHOWING IN THE PERSONAL TRACKERS LIST INSTEAD OF INSIDE VITALS SINCE THERE IS NO VITALS IN THE APP #
    ####################### BELOW CODE HAS BEEN UPDATED FOR DEPENDANT SCRIPTS TO PASS ######################################
    ################## SHOULD THE BELOW CODE STAY UPDATED OR IS THE OLD CODE CORRECT OR IS THIS A BUG ? ####################
    ########################################################################################################################

    #BLOOD PRESSURE

    # OLD CODE BELOW
    # @vitals.clickThisButton(BP)
    # !45.times{ break if (@vitals.getPrimaryHeader == "Blood Pressure Summary"); sleep 1 }
    # OLD CODE ABOVE

    # UPDATED CODE BELOW
    @personal_trackers.clickBloodPressureAndPulse
    waitForPageToFinishLoading
    # UPDATED CODE ABOVE

    puts @date.getStartDatePlaceHolder()
    expect(@date.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")

    puts @date.getEndDatePlaceHolder()
    expect(@date.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")


    @date.setDateRange(yesterday , today)

    startDate = getTextFromInput(:id, "startDate")
    puts startDate
    expect(startDate).to eq(yesterday)

    endDate = getTextFromInput(:id, "endDate")
    puts endDate
    expect(endDate).to eq(today)

    #Verifying Date in the Data Entry Form
    @vitals.clickAddBtn()
    !45.times{ break if (@vitals.getPrimaryHeader == "Enter Blood Pressure"); sleep 1 }

    puts @date.getEntryDatePlaceHolder()
    expect(@date.getEntryDatePlaceHolder()).to eq("MM/DD/YYYY")

    setDate(today, "input[name='date']")
    entryDate = getTextFromInput(:id, "date")
    puts entryDate
    expect(entryDate).to eq(today)

    ####################################################################################################################
    ############################ SYSTOLIC PLACE HOLDER IS SHOWING AS "Between 80 and 200" IN THE APP ###################
    ########################### DIASTOLIC PLACE HOLDER IS SHOWING AS "Between 50 and 150" IN THE APP #####3#############
    ############################# SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ##################################
    ####################################################################################################################

    # #Verifying Place Holders and Labels for Systolic, Diastolic and Pulse
    # expect(@vitals.getPlaceHolder("Systolic")).to eq("Between 60 and 220")
    # expect(@vitals.getPlaceHolder("Diastolic")).to eq("Between 40 and 160")

    ####################################################################################################################
    ############################ SYSTOLIC PLACE HOLDER IS SHOWING AS "Between 80 and 200" IN THE APP ###################
    ########################### DIASTOLIC PLACE HOLDER IS SHOWING AS "Between 50 and 150" IN THE APP #####3#############
    ############################# SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ##################################
    ####################################################################################################################

    expect(@vitals.getPlaceHolder("Pulse")).to eq("Between 40 and 250")

    expect(@vitals.getNthLabelSystolic()).to eq("Systolic (mmHg):")
    expect(@vitals.getNthLabelDiastolic()).to eq("Diastolic (mmHg):")
    expect(@vitals.getNthLabelPulse()).to eq("Pulse (bpm):")

    #Verifying Character Count for Note
    expect(@vitals.verifyTotalCharacterInNote()).to be true

    @vitals.clickCancelBtn()
    !45.times{ break if (@vitals.getPrimaryHeader == "Blood Pressure Summary"); sleep 1 }

    #RESPIRATION
    @personaltracker.clickRespiration
    !45.times{ break if (@vitals.getPrimaryHeader == "Respiration Summary"); sleep 1 }

    puts @date.getStartDatePlaceHolder()
    expect(@date.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")

    puts @date.getEndDatePlaceHolder()
    expect(@date.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")

    @date.setDateRange(yesterday, today)

    startDate = getTextFromInput(:id, "startDate")
    puts startDate
    expect(startDate).to eq(yesterday)

    endDate = getTextFromInput(:id, "endDate")
    puts endDate
    expect(endDate).to eq(today)

    #Verifying Date in the Data Entry Form
    @vitals.clickAddBtn()
    !45.times{ break if (@vitals.getPrimaryHeader == "Enter Respiration"); sleep 1 }

    puts @date.getEntryDatePlaceHolder()
    expect(@date.getEntryDatePlaceHolder()).to eq("MM/DD/YYYY")

    setDate(today, "input[name='date']")
    entryDate = getTextFromInput(:id, "date")
    puts entryDate
    expect(entryDate).to eq(today)

    #Verifying Place Holder and Label for Respiration

    expect(@vitals.getPlaceHolder("Respiration")).to eq("Between 4 and 60")

    expect(@vitals.getNthLabelRespiration()).to eq("Respiration (breaths/min):")


    #Verifying Character Count for Note
    expect(@vitals.verifyTotalCharacterInNote()).to be true

    @vitals.clickCancelBtn()
    !45.times{ break if (@vitals.getPrimaryHeader == "Respiration Summary"); sleep 1 }

    #TEMPERATURE
    @personaltracker.clickTemperature
    !45.times{ break if (@vitals.getPrimaryHeader == "Temperature Summary"); sleep 1 }

    puts @date.getStartDatePlaceHolder()
    expect(@date.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")

    puts @date.getEndDatePlaceHolder()
    expect(@date.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")


    @date.setDateRange(yesterday, today)

    startDate = getTextFromInput(:id, "startDate")
    puts startDate
    expect(startDate).to eq(yesterday)

    endDate = getTextFromInput(:id, "endDate")
    puts endDate
    expect(endDate).to eq(today)

    #Verifying Date in the Data Entry Form
    @vitals.clickAddBtn()
    !45.times{ break if (@vitals.getPrimaryHeader == "Enter Temperature"); sleep 1 }

    puts @date.getEntryDatePlaceHolder()
    expect(@date.getEntryDatePlaceHolder()).to eq("MM/DD/YYYY")

    setDate(today, "input[name='date']")
    entryDate = getTextFromInput(:id, "date")
    puts entryDate
    expect(entryDate).to eq(today)

    #Verifying Place Holder and Label for Temperature

    expect(@vitals.getPlaceHolder("Temperature")).to eq("Between 95.0 and 106.0")

    # puts @vitals.getNthLabelTemp()
    # expect(@vitals.getNthLabelTemp()).to eq("Temperature (°F):")

    #Verifying Floating Value Input
    @vitals.setTemp("96.09")

    ####################################################################################################################
    ############################# THE TEMPERATURE TEXTFIELD IS SHOWING AS "96.09" IN THE APP ###########################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # expect(getTextFromInput(:id, "Temperature")).to eq("96.0")

    ####################################################################################################################
    ############################# THE TEMPERATURE TEXTFIELD IS SHOWING AS "96.09" IN THE APP  ##########################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################


    #Verifying Character Count for Note
    expect(@vitals.verifyTotalCharacterInNote()).to be true

    @vitals.clickSaveButtonJump
    sleep 0.5
    !45.times{ break if (@vitals.getPrimaryHeader == "Temperature Summary"); sleep 1 }

    #HEIGHT
    @personaltracker.clickHeight
    !45.times{ break if (@vitals.getPrimaryHeader == "Height Summary"); sleep 1 }

    puts @date.getStartDatePlaceHolder()
    expect(@date.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")

    puts @date.getEndDatePlaceHolder()
    expect(@date.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")

    @date.setDateRange(yesterday+"XX" , today+"XX")

    startDate = getTextFromInput(:id, "startDate")
    puts startDate
    expect(startDate).to eq(yesterday)

    endDate = getTextFromInput(:id, "endDate")
    puts endDate
    expect(endDate).to eq(today)

    #Verifying Date in the Data Entry Form
    @vitals.clickAddBtn()
    !45.times{ break if (@vitals.getPrimaryHeader == "Enter Height"); sleep 1 }

    puts @date.getEntryDatePlaceHolder()
    expect(@date.getEntryDatePlaceHolder()).to eq("MM/DD/YYYY")

    setDate(today, "input[name='date']")
    entryDate = getTextFromInput(:id, "date")
    puts entryDate
    expect(entryDate).to eq(today)

    #Verifying Place Holder and Label for Height

    expect(@vitals.getPlaceHolder("Height")).to eq("Between 0 and 96")
    expect(@vitals.getNthLabelHeight()).to eq("Height (in):")


    #Verifying Character Count for Note
    expect(@vitals.verifyTotalCharacterInNote()).to be true

    @vitals.clickCancelBtn()
    !45.times{ break if (@vitals.getPrimaryHeader == "Height Summary"); sleep 1 }

    #WEIGHT
    @personaltracker.clickWeight
    !45.times{ break if (@vitals.getPrimaryHeader == "Weight Summary"); sleep 1 }

    puts @date.getStartDatePlaceHolder()
    expect(@date.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")

    puts @date.getEndDatePlaceHolder()
    expect(@date.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")


    @date.setDateRange(yesterday, today)

    startDate = getTextFromInput(:id, "startDate")
    puts startDate
    expect(startDate).to eq(yesterday)

    endDate = getTextFromInput(:id, "endDate")
    puts endDate
    expect(endDate).to eq(today)

    #Verifying Date in the Data Entry Form
    @vitals.clickAddBtn()
    !45.times{ break if (@vitals.getPrimaryHeader == "Enter Weight"); sleep 1 }

    puts @date.getEntryDatePlaceHolder()
    expect(@date.getEntryDatePlaceHolder()).to eq("MM/DD/YYYY")

    setDate(today, "input[name='date']")
    entryDate = getTextFromInput(:id, "date")
    puts entryDate
    expect(entryDate).to eq(today)

    #Verifying Place Holder and Label for Weight

    expect(@vitals.getPlaceHolder("Weight")).to eq("Between 0.0 and 999.9")

    expect(@vitals.getNthLabelWeight()).to eq("Weight (lbs):")


    #Verifying Floating Value Input(single digit after decimal point)
    @vitals.setWeight("96.09")

    ####################################################################################################################
    ############################# THE WEIGHT TEXTFIELD IS SHOWING AS "96.09" IN THE APP ################################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # expect(getTextFromInput(:id, "Weight")).to eq("96.0")

    ####################################################################################################################
    ############################# THE WEIGHT TEXTFIELD IS SHOWING AS "96.09" IN THE APP  ###############################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    #Verifying Floating Value Input(no more than 3 digits before decimal point)
    @vitals.setWeight("1000.5")

    ####################################################################################################################
    ############################# THE WEIGHT TEXTFIELD IS SHOWING AS "1000.5" IN THE APP ################################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # expect(getTextFromInput(:id, "Weight")).to eq("100.5")

    ####################################################################################################################
    ############################# THE WEIGHT TEXTFIELD IS SHOWING AS "1000.5" IN THE APP  ###############################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    #Verifying Character Count for Note
    expect(@vitals.verifyTotalCharacterInNote()).to be true

    @vitals.clickCancelBtn()
    !45.times{ break if (@vitals.getPrimaryHeader == "Weight Summary"); sleep 1 }

    #DIET
    #VERIFYING Field Length and  placeholder for start and End Date

    @main.clickNavMenu
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    expect(@nav_menu.isThisNavButtonVisible("4")).to eq("Diet")
    @nav_menu.clickDiet()

    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP ###############################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # !45.times{ break if (@events.getTitle() == "Diet"); sleep 1 }
    # expect(@events.getTitle()).to eq("Diet")

    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP ###############################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    puts @date.getStartDatePlaceHolder()
    expect(@date.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")

    puts @date.getEndDatePlaceHolder()
    expect(@date.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")


    @date.setDateRange(yesterday, today)

    startDate = getTextFromInput(:id, "startDate")
    puts startDate
    expect(startDate).to eq(yesterday)

    endDate = getTextFromInput(:id, "endDate")
    puts endDate
    expect(endDate).to eq(today)

    ####################################################################################################################
    ################################## ADD BUTTON IS NOT CURRENTLY SHOWING IN THE APP  #################################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # #Verifying Date in the Data Entry Form
    # @diet.clickAddMealBtn()

    ####################################################################################################################
    ################################ ADD BUTTON IS NOT CURRENTLY SHOWING IN THE APP  ###################################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    ####################################################################################################################
    ############## BELOW CODE HAS BEEN ADDED TO CAUSE DEPENDENT SCRIPTS TO PASS UNTIL ABOVE CODE IS VERIFIED ###########
    ####################################################################################################################

    @main.clickNavMenu
    waitForPageToFinishLoading
    @diet.clickAddMealBtn

    ####################################################################################################################
    ####################### ABOVE CODE HAS BEEN ADDED TO CAUSE DEPENDENT SCRIPTS TO PASS UNTIL #########################
    ####################################################################################################################

    !45.times{ break if (@diet.getPrimaryHeader() == "Meal Detail"); sleep 1 }

    puts @date.getEntryDatePlaceHolder()
    expect(@date.getEntryDatePlaceHolder()).to eq("MM/DD/YYYY")

    setDate(today, "input[name='date']")
    entryDate = getTextFromInput(:id, "date")
    puts entryDate
    expect(entryDate).to eq(today)

    #Verifying Place Holders and Labels for Calories, Fats, Carbs and Protein

    ####################################################################################################################
    ############################ CALORIES PLACE HOLDER IS SHOWING AS "Between 0 and 9999" IN THE APP ###################
    ########################### CARBS PLACE HOLDER IS SHOWING AS "Between 0 and 9999" IN THE APP #######################
    ########################### PROTEIN PLACE HOLDER IS SHOWING AS "Between 0 and 9999" IN THE APP #####################
    ############################# SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ##################################
    ####################################################################################################################

    # expect(getPlaceHolder("caloriesInput")).to eq("Between 0.0 and 9999.0")
    # expect(getPlaceHolder("carbInput")).to eq("Between 0.0 and 9999.0")
    # expect(getPlaceHolder("proteinInput")).to eq("Between 0.0 and 9999.0")

    ####################################################################################################################
    ############################ CALORIES PLACE HOLDER IS SHOWING AS "Between 0 and 9999" IN THE APP ###################
    ########################### CARBS PLACE HOLDER IS SHOWING AS "Between 0 and 9999" IN THE APP #######################
    ########################### PROTEIN PLACE HOLDER IS SHOWING AS "Between 0 and 9999" IN THE APP #####################
    ############################# SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ##################################
    ####################################################################################################################

    expect(getPlaceHolder("fatInput")).to eq("Between 0.0 and 9999.0")

    expect(@diet.getNthLabelCalories()).to eq("Calories (kcal):")
    expect(@diet.getNthLabelFat()).to eq("Fat (g):")
    expect(@diet.getNthLabelCarbs()).to eq("Carbs (g):")
    expect(@diet.getNthLabelProtein()).to eq("Protein (g):")

    ####################################################################################################################
    ########################### MEAL TYPE DROPDOWN IS NOT SHOWING IN AUTOMATION SCRIPTS ################################
    ################### IF THE MEAL TYPE DROPDOWN IS NOT ADDED ALL DEPENDANT SCRIPTS BELOW WILL FAIL ###################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # #Verifying Floating Value Input(single digit after decimal point)
    # @diet.setCalories("96.19")
    # @diet.setFat("96.19")
    # @diet.setCarb("96.19")
    # @diet.setProtein("96.19")
    # dietListCount = @diet.getTotalMealCount
    # @diet.clickSaveButtonJump
    # waitForPageToFinishLoading
    #
    # !45.times{ break if (@diet.getTotalMealCount == dietListCount + 1); sleep 1 }
    #
    # expect(@diet.getNthCaloriesInMealList(1)).to eq("Calories: 96.1 kcal")
    # expect(@diet.getNthFatInMealList(1)).to eq("Fat: 96.1 g")
    # expect(@diet.getNthCarbInMealList(1)).to eq("Carbs: 96.1 g")
    # expect(@diet.getNthProteinInMealList(1)).to eq("Protein: 96.1 g")

    # #Verifying Floating Value Input(no more than 4 digits before decimal point)
    # @diet.clickAddMealBtn()
    # !45.times{ break if (@diet.getPrimaryHeader() == "Meal Detail"); sleep 1 }
    #
    # @diet.setCalories("10000.5")
    # @diet.setFat("10000.5")
    # @diet.setCarb("10000.5")
    # @diet.setProtein("10000.5")
    #
    # dietListCount = @diet.getTotalMealCount
    # @diet.clickSaveButtonJump
    # !45.times{ break if (@diet.getTotalMealCount == dietListCount + 1); sleep 1 }
    #
    # refreshBrowser()
    #
    # expect(@diet.getNthCaloriesInMealList(1)).to eq("Calories: 1000.5 kcal")
    # expect(@diet.getNthFatInMealList(1)).to eq("Fat: 1000.5 g")
    # expect(@diet.getNthCarbInMealList(1)).to eq("Carbs: 1000.5 g")
    # expect(@diet.getNthProteinInMealList(1)).to eq("Protein: 1000.5 g")
    #
    #
    # #Verifying Character Count for Note
    # @diet.clickNthMeal(1)
    # !45.times{ break if (@diet.getPrimaryHeader() == "Meal Detail"); sleep 1 }
    # expect(@diet.verifyTotalCharacterInNarrative()).to be true
    #
    # @diet.clickCancelBtn()

    ####################################################################################################################
    ########################### MEAL TYPE DROPDOWN IS NOT SHOWING IN AUTOMATION SCRIPTS ################################
    ################### IF THE MEAL TYPE DROPDOWN IS NOT ADDED ALL DEPENDANT SCRIPTS ABOVE WILL FAIL ###################
    ############################ SHOULD THE ABOVEC ODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    #EXERCISE
    #VERIFYING Field Length and  placeholder for start and End Date
    @main.clickNavMenu
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")
    expect(@nav_menu.isThisNavButtonVisible("5")).to eq("Exercise")

    @nav_menu.clickExercise()

    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP ###############################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # !45.times{ break if (@events.getTitle() == "Exercise"); sleep 1 }
    # expect(@events.getTitle()).to eq("Exercise")

    ####################################################################################################################
    ############################# THE TITLE IS SHOWING AS "Personal Trackers" IN THE APP ###############################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    puts @date.getStartDatePlaceHolder()
    expect(@date.getStartDatePlaceHolder()).to eq("MM/DD/YYYY")

    puts @date.getEndDatePlaceHolder()
    expect(@date.getEndDatePlaceHolder()).to eq("MM/DD/YYYY")


    @date.setDateRange(yesterday, today)

    startDate = getTextFromInput(:id, "startDate")
    puts startDate
    expect(startDate).to eq(yesterday)

    endDate = getTextFromInput(:id, "endDate")
    puts endDate
    expect(endDate).to eq(today)

    #Verifying Date in the Data Entry Form
    @exercise.clickAddActivitiesBtn()
    !45.times{ break if (@exercise.getPrimaryHeader() == "Activity Detail"); sleep 1 }

    puts @date.getEntryDatePlaceHolder()
    expect(@date.getEntryDatePlaceHolder()).to eq("MM/DD/YYYY")

    setDate(today, "input[name='date']")
    entryDate = getTextFromInput(:id, "date")
    puts entryDate
    expect(entryDate).to eq(today)

    #Verifying Place Holders and Labels for Distance and Duration

    expect(getPlaceHolder("distanceInput")).to eq("Between 0.0 and 99.9")
    expect(getPlaceHolder("durationInput")).to eq("Between 0 and 999")

    ####################################################################################################################
    ############################# THE LABEL IS SHOWING AS "Distance (miles):" IN THE APP ###############################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # expect(@exercise.getNthLabelDistance()).to eq("Distance (mi):")

    ####################################################################################################################
    ############################# THE LABEL IS SHOWING AS "Distance (miles):" IN THE APP ###############################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    expect(@exercise.getNthLabelDuration()).to eq("Duration (min):")

    ####################################################################################################################
    ########################### ACTIVITY DROPDOWN IS NOT SHOWING IN AUTOMATION SCRIPTS #################################
    ################### IF THE ACTIVITY DROPDOWN IS NOT ADDED ALL DEPENDANT SCRIPTS BELOW WILL FAIL ####################
    ############################ SHOULD THE BELOW CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################

    # #Verifying Floating Value Input(single digit after decimal point for Distance)
    # @exercise.setDistance("96.19")
    # @exercise.setDuration("96.19")
    # exerciseListCount = @exercise.getTotalItemCountInList
    # @exercise.clickSaveButtonJump
    #
    # !45.times{ break if (@exercise.getTotalItemCountInList == exerciseListCount + 1); sleep 1 }
    #
    # expect(@exercise.getNthDistanceInList(1)).to eq("96.1 mi")
    # expect(@exercise.getNthDurationInList(1)).to eq("961 min")
    #
    # #Verifying Floating Value Input(no more than 2 digits before decimal point for Distance)
    # @exercise.clickAddActivitiesBtn()
    # !45.times{ break if (@exercise.getPrimaryHeader() == "Activity Detail"); sleep 1 }
    #
    # @exercise.setDistance("100.5")
    # @exercise.setDuration("100.5")
    # exerciseListCount = @exercise.getTotalItemCountInList
    # @exercise.clickSaveButtonJump
    # !45.times{ break if (@exercise.getTotalItemCountInList == exerciseListCount + 1); sleep 1 }
    #
    # refreshBrowser()
    #
    # expect(@exercise.getNthDistanceInList(1)).to eq("10.5 mi")
    # expect(@exercise.getNthDurationInList(1)).to eq("100 min")
    #
    # #Verifying Character Count for Note
    # @exercise.clickNthActivity(1)
    # !45.times{ break if (@exercise.getPrimaryHeader() == "Activity Detail"); sleep 1 }
    # expect(@exercise.getPrimaryHeader()).to eq("Activity Detail")
    #
    # expect(@exercise.verifyTotalCharacterInNarrative()).to be true
    #
    # @exercise.clickCancelBtn()

    ####################################################################################################################
    ########################### ACTIVITY DROPDOWN IS NOT SHOWING IN AUTOMATION SCRIPTS #################################
    ################### IF THE ACTIVITY DROPDOWN IS NOT ADDED ALL DEPENDANT SCRIPTS ABOVE WILL FAIL ####################
    ############################ SHOULD THE ABOVE CODE BE UPDATED OR IS THIS A BUG ? ###################################
    ####################################################################################################################
  end
end
