require_relative '../../globalized'
include Globalized

describe "[ Story #JRNL-261: Use Spinner Date Picker for User Entered Date ]", :broken => true, :regression => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
    deleteDailyEventTable("D123401")


    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    !45.times{ break if (@landing.getTitle() == "My VA Health"); sleep 1 }
    expect(@landing.getTitle()).to eq("My VA Health")
    expect(@landing.getFooterText()).to eq("Not logged in")

    @loginpage.passingByTheLandingPage()

    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

########################################################################################################################
########################################################################################################################
############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  BELOW CODE ###################################
########################################################################################################################
########################################################################################################################

    !15.times{ break if (@main.pleaseNoteHeader() == "Please Note"); sleep 2 }
    click(:css, "input[id='no-show-notice']")
    @pleasenote.clickAccept

########################################################################################################################
########################################################################################################################
############################# WHAT IS THE REQUIREMENTS FOR "PLEASE NOTE"  ABOVE CODE ###################################
########################################################################################################################
########################################################################################################################

########################################################################################################################
########################################################################################################################
############################# THE REST OF THE CODE ON THIS PAGE STILL NEEDS TO BE FIXED ################################
########################################################################################################################
########################################################################################################################

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickNavMenu
    @navMenu.clickPersonalTrackers
    @personalTrackers.clickDailyEvents

  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-449|TC #JRNL-814: If a date field has date constraints (users may select only values within the last 100 years) then the date picker must constrain the available dates and convey the constraint to all users including those using assistive technology." do
    startDate = getDateNthYeasFromNow(-100, "%m/%d/%Y")
    endDate = getDateNthDaysAgo(0, "%m/%d/%Y")
    @dateFilter.setDateRange(startDate, endDate)

    @dateFilter.clickStartDateCalendarBtn
    # !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }

    dayStr = @datePicker.getSelectedDay
    monStr = @datePicker.getSelectedMonth
    yearStr = @datePicker.getSelectedYear

    puts "returned date:"
    puts monStr + " " + dayStr + ", " + yearStr

    datePickerDate = DateTime.strptime(monStr + " " + dayStr + ", " + yearStr, "%b %d, %Y")
    puts "datePickerDate " + datePickerDate.to_s
    dateSelectionDate = DateTime.strptime(startDate,  "%m/%d/%Y")
    puts "dateSelectionDate " + dateSelectionDate.to_s

    expect(datePickerDate).to eq(dateSelectionDate)

    @datePicker.clickCloseBtn

    @dateFilter.clickEndDateCalendarBtn
    !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }
    dayStr = @datePicker.getSelectedDay
    monStr = @datePicker.getSelectedMonth
    yearStr = @datePicker.getSelectedYear

    @datePicker.areMonthsAfterThisDisabled(monStr).should be true
    @datePicker.areDaysAfterThisDisabled(dayStr).should be true
    @datePicker.verifyTheYearIsTheLastInList(yearStr).should be true

    refreshBrowser
  end


  it "AC #JRNL-448: Date picker is displayed" do
    @dateFilter.clickStartDateCalendarBtn
    !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }

    expect(@datePicker.getSetButtonText).to eq("SET")
    @datePicker.clickCloseBtn

  end

  it "AC #JRNL-449|TC #JRNL-814: The date picker will allow a user to select the date (month, day, year) via a set of three spinner controls." do
    @dateFilter.clickStartDateCalendarBtn
    !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }
    expect(@datePicker.getSetButtonText).to eq("SET")

    @datePicker.setYear(2012)
    !45.times{ break if (@datePicker.getSelectedYear == "2012"); sleep 1 }
    @datePicker.setMonth(12)
    !45.times{ break if (@datePicker.getSelectedMonth == "DEC"); sleep 1 }
    @datePicker.setDay(3)
    !45.times{ break if (@datePicker.getSelectedDay == "03"); sleep 1 }

    expect(@datePicker.getSelectedYear).to eq("2012")
    expect(@datePicker.getSelectedMonth).to eq("DEC")
    expect(@datePicker.getSelectedDay).to eq("03")

    @datePicker.setYear(2014)
    !45.times{ break if (@datePicker.getSelectedYear == "2014"); sleep 1 }
    @datePicker.setMonth(4)
    !45.times{ break if (@datePicker.getSelectedMonth == "APR"); sleep 1 }
    @datePicker.setDay(28)
    !45.times{ break if (@datePicker.getSelectedDay == "28"); sleep 1 }

    expect(@datePicker.getSelectedYear).to eq("2014")
    expect(@datePicker.getSelectedMonth).to eq("APR")
    expect(@datePicker.getSelectedDay).to eq("28")
    @datePicker.clickCloseBtn

  end

  it "AC #JRNL-449|TC #JRNL-814: Once the user has entered the date, the user must select 'set' to close the date picker and populate the date field display. All date components (month, day, and year) must have a valid selection before a 'set' action can be invoked." do
    @dateFilter.clickStartDateCalendarBtn
    !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }
    expect(@datePicker.getSetButtonText).to eq("SET")
    @datePicker.setYear(2013)
    !45.times{ break if (@datePicker.getSelectedYear == "2013"); sleep 1 }
    @datePicker.setMonth(4)
    !45.times{ break if (@datePicker.getSelectedMonth == "APR"); sleep 1 }
    @datePicker.setDay(4)
    !45.times{ break if (@datePicker.getSelectedDay == "04"); sleep 1 }

    expect(@datePicker.getSelectedYear).to eq("2013")
    expect(@datePicker.getSelectedMonth).to eq("APR")
    expect(@datePicker.getSelectedDay).to eq("04")

    @datePicker.clickSet
    !45.times{ break if (@dateFilter.getStartDate == "04/04/2013"); sleep 1 }
    expect(@dateFilter.getStartDate).to eq("04/04/2013")


    @dateFilter.clickEndDateCalendarBtn
    !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }
    @datePicker.setDateFromGUI(3, 24, 2014)
    expect(@dateFilter.getEndDate).to eq("03/24/2014")

  end

  it "AC #JRNL-449|TC #JRNL-814: Users shall be able to exit out of the date picker without selecting a date. This action will retain the last 'set' date or a null date if the field was previously empty." do
    #Validate Start date field
    startDate = @dateFilter.getStartDate

    @dateFilter.clickStartDateCalendarBtn
    !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }
    expect(@datePicker.getSetButtonText).to eq("SET")

    @datePicker.setYear(2009)
    !45.times{ break if (@datePicker.getSelectedYear == "2009"); sleep 1 }
    @datePicker.setMonth(10)
    !45.times{ break if (@datePicker.getSelectedMonth == "OCT"); sleep 1 }
    @datePicker.setDay(1)
    !45.times{ break if (@datePicker.getSelectedDay == "01"); sleep 1 }

    @datePicker.clickCloseBtn
    expect(@dateFilter.getStartDate == startDate)

    @dateFilter.clearFromDateFiled
    expect(@dateFilter.getStartDate).to eq("")

    @dateFilter.clickStartDateCalendarBtn
    !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }
    expect(@datePicker.getSetButtonText).to eq("SET")

    @datePicker.setYear(2012)
    !45.times{ break if (@datePicker.getSelectedYear == "2012"); sleep 1 }
    @datePicker.setMonth(11)
    !45.times{ break if (@datePicker.getSelectedMonth == "NOV"); sleep 1 }
    @datePicker.setDay(25)
    !45.times{ break if (@datePicker.getSelectedDay == "25"); sleep 1 }

    @datePicker.clickCloseBtn
    expect(@dateFilter.getStartDate == "")

    #Validate End Date Field
    endDate = @dateFilter.getEndDate
    @dateFilter.clickEndDateCalendarBtn

    @datePicker.setYear(2013)
    !45.times{ break if (@datePicker.getSelectedYear == "2013"); sleep 1 }
    @datePicker.setMonth(8)
    !45.times{ break if (@datePicker.getSelectedMonth == "AUG"); sleep 1 }
    @datePicker.setDay(16)
    !45.times{ break if (@datePicker.getSelectedDay == "16"); sleep 1 }

    @datePicker.clickCloseBtn
    expect(@dateFilter.getEndDate).to eq(endDate)

    #Validate Empty end date
    @dateFilter.clearEndDateField
    expect(@dateFilter.getEndDate).to eq("")
    @dateFilter.clickEndDateCalendarBtn

    @datePicker.setYear(2007)
    !45.times{ break if (@datePicker.getSelectedYear == "2007"); sleep 1 }
    @datePicker.setMonth(2)
    !45.times{ break if (@datePicker.getSelectedMonth == "FEB"); sleep 1 }
    @datePicker.setDay(23)
    !45.times{ break if (@datePicker.getSelectedDay == "23"); sleep 1 }

    @datePicker.clickCloseBtn
    expect(@dateFilter.getEndDate).to eq("")

  end

  it "AC #JRNL-449|TC #JRNL-814: The date entered via the date picker must match the date populated in the date field display." do
    refreshBrowser()

    @dateFilter.clickStartDateCalendarBtn
    !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }
    expect(@datePicker.getSetButtonText).to eq("SET")

    @datePicker.setDateFromGUI(2, 12, 2013)
    expect(@dateFilter.getStartDate).to eq("02/12/2013")

    @dateFilter.clickEndDateCalendarBtn
    !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }
    @datePicker.setDateFromGUI(3, 24, 2014)
    expect(@dateFilter.getEndDate).to eq("03/24/2014")
  end

  it "AC #JRNL-449|TC #JRNL-814: The spinner date display shall be shown in the format of month (JAN, FEB, MAR, etc.) day (DD), and year (YYYY)" do
    @dateFilter.clickStartDateCalendarBtn
    !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }
    expect(@datePicker.getSetButtonText).to eq("SET")
    @datePicker.setYear(2012)
    !45.times{ break if (@datePicker.getSelectedYear == "2012"); sleep 1 }
    @datePicker.setMonth(3)
    !45.times{ break if (@datePicker.getSelectedMonth == "MAR"); sleep 1 }
    @datePicker.setDay(1)
    !45.times{ break if (@datePicker.getSelectedDay == "01"); sleep 1 }

    expect(@datePicker.getSelectedYear).to eq("2012")
    expect(@datePicker.getSelectedMonth).to eq("MAR")
    expect(@datePicker.getSelectedDay).to eq("01")

    expect(isDateFormatValid?("MAR 01, 2012", "%b %d, %Y")).to eq(true)

    @datePicker.setYear(2013)
    !45.times{ break if (@datePicker.getSelectedYear == "2013"); sleep 1 }
    @datePicker.setMonth(12)
    !45.times{ break if (@datePicker.getSelectedMonth == "DEC"); sleep 1 }
    @datePicker.setDay(25)
    !45.times{ break if (@datePicker.getSelectedDay == "25"); sleep 1 }

    expect(@datePicker.getSelectedYear).to eq("2013")
    expect(@datePicker.getSelectedMonth).to eq("DEC")
    expect(@datePicker.getSelectedDay).to eq("25")

    expect(isDateFormatValid?("DEC 25, 2013", "%b %d, %Y")).to eq(true)

    @datePicker.clickCloseBtn
  end

  it "AC #JRNL-449|TC #JRNL-814: If the user has already entered/selected a date and invokes the date picker, the date picker will display the previously entered/selected date" do
    @dateFilter.setDateRange("03/28/2014", "06/03/2014")

    @dateFilter.clickStartDateCalendarBtn
    expect(@datePicker.getSelectedYear).to eq("2014")
    expect(@datePicker.getSelectedMonth).to eq("MAR")
    expect(@datePicker.getSelectedDay).to eq("28")

    @datePicker.clickCloseBtn

    @dateFilter.clickEndDateCalendarBtn
    expect(@datePicker.getSelectedYear).to eq("2014")
    expect(@datePicker.getSelectedMonth).to eq("JUN")
    expect(@datePicker.getSelectedDay).to eq("03")

    @datePicker.clickCloseBtn
  end

  it "AC #JRNL-449|TC #JRNL-814: Once the user selects and sets the date, the date will appear in the correct format for the app (e.g. mm/dd/yyyy)" do
    @dateFilter.clickEndDateCalendarBtn
    !45.times{ break if (@datePicker.getSetButtonText == "SET"); sleep 1 }
    @datePicker.setDateFromGUI(8, 22, 2011)
    expect(@dateFilter.getEndDate).to eq("08/22/2011")

    expect(isDateFormatValid?(@dateFilter.getEndDate, "%m/%d/%Y")).to eq(true)

  end

end
 