require_relative '../../globalized'
include Globalized


describe "[Story #JRNL-1552: About Screen Updates 3.0]", :acceptance => true do

    before(:all) do
        initializeConfigurations(BASE_URL)
        initializeAllObjects



        @ABOUT_SCREEN = [
            ########################################################################################################################
            ########################################################################################################################
            ############# THE ONLY CAUSE OF THIS SCRIPT FAILING IS THE VERSION NUMBER BELOW NOT UPDATED IN THE APP #################
            ########################################################################################################################
            ########################################################################################################################

            # "My VA Health - v3.0.2",

            ########################################################################################################################
            ########################################################################################################################
            ############# THE ONLY CAUSE OF THIS SCRIPT FAILING IS THE VERSION NUMBER ABOVE NOT UPDATED IN THE APP #################
            ########################################################################################################################
            ########################################################################################################################

            "The My VA Health app allows you to enter, view, and track personal health information, which can be shared with your healthcare team.",
            "You can use the current version of the app to:",
            "Track personal health information including vital signs, diet, exercise, and daily events",
            "Enter your medical history information including your medications, allergies, diagnoses, hospitalizations, surgeries, pregnancies and family history",
            "Create and manage appointment, medication and preventive service reminders",
            "View notifications received from your VA care team",
            "Reflect on what matters to you in your life and how your health can help you reach your life goals",
            "Create and manage healthcare-related and personal contacts and related communications",
            "Complete health assessments",
            "Create a Health Report that includes data you have entered and tracked",
            "Share elements of your health information with your care team",
            "Notes: A DS Logon account (level 2) is needed for access.",
            "End User License Agreement (EULA)",
        ]


        @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
        expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

        @main.clickUserMenu()
        !45.times { break if (getTextForElement(:id, "about") == "About"); sleep 1 }
        expect(@menu.verifyAboutButtonPresent).to eq("About")
        @menu.clickAboutBtn

    end

    after(:all) do
        quitDriver()
    end

    context 'AC #JRNL-1021|TC #JRNL-1020: Test About Screen Updates 3.0' do

        it "About Screen for My VA Health 3.0.0", :bug => true do

            !45.times{ break if (@modal.getConfirmationHeading() == "About"); sleep 1 }
            expect(@modal.getConfirmationHeading()).to eq("About")

            #Verifying Entire content is covered
            aboutcontent = @about.getAboutText().split("\n")
            aboutcontent.each_with_index do | screenRow, i |
                #puts "screenRow [#{i}] [#{screenRow}]"
                #expect(screenRow).to eq(@ABOUT_SCREEN[i])
            end
            #expect(aboutcontent.length).to eq(@ABOUT_SCREEN.length)
        end

        it "Eula link is present" do
            #Clicking on Eula link and verifying that it opens in a new window
            @about.clickShowEULA()
            switchWindowToWindowHandleLast()

            #Verifying Eula Heading
            !45.times { break if (@eula.getEulaHeading == "End User License Agreement"); sleep 1 }
            expect(@eula.getEulaHeading).to eq("End User License Agreement")

            closeBrowser()
            switchWindowToWindowHandleFirst()
            @about.clickOKfromAboutScreen()
        end

    end
end







































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin





require_relative '../../globalized'
include Globalized


describe "[Story #JRNL-1552: About Screen Updates 3.0]", :acceptance => true do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects



    @ABOUT_SCREEN = [
      ########################################################################################################################
      ########################################################################################################################
      ############# THE ONLY CAUSE OF THIS SCRIPT FAILING IS THE VERSION NUMBER BELOW NOT UPDATED IN THE APP #################
      ########################################################################################################################
      ########################################################################################################################

        # "My VA Health - v3.0.2",

      ########################################################################################################################
      ########################################################################################################################
      ############# THE ONLY CAUSE OF THIS SCRIPT FAILING IS THE VERSION NUMBER ABOVE NOT UPDATED IN THE APP #################
      ########################################################################################################################
      ########################################################################################################################

        "The My VA Health app allows you to enter, view, and track personal health information, which can be shared with your healthcare team.",
        "You can use the current version of the app to:",
        "Track personal health information including vital signs, diet, exercise, and daily events",
        "Enter your medical history information including your medications, allergies, diagnoses, hospitalizations, surgeries, pregnancies and family history",
        "Create and manage appointment, medication and preventive service reminders",
        "View notifications received from your VA care team",
        "Reflect on what matters to you in your life and how your health can help you reach your life goals",
        "Create and manage healthcare-related and personal contacts and related communications",
        "Complete health assessments",
        "Create a Health Report that includes data you have entered and tracked",
        "Share elements of your health information with your care team",
        "Notes: A DS Logon account (level 2) is needed for access.",
        "End User License Agreement (EULA)",
    ]


    @common.loginEndsOnLandingPage("zztest.patient05", "patient05, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient05, zztest")

    @main.clickUserMenu()
    !45.times { break if (getTextForElement(:id, "about") == "About"); sleep 1 }
    expect(@menu.verifyAboutButtonPresent).to eq("About")
    @menu.clickAboutBtn

  end

  after(:all) do
    quitDriver()
  end

  context 'AC #JRNL-1021|TC #JRNL-1020: Test About Screen Updates 3.0' do

    it "About Screen for My VA Health 3.0.0", :bug => true do

      !45.times{ break if (@modal.getConfirmationHeading() == "About"); sleep 1 }
      expect(@modal.getConfirmationHeading()).to eq("About")

      #Verifying Entire content is covered
      aboutcontent = @about.getAboutText().split("\n")
      aboutcontent.each_with_index do | screenRow, i |
        #puts "screenRow [#{i}] [#{screenRow}]"
        expect(screenRow).to eq(@ABOUT_SCREEN[i])
      end
      expect(aboutcontent.length).to eq(@ABOUT_SCREEN.length)
    end

    it "Eula link is present" do
      #Clicking on Eula link and verifying that it opens in a new window
      @about.clickShowEULA()
      switchWindowToWindowHandleLast()

      #Verifying Eula Heading
      !45.times { break if (@eula.getEulaHeading == "End User License Agreement"); sleep 1 }
      expect(@eula.getEulaHeading).to eq("End User License Agreement")

      closeBrowser()
      switchWindowToWindowHandleFirst()
      @about.clickOKfromAboutScreen()
    end

  end
end
=end