require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2489: Personal Contacts List View and Filter]", :broken => true, :regression => true  do

  before(:all) do
    @FILTER_EXPANDED = [
        "First Name",
        "50 character maximum",
        "Last Name",
        "50 character maximum",
        "Relationship",
        "Select",
        "Family",
        "Friend",
        "Co-Worker",
        "Lawyer",
        "Support",
        "Other",
        "Filter Reset"
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("contacts", "personalprofiledb", "personalContacts")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickContacts()
    !45.times{ break if (getSecondaryHeader == "Contacts"); sleep 1 }
    expect(@contacts.getSecondaryHeader).to eq("Contacts")

    @contacts.clickPersonalContacts()
    !45.times{ break if (getPrimaryHeader == "Personal Contacts"); sleep 1 }
    expect(@contacts.getPrimaryHeader).to eq("Personal Contacts")

    expect(getCount()).to eq(11)
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1922|TC JRNL-1751: Filter" do

    it "Filter defaults to an expanded view" do
      expect(@personal_contacts_filter.isFilterExpanded()).to be true
    end

    it "Filter button alt text reads 'Collapse filter options' when expanded" do
      expect(@personal_contacts_filter.getFilterIconAriaLabel()).to eq("Collapse filter options")
    end

    it "Content" do
      personalContactsFilterScreen = @personal_contacts_filter.getScreenContent().split("\n")
      @FILTER_EXPANDED.each_with_index do | expectedScreenRow, i |
        expect(personalContactsFilterScreen[i]).to eq(expectedScreenRow)
      end
    end

    it "Users can collapse the filter list by clicking on the Collapse filter icon" do
      @personal_contacts_filter.clickOnFilterIcon()
      expect(@personal_contacts_filter.isFilterCollapsed()).to be true
    end

    it "When collapsed, the filter icon alt text reads Expand Filter" do
      expect(@personal_contacts_filter.getFilterIconAriaLabel()).to eq("Expand filter options")
    end

    it "Filter Options: First Name" do
      @personal_contacts_filter.clickOnFilterIcon()
      expect(@personal_contacts_filter.getTextFromInput(:css, Personal_Contacts_Filter::FIRST_NAME)).to eq("")
    end

    it "Filter Options: Last Name" do
      expect(@personal_contacts_filter.getTextFromInput(:css, Personal_Contacts_Filter::LAST_NAME)).to eq("")
    end

    it "Filter Options: Relationship" do
      expect(@personal_contacts_filter.getSelectBoxText(Personal_Contacts_Filter::RELATIONSHIP)).to eq("Select")

      relationshipValues = @personal_contacts_filter.getElements(:css, Personal_Contacts_Filter::RELATIONSHIP + " option")
      relationshipValues.each_with_index do | actual, i |
        expect(actual.text()).to eq(@FILTER_EXPANDED[i + 5])
      end
    end

    it "Filter Button (alt text = Filter)" do
      expect(@personal_contacts_filter.getFilterButtonLabel()).to eq("Filter")
    end

  end

  describe "AC JRNL-1921|TC JRNL-1751: List" do

    it "Table headers" do
      expect(getTableHeaders()).to eq(["Name", "Relationship", "Primary Phone"])
    end

    it "If no records are found when a filter is applied the message 'No results found.' Is displayed in the screen area in place of the table view" do
      @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "xyz")

      @personal_contacts_filter.clickFilterButton()
      !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("No results")); sleep 1 }
      expect(@personal_contacts_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
      expect(getCount()).to eq(0)
    end

    it "Story JRNL-1696|AC JRNL-1583: Reset Button" do
      expect(@personal_contacts_filter.isResetButtonPresent()).to eq(true)
      expect(@personal_contacts_filter.getResetButtonLabel()).to eq("Reset")

      @personal_contacts_filter.clickResetBtn()
      !10.times{ break if (getFocusedElementText().include?("Name")); sleep 1 }
      verifyContactsList(getList(), getFilteredContacts("Select", "", ""))
      expect(getCount()).to eq(11)
      expect(@personal_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))

      # DEFAULTS
      expect(@personal_contacts_filter.getTextFromInput(:css, Personal_Contacts_Filter::FIRST_NAME)).to eq("")
      expect(@personal_contacts_filter.getTextFromInput(:css, Personal_Contacts_Filter::LAST_NAME)).to eq("")
      expect(@personal_contacts_filter.getTextFromInput(:css, Personal_Contacts_Filter::RELATIONSHIP)).to eq("")
    end

    describe "If records are found Personal Contact entries are displayed in a table format" do

      it "sorted alphabetically" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("Name")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))
        expect(getCount()).to eq(11)

        verifyContactsList(getList(), getFilteredContacts("Select", "", ""))
      end

      it "first name only" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "Billy")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("Name")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))
        expect(getCount()).to eq(2)

        verifyContactsList(getList(), getFilteredContacts("Select", "Billy", ""))
      end

      it "last name only" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "")
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::LAST_NAME, "Watkins")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("Name")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))
        expect(getCount()).to eq(2)

        verifyContactsList(getList(), getFilteredContacts("Select", "", "Watkins"))
      end

      it "relationship only" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::LAST_NAME, "")
        @personal_contacts_filter.setSelectBoxValue(Personal_Contacts_Filter::RELATIONSHIP, "Family")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("Name")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))
        expect(getCount()).to eq(4)

        verifyContactsList(getList(), getFilteredContacts("Family", "", ""))
      end

      it "first name and last name" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "Billy")
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::LAST_NAME, "Smith")
        @personal_contacts_filter.setSelectBoxValue(Personal_Contacts_Filter::RELATIONSHIP, "Select")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("Name")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))
        expect(getCount()).to eq(1)

        verifyContactsList(getList(), getFilteredContacts("Select", "Billy", "Smith"))
      end

      it "first name and invalid last name" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::LAST_NAME, "Junior")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("No results")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        expect(getCount()).to eq(0)

        verifyContactsList(getList(), getFilteredContacts("Select", "Billy", "Junior"))
      end

      it "last name and invalid first name" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "Johnny")
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::LAST_NAME, "Watkins")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("No results")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        expect(getCount()).to eq(0)

        verifyContactsList(getList(), getFilteredContacts("Select", "Johnny", "Watkins"))
      end

      it "first name and relationship" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "Jimbo")
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::LAST_NAME, "")
        @personal_contacts_filter.setSelectBoxValue(Personal_Contacts_Filter::RELATIONSHIP, "Lawyer")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("Name")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))
        expect(getCount()).to eq(1)

        verifyContactsList(getList(), getFilteredContacts("Lawyer", "Jimbo", ""))
      end

      it "relationship and invalid first name" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "Billy")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("No results")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        expect(getCount()).to eq(0)

        verifyContactsList(getList(), getFilteredContacts("Lawyer", "Billy", ""))
      end

      it "last name and relationship" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "")
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::LAST_NAME, "Carlton")
        @personal_contacts_filter.setSelectBoxValue(Personal_Contacts_Filter::RELATIONSHIP, "Family")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("Name")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))
        expect(getCount()).to eq(3)

        verifyContactsList(getList(), getFilteredContacts("Family", "", "Carlton"))
      end

      it "relationship and invalid last name" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::LAST_NAME, "Madison")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("No results")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        expect(getCount()).to eq(0)

        verifyContactsList(getList(), getFilteredContacts("Family", "", "Madison"))
      end

      it "first name, last name and relationship" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "Andrew")
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::LAST_NAME, "Watkins")
        @personal_contacts_filter.setSelectBoxValue(Personal_Contacts_Filter::RELATIONSHIP, "Other")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("Name")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))
        expect(getCount()).to eq(1)

        verifyContactsList(getList(), getFilteredContacts("Other", "Andrew", "Watkins"))
      end

      it "last name, relationship and invalid first name" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "Peter")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("No results")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        expect(getCount()).to eq(0)

        verifyContactsList(getList(), getFilteredContacts("Other", "Peter", "Watkins"))
      end

      it "first name, relationship and invalid last name" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "Andrew")
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::LAST_NAME, "Carnegie")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("No results")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
        expect(getCount()).to eq(0)

        verifyContactsList(getList(), getFilteredContacts("Other", "Andrew", "Carnegie"))
      end

      it "case insensitive" do
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "ANDREW")
        @personal_contacts_filter.setInput(Personal_Contacts_Filter::LAST_NAME, "")
        @personal_contacts_filter.setSelectBoxValue(Personal_Contacts_Filter::RELATIONSHIP, "Select")

        @personal_contacts_filter.clickFilterButton()
        !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("Name")); sleep 1 }
        expect(@personal_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))
        expect(getCount()).to eq(2)

        verifyContactsList(getList(), getFilteredContacts("Select", "ANDREW", ""))
      end

      describe "partial string matches are returned" do

        it "matches include initial character matches of 1 character or more" do
          @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "Jim")

          @personal_contacts_filter.clickFilterButton()
          !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("Name")); sleep 1 }
          expect(@personal_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))
          expect(getCount()).to eq(2)

          verifyContactsList(getList(), getFilteredContacts("Select", "Jim", ""))
        end

        it "internal character matches are not included" do
          @personal_contacts_filter.setInput(Personal_Contacts_Filter::FIRST_NAME, "drew")

          @personal_contacts_filter.clickFilterButton()
          !10.times{ break if (@personal_contacts_filter.getFocusedElementText().include?("No results")); sleep 1 }
          expect(@personal_contacts_filter.getFocusedElementText()).to eq("No results were found with the current filters. Use the Add button above to create a new record.")
          expect(getCount()).to eq(0)

          verifyContactsList(getList(), getFilteredContacts("Select", "drew", ""))
        end

      end

    end

  end

  #######################
  ### Local Functions ###
  #######################

  def getAllContactsInDBSorted
    def sortContactsKeys(x,y)
      if(x["lastName"].upcase() + ", " + x["firstName"].upcase() == y["lastName"].upcase() + ", " + y["firstName"].upcase())
        return (x["association"] <=> y["association"])
      end
      return (x["lastName"].upcase() + ", " + x["firstName"].upcase() <=> y["lastName"].upcase() + ", " + y["firstName"].upcase())
    end

    return retreiveAllDocumentsInCollection("contacts", "personalprofiledb").sort { |x, y| sortContactsKeys(x,y) }
  end

  def getFilteredContacts(association, first, last)
    relationshipContacts = []
    firstNameContacts = []
    lastNameContacts = []
    getAllContactsInDBSorted.each_with_index do |contacts_event, rowIndex|
      if association == "Select" && first == "" && last == ""
        relationshipContacts << contacts_event
      elsif contacts_event["association"] == association
        relationshipContacts << contacts_event
      end

      if first != "" && first.upcase() == contacts_event["firstName"][0..first.length()]
        firstNameContacts << contacts_event
      end

      if last != "" && last.upcase() == contacts_event["lastName"][0..last.length()]
        lastNameContacts << contacts_event
      end
    end

    return (relationshipContacts & firstNameContacts & lastNameContacts)
  end

  def verifyContactsList(screenList, dbList)
    dbList.each_with_index do |dbrow, i|
      screenRow = screenList[i].text.split("\n")
      expect(screenRow[1].strip).to eq(dbrow["lastName"] + ", " + dbrow["firstName"])
      if dbrow["association"] != ""
        expect(screenRow[3].strip).to eq(dbrow["association"])
      end
    end
  end

end