require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2488: Personal Contacts - Edit/Delete/Nav]", :broken => true, :regression => true do

  before(:all) do
    @ENTRY_FORM_1 = [
        "* required field",
        "",
        "* First Name:",
        "50 character maximum",
        "* Last Name:",
        "50 character maximum",
        "Relationship:",
        "Primary Phone:",
        "Enter 10 digits",
        "Primary Phone Type:",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Email:",
        "100 character maximum",
        "Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State:",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Delete Cancel"
    ]

    @ENTRY_FORM_2 = [
        "* required field",
        "",
        "* First Name:",
        "50 character maximum",
        "* Last Name:",
        "50 character maximum",
        "Relationship:",
        "Primary Phone:",
        "Enter 10 digits",
        "Primary Phone Type:",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Other Phone:",
        "Enter 10 digits",
        "Other Phone Type:",
        " Delete",
        "Email:",
        "100 character maximum",
        "Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State/Province:",
        "50 character maximum",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Delete Cancel"
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("contacts", "personalprofiledb", "personalContacts")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }

    @navMenu.clickContacts()
    !45.times{ break if (@contacts.getSecondaryHeader() == "Contacts"); sleep 1 }
    expect(@contacts.getSecondaryHeader()).to eq("Contacts")

    @contacts.clickPersonalContacts()
    !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::HEADER); sleep 1 }
    expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::HEADER)

    expect(getCount()).to eq(11)

    @contactCountBeforeDelete = retreiveAllDocumentsInCollection("contacts", "personalprofiledb").length()
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1908|TC JRNL-1746: When the user selects a Personal Contacts entry from the table view" do

    it "the system displays the Personal Contact record in the Detail screen in Edit mode" do
      clickNthRow(1)
      !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
      expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)

      ### It is not in the AC to check for the back button but I believe the addition of the back button is a universal change.
      # expect(@personalContacts.isBackButtonVisible()).to eq(true)
      # expect(@personalContacts.getBackButtonAltText()).to eq("Return to Personal Contacts table view")
    end

    it "All values previously saved are visible" do
      expect(@personalContacts.getTextFromInput(:css, PersonalContacts::FIRST_NAME)).to eq("Randy")
      expect(@personalContacts.getTextFromInput(:css, PersonalContacts::LAST_NAME)).to eq("Carlton")
      expect(@personalContacts.getSelectBoxText(PersonalContacts::RELATIONSHIP)).to eq("Family")
      expect(@personalContacts.getTextFromInput(:css, PersonalContacts::PRIMARY_PHONE)).to eq("")
      expect(@personalContacts.getSelectBoxText(PersonalContacts::PRIMARY_PHONE_TYPE)).to eq("Select")
      expect(@personalContacts.getTextFromInput(:css, PersonalContacts::OTHER_PHONE_1)).to eq("")
      expect(@personalContacts.getSelectBoxText(PersonalContacts::OTHER_PHONE_TYPE_1)).to eq("Select")
      expect(@personalContacts.getTextFromInput(:css, PersonalContacts::EMAIL)).to eq("")
      expect(@personalContacts.getSelectBoxText(PersonalContacts::COUNTRY)).to eq("Select")
      expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ADDRESS_LINE_1)).to eq("")
      expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ADDRESS_LINE_2)).to eq("")
      expect(@personalContacts.getTextFromInput(:css, PersonalContacts::CITY)).to eq("")
      expect(@personalContacts.getTextFromInput(:css, PersonalContacts::STATE_PROVINCE)).to eq("")
      expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ZIP_POSTAL_CODE)).to eq("")
      expect(@personalContacts.getTextFromInput(:css, PersonalContacts::NOTE)).to eq("")
      expect(@personalContacts.getTextForElement(:css, PersonalContacts::NOTE_CHARACTER_COUNT)).to eq("250 characters left")
    end

    describe "All fields displayed in the Add mode are available in the Edit mode" do

      it "Detail screen - Country != US" do
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_1_DELETE)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_2)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2_DELETE)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_3)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3_DELETE)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4_DELETE)).to eq(false)

        @personalContacts.click(:css, PersonalContacts::ADD_PHONE)

        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_1_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_2)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_3)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3_DELETE)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4_DELETE)).to eq(false)

        @personalContacts.click(:css, PersonalContacts::ADD_PHONE)

        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_1_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_2)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_3)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4_DELETE)).to eq(false)

        @personalContacts.click(:css, PersonalContacts::ADD_PHONE)

        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_1_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_2)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_3)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_4)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4_DELETE)).to eq(true)

        @form = @personalContacts.stripSelectTextFromScreen(
            @personalContacts.getScreenContent().split("\n"),
            ['relationship', 'primaryPhoneType', 'otherPhoneType1', 'otherPhoneType2', 'otherPhoneType3', 'otherPhoneType4', 'addressCountry']
        )

        @ENTRY_FORM_2.each_with_index do | expectedScreenRow, i |
          expect(@form[i]).to eq(expectedScreenRow)
        end

        relationships = ["Select", "Family", "Friend", "Support", "Lawyer", "Co-Worker", "Other"]

        @personalContacts.getElements(:css, PersonalContacts::RELATIONSHIP + " option").each_with_index do | content, i |
          expect(content.text()).to eq(relationships[i])
        end

        phoneTypes = ["Select", "Mobile", "Home", "Work", "Fax"]

        @personalContacts.getElements(:css, PersonalContacts::OTHER_PHONE_TYPE_1 + " option").each_with_index do | content, i |
          expect(content.text()).to eq(phoneTypes[i])
        end

        @personalContacts.getElements(:css, PersonalContacts::OTHER_PHONE_TYPE_2 + " option").each_with_index do | content, i |
          expect(content.text()).to eq(phoneTypes[i])
        end

        @personalContacts.getElements(:css, PersonalContacts::OTHER_PHONE_TYPE_3 + " option").each_with_index do | content, i |
          expect(content.text()).to eq(phoneTypes[i])
        end

        @personalContacts.getElements(:css, PersonalContacts::OTHER_PHONE_TYPE_4 + " option").each_with_index do | content, i |
          expect(content.text()).to eq(phoneTypes[i])
        end
      end

      it "Required" do
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::FIRST_NAME)).to eq(true)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::LAST_NAME)).to eq(true)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::RELATIONSHIP)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::PRIMARY_PHONE)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::PRIMARY_PHONE_TYPE)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::OTHER_PHONE_1)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::OTHER_PHONE_TYPE_1)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::OTHER_PHONE_2)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::OTHER_PHONE_TYPE_2)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::OTHER_PHONE_3)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::OTHER_PHONE_TYPE_3)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::OTHER_PHONE_4)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::OTHER_PHONE_TYPE_4)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::EMAIL)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::COUNTRY)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::ADDRESS_LINE_1)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::ADDRESS_LINE_2)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::CITY)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::STATE_PROVINCE)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::ZIP_POSTAL_CODE)).to eq(false)
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::NOTE)).to eq(false)

        @personalContacts.setSelectBoxValue(PersonalContacts::COUNTRY, "United States")
        expect(@personalContacts.isElementVisible(:css, PersonalContacts::STATE_PROVINCE)).to eq(false)
        expect(@personalContacts.isElementVisible(:css, PersonalContacts::STATE)).to eq(true)
        expect(@personalContacts.getSelectBoxText(PersonalContacts::STATE)).to eq("Select")
        expect(@personalContacts.isFieldRequired(:css, PersonalContacts::STATE)).to eq(false)
      end

      it "Detail screen - Country = US" do
        @form = @personalContacts.stripSelectTextFromScreen(
            @personalContacts.getScreenContent().split("\n"),
            ['relationship', 'primaryPhoneType', 'otherPhoneType1', 'otherPhoneType2', 'otherPhoneType3', 'otherPhoneType4', 'addressCountry', 'addressStateAbbreviation']
        )

        @ENTRY_FORM_1.each_with_index do | expectedScreenRow, i |
          expect(@form[i]).to eq(expectedScreenRow)
        end

        @personalContacts.click(:css, PersonalContacts::OTHER_PHONE_1_DELETE)

        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_1_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_2)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_3)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4_DELETE)).to eq(false)

        @personalContacts.click(:css, PersonalContacts::OTHER_PHONE_1_DELETE)

        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_1_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_2)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2_DELETE)).to eq(true)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_3)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3_DELETE)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4_DELETE)).to eq(false)

        @personalContacts.click(:css, PersonalContacts::OTHER_PHONE_1_DELETE)

        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_1_DELETE)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_2)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_2_DELETE)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_3)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_3_DELETE)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_TYPE_4)).to eq(false)
        expect(@personalContacts.is_element_present(:css, PersonalContacts::OTHER_PHONE_4_DELETE)).to eq(false)
      end

      it "Error Messages" do
        expectedValidationSummaryHeader = "The following errors were found:"

        @personalContacts.setInput(PersonalContacts::FIRST_NAME, "")
        @personalContacts.setInput(PersonalContacts::LAST_NAME, "")
        @personalContacts.setPhoneInput(PersonalContacts::PRIMARY_PHONE, "10")
        @personalContacts.setPhoneInput(PersonalContacts::OTHER_PHONE_1, "10")

        @personalContacts.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("entryForm", "First Name field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Last Name field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Primary Phone must be formatted (###) ###-####.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Other Phone must be formatted (###) ###-####.")).to eq(true)
      end

    end

    describe "Standard Edit functions are available" do

      it "Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        expect(@personalContacts.isCancelButtonVisible()).to eq(true)

        @personalContacts.clickCancelButton()
        !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::HEADER); sleep 1 }
        expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::HEADER)

        expect(getCount()).to eq(11)

        clickNthRow(1)
        !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
        expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)

        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::FIRST_NAME)).to eq("Randy")
        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::LAST_NAME)).to eq("Carlton")
        expect(@personalContacts.getSelectBoxText(PersonalContacts::RELATIONSHIP)).to eq("Family")
        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::PRIMARY_PHONE)).to eq("")
        expect(@personalContacts.getSelectBoxText(PersonalContacts::PRIMARY_PHONE_TYPE)).to eq("Select")
        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::OTHER_PHONE_1)).to eq("")
        expect(@personalContacts.getSelectBoxText(PersonalContacts::OTHER_PHONE_TYPE_1)).to eq("Select")
        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::EMAIL)).to eq("")
        expect(@personalContacts.getSelectBoxText(PersonalContacts::COUNTRY)).to eq("Select")
        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ADDRESS_LINE_1)).to eq("")
        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ADDRESS_LINE_2)).to eq("")
        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::CITY)).to eq("")
        expect(@personalContacts.getSelectBoxText(PersonalContacts::STATE)).to eq("")
        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ZIP_POSTAL_CODE)).to eq("")
        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::NOTE)).to eq("")
        expect(@personalContacts.getTextForElement(:css, PersonalContacts::NOTE_CHARACTER_COUNT)).to eq("250 characters left")
      end

      it "Delete" do
        expect(@personalContacts.isDeleteButtonVisible()).to eq(true)

        @personalContacts.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickNoButton()
        !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
        expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)
        !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
        expect(@personalContacts.getFocusedElementText()).to eq("Delete")

        @personalContacts.clickCancelButton()
        !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::HEADER); sleep 1 }
        expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::HEADER)

        expect(getCount()).to eq(11)

        clickNthRow(1)
        !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
        expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)

        @personalContacts.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickYesButton()
        !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::HEADER); sleep 1 }
        expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::HEADER)

        expect(getCount()).to eq(10)

        expect(retreiveAllDocumentsInCollection("contacts", "personalprofiledb").length()).to eq(@contactCountBeforeDelete)
      end

      describe "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view" do

        it "max" do
          clickNthRow(1)
          !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
          expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)

          expect(@personalContacts.isSaveButtonVisible()).to eq(true)

          @personalContacts.setInput(PersonalContacts::FIRST_NAME, "()*&^%$@!?><.,:;{}[]ABCDEFGHIJKLMNopqrstuvwxyz1234567890")
          @personalContacts.setInput(PersonalContacts::LAST_NAME, "ABCDEFGHIJKLMNopqrstuvwxyz1234567890()*&^%$@!?><.,:;{}[]")
          @personalContacts.setSelectBoxValue(PersonalContacts::RELATIONSHIP, "Lawyer")
          @personalContacts.setPhoneInput(PersonalContacts::PRIMARY_PHONE, "123a456b7890")
          @personalContacts.setSelectBoxValue(PersonalContacts::PRIMARY_PHONE_TYPE, "Home")
          @personalContacts.setPhoneInput(PersonalContacts::OTHER_PHONE_1, "c098765b4321d")
          @personalContacts.setSelectBoxValue(PersonalContacts::OTHER_PHONE_TYPE_1, "Mobile")
          @personalContacts.click(:css, PersonalContacts::ADD_PHONE)
          @personalContacts.setPhoneInput(PersonalContacts::OTHER_PHONE_2, "1a0s2d9f3g8h4j7i5o6")
          @personalContacts.setSelectBoxValue(PersonalContacts::OTHER_PHONE_TYPE_2, "Work")
          @personalContacts.click(:css, PersonalContacts::ADD_PHONE)
          @personalContacts.setPhoneInput(PersonalContacts::OTHER_PHONE_3, "0?987612!345")
          @personalContacts.setSelectBoxValue(PersonalContacts::OTHER_PHONE_TYPE_3, "Fax")
          @personalContacts.click(:css, PersonalContacts::ADD_PHONE)
          @personalContacts.setPhoneInput(PersonalContacts::OTHER_PHONE_4, "678-901-2345")
          @personalContacts.setSelectBoxValue(PersonalContacts::OTHER_PHONE_TYPE_4, "Mobile")
          @personalContacts.setInput(PersonalContacts::EMAIL, "my.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.com")
          @personalContacts.setSelectBoxValue(PersonalContacts::COUNTRY, "Serbia")
          @personalContacts.setInput(PersonalContacts::ADDRESS_LINE_1, "100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St ")
          @personalContacts.setInput(PersonalContacts::ADDRESS_LINE_2, "Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 ")
          @personalContacts.setInput(PersonalContacts::CITY, "SerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSerbinia")
          @personalContacts.setInput(PersonalContacts::STATE_PROVINCE, "SerbistateSerbistateSerbistateSerbistateSerbistateSerbistate")
          @personalContacts.setInput(PersonalContacts::ZIP_POSTAL_CODE, "1a4561a4561a456")
          @personalContacts.setInput(PersonalContacts::NOTE, "None of this info is real. None of this info is real. None of this info is real.")

          expect(@personalContacts.getTextForElement(:css, PersonalContacts::NOTE_CHARACTER_COUNT)).to eq("170 characters left")

          @personalContacts.setInput(PersonalContacts::NOTE, "None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real. None of this info is real.")

          expect(@personalContacts.getTextForElement(:css, PersonalContacts::NOTE_CHARACTER_COUNT)).to eq("0 characters left")

          @personalContacts.clickSaveButton()
          !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::HEADER); sleep 1 }
          expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::HEADER)

          expect(getCount()).to eq(10)

          clickNthRow(1)
          !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
          expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)

          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::FIRST_NAME)).to eq("()*&^%$@!?><.,:;{}[]ABCDEFGHIJKLMNopqrstuvwxyz1234")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::FIRST_NAME).length()).to eq(50)
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::LAST_NAME)).to eq("ABCDEFGHIJKLMNopqrstuvwxyz1234567890()*&^%$@!?><.,")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::LAST_NAME).length()).to eq(50)
          expect(@personalContacts.getSelectBoxText(PersonalContacts::RELATIONSHIP)).to eq("Lawyer")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::PRIMARY_PHONE)).to eq("(123) 456-7890")
          expect(@personalContacts.getSelectBoxText(PersonalContacts::PRIMARY_PHONE_TYPE)).to eq("Home")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::OTHER_PHONE_1)).to eq("(098) 765-4321")
          expect(@personalContacts.getSelectBoxText(PersonalContacts::OTHER_PHONE_TYPE_1)).to eq("Mobile")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::OTHER_PHONE_2)).to eq("(102) 938-4756")
          expect(@personalContacts.getSelectBoxText(PersonalContacts::OTHER_PHONE_TYPE_2)).to eq("Work")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::OTHER_PHONE_3)).to eq("(098) 761-2345")
          expect(@personalContacts.getSelectBoxText(PersonalContacts::OTHER_PHONE_TYPE_3)).to eq("Fax")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::OTHER_PHONE_4)).to eq("(678) 901-2345")
          expect(@personalContacts.getSelectBoxText(PersonalContacts::OTHER_PHONE_TYPE_4)).to eq("Mobile")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::EMAIL)).to eq("my.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@ag")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::EMAIL).length()).to eq(100)
          expect(@personalContacts.getSelectBoxText(PersonalContacts::COUNTRY)).to eq("Serbia")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ADDRESS_LINE_1)).to eq("100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 1")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ADDRESS_LINE_1).length()).to eq(100)
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ADDRESS_LINE_2)).to eq("Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suit")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ADDRESS_LINE_2).length()).to eq(100)
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::CITY)).to eq("SerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSe")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::CITY).length()).to eq(50)
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::STATE_PROVINCE)).to eq("SerbistateSerbistateSerbistateSerbistateSerbistate")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::STATE_PROVINCE).length()).to eq(50)
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ZIP_POSTAL_CODE)).to eq("1a4561a456")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ZIP_POSTAL_CODE).length()).to eq(10)
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::NOTE)).to eq("None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real. None of t")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::NOTE).length()).to eq(250)
          expect(@personalContacts.getTextForElement(:css, PersonalContacts::NOTE_CHARACTER_COUNT)).to eq("0 characters left")
        end

        it "min" do
          @personalContacts.setInput(PersonalContacts::FIRST_NAME, "B")
          @personalContacts.setInput(PersonalContacts::LAST_NAME, "A")
          @personalContacts.setSelectBoxValue(PersonalContacts::RELATIONSHIP, "Select")
          @personalContacts.setPhoneInput(PersonalContacts::PRIMARY_PHONE, "")
          @personalContacts.setSelectBoxValue(PersonalContacts::PRIMARY_PHONE_TYPE, "Select")
          @personalContacts.setPhoneInput(PersonalContacts::OTHER_PHONE_1, "")
          @personalContacts.setSelectBoxValue(PersonalContacts::OTHER_PHONE_TYPE_1, "Select")
          @personalContacts.click(:css, PersonalContacts::OTHER_PHONE_4_DELETE)
          @personalContacts.click(:css, PersonalContacts::OTHER_PHONE_3_DELETE)
          @personalContacts.click(:css, PersonalContacts::OTHER_PHONE_2_DELETE)
          @personalContacts.setInput(PersonalContacts::EMAIL, "")
          @personalContacts.setSelectBoxValue(PersonalContacts::COUNTRY, "Select")
          @personalContacts.setInput(PersonalContacts::ADDRESS_LINE_1, "")
          @personalContacts.setInput(PersonalContacts::ADDRESS_LINE_2, "")
          @personalContacts.setInput(PersonalContacts::CITY, "")
          @personalContacts.setInput(PersonalContacts::STATE_PROVINCE, "")
          @personalContacts.setInput(PersonalContacts::ZIP_POSTAL_CODE, "")
          @personalContacts.setInput(PersonalContacts::NOTE, "")

          @personalContacts.clickSaveButton()
          !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::HEADER); sleep 1 }
          expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::HEADER)

          expect(getCount()).to eq(10)

          clickNthRow(1)
          !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
          expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)

          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::FIRST_NAME)).to eq("B")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::LAST_NAME)).to eq("A")
          expect(@personalContacts.getSelectBoxText(PersonalContacts::RELATIONSHIP)).to eq("Select")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::PRIMARY_PHONE)).to eq("")
          expect(@personalContacts.getSelectBoxText(PersonalContacts::PRIMARY_PHONE_TYPE)).to eq("Select")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::OTHER_PHONE_1)).to eq("")
          expect(@personalContacts.getSelectBoxText(PersonalContacts::OTHER_PHONE_TYPE_1)).to eq("Select")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::EMAIL)).to eq("")
          expect(@personalContacts.getSelectBoxText(PersonalContacts::COUNTRY)).to eq("Select")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ADDRESS_LINE_1)).to eq("")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ADDRESS_LINE_2)).to eq("")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::CITY)).to eq("")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::STATE_PROVINCE)).to eq("")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::ZIP_POSTAL_CODE)).to eq("")
          expect(@personalContacts.getTextFromInput(:css, PersonalContacts::NOTE)).to eq("")
          expect(@personalContacts.getTextForElement(:css, PersonalContacts::NOTE_CHARACTER_COUNT)).to eq("250 characters left")

          @personalContacts.clickCancelButton()
          !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::HEADER); sleep 1 }
          expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::HEADER)

          expect(getCount()).to eq(10)
        end

      end

    end

    describe "AC JRNL-1907|TC JRNL-1745: Navigation Without Saving" do

      it "If the user tries to navigate away from a detail record where a field has been updated without saving, the user is prompted to confirm that they want to leave the record without saving via a modal" do
        clickNthRow(1)
        !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
        expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)

        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::LAST_NAME)).to eq("A")
        @personalContacts.setInput(PersonalContacts::LAST_NAME, "XYZ")

        @contacts.clickPersonalContacts()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickReturnButton()
        !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
        expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)

        @contacts.clickPersonalContacts()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickContinueButton()
        !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::HEADER); sleep 1 }
        expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::HEADER)

        expect(getCount()).to eq(10)

        clickNthRow(1)
        !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
        expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)

        expect(@personalContacts.getTextFromInput(:css, PersonalContacts::LAST_NAME)).to eq("A")
      end

      it "Back button" do
        # @personalContacts.setInput(PersonalContacts::LAST_NAME, "XYZ")
        #
        # @personalContacts.clickBackButton()
        # !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        # expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        # expect(@modal.getConfirmButtonText()).to eq("Continue")
        # expect(@modal.getCancelButtonText()).to eq("Return")
        #
        # @modal.clickReturnButton()
        # !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
        # expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)
        #
        # @personalContacts.clickBackButton()
        # !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        # expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        # expect(@modal.getConfirmButtonText()).to eq("Continue")
        # expect(@modal.getCancelButtonText()).to eq("Return")
        #
        # @modal.clickContinueButton()
        # !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::HEADER); sleep 1 }
        # expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::HEADER)
        #
        # expect(getCount()).to eq(10)
        #
        # clickNthRow(1)
        # !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::EDIT_HEADER); sleep 1 }
        # expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::EDIT_HEADER)
        #
        # expect(@personalContacts.getTextFromInput(:css, PersonalContacts::LAST_NAME)).to eq("A")

        @personalContacts.clickCancelButton()
        !45.times{ break if (@personalContacts.getPrimaryHeader() == PersonalContacts::HEADER); sleep 1 }
        expect(@personalContacts.getPrimaryHeader()).to eq(PersonalContacts::HEADER)
      end

    end

  end

end
