require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2485: Insurance Contacts List View and Filters]", :regression => true  do

  before(:all) do
    @INSURANCE_CONTACTS_FILTER_EXPANDED = [
        "Company Name",
        "50 character maximum",
        "Type",
        "Select",
        "Medical",
        "Dental",
        "Vision",
        "Disability",
        "Other",
        "Filter Reset"
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("contacts", "personalprofiledb", "insuranceContacts")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickContacts()

    !45.times{ break if (getSecondaryHeader == "Contacts"); sleep 1 }
    expect(@contacts.getSecondaryHeader).to eq("Contacts")

    @contacts.clickInsuranceContacts
    !45.times{ break if (getPrimaryHeader == "Insurance Contacts"); sleep 1 }
    expect(@contacts.getPrimaryHeader).to eq("Insurance Contacts")
  end

  after(:all) do
    quitDriver()
  end

  context "AC JRNL-1920|TC JRNL-1757: Filter Feature" do

    it "1a: User can expand filter", :broken => true do

      expect(@insurance_contacts_filter.isFilterExpanded()).to be true

      insuranceContactsFilterForm = @insurance_contacts_filter.getScreenContent().split("\n")
      @INSURANCE_CONTACTS_FILTER_EXPANDED.each_with_index do | expectedScreenRow, i |
        expect(insuranceContactsFilterForm[i]).to eq(expectedScreenRow)
      end

      expect(@insurance_contacts_filter.getFilterIconAriaLabel()).to eq("Collapse filter options")
    end

    it "1b: Users can collapse the filter list by clicking on the Collapse filter icon.  When collapsed, the filter icon alt text reads Expand Filter." do
      @insurance_contacts_filter.clickOnFilterIcon()
      expect(@insurance_contacts_filter.isFilterCollapsed()).to be true
      expect(@insurance_contacts_filter.getFilterIconAriaLabel()).to eq("Expand filter options")
    end

  end

  context "AC JRNL-1919|TC JRNL-1756: Filter Options" do

    it "1c: Filter Options for Insurance Contacts" do
      @insurance_contacts_filter.clickOnFilterIcon()
      expect(@insurance_contacts_filter.getCompanyName()).to eq("")
      expect(@insurance_contacts_filter.getCompanyType()).to eq("Select")
    end

    it "1d: Filter Button (alt text = Filter)", :broken => true do
      expect(@insurance_contacts_filter.getFilterButtonLabel()).to eq("Filter")
    end
    
  end

  context "AC JRNL-1918|TC JRNL-1755: Filtering" do

    it "2 (a) Search upper/lower case Company name (exact match)", :broken => true do
      @insurance_contacts_filter.setCompanyName("a test company1")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")); sleep 1 }
      expect(getCount()).to eq(1)
      expect(getTextForRow(1)).to eq("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")
    end

    it "2 (b) Search upper/lower case Company name (exact match)", :broken => true do
      @insurance_contacts_filter.setCompanyName("A TEST COMPANY1")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")); sleep 1 }
      expect(getCount()).to eq(1)
      expect(getTextForRow(1)).to eq("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")
    end

    it "3  Search Company names that have special chars", :broken => true do
      @insurance_contacts_filter.setCompanyName("A*Test Company2")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \nA*Test Company2 \nType \nDental \nCompany Phone")); sleep 1 }
      expect(getCount()).to eq(1)
      expect(getTextForRow(1)).to eq("Company Name \nA*Test Company2 \nType \nDental \nCompany Phone")
    end

    it "4 Search with partial name match (which matches) and type (which also matches).  It should returns the match.", :broken => true do
      @insurance_contacts_filter.setCompanyName("a test")
      @insurance_contacts_filter.setCompanyType("Medical")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")); sleep 1 }
      verifyContactsList(getList(), getSortedContacts("Medical"))
      expect(getCount()).to eq(1)
      expect(getTextForRow(1)).to eq("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")
    end

    it "5 Search with partial name match (which matches) and type (which does not match).  It should return no matches." do
      @insurance_contacts_filter.setCompanyName("a test")
      @insurance_contacts_filter.setCompanyType("Other")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")); sleep 1 }
      !10.times{ break if (getFocusedElementText().include?("No results found.")); sleep 1 }
      # expect(getFocusedElementText()).to match("No results found.")
      expect(getFocusedElementText()).to match("No results were found with the current filters. Use the Add button above to create a new record.")

      expect(getCount()).to eq(0)
    end

    it "6 Search with partial first char match", :broken => true do
      @insurance_contacts_filter.setCompanyName("a")
      @insurance_contacts_filter.setCompanyType("Select")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")); sleep 1 }
      verifyContactsList(getList(), getSortedContacts("Medical"))
      expect(getCount()).to eq(2)
      expect(getTextForRow(1)).to eq("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")
    end

  end

  context "AC JRNL-1917|TC JRNL-1754: List" do

    it "7 Search with no fields selected", :broken => true do
      @insurance_contacts_filter.setCompanyName("")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")); sleep 1 }
      verifyContactsList(getList(), getSortedContacts("Select"))
      expect(getCount()).to eq(8)
      expect(getTextForRow(1)).to eq("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")
    end

    it "8 Search on just Medical", :broken => true do
      @insurance_contacts_filter.setCompanyType("Medical")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")); sleep 1 }
      verifyContactsList(getList(), getSortedContacts("Medical"))
      expect(getCount()).to eq(1)
      expect(getTextForRow(1)).to eq("Company Name \na Test Company1 \nType \nMedical \nCompany Phone")
    end

    it "9 Search on just Dental", :broken => true do
      @insurance_contacts_filter.setCompanyType("Dental")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \nA*Test Company2 \nType \nDental \nCompany Phone")); sleep 1 }
      verifyContactsList(getList(), getSortedContacts("Dental"))
      expect(getCount()).to eq(2)
      expect(getTextForRow(1)).to eq("Company Name \nA*Test Company2 \nType \nDental \nCompany Phone")
    end

    it "10 Search on just Vision", :broken => true do
      @insurance_contacts_filter.setCompanyType("Vision")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \nTest Company4 \nType \nVision \nCompany Phone")); sleep 1 }
      verifyContactsList(getList(), getSortedContacts("Vision"))
      expect(getCount()).to eq(2)
      expect(getTextForRow(1)).to eq("Company Name \nTest Company4 \nType \nVision \nCompany Phone")
    end

    it "11 Search on just Disability", :broken => true do
      @insurance_contacts_filter.setCompanyType("Disability")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \nTest Company4 \nType \nDisability \nCompany Phone")); sleep 1 }
      verifyContactsList(getList(), getSortedContacts("Disability"))
      expect(getCount()).to eq(1)
      expect(getTextForRow(1)).to eq("Company Name \nTest Company4 \nType \nDisability \nCompany Phone")
    end

    it "12 Search on just Other", :broken => true do
      @insurance_contacts_filter.setCompanyType("Other")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Company Name \nTest Company5 \nType \nOther \nCompany Phone")); sleep 1 }
      verifyContactsList(getList(), getSortedContacts("Other"))
      expect(getCount()).to eq(2)
      expect(getTextForRow(1)).to eq("Company Name \nTest Company5 \nType \nOther \nCompany Phone")
    end

    it "13 Search with no-find on company name" do
      @insurance_contacts_filter.setCompanyName("ZZZZZZ")
      @insurance_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("No results found.")); sleep 1 }
      expect(getCount()).to eq(0)
      # expect(getFocusedElementText()).to match("No results found.")
      expect(getFocusedElementText()).to match("No results were found with the current filters. Use the Add button above to create a new record.")
    end

  end

  it "Story JRNL-1696|AC JRNL-1583: Reset Button", :broken => true do
    expect(@insurance_contacts_filter.isResetButtonPresent()).to eq(true)
    expect(@insurance_contacts_filter.getResetButtonLabel()).to eq("Reset")

    @insurance_contacts_filter.clickResetBtn()
    !10.times{ break if (getFocusedElementText().include?("Company Name")); sleep 1 }
    verifyContactsList(getList(), getSortedContacts("Select"))
    expect(getCount()).to eq(8)
    expect(@insurance_contacts_filter.getFocusedElementText()).to eq(getTextForRow(1) + %( \n ))

    # DEFAULTS
    expect(@insurance_contacts_filter.getCompanyName).to eq("")
    expect(@insurance_contacts_filter.getCompanyType).to eq("Select")
  end

  # Local functions starts

  def getAllContactsInDBSorted
    def sortContactsKeys(x,y)
      if(x["address"]["name"].upcase == y["address"]["name"].upcase)
        return (x["association"] <=> y["association"])
      end
      return (x["address"]["name"].upcase <=> y["address"]["name"].upcase)
    end

    return retreiveAllDocumentsInCollection("contacts", "personalprofiledb").sort { |x, y| sortContactsKeys(x,y) }
  end

  def getSortedContacts(association)
    #Given a type, extract the contacts that are in the db
    selectedContacts = []
    getAllContactsInDBSorted.each_with_index do |contacts_event, rowIndex|
      if association == "Select"
        selectedContacts << contacts_event
      elsif contacts_event ["association"] == association
        selectedContacts << contacts_event
      end
    end

    return selectedContacts
  end

  def verifyContactsList(screenList, dbList)
    dbList.each_with_index do |dbrow, i|
      screenRow = screenList[i].text.split("\n")
      expect(screenRow[3].strip).to eq(dbrow["association"])
      expect((screenRow[1].upcase).strip).to eq(dbrow["address"]["name"].upcase)
    end
  end

end