require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2484: Insurance Contacts - Edit/Delete/Nav]", :broken => true, :regression => true do

  before(:all) do
    @ENTRY_FORM_1 = [
        "* required field",
        "",
        "* Company:",
        "50 character maximum",
        "Type:",
        "Policy Holder Name:",
        "50 character maximum",
        "Policy Number:",
        "50 character maximum",
        "Group Name:",
        "50 character maximum",
        "Group ID Number:",
        "50 character maximum",
        "Effective Date:",
        "MM/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "End Date:",
        "MM/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Contact Information",
        "Company Phone Number:",
        "Enter 10 digits",
        "Pre-Approval Call Number:",
        "Enter 10 digits",
        "Fax:",
        "Enter 10 digits",
        "Email:",
        "100 character maximum",
        "Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State:",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Website:",
        "100 character maximum",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Delete Cancel"
    ]

    @ENTRY_FORM_2 = [
        "* required field",
        "",
        "* Company:",
        "50 character maximum",
        "Type:",
        "Policy Holder Name:",
        "50 character maximum",
        "Policy Number:",
        "50 character maximum",
        "Group Name:",
        "50 character maximum",
        "Group ID Number:",
        "50 character maximum",
        "Effective Date:",
        "MM/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "End Date:",
        "MM/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Contact Information",
        "Company Phone Number:",
        "Enter 10 digits",
        "Pre-Approval Call Number:",
        "Enter 10 digits",
        "Fax:",
        "Enter 10 digits",
        "Email:",
        "100 character maximum",
        "Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State/Province:",
        "50 character maximum",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Website:",
        "100 character maximum",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Delete Cancel"
    ]

    initializeConfigurations(BASE_URL)
    resetCollection("contacts", "personalprofiledb", "insuranceContacts")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }

    @navMenu.clickContacts()
    !45.times{ break if (@contacts.getSecondaryHeader() == "Contacts"); sleep 1 }
    expect(@contacts.getSecondaryHeader()).to eq("Contacts")

    @contacts.clickInsuranceContacts()
    !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
    expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

    expect(getCount()).to eq(8)

    @contactCountBeforeDelete = retreiveAllDocumentsInCollection("contacts", "personalprofiledb").length()
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1915|TC JRNL-1790: When the user selects an Insurance Contacts entry from the table view" do

    it "the system displays the Insurance Contact record in the Detail screen in Edit mode" do
      clickNthRow(1)
      !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
      expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")

      ### It is not in the AC to check for the back button but I believe the addition of the back button is a universal change.
      # expect(@insuranceContacts.isBackButtonVisible()).to eq(true)
      # expect(@insuranceContacts.getBackButtonAltText()).to eq("Return to Insurance Contacts table view")
    end

    it "All values previously saved are visible" do
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY)).to eq("a Test Company1")
      expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::TYPE)).to eq("Medical")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_HOLDER_NAME)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_NUMBER)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_NAME)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_ID_NUMBER)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EFFECTIVE_DATE)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::END_DATE)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY_PHONE_NUMBER)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::PRE_APPROVAL_CALL_NUMBER)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::FAX)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EMAIL)).to eq("")
      expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::COUNTRY)).to eq("United States")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_1)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_2)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::CITY)).to eq("")
      expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::STATE)).to eq("Select")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ZIP_POSTAL_CODE)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::WEBSITE)).to eq("")
      expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::NOTE)).to eq("")
      expect(@insuranceContacts.getTextForElement(:css, InsuranceContacts::NOTE_CHARACTER_COUNT)).to eq("250 characters left")
    end

    describe "All fields displayed in the Add mode are available in the Edit mode" do

      it "Detail screen - Country = US" do
        @form = @insuranceContacts.stripSelectTextFromScreen(
            @insuranceContacts.getScreenContent().split("\n"),
            ['type', 'addressCountry', 'addressStateAbbreviation']
        )

        @ENTRY_FORM_1.each_with_index do | expectedScreenRow, i |
          expect(@form[i]).to eq(expectedScreenRow)
        end
      end

      it "Required" do
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::COMPANY)).to eq(true)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::TYPE)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::POLICY_HOLDER_NAME)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::POLICY_NUMBER)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::GROUP_NAME)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::GROUP_ID_NUMBER)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::EFFECTIVE_DATE)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::END_DATE)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::COMPANY_PHONE_NUMBER)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::PRE_APPROVAL_CALL_NUMBER)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::FAX)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::EMAIL)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::COUNTRY)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::ADDRESS_LINE_1)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::ADDRESS_LINE_2)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::CITY)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::STATE)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::ZIP_POSTAL_CODE)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::WEBSITE)).to eq(false)
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::NOTE)).to eq(false)

        expect(@insuranceContacts.isElementVisible(:css, InsuranceContacts::STATE_PROVINCE)).to eq(false)
        @insuranceContacts.setSelectBoxValue(InsuranceContacts::COUNTRY, "United Kingdom")
        expect(@insuranceContacts.isElementVisible(:css, InsuranceContacts::STATE_PROVINCE)).to eq(true)
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::STATE_PROVINCE)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::STATE_PROVINCE)).to eq(false)
      end

      it "Detail screen - Country != US" do
        @form = @insuranceContacts.stripSelectTextFromScreen(
            @insuranceContacts.getScreenContent().split("\n"),
            ['type', 'addressCountry']
        )

        @ENTRY_FORM_2.each_with_index do | expectedScreenRow, i |
          expect(@form[i]).to eq(expectedScreenRow)
        end
      end

      it "Error Messages" do
        expectedValidationSummaryHeader = "The following errors were found:"

        @insuranceContacts.setInput(InsuranceContacts::COMPANY, "")
        @insuranceContacts.setInput(InsuranceContacts::EFFECTIVE_DATE, "10")
        @insuranceContacts.setInput(InsuranceContacts::END_DATE, "10")
        @insuranceContacts.setPhoneInput(InsuranceContacts::COMPANY_PHONE_NUMBER, "abc")
        @insuranceContacts.setPhoneInput(InsuranceContacts::PRE_APPROVAL_CALL_NUMBER, "!@$")
        @insuranceContacts.setPhoneInput(InsuranceContacts::FAX, "(def) hij-jklm")

        @insuranceContacts.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("entryForm", "Company field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Effective Date must occur before End Date.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "Effective Date must be formatted MM/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "End Date must be formatted MM/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Company Phone Number must be formatted (###) ###-####.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "Pre-Approval Call Number must be formatted (###) ###-####.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "Fax must be formatted (###) ###-####.")).to eq(false)

        @insuranceContacts.setInput(InsuranceContacts::COMPANY, "Company")
        @insuranceContacts.setInput(InsuranceContacts::EFFECTIVE_DATE, "10/2014")
        @insuranceContacts.setInput(InsuranceContacts::END_DATE, "10/2012")
        @insuranceContacts.setPhoneInput(InsuranceContacts::COMPANY_PHONE_NUMBER, "123")
        @insuranceContacts.setPhoneInput(InsuranceContacts::PRE_APPROVAL_CALL_NUMBER, "098")
        @insuranceContacts.setPhoneInput(InsuranceContacts::FAX, "102")

        @insuranceContacts.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("entryForm", "Company field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "Effective Date must occur before End Date.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Effective Date must be formatted MM/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "End Date must be formatted MM/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "Company Phone Number must be formatted (###) ###-####.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Pre-Approval Call Number must be formatted (###) ###-####.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Fax must be formatted (###) ###-####.")).to eq(true)
      end

    end

    describe "Standard Edit functions are available" do

      it "Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        expect(@insuranceContacts.isCancelButtonVisible()).to eq(true)

        @insuranceContacts.clickCancelButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

        expect(getCount()).to eq(8)

        clickNthRow(1)
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")

        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY)).to eq("a Test Company1")
        expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::TYPE)).to eq("Medical")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_HOLDER_NAME)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_NUMBER)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_NAME)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_ID_NUMBER)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EFFECTIVE_DATE)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::END_DATE)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY_PHONE_NUMBER)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::PRE_APPROVAL_CALL_NUMBER)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::FAX)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EMAIL)).to eq("")
        expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::COUNTRY)).to eq("United States")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_1)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_2)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::CITY)).to eq("")
        expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::STATE)).to eq("Select")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ZIP_POSTAL_CODE)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::WEBSITE)).to eq("")
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::NOTE)).to eq("")
        expect(@insuranceContacts.getTextForElement(:css, InsuranceContacts::NOTE_CHARACTER_COUNT)).to eq("250 characters left")
      end

      it "Delete" do
        expect(@insuranceContacts.isDeleteButtonVisible()).to eq(true)

        @insuranceContacts.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickNoButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")
        !10.times{ break if (getFocusedElementText().include?("Delete")); sleep 1 }
        expect(@insuranceContacts.getFocusedElementText()).to eq("Delete")

        @insuranceContacts.clickCancelButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

        expect(getCount()).to eq(8)

        clickNthRow(8)
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")

        @insuranceContacts.clickDeleteButton()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Yes")
        expect(@modal.getCancelButtonText()).to eq("No")

        @modal.clickYesButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

        expect(getCount()).to eq(7)

        expect(retreiveAllDocumentsInCollection("contacts", "personalprofiledb").length()).to eq(@contactCountBeforeDelete)
      end

      describe "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view" do

        it "max" do
          clickNthRow(1)
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")

          @insuranceContacts.setInput(InsuranceContacts::COMPANY, "ZCompanyZCompanyZCompanyZCompanyZCompanyZCompanyZCompanyZCompany")
          @insuranceContacts.setSelectBoxValue(InsuranceContacts::TYPE, "Medical")
          @insuranceContacts.setInput(InsuranceContacts::POLICY_HOLDER_NAME, "RichardRichardRichardRichardRichardRichardRichardRichard")
          @insuranceContacts.setInput(InsuranceContacts::POLICY_NUMBER, "ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234")
          @insuranceContacts.setInput(InsuranceContacts::GROUP_NAME, "SomeGroupSomeGroupSomeGroupSomeGroupSomeGroupSomeGroup")
          @insuranceContacts.setInput(InsuranceContacts::GROUP_ID_NUMBER, "1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD")

          @date_picker.click(:css, InsuranceContacts::EFFECTIVE_DATE_BUTTON)
          !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
          @date_picker.setMonthYearFromGUI(10, 2014)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EFFECTIVE_DATE)).to eq("10/2014")

          @date_picker.click(:css, InsuranceContacts::END_DATE_BUTTON)
          !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
          @date_picker.setMonthYearFromGUI(10, 2017)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::END_DATE)).to eq("10/2017")

          @insuranceContacts.setPhoneInput(InsuranceContacts::COMPANY_PHONE_NUMBER, "11111111111111111")
          @insuranceContacts.setPhoneInput(InsuranceContacts::PRE_APPROVAL_CALL_NUMBER, "9999999999999999")
          @insuranceContacts.setPhoneInput(InsuranceContacts::FAX, "77777777777777")
          @insuranceContacts.setInput(InsuranceContacts::EMAIL, "my.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.com")
          @insuranceContacts.setSelectBoxValue(InsuranceContacts::COUNTRY, "Serbia")
          @insuranceContacts.setInput(InsuranceContacts::ADDRESS_LINE_1, "100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St ")
          @insuranceContacts.setInput(InsuranceContacts::ADDRESS_LINE_2, "Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 ")
          @insuranceContacts.setInput(InsuranceContacts::CITY, "SerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSerbinia")
          @insuranceContacts.setInput(InsuranceContacts::STATE_PROVINCE, "SerbistateSerbistateSerbistateSerbistateSerbistateSerbistate")
          @insuranceContacts.setInput(InsuranceContacts::ZIP_POSTAL_CODE, "1a4561a4561a456")
          @insuranceContacts.setInput(InsuranceContacts::WEBSITE, "www.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.com")
          @insuranceContacts.setInput(InsuranceContacts::NOTE, "None of this info is real. None of this info is real. None of this info is real.")

          expect(@insuranceContacts.getTextForElement(:css, InsuranceContacts::NOTE_CHARACTER_COUNT)).to eq("170 characters left")

          @insuranceContacts.setInput(InsuranceContacts::NOTE, "None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real. None of this info is real.")

          expect(@insuranceContacts.getTextForElement(:css, InsuranceContacts::NOTE_CHARACTER_COUNT)).to eq("0 characters left")

          @insuranceContacts.clickSaveButton()
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

          expect(getCount()).to eq(7)

          clickNthRow(7)
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")

          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY)).to eq("ZCompanyZCompanyZCompanyZCompanyZCompanyZCompanyZC")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY).length()).to eq(50)
          expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::TYPE)).to eq("Medical")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_HOLDER_NAME)).to eq("RichardRichardRichardRichardRichardRichardRichardR")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_HOLDER_NAME).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_NUMBER)).to eq("ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234AB")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_NUMBER).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_NAME)).to eq("SomeGroupSomeGroupSomeGroupSomeGroupSomeGroupSomeG")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_NAME).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_ID_NUMBER)).to eq("1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD12")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_ID_NUMBER).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EFFECTIVE_DATE)).to eq("10/2014")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::END_DATE)).to eq("10/2017")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY_PHONE_NUMBER)).to eq("(111) 111-1111")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::PRE_APPROVAL_CALL_NUMBER)).to eq("(999) 999-9999")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::FAX)).to eq("(777) 777-7777")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EMAIL)).to eq("my.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@ag")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EMAIL).length()).to eq(100)
          expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::COUNTRY)).to eq("Serbia")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_1)).to eq("100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 1")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_1).length()).to eq(100)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_2)).to eq("Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suit")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_2).length()).to eq(100)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::CITY)).to eq("SerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSe")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::CITY).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::STATE_PROVINCE)).to eq("SerbistateSerbistateSerbistateSerbistateSerbistate")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::STATE_PROVINCE).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ZIP_POSTAL_CODE)).to eq("1a4561a456")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ZIP_POSTAL_CODE).length()).to eq(10)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::WEBSITE)).to eq("www.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.c")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::WEBSITE).length()).to eq(100)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::NOTE)).to eq("None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real. None of t")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::NOTE).length()).to eq(250)
          expect(@insuranceContacts.getTextForElement(:css, InsuranceContacts::NOTE_CHARACTER_COUNT)).to eq("0 characters left")
        end

        it "min" do
          @insuranceContacts.setInput(InsuranceContacts::COMPANY, "Z Company")
          @insuranceContacts.setSelectBoxValue(InsuranceContacts::TYPE, "Select")
          @insuranceContacts.setInput(InsuranceContacts::POLICY_HOLDER_NAME, "")
          @insuranceContacts.setInput(InsuranceContacts::POLICY_NUMBER, "")
          @insuranceContacts.setInput(InsuranceContacts::GROUP_NAME, "")
          @insuranceContacts.setInput(InsuranceContacts::GROUP_ID_NUMBER, "")
          @insuranceContacts.setInput(InsuranceContacts::EFFECTIVE_DATE, "")
          @insuranceContacts.setInput(InsuranceContacts::END_DATE, "")
          @insuranceContacts.setPhoneInput(InsuranceContacts::COMPANY_PHONE_NUMBER, "")
          @insuranceContacts.setPhoneInput(InsuranceContacts::PRE_APPROVAL_CALL_NUMBER, "")
          @insuranceContacts.setPhoneInput(InsuranceContacts::FAX, "")
          @insuranceContacts.setInput(InsuranceContacts::EMAIL, "")
          @insuranceContacts.setSelectBoxValue(InsuranceContacts::COUNTRY, "Select")
          @insuranceContacts.setInput(InsuranceContacts::ADDRESS_LINE_1, "")
          @insuranceContacts.setInput(InsuranceContacts::ADDRESS_LINE_2, "")
          @insuranceContacts.setInput(InsuranceContacts::CITY, "")
          @insuranceContacts.setInput(InsuranceContacts::STATE_PROVINCE, "")
          @insuranceContacts.setInput(InsuranceContacts::ZIP_POSTAL_CODE, "")
          @insuranceContacts.setInput(InsuranceContacts::WEBSITE, "")
          @insuranceContacts.setInput(InsuranceContacts::NOTE, "")

          @insuranceContacts.clickSaveButton()
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

          expect(getCount()).to eq(7)

          clickNthRow(7)
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")

          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY)).to eq("Z Company")
          expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::TYPE)).to eq("Select")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_HOLDER_NAME)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_NUMBER)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_NAME)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_ID_NUMBER)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EFFECTIVE_DATE)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::END_DATE)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY_PHONE_NUMBER)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::PRE_APPROVAL_CALL_NUMBER)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::FAX)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EMAIL)).to eq("")
          expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::COUNTRY)).to eq("Select")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_1)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_2)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::CITY)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::STATE_PROVINCE)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ZIP_POSTAL_CODE)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::WEBSITE)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::NOTE)).to eq("")
          expect(@insuranceContacts.getTextForElement(:css, InsuranceContacts::NOTE_CHARACTER_COUNT)).to eq("250 characters left")

          @insuranceContacts.clickCancelButton()
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

          expect(getCount()).to eq(7)
        end

      end

    end

    describe "AC JRNL-1914|TC JRNL-1787: Navigation Without Saving" do

      it "If the user tries to Navigate away from a detail record where a field has been updated without Saving, the user is prompted to confirm that they want to leave the record without saving via a modal" do
        clickNthRow(1)
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")

        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY)).to eq("A*Test Company2")
        @insuranceContacts.setInput(InsuranceContacts::COMPANY, "XYZ")

        @contacts.clickInsuranceContacts()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickReturnButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")

        @contacts.clickInsuranceContacts()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickContinueButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

        expect(getCount()).to eq(7)

        clickNthRow(1)
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")

        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY)).to eq("A*Test Company2")
      end

      it "Back button" do
        # @insuranceContacts.setInput(InsuranceContacts::COMPANY, "XYZ")
        #
        # @insuranceContacts.clickBackButton()
        # !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        # expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        # expect(@modal.getConfirmButtonText()).to eq("Continue")
        # expect(@modal.getCancelButtonText()).to eq("Return")
        #
        # @modal.clickReturnButton()
        # !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
        # expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")
        #
        # @insuranceContacts.clickBackButton()
        # !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        # expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        # expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        # expect(@modal.getConfirmButtonText()).to eq("Continue")
        # expect(@modal.getCancelButtonText()).to eq("Return")
        #
        # @modal.clickContinueButton()
        # !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
        # expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")
        #
        # expect(getCount()).to eq(7)
        #
        # clickNthRow(1)
        # !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
        # expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")
        #
        # expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY)).to eq("A*Test Company2")

        @insuranceContacts.clickCancelButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")
      end

    end

  end

end
