require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2484: Insurance Contacts - Add]", :regression => true do

  before(:all) do
    @ENTRY_FORM_1 = [
        "* required field",
        "",
        "* Company:",
        "50 character maximum",
        "Type:",
        "Policy Holder Name:",
        "50 character maximum",
        "Policy Number:",
        "50 character maximum",
        "Group Name:",
        "50 character maximum",
        "Group ID Number:",
        "50 character maximum",
        "Effective Date:",
        "MM/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "End Date:",
        "MM/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Contact Information",
        "Company Phone Number:",
        "Enter 10 digits",
        "Pre-Approval Call Number:",
        "Enter 10 digits",
        "Fax:",
        "Enter 10 digits",
        "Email:",
        "100 character maximum",
        "Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State:",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Website:",
        "100 character maximum",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel"
    ]

    @ENTRY_FORM_2 = [
        "* required field",
        "",
        "* Company:",
        "50 character maximum",
        "Type:",
        "Policy Holder Name:",
        "50 character maximum",
        "Policy Number:",
        "50 character maximum",
        "Group Name:",
        "50 character maximum",
        "Group ID Number:",
        "50 character maximum",
        "Effective Date:",
        "MM/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "End Date:",
        "MM/YYYY",
        "This date selection control is not optimized for screen readers. Please directly enter the date in the text box provided. Open Date Picker",
        "Contact Information",
        "Company Phone Number:",
        "Enter 10 digits",
        "Pre-Approval Call Number:",
        "Enter 10 digits",
        "Fax:",
        "Enter 10 digits",
        "Email:",
        "100 character maximum",
        "Address",
        "Country:",
        "Address Line 1:",
        "100 character maximum",
        "Address Line 2:",
        "100 character maximum",
        "City:",
        "50 character maximum",
        "State/Province:",
        "50 character maximum",
        "ZIP/Postal Code:",
        "10 character maximum",
        "Website:",
        "100 character maximum",
        "Note:",
        "250 character maximum",
        "250 characters left",
        "Save Cancel"
    ]

    initializeConfigurations(BASE_URL)
    removeCollection("contacts", "personalprofiledb")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01","patient01, zztest");

    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest");

    @main.clickNavMenu()
    !45.times{ break if (@navMenu.getNavMenuHeading() == "App Options"); sleep 1 }

    @navMenu.clickContacts()
    !45.times{ break if (@contacts.getSecondaryHeader() == "Contacts"); sleep 1 }
    expect(@contacts.getSecondaryHeader()).to eq("Contacts")

    @contacts.clickInsuranceContacts()
    !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
    expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

    expect(getCount()).to eq(0)
  end

  after(:all) do
    quitDriver()
  end

  describe "AC JRNL-1916|TC-2401: When the user views the Insurance Contacts Table list" do

    it "an Add button (+ icon, alt text Add), is available in the upper right corner of the Detail screen" do
      expect(@contacts.isAddVisible()).to eq(true)
    end

  end

  describe "AC JRNL-1916|TC-2401: When a user selects Add" do

    it "the Add Insurance Contacts screen is shown, header: Add Insurance Contact" do
      @contacts.clickAddButton()
      !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Add Insurance Contact"); sleep 1 }
      expect(@insuranceContacts.getPrimaryHeader()).to eq("Add Insurance Contact")

      ### It is not in the AC to check for the back button but I believe the addition of the back button is a universal change.
      # expect(@insuranceContacts.isBackButtonVisible()).to eq(true)
      # expect(@insuranceContacts.getBackButtonAltText()).to eq("Return to Insurance Contacts table view")
    end

    describe "Detailed Insurance Contact fields include the following" do

      it "Unless otherwise indicated, all values default to null (or select for drop lists), no guidance text (light gray placeholder text) is shown, and all fields are optional", :broken => true do
        @form = @insuranceContacts.stripSelectTextFromScreen(
            @insuranceContacts.getScreenContent().split("\n"),
            ['type', 'addressCountry', 'addressStateAbbreviation']
        )

        @ENTRY_FORM_1.each_with_index do | expectedScreenRow, i |
          expect(@form[i]).to eq(expectedScreenRow)
        end
      end

      it "Company (Text, 50 characters, required)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::COMPANY)).to eq(true)
      end

      it "Type (drop list, values: select, Medical, Dental, Vision, Disability, Other)" do
        expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::TYPE)).to eq("Select")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::TYPE)).to eq(false)

        types = [ "Select", "Medical",  "Dental", "Vision", "Disability", "Other" ]

        @insuranceContacts.getElement(:css, "select[name='type']").text().split("\n").each_with_index do | foundText, i |
          expect(foundText).to eq(types[i])
        end
      end

      it "Policy Holder Name (text, 50 characters)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_HOLDER_NAME)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::POLICY_HOLDER_NAME)).to eq(false)
      end

      it "Policy Number (text, 50 characters)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_NUMBER)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::POLICY_NUMBER)).to eq(false)
      end

      it "Group Name (text, 50 characters)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_NAME)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::GROUP_NAME)).to eq(false)
      end

      it "Group ID Number (text, 50 characters)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_ID_NUMBER)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::GROUP_ID_NUMBER)).to eq(false)
      end

      it "Effective Date (mm/yyyy, date picker)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EFFECTIVE_DATE)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::EFFECTIVE_DATE)).to eq(false)
      end

      it "End Date (mm/yyyy, date picker)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::END_DATE)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::END_DATE)).to eq(false)
      end

      it "Company Phone Number (constrain format to (###) ###-####; display light gray guidance text when field is null to convey format)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY_PHONE_NUMBER)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::COMPANY_PHONE_NUMBER)).to eq(false)
      end

      it "Pre-Approval Call Number (constrain format to (###) ###-####; display light gray guidance text when field is null to convey format)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::PRE_APPROVAL_CALL_NUMBER)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::PRE_APPROVAL_CALL_NUMBER)).to eq(false)
      end

      it "Fax (constrain format to (###) ###-####; display light gray guidance text when field is null to convey format)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::FAX)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::FAX)).to eq(false)
      end

      it "Email (text, 100 characters, no field validation)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EMAIL)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::EMAIL)).to eq(false)
      end

      it "Country, select list, default to United States" do
        expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::COUNTRY)).to eq("United States")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::COUNTRY)).to eq(false)
      end

      it "Address Line 1 (alphanumeric, text box, 100 characters)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_1)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::ADDRESS_LINE_1)).to eq(false)
      end

      it "Address line 2 (alphanumeric, text box, 100 characters)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_2)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::ADDRESS_LINE_2)).to eq(false)
      end

      it "City (alphanumeric, text box, 50 characters)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::CITY)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::CITY)).to eq(false)
      end

      it "State (select list, select option shown as default and is equivalent to null; standard list to be used that includes DC and Puerto Rico)" do
        expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::STATE)).to eq("Select")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::STATE)).to eq(false)
      end

      it "State/Province (text, 50 characters)" do
        expect(@insuranceContacts.isElementVisible(:css, InsuranceContacts::STATE_PROVINCE)).to eq(false)
        @insuranceContacts.setSelectBoxValue(InsuranceContacts::COUNTRY, "United Kingdom")
        expect(@insuranceContacts.isElementVisible(:css, InsuranceContacts::STATE_PROVINCE)).to eq(true)
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::STATE_PROVINCE)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::STATE_PROVINCE)).to eq(false)
      end

      it "ZIP/Postal Code (alphanumeric, text box, 10 characters)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ZIP_POSTAL_CODE)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::ZIP_POSTAL_CODE)).to eq(false)
      end

      it "Website (URL, 100 characters)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::WEBSITE)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::WEBSITE)).to eq(false)
      end

      it "Note (text 250 Characters)" do
        expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::NOTE)).to eq("")
        expect(@insuranceContacts.isFieldRequired(:css, InsuranceContacts::NOTE)).to eq(false)
        expect(@insuranceContacts.getTextForElement(:css, InsuranceContacts::NOTE_CHARACTER_COUNT)).to eq("250 characters left")
      end

      it "Unless otherwise indicated, all values default to null (or select for drop lists), no guidance text (light gray placeholder text) is shown, and all fields are optional", :broken => true do
        @form = @insuranceContacts.stripSelectTextFromScreen(
            @insuranceContacts.getScreenContent().split("\n"),
            ['type', 'addressCountry']
        )

        @ENTRY_FORM_2.each_with_index do | expectedScreenRow, i |
          expect(@form[i]).to eq(expectedScreenRow)
        end
      end

      it "Error Messages", :broken => true do
        expectedValidationSummaryHeader = "The following errors were found:"

        @insuranceContacts.setInput(InsuranceContacts::EFFECTIVE_DATE, "10")
        @insuranceContacts.setInput(InsuranceContacts::END_DATE, "10")
        @insuranceContacts.setPhoneInput(InsuranceContacts::COMPANY_PHONE_NUMBER, "10")
        @insuranceContacts.setPhoneInput(InsuranceContacts::PRE_APPROVAL_CALL_NUMBER, "10")
        @insuranceContacts.setPhoneInput(InsuranceContacts::FAX, "10")

        @insuranceContacts.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("entryForm", "Company field is required.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Effective Date must occur before End Date.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "Effective Date must be formatted MM/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "End Date must be formatted MM/YYYY.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Company Phone Number must be formatted (###) ###-####.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Pre-Approval Call Number must be formatted (###) ###-####.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Fax must be formatted (###) ###-####.")).to eq(true)

        @insuranceContacts.setInput(InsuranceContacts::COMPANY, "Company")
        @insuranceContacts.setInput(InsuranceContacts::EFFECTIVE_DATE, "10/2014")
        @insuranceContacts.setInput(InsuranceContacts::END_DATE, "10/2012")
        @insuranceContacts.setPhoneInput(InsuranceContacts::COMPANY_PHONE_NUMBER, "1234567890")
        @insuranceContacts.setPhoneInput(InsuranceContacts::PRE_APPROVAL_CALL_NUMBER, "0987654321")
        @insuranceContacts.setPhoneInput(InsuranceContacts::FAX, "1029384756")

        @insuranceContacts.clickSaveButton()

        !45.times{ break if (@error.getValidationSummaryHeader("entryForm") == expectedValidationSummaryHeader); sleep 1 }
        expect(@error.getValidationSummaryHeader("entryForm")).to eq(expectedValidationSummaryHeader)
        expect(@error.isErrorMessageDisplayed("entryForm", "Company field is required.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "Effective Date must occur before End Date.")).to eq(true)
        expect(@error.isErrorMessageDisplayed("entryForm", "Effective Date must be formatted MM/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "End Date must be formatted MM/YYYY.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "Company Phone Number must be formatted (###) ###-####.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "Pre-Approval Call Number must be formatted (###) ###-####.")).to eq(false)
        expect(@error.isErrorMessageDisplayed("entryForm", "Fax must be formatted (###) ###-####.")).to eq(false)
      end

    end

    describe "Standard Save and Cancel options are available" do

      it "Cancel - When a user selects Cancel, no updates are made to the record and the user is shown the table view with the focus placed on the header" do
        expect(@insuranceContacts.isCancelButtonVisible()).to eq(true)

        @insuranceContacts.clickCancelButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

        expect(getCount()).to eq(0)
      end

      describe "Save - When a user selects Save the system saves the record and the user is returned to the table view, with the focus on the header. Updates made to the record are visible in the table, if included in that view" do

        it "min", :broken => true do
          @contacts.clickAddButton()
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Add Insurance Contact"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Add Insurance Contact")

          @insuranceContacts.setInput(InsuranceContacts::COMPANY, "Example Company")

          @insuranceContacts.clickSaveButton()
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

          expect(getCount()).to eq(1)

          clickNthRow(1)
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")

          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY)).to eq("Example Company")
          expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::TYPE)).to eq("Select")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_HOLDER_NAME)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_NUMBER)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_NAME)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_ID_NUMBER)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EFFECTIVE_DATE)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::END_DATE)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY_PHONE_NUMBER)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::PRE_APPROVAL_CALL_NUMBER)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::FAX)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EMAIL)).to eq("")
          expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::COUNTRY)).to eq("United States")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_1)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_2)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::CITY)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::STATE_PROVINCE)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ZIP_POSTAL_CODE)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::WEBSITE)).to eq("")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::NOTE)).to eq("")
          expect(@insuranceContacts.getTextForElement(:css, InsuranceContacts::NOTE_CHARACTER_COUNT)).to eq("250 characters left")

          @insuranceContacts.clickCancelButton()
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

          expect(getCount()).to eq(1)
        end

        it "max", :broken => true do
          @contacts.clickAddButton()
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Add Insurance Contact"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Add Insurance Contact")

          @insuranceContacts.setInput(InsuranceContacts::COMPANY, "NewCompanyNewCompanyNewCompanyNewCompanyNewCompanyNewCompany")
          @insuranceContacts.setSelectBoxValue(InsuranceContacts::TYPE, "Medical")
          @insuranceContacts.setInput(InsuranceContacts::POLICY_HOLDER_NAME, "RichardRichardRichardRichardRichardRichardRichardRichard")
          @insuranceContacts.setInput(InsuranceContacts::POLICY_NUMBER, "ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234")
          @insuranceContacts.setInput(InsuranceContacts::GROUP_NAME, "SomeGroupSomeGroupSomeGroupSomeGroupSomeGroupSomeGroup")
          @insuranceContacts.setInput(InsuranceContacts::GROUP_ID_NUMBER, "1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD")

          @date_picker.click(:css, InsuranceContacts::EFFECTIVE_DATE_BUTTON)
          !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
          @date_picker.setMonthYearFromGUI(10, 2014)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EFFECTIVE_DATE)).to eq("10/2014")

          @date_picker.click(:css, InsuranceContacts::END_DATE_BUTTON)
          !45.times{ break if (@date_picker.getSetButtonText == "SET"); sleep 1 }
          @date_picker.setMonthYearFromGUI(10, 2017)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::END_DATE)).to eq("10/2017")

          @insuranceContacts.setPhoneInput(InsuranceContacts::COMPANY_PHONE_NUMBER, "FBJ22222222222222")
          @insuranceContacts.setPhoneInput(InsuranceContacts::PRE_APPROVAL_CALL_NUMBER, "!$%444444444444444")
          @insuranceContacts.setPhoneInput(InsuranceContacts::FAX, "abc6666666666666666")
          @insuranceContacts.setInput(InsuranceContacts::EMAIL, "my.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.com")
          @insuranceContacts.setSelectBoxValue(InsuranceContacts::COUNTRY, "Serbia")
          @insuranceContacts.setInput(InsuranceContacts::ADDRESS_LINE_1, "100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St ")
          @insuranceContacts.setInput(InsuranceContacts::ADDRESS_LINE_2, "Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 ")
          @insuranceContacts.setInput(InsuranceContacts::CITY, "SerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSerbinia")
          @insuranceContacts.setInput(InsuranceContacts::STATE_PROVINCE, "SerbistateSerbistateSerbistateSerbistateSerbistateSerbistate")
          @insuranceContacts.setInput(InsuranceContacts::ZIP_POSTAL_CODE, "1a4561a4561a456")
          @insuranceContacts.setInput(InsuranceContacts::WEBSITE, "www.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.com")
          @insuranceContacts.setInput(InsuranceContacts::NOTE, "None of this info is real. None of this info is real. None of this info is real.")

          expect(@insuranceContacts.getTextForElement(:css, InsuranceContacts::NOTE_CHARACTER_COUNT)).to eq("170 characters left")

          @insuranceContacts.setInput(InsuranceContacts::NOTE, "None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real. None of this info is real.")

          expect(@insuranceContacts.getTextForElement(:css, InsuranceContacts::NOTE_CHARACTER_COUNT)).to eq("0 characters left")

          @insuranceContacts.clickSaveButton()
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

          expect(getCount()).to eq(2)

          clickNthRow(2)
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Edit Insurance Contact"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Edit Insurance Contact")

          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY)).to eq("NewCompanyNewCompanyNewCompanyNewCompanyNewCompany")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY).length()).to eq(50)
          expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::TYPE)).to eq("Medical")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_HOLDER_NAME)).to eq("RichardRichardRichardRichardRichardRichardRichardR")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_HOLDER_NAME).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_NUMBER)).to eq("ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234AB")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::POLICY_NUMBER).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_NAME)).to eq("SomeGroupSomeGroupSomeGroupSomeGroupSomeGroupSomeG")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_NAME).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_ID_NUMBER)).to eq("1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD1234ABCD12")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::GROUP_ID_NUMBER).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EFFECTIVE_DATE)).to eq("10/2014")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::END_DATE)).to eq("10/2017")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::COMPANY_PHONE_NUMBER)).to eq("(222) 222-2222")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::PRE_APPROVAL_CALL_NUMBER)).to eq("(444) 444-4444")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::FAX)).to eq("(666) 666-6666")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EMAIL)).to eq("my.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@agilex.commy.name@ag")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::EMAIL).length()).to eq(100)
          expect(@insuranceContacts.getSelectBoxText(InsuranceContacts::COUNTRY)).to eq("Serbia")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_1)).to eq("100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 100 1st St 1")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_1).length()).to eq(100)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_2)).to eq("Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suite 8 Suit")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ADDRESS_LINE_2).length()).to eq(100)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::CITY)).to eq("SerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSerbiniaSe")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::CITY).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::STATE_PROVINCE)).to eq("SerbistateSerbistateSerbistateSerbistateSerbistate")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::STATE_PROVINCE).length()).to eq(50)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ZIP_POSTAL_CODE)).to eq("1a4561a456")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::ZIP_POSTAL_CODE).length()).to eq(10)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::WEBSITE)).to eq("www.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.comwww.mywebsite.c")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::WEBSITE).length()).to eq(100)
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::NOTE)).to eq("None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real.None of this info is real. None of this info is real. None of this info is real. None of t")
          expect(@insuranceContacts.getTextFromInput(:css, InsuranceContacts::NOTE).length()).to eq(250)
          expect(@insuranceContacts.getTextForElement(:css, InsuranceContacts::NOTE_CHARACTER_COUNT)).to eq("0 characters left")

          @insuranceContacts.clickCancelButton()
          !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
          expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

          expect(getCount()).to eq(2)
        end

      end

    end

    describe "Navigation Without Saving" do

      it "No changes", :broken => true do
        @common.clickAddButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Add Insurance Contact"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Add Insurance Contact")

        @contacts.clickInsuranceContacts()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }

        expect(getCount()).to eq(2)
      end

      it "Changes", :broken => true do
        @common.clickAddButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Add Insurance Contact"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Add Insurance Contact")

        @insuranceContacts.setInput(InsuranceContacts::COMPANY, "XYZ")

        @contacts.clickInsuranceContacts()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickReturnButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Add Insurance Contact"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Add Insurance Contact")

        @contacts.clickInsuranceContacts()
        !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
        expect(@modal.getConfirmationHeading()).to eq("Confirmation")
        expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
        expect(@modal.getConfirmButtonText()).to eq("Continue")
        expect(@modal.getCancelButtonText()).to eq("Return")

        @modal.clickContinueButton()
        !45.times{ break if (@insuranceContacts.getPrimaryHeader() == "Insurance Contacts"); sleep 1 }
        expect(@insuranceContacts.getPrimaryHeader()).to eq("Insurance Contacts")

        expect(getCount()).to eq(2)
      end

    end

  end

end
