require_relative '../../../globalized'
include Globalized

describe "[Story #JRNL-2487: Healthcare Contacts List View and Filters]", :regression => true  do

  before(:all) do
    @HEALTHCARE_CONTACTS_FILTER_EXPANDED = [
        "Type:",
        "All",
        "Individual Provider",
        "Organization",
        "Apply Reset"
    ]

    @HEALTHCARE_CONTACTS_FILTER_COLLAPSED = []

    initializeConfigurations(BASE_URL)
    resetCollection("contacts", "personalprofiledb", "healthcareContacts")
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")

    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    expect(@nav_menu.getNavMenuHeading()).to eq("App Options")

    @nav_menu.clickContacts()

    !45.times{ break if (getSecondaryHeader == "Contacts"); sleep 1 }
    expect(@contacts.getSecondaryHeader).to eq("Contacts")

    @contacts.clickHealthCareContacts
    !45.times{ break if (getPrimaryHeader == "Healthcare Contacts"); sleep 1 }
    expect(@contacts.getPrimaryHeader).to eq("Healthcare Contacts")
  end

  after(:all) do
    quitDriver()
  end


   it "AC #JRNL-2899|TC #JRNL-2928: (a) Filter Feature (i) Filter defaults to an expanded view. Filter button alt text reads 'Collapse filter' when expanded.", :broken => true do

      expect(@healthcare_contacts_filter.isFilterExpanded()).to be true

      healthcareContactsFilterForm = @healthcare_contacts_filter.getScreenContent().split("\n")
      @HEALTHCARE_CONTACTS_FILTER_EXPANDED.each_with_index do | expectedScreenRow, i |
        expect(healthcareContactsFilterForm[i]).to eq(expectedScreenRow)
      end

      expect(@healthcare_contacts_filter.getFilterIconAriaLabel()).to eq("Collapse filter options")
    end

    it "(1a) Filter Feature (ii) Users can collapse the filter list by clicking on the Collapse filter icon.  When collapsed, the filter icon alt text reads Expand Filter." do
      @healthcare_contacts_filter.clickOnFilterIcon()
      expect(@healthcare_contacts_filter.isFilterCollapsed()).to be true
      expect(@healthcare_contacts_filter.getFilterIconAriaLabel()).to eq("Expand filter options")
    end


    it "(1b) Filter Options (i) type (radio button, values: All, Individual Provider, Organization, default to All)" do
      @healthcare_contacts_filter.clickOnFilterIcon()
      expect(@healthcare_contacts_filter.getFilterHeader()).to eq("Type:")
      expect(@healthcare_contacts_filter.getFilterRadioLabels()).to eq("All\nIndividual Provider\nOrganization")
      expect(@healthcare_contacts_filter.isAllSelected()).to be true
      expect(@healthcare_contacts_filter.isProviderSelected()).to be false
      expect(@healthcare_contacts_filter.isOrganizationSelected()).to be false
    end

    it "(1c) Filter Button (alt text = Filter)" do
      expect(@healthcare_contacts_filter.getFilterButtonLabel()).to eq("Apply")
    end

    it "AC #JRNL-2899|TC #JRNL-2928: (2) contacts entries are displayed in a table format, sorted alphabetically by Name; null values are shown as empty table cell.", :broken => true do
      expect(@healthcare_contacts_list.getContactsListHeaders()[0]).to eq("Name")
      expect(@healthcare_contacts_list.getContactsListHeaders()[1]).to eq("Type")
      expect(@healthcare_contacts_list.getContactsListHeaders()[2]).to eq("Primary Phone")

      @healthcare_contacts_filter.clickProviderRadioButton()
      @healthcare_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Name \nblack \nType \nProvider \nPrimary Phone \n(111) 000-0002 ")); sleep 1 }
      verifyContactsList(@healthcare_contacts_list.getContactsList(), getSortedContacts("Individual Provider"))
      expect(@healthcare_contacts_list.getContentByRowNumber(0)).to eq("Name \nblack \nType \nIndividual Provider \nPrimary Phone \n(111) 000-0002 ")

      @healthcare_contacts_filter.clickOrganizationRadioButton()
      @healthcare_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Name \nAlexandria Hospital \nType \nOrganization \nPrimary Phone \n(111) 000-0003 ")); sleep 1 }
      verifyContactsList(@healthcare_contacts_list.getContactsList(), getSortedContacts("Organization"))
      expect(@healthcare_contacts_list.getContentByRowNumber(0)).to eq("Name \nAlexandria Hospital \nType \nOrganization \nPrimary Phone \n(111) 000-0003 ")

      @healthcare_contacts_filter.clickAllRadioButton()
      @healthcare_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Name \nAlexandria Hospital \nType \nOrganization \nPrimary Phone \n(111) 000-0003 ")); sleep 1 }
      verifyContactsList(@healthcare_contacts_list.getContactsList(), getSortedContacts("All"))
      expect(@healthcare_contacts_list.getContentByRowNumber(0)).to eq("Name \nAlexandria Hospital \nType \nOrganization \nPrimary Phone \n(111) 000-0003 ")

      @healthcare_contacts_filter.clickOrganizationRadioButton()
      @healthcare_contacts_filter.clickFilterButton()
      !10.times{ break if (getFocusedElementText().include?("Name \nAlexandria Hospital \nType \nOrganization \nPrimary Phone \n(111) 000-0003 ")); sleep 1 }
    end

    it "Story JRNL-1696|AC JRNL-1583: Reset Button", :broken => true do
      expect(isResetButtonPresent()).to eq(true)
      expect(getResetButtonLabel()).to eq("Reset")

      clickResetBtn()
      !10.times{ break if (getFocusedElementText().include?("Name")); sleep 1 }
      expect(getCount()).to eq(20)
      verifyContactsList(@healthcare_contacts_list.getContactsList(), getSortedContacts("All"))
      expect(@healthcare_contacts_list.getFocusedElementText()).to eq(getTextForRow(1) + " ")

      # DEFAULT
      expect(@healthcare_contacts_filter.isAllSelected()).to eq(true)
    end

    it "AC #JRNL-2899|TC #JRNL-2928: (c) Filter Button (ii) If no records are found when a filter is applied the message \"No results found.\" Is displayed in the screen area in place of the table view." do
      removeCollection("contacts", "personalprofiledb")

      @healthcare_contacts_filter.clickAllRadioButton()
      expect(@healthcare_contacts_filter.isAllSelected()).to be true

      @healthcare_contacts_filter.clickFilterButton()
      puts "AC #JRNL-2891|TC #JRNL-2468: (c) Filter Button (iii) After the filter button is selected, the focus moves to the returned results, first row, or the No results found message."
      !10.times{ break if (getFocusedElementText().include?("No results found.")); sleep 1 }
      # expect(getFocusedElementText()).to match("No results found.")
      expect(getFocusedElementText()).to match("No results were found with the current filters. Use the Add button above to create a new record.")
    end

    # Local functions starts

    def getAllContactsInDBSorted
      def sortContactsKeys(x,y)
        xname = ''
        yname = ''
        if x["type"] == "Individual Provider"
          xname = x["firstName"] ? x["lastName"] + ", " + x["firstName"] : x["lastName"];
        elsif
          xname = x["address"]["name"]
        end

        if y["type"] == "Individual Provider"
          yname = y["firstName"] ? y["lastName"] + ", " + y["firstName"] : y["lastName"];
        elsif
          yname = y["address"]["name"]
        end

        return (xname.upcase <=> yname.upcase)
      end

      return retreiveAllDocumentsInCollection("contacts", "personalprofiledb").sort { |x, y| sortContactsKeys(x,y) }
    end

    def getSortedContacts(type)
      #Given a type, extract the contacts that are in the db
      selectedContacts = []
      getAllContactsInDBSorted.each_with_index do |contacts_event, rowIndex|
        if type == "All"
          selectedContacts << contacts_event
        elsif contacts_event ["contact"] == type
          selectedContacts << contacts_event
        end
      end

      return selectedContacts
    end

    def verifyContactsList(screenList, dbList)
      dbList.each_with_index do |dbrow, i|
        screenRow = screenList[i]
        name = ''

        expect(screenRow[1]).to eq(dbrow['type'])
        if screenRow[1] == "Individual Provider"
            name = dbrow["firstName"] ? dbrow["lastName"] + ", " + dbrow["firstName"] : dbrow["lastName"];
        elsif screenRow[1] == "Organization"
            name = dbrow["address"]["name"]
        expect(screenRow[0].upcase).to eq(name.upcase)
        end
      end
    end

  end